/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Translation;
import org.eclipse.birt.report.model.parser.DataItemState;
import org.eclipse.birt.report.model.parser.DesignParseState;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.ExtendedItemState;
import org.eclipse.birt.report.model.parser.FreeFormState;
import org.eclipse.birt.report.model.parser.GraphicMasterPageState;
import org.eclipse.birt.report.model.parser.GridItemState;
import org.eclipse.birt.report.model.parser.ImageState;
import org.eclipse.birt.report.model.parser.JointDataSetState;
import org.eclipse.birt.report.model.parser.LabelState;
import org.eclipse.birt.report.model.parser.LineItemState;
import org.eclipse.birt.report.model.parser.ListItemState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.OdaDataSetState;
import org.eclipse.birt.report.model.parser.OdaDataSourceState;
import org.eclipse.birt.report.model.parser.RectangleState;
import org.eclipse.birt.report.model.parser.ScriptDataSetState;
import org.eclipse.birt.report.model.parser.ScriptDataSourceState;
import org.eclipse.birt.report.model.parser.SimpleMasterPageState;
import org.eclipse.birt.report.model.parser.TableItemState;
import org.eclipse.birt.report.model.parser.TemplateDataSetState;
import org.eclipse.birt.report.model.parser.TextDataItemState;
import org.eclipse.birt.report.model.parser.TextItemState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.AnyElementState;
import org.eclipse.birt.report.model.util.VersionUtil;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.eclipse.birt.report.model.util.XMLParserHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class ModuleState
extends DesignParseState {
    protected Module module = null;

    public ModuleState(ModuleParserHandler theHandler) {
        super(theHandler);
        this.module = theHandler.getModule();
    }

    public DesignElement getElement() {
        return this.module;
    }

    public void parseAttrs(Attributes attrs) throws XMLParserException {
        String version = attrs.getValue("version");
        if (!StringUtil.isBlank(version)) {
            int result;
            try {
                this.handler.versionNumber = VersionUtil.parseVersion(version);
                result = 3020600 < this.handler.versionNumber ? -1 : (3020600 == this.handler.versionNumber ? 0 : 1);
            }
            catch (NumberFormatException ex) {
                DesignParserException e = new DesignParserException(new String[]{version}, "Error.DesignParserException.INVALID_VERSION");
                throw new XMLParserException((Exception)((Object)e));
            }
            catch (IllegalArgumentException ex) {
                DesignParserException e = new DesignParserException(new String[]{version}, "Error.DesignParserException.INVALID_VERSION");
                throw new XMLParserException((Exception)((Object)e));
            }
            if (result < 0) {
                DesignParserException e = new DesignParserException(new String[]{version}, "Error.DesignParserException.UNSUPPORTED_VERSION");
                throw new XMLParserException((Exception)((Object)e));
            }
            if (result == 0) {
                this.handler.isCurrentVersion = true;
            }
        }
        this.module.getVersionManager().setVersion(version);
        super.parseAttrs(attrs);
    }

    class SlotState
    extends InnerParseState {
        private int slotID;

        public SlotState(int slotID) {
            this.slotID = slotID;
        }

        public AbstractParseState startElement(String tagName) {
            if ("browser-control".equalsIgnoreCase(tagName)) {
                return new AnyElementState(ModuleState.this.handler);
            }
            if ("free-form".equalsIgnoreCase(tagName)) {
                return new FreeFormState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            if ("data".equalsIgnoreCase(tagName)) {
                return new DataItemState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            if ("extended-item".equalsIgnoreCase(tagName)) {
                return new ExtendedItemState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            if ("grid".equalsIgnoreCase(tagName)) {
                return new GridItemState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            if ("image".equalsIgnoreCase(tagName)) {
                return new ImageState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            if ("include".equalsIgnoreCase(tagName)) {
                return new AnyElementState(ModuleState.this.handler);
            }
            if ("label".equalsIgnoreCase(tagName)) {
                return new LabelState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            if ("text".equalsIgnoreCase(tagName)) {
                return new TextItemState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            if ("line".equalsIgnoreCase(tagName)) {
                return new LineItemState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            if ("list".equalsIgnoreCase(tagName)) {
                return new ListItemState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            if ("rectangle".equalsIgnoreCase(tagName)) {
                return new RectangleState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            if ("table".equalsIgnoreCase(tagName)) {
                return new TableItemState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            if ("text".equalsIgnoreCase(tagName)) {
                return new TextItemState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            if ("toc".equalsIgnoreCase(tagName)) {
                return new AnyElementState(ModuleState.this.handler);
            }
            if (tagName.equalsIgnoreCase("multi-line-data") || tagName.equalsIgnoreCase("text-data")) {
                return new TextDataItemState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            return super.startElement(tagName);
        }
    }

    class PageSetupState
    extends InnerParseState {
        PageSetupState() {
        }

        public AbstractParseState startElement(String tagName) {
            if ("graphic-master-page".equalsIgnoreCase(tagName)) {
                return new GraphicMasterPageState(ModuleState.this.handler);
            }
            if ("simple-master-page".equalsIgnoreCase(tagName)) {
                return new SimpleMasterPageState(ModuleState.this.handler);
            }
            if ("page-sequence".equalsIgnoreCase(tagName)) {
                return new AnyElementState(ModuleState.this.handler);
            }
            return super.startElement(tagName);
        }
    }

    class TranslationState
    extends InnerParseState {
        private String resourceKey;
        private String locale;

        TranslationState(String key) {
            this.resourceKey = null;
            this.locale = null;
            this.resourceKey = key;
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            this.locale = attrs.getValue("locale");
            this.locale = StringUtil.trimString(this.locale);
            if (ModuleState.this.module.findTranslation(this.resourceKey, this.locale) != null) {
                ModuleState.this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException("Error.DesignParserException.DUPLICATE_TRANSLATION_LOCALE")));
                return;
            }
            super.parseAttrs(attrs);
        }

        public void end() throws SAXException {
            ModuleState.this.module.addTranslation(new Translation(this.resourceKey, this.locale, this.text.toString()));
            super.end();
        }
    }

    class ResourceState
    extends InnerParseState {
        private String key;

        ResourceState() {
            this.key = null;
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            this.key = attrs.getValue("key");
            if (StringUtil.isEmpty(this.key)) {
                ModuleState.this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException("Error.DesignParserException.MESSAGE_KEY_REQUIRED")));
                return;
            }
            super.parseAttrs(attrs);
        }

        public AbstractParseState startElement(String tagName) {
            if ("translation".equalsIgnoreCase(tagName)) {
                return new TranslationState(this.key);
            }
            return super.startElement(tagName);
        }
    }

    class TranslationsState
    extends InnerParseState {
        TranslationsState() {
        }

        public AbstractParseState startElement(String tagName) {
            if ("resource".equalsIgnoreCase(tagName)) {
                return new ResourceState();
            }
            return super.startElement(tagName);
        }
    }

    class DataSetsState
    extends InnerParseState {
        DataSetsState() {
        }

        public AbstractParseState startElement(String tagName) {
            if ("script-data-set".equalsIgnoreCase(tagName)) {
                return new ScriptDataSetState(ModuleState.this.handler);
            }
            if ("oda-data-set".equalsIgnoreCase(tagName) || "extended-data-set".equalsIgnoreCase(tagName)) {
                return new OdaDataSetState(ModuleState.this.handler);
            }
            if ("template-data-set".equalsIgnoreCase(tagName)) {
                return new TemplateDataSetState(ModuleState.this.handler);
            }
            if ("joint-data-set".equalsIgnoreCase(tagName)) {
                return new JointDataSetState(ModuleState.this.handler);
            }
            return super.startElement(tagName);
        }
    }

    class DataSourcesState
    extends InnerParseState {
        DataSourcesState() {
        }

        public AbstractParseState startElement(String tagName) {
            if ("script-data-source".equalsIgnoreCase(tagName)) {
                return new ScriptDataSourceState(ModuleState.this.handler);
            }
            if ("oda-data-source".equalsIgnoreCase(tagName) || "extended-data-source".equalsIgnoreCase(tagName)) {
                return new OdaDataSourceState(ModuleState.this.handler);
            }
            return super.startElement(tagName);
        }
    }

    class InnerParseState
    extends AbstractParseState {
        InnerParseState() {
        }

        public XMLParserHandler getHandler() {
            return ModuleState.this.handler;
        }
    }
}

