/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.tape;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.Node;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.TapeCartridge;
import org.eclipse.aperi.infrastructure.database.objects.TapeDrive;
import org.eclipse.aperi.infrastructure.database.objects.TapeFrame;
import org.eclipse.aperi.infrastructure.database.objects.TapeIoport;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.eclipse.aperi.infrastructure.database.objects.TapeMediaChanger;
import org.eclipse.aperi.infrastructure.database.objects.TapeMediaLocation;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.tape.api.ITapeReportingService;

public class TapeReportingService
implements ITapeReportingService {
    private static final int GET_KEYS = 0;
    private static final int GET_ATTRS = 1;
    protected static String className;
    protected static ILogger msgLogger;
    protected static ILogger traceLogger;
    private String[] SECBREACH2STRING = new String[]{"Unknown", "Other", "Unknown", "No Breach", "Breach Attempted", "Breach Successful"};
    private String[] MEDIATYPE2STRING = new String[]{"Unknown", "Other", "Tape", "QIC", "AIT", "DFT", "DAT", "Eight MM Tape", "Nineteen MM Tape", "DLT", "Half Inch MO", "Cartridge Disk", "Jaz Disk", "Zip disk", "SyQuest Disk", "Winchester Disk", "CDROM", "CDROMXA", "CDI", "CD Recordable", "Worm", "Magneto-Optical", "DVD", "DVDRWPlus", "DVDRAM", "DVDROM", "DVD Video", "DIVX", "Floppy Diskette", "Harddisk", "Memory Card", "Hardcopy", "Clikdisk", "CDRW", "CDDA", "CD Plus", "DVD Recordable", "DVDRW", "DVD Audio", "DVD5", "DVD9", "DVD10", "DVD18", "MO Rewritable", "MO Write Once", "MO LIMDOW", "Phase Change WO", "Phase Change Rewritable", "Phase Change Dual Rewritable", "Ablative Write Once", "Near Field", "Mini Qic", "Travan", "Eight MM Metal", "Eight MM Advanced", "NCTP", "LTO Ultrium", "LTO Accelis", "Tape 9 Track", "Tape 18 Track", "Take 36 Track", "Tape 36 Track", "Magstar 3590", "Magstar MP", "D2Tape", "DST Small", "DST Medium"};

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.tape.TapeReportingService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        msgLogger = null;
        traceLogger = null;
        msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.TapeManager");
        traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.TapeManager");
        msgLogger.setMessageFile("org.eclipse.aperi.tape.api.resources.TapeManagerMsgs");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getTapeLibraries(HashMap hashMap) throws ServerException, InvalidParameterException {
        String[] stringArray;
        DBConnection dBConnection;
        String string;
        block25: {
            string = "getTapeLibraries";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
            }
            LinkedList<String> linkedList = new LinkedList<String>();
            dBConnection = ServiceUtils.getConnection();
            TapeLibrary.TapeLibraryCursor tapeLibraryCursor = null;
            try {
                try {
                    Hashtable hashtable = null;
                    if (hashMap != null) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.TapeLibrary");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        hashtable = this.createWhereClauseMap(clazz, hashMap);
                    }
                    tapeLibraryCursor = TapeLibrary.getCursor((DBConnection)dBConnection, hashtable, null);
                    while (true) {
                        if (!tapeLibraryCursor.next()) {
                            stringArray = linkedList.toArray(new String[0]);
                            Object var8_10 = null;
                            if (tapeLibraryCursor == null) break block25;
                            break;
                        }
                        TapeLibrary tapeLibrary = tapeLibraryCursor.getAttributes();
                        linkedList.add(String.valueOf(tapeLibrary.getName()) + "-multikey-" + tapeLibrary.getNameFormat());
                    }
                }
                catch (SQLException sQLException) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sQLException);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (tapeLibraryCursor != null) {
                    try {
                        tapeLibraryCursor.close();
                    }
                    catch (SQLException sQLException2) {
                        if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException2.getMessage()}));
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sQLException2);
                        throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException2.getMessage()}));
                    }
                }
                if (dBConnection != null) {
                    try {
                        dBConnection.commit();
                        dBConnection.close();
                    }
                    catch (SQLException sQLException3) {
                        if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException3.getMessage()}));
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sQLException3);
                        throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException3.getMessage()}));
                    }
                }
                if (!traceLogger.isLogging()) throw throwable;
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
                throw throwable;
            }
            try {}
            catch (SQLException sQLException) {
                if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sQLException);
                throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
            }
            tapeLibraryCursor.close();
        }
        if (dBConnection != null) {
            try {}
            catch (SQLException sQLException) {
                if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sQLException);
                throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
            }
            dBConnection.commit();
            dBConnection.close();
        }
        if (!traceLogger.isLogging()) return stringArray;
        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        return stringArray;
    }

    public String[] getTapeLibraries() throws ServerException, InvalidParameterException {
        return this.getTapeLibraries(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap[] getTapeLibraryAttributes(String[] stringArray, String[] stringArray2) throws ServerException, InvalidParameterException {
        HashMap[] hashMapArray;
        DBConnection dBConnection;
        String string;
        block28: {
            string = "getTapeLibraryAttributes";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
            }
            if (stringArray == null || stringArray.length == 0) {
                stringArray = this.getTapeLibraries();
            }
            HashMap[] hashMapArray2 = new HashMap[stringArray.length];
            dBConnection = ServiceUtils.getConnection();
            TapeLibrary.TapeLibraryCursor tapeLibraryCursor = null;
            try {
                try {
                    int n = 0;
                    while (true) {
                        Class<?> clazz;
                        if (n >= stringArray.length) {
                            hashMapArray = hashMapArray2;
                            Object var13_15 = null;
                            if (tapeLibraryCursor == null) break block28;
                            break;
                        }
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        String[] stringArray3 = stringArray[n].split("-multikey-");
                        hashMap.put("NAME", stringArray3[0]);
                        if (stringArray3.length > 1) {
                            hashMap.put("NAME_FORMAT", stringArray3[1]);
                        }
                        try {
                            clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.TapeLibrary");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        Hashtable hashtable = this.createWhereClauseMap(clazz, hashMap);
                        HashMap hashMap2 = null;
                        tapeLibraryCursor = TapeLibrary.getCursor((DBConnection)dBConnection, (Hashtable)hashtable, null);
                        while (true) {
                            if (!tapeLibraryCursor.next()) {
                                tapeLibraryCursor.close();
                                tapeLibraryCursor = null;
                                if (hashMap2 != null) break;
                                throw new InvalidParameterException(1, new SRMMessage("HWNTM1519E", new String[]{stringArray[n]}));
                            }
                            TapeLibrary tapeLibrary = tapeLibraryCursor.getAttributes();
                            hashMap2 = this.getAttributes(tapeLibrary, stringArray2);
                        }
                        hashMapArray2[n] = hashMap2;
                        ++n;
                    }
                }
                catch (SQLException sQLException) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sQLException);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                if (tapeLibraryCursor != null) {
                    try {
                        tapeLibraryCursor.close();
                    }
                    catch (SQLException sQLException2) {
                        if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException2.getMessage()}));
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sQLException2);
                        throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException2.getMessage()}));
                    }
                }
                if (dBConnection != null) {
                    try {
                        dBConnection.commit();
                        dBConnection.close();
                    }
                    catch (SQLException sQLException3) {
                        if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException3.getMessage()}));
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sQLException3);
                        throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException3.getMessage()}));
                    }
                }
                if (!traceLogger.isLogging()) throw throwable;
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
                throw throwable;
            }
            try {}
            catch (SQLException sQLException) {
                if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sQLException);
                throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
            }
            tapeLibraryCursor.close();
        }
        if (dBConnection != null) {
            try {}
            catch (SQLException sQLException) {
                if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sQLException);
                throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
            }
            dBConnection.commit();
            dBConnection.close();
        }
        if (!traceLogger.isLogging()) return hashMapArray;
        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        return hashMapArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getComponents(int n, String string, HashMap hashMap) throws ServerException, InvalidParameterException, MissingParameterException {
        String[] stringArray;
        String string2;
        block27: {
            string2 = "getComponents";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
            }
            DBConnection dBConnection = ServiceUtils.getConnection();
            try {
                try {
                    List list;
                    if (string != null) {
                        int n2;
                        if (hashMap == null) {
                            hashMap = new HashMap();
                        }
                        if ((n2 = this.getTapeLibID(dBConnection, string)) >= 0) {
                            hashMap.put("TAPE_LIBRARY_ID", new Integer(n2).toString());
                        } else {
                            if (!traceLogger.isLogging()) throw new InvalidParameterException(2, new SRMMessage("HWNTM1519E", new String[]{string}));
                            traceLogger.text(IRecordType.TYPE_ERR, (Object)className, string2, "Couldn't find tape library for " + string);
                            throw new InvalidParameterException(2, new SRMMessage("HWNTM1519E", new String[]{string}));
                        }
                    }
                    Hashtable hashtable = null;
                    Class clazz = this.getClassForCompType(n);
                    if (hashMap != null) {
                        hashtable = this.createWhereClauseMap(clazz, hashMap);
                    }
                    switch (n) {
                        case 1: {
                            list = this.getDrivesKeysAttrs(dBConnection, hashtable, 0, null);
                            break;
                        }
                        case 2: {
                            list = this.getChangersKeysAttrs(dBConnection, hashtable, 0, null);
                            break;
                        }
                        case 3: {
                            list = this.getIoPortsKeysAttrs(dBConnection, hashtable, 0, null);
                            break;
                        }
                        case 4: {
                            list = this.getCartridgesKeysAttrs(dBConnection, hashtable, 0, null);
                            break;
                        }
                        case 5: {
                            list = this.getFramesKeysAttrs(dBConnection, hashtable, 0, null);
                            break;
                        }
                        case 6: {
                            list = this.getLocationsKeysAttrs(dBConnection, hashtable, 0, null);
                            break;
                        }
                        default: {
                            throw new InvalidParameterException(1, new SRMMessage("HWNTM0003E", new String[]{"Invalid component type: " + new Integer(n)}));
                        }
                    }
                    stringArray = list.toArray(new String[0]);
                    Object var9_12 = null;
                    if (dBConnection == null) break block27;
                }
                catch (SQLException sQLException) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)sQLException);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                }
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                if (dBConnection != null) {
                    try {
                        dBConnection.close();
                    }
                    catch (SQLException sQLException2) {
                        if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException2.getMessage()}));
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)sQLException2);
                        throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException2.getMessage()}));
                    }
                }
                if (!traceLogger.isLogging()) throw throwable;
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
                throw throwable;
            }
            try {}
            catch (SQLException sQLException) {
                if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)sQLException);
                throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
            }
            dBConnection.close();
        }
        if (!traceLogger.isLogging()) return stringArray;
        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap[] getComponentAttributes(int n, String[] stringArray, String[] stringArray2) throws ServerException, InvalidParameterException, MissingParameterException {
        Object[] objectArray;
        String string;
        block41: {
            String[] stringArray3;
            Object[] objectArray2;
            string = "getComponentAttributes";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
            }
            if (stringArray == null || stringArray.length == 0) {
                if (n != 9 && n != 7) {
                    stringArray = this.getComponents(n, null, null);
                } else if (n == 9) {
                    objectArray2 = this.getComponentNodes(1, null);
                    stringArray3 = this.getComponentNodes(1, null);
                    stringArray = new String[objectArray2.length + stringArray3.length];
                    System.arraycopy(objectArray2, 0, stringArray, 0, objectArray2.length);
                    System.arraycopy(stringArray3, 0, stringArray, objectArray2.length, stringArray3.length);
                } else if (n == 7) {
                    throw new InvalidParameterException(2, new SRMMessage("HWNTM0003E", new String[]{"Component IDs cannot be empty for ports"}));
                }
            }
            objectArray2 = new HashMap[stringArray.length];
            stringArray3 = ServiceUtils.getConnection();
            Class clazz = this.getClassForCompType(n);
            try {
                try {
                    int n2 = 0;
                    while (true) {
                        Hashtable hashtable;
                        Object object;
                        if (n2 >= stringArray.length) {
                            objectArray = objectArray2;
                            Object var12_16 = null;
                            if (stringArray3 == null) break block41;
                            break;
                        }
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        if (n == 1 || n == 2 || n == 3) {
                            object = stringArray[n2].split("-multikey-");
                            hashMap.put((String)clazz.getField("TAPE_LIBRARY_ID").get(null), object[0]);
                            hashMap.put((String)clazz.getField("DEVICE_ID").get(null), object[1]);
                            hashtable = this.createWhereClauseMap(this.getClassForCompType(n), hashMap);
                        } else if (n == 5 || n == 4 || n == 6) {
                            hashMap.put((String)clazz.getField("TAG").get(null), stringArray[n2]);
                            hashtable = this.createWhereClauseMap(this.getClassForCompType(n), hashMap);
                        } else {
                            if (n != 9 && n != 7) {
                                throw new InvalidParameterException(1, new SRMMessage("HWNTM0003E", new String[]{"Invalid component type: " + new Integer(n)}));
                            }
                            object = stringArray[n2].split("-multikey-");
                            hashMap.put((String)clazz.getField("NAME").get(null), object[0]);
                            hashMap.put((String)clazz.getField("NAME_FORMAT").get(null), object[1]);
                            hashtable = this.createWhereClauseMap(this.getClassForCompType(n), hashMap);
                        }
                        object = null;
                        switch (n) {
                            case 1: {
                                object = (HashMap)this.getDrivesKeysAttrs((DBConnection)stringArray3, hashtable, 1, stringArray2).get(0);
                                break;
                            }
                            case 2: {
                                object = (HashMap)this.getChangersKeysAttrs((DBConnection)stringArray3, hashtable, 1, stringArray2).get(0);
                                break;
                            }
                            case 3: {
                                object = (HashMap)this.getIoPortsKeysAttrs((DBConnection)stringArray3, hashtable, 1, stringArray2).get(0);
                                break;
                            }
                            case 4: {
                                object = (HashMap)this.getCartridgesKeysAttrs((DBConnection)stringArray3, hashtable, 1, stringArray2).get(0);
                                break;
                            }
                            case 5: {
                                object = (HashMap)this.getFramesKeysAttrs((DBConnection)stringArray3, hashtable, 1, stringArray2).get(0);
                                break;
                            }
                            case 6: {
                                object = (HashMap)this.getLocationsKeysAttrs((DBConnection)stringArray3, hashtable, 1, stringArray2).get(0);
                                break;
                            }
                            case 9: {
                                object = (HashMap)this.getNodesKeysAttrs((DBConnection)stringArray3, hashtable, 1, stringArray2).get(0);
                                break;
                            }
                            case 7: {
                                object = (HashMap)this.getPortsKeysAttrs((DBConnection)stringArray3, hashtable, 1, stringArray2).get(0);
                                break;
                            }
                            default: {
                                throw new InvalidParameterException(1, new SRMMessage("HWNTM0003E", new String[]{"Invalid component type: " + new Integer(n)}));
                            }
                        }
                        if (object == null) {
                            throw new InvalidParameterException(1, new SRMMessage("HWNTM1519E", new String[]{stringArray[n2]}));
                        }
                        objectArray2[n2] = object;
                        ++n2;
                    }
                }
                catch (SQLException sQLException) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sQLException);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{illegalAccessException.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)illegalAccessException);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{illegalAccessException.getMessage()}));
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{noSuchFieldException.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)noSuchFieldException);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{noSuchFieldException.getMessage()}));
                }
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                if (stringArray3 != null) {
                    try {
                        stringArray3.close();
                    }
                    catch (SQLException sQLException) {
                        if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sQLException);
                        throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                    }
                }
                if (!traceLogger.isLogging()) throw throwable;
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
                throw throwable;
            }
            try {}
            catch (SQLException sQLException) {
                if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sQLException);
                throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
            }
            stringArray3.close();
        }
        if (!traceLogger.isLogging()) return objectArray;
        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getComponentNodes(int n, String[] stringArray) throws ServerException, InvalidParameterException, MissingParameterException {
        String[] stringArray2;
        String string;
        block28: {
            string = "getComponentNodes";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
            }
            if (n != 1 && n != 2) {
                if (!traceLogger.isLogging()) throw new InvalidParameterException(1, new SRMMessage("HWNTM0003E", new String[]{"Invalid component type: " + new Integer(n)}));
                traceLogger.text(IRecordType.TYPE_ERR, (Object)className, string, "Invalid component type: " + n);
                throw new InvalidParameterException(1, new SRMMessage("HWNTM0003E", new String[]{"Invalid component type: " + new Integer(n)}));
            }
            if (stringArray == null || stringArray.length == 0) {
                stringArray = this.getComponents(n, null, null);
            }
            DBConnection dBConnection = ServiceUtils.getConnection();
            LinkedList linkedList = new LinkedList();
            Class clazz = this.getClassForCompType(n);
            try {
                try {
                    int n2 = 0;
                    while (true) {
                        Class<?> clazz2;
                        if (n2 >= stringArray.length) {
                            stringArray2 = linkedList.toArray(new String[0]);
                            Object var13_17 = null;
                            if (dBConnection == null) break block28;
                            break;
                        }
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.clear();
                        String[] stringArray3 = stringArray[n2].split("-multikey-");
                        hashMap.put((String)clazz.getField("TAPE_LIBRARY_ID").get(null), stringArray3[0]);
                        hashMap.put((String)clazz.getField("DEVICE_ID").get(null), stringArray3[1]);
                        Hashtable hashtable = this.createWhereClauseMap(this.getClassForCompType(n), hashMap);
                        String string2 = null;
                        switch (n) {
                            case 1: {
                                HashMap hashMap2 = (HashMap)this.getDrivesKeysAttrs(dBConnection, hashtable, 1, new String[]{"NODE_ID"}).get(0);
                                string2 = ((Integer)hashMap2.get("NODE_ID")).toString();
                                break;
                            }
                            case 2: {
                                HashMap hashMap2 = (HashMap)this.getChangersKeysAttrs(dBConnection, hashtable, 1, new String[]{"NODE_ID"}).get(0);
                                string2 = ((Integer)hashMap2.get("NODE_ID")).toString();
                                break;
                            }
                        }
                        hashMap.clear();
                        hashMap.put("NODE_ID", string2);
                        try {
                            clazz2 = Class.forName("org.eclipse.aperi.infrastructure.database.objects.Node");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        hashtable = this.createWhereClauseMap(clazz2, hashMap);
                        linkedList.addAll(this.getNodesKeysAttrs(dBConnection, hashtable, 0, null));
                        ++n2;
                    }
                }
                catch (SQLException sQLException) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sQLException);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{illegalAccessException.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)illegalAccessException);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{illegalAccessException.getMessage()}));
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{noSuchFieldException.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)noSuchFieldException);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{noSuchFieldException.getMessage()}));
                }
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                if (dBConnection != null) {
                    try {
                        dBConnection.close();
                    }
                    catch (SQLException sQLException) {
                        if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sQLException);
                        throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                    }
                }
                if (!traceLogger.isLogging()) throw throwable;
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
                throw throwable;
            }
            try {}
            catch (SQLException sQLException) {
                if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sQLException);
                throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
            }
            dBConnection.close();
        }
        if (!traceLogger.isLogging()) return stringArray2;
        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        return stringArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getComponentPorts(int n, String string) throws ServerException, InvalidParameterException, MissingParameterException {
        String[] stringArray;
        String string2;
        block26: {
            string2 = "getComponentPorts";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
            }
            if (n != 1 && n != 2) {
                if (!traceLogger.isLogging()) throw new InvalidParameterException(1, new SRMMessage("HWNTM0003E", new String[]{"Invalid component type: " + new Integer(n)}));
                traceLogger.text(IRecordType.TYPE_ERR, (Object)className, string2, "Invalid component type: " + n);
                throw new InvalidParameterException(1, new SRMMessage("HWNTM0003E", new String[]{"Invalid component type: " + new Integer(n)}));
            }
            if (string == null || string.length() == 0) {
                throw new InvalidParameterException(2, new SRMMessage("HWNTM0003E", new String[]{"Component ID cannot be empty"}));
            }
            DBConnection dBConnection = ServiceUtils.getConnection();
            LinkedList linkedList = new LinkedList();
            Class clazz = this.getClassForCompType(n);
            try {
                try {
                    Class<?> clazz2;
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.clear();
                    String[] stringArray2 = string.split("-multikey-");
                    hashMap.put((String)clazz.getField("TAPE_LIBRARY_ID").get(null), stringArray2[0]);
                    hashMap.put((String)clazz.getField("DEVICE_ID").get(null), stringArray2[1]);
                    Hashtable hashtable = this.createWhereClauseMap(this.getClassForCompType(n), hashMap);
                    String string3 = null;
                    switch (n) {
                        case 1: {
                            HashMap hashMap2 = (HashMap)this.getDrivesKeysAttrs(dBConnection, hashtable, 1, new String[]{"NODE_ID"}).get(0);
                            string3 = ((Integer)hashMap2.get("NODE_ID")).toString();
                            break;
                        }
                        case 2: {
                            HashMap hashMap3 = (HashMap)this.getChangersKeysAttrs(dBConnection, hashtable, 1, new String[]{"NODE_ID"}).get(0);
                            string3 = ((Integer)hashMap3.get("NODE_ID")).toString();
                            break;
                        }
                    }
                    hashMap.clear();
                    hashMap.put("NODE_ID", string3);
                    try {
                        clazz2 = Class.forName("org.eclipse.aperi.infrastructure.database.objects.Port");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    hashtable = this.createWhereClauseMap(clazz2, hashMap);
                    linkedList.addAll(this.getPortsKeysAttrs(dBConnection, hashtable, 0, null));
                    stringArray = linkedList.toArray(new String[0]);
                    Object var12_17 = null;
                    if (dBConnection == null) break block26;
                }
                catch (SQLException sQLException) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)sQLException);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{illegalAccessException.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)illegalAccessException);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{illegalAccessException.getMessage()}));
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{noSuchFieldException.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)noSuchFieldException);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{noSuchFieldException.getMessage()}));
                }
            }
            catch (Throwable throwable) {
                Object var12_18 = null;
                if (dBConnection != null) {
                    try {
                        dBConnection.close();
                    }
                    catch (SQLException sQLException) {
                        if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)sQLException);
                        throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                    }
                }
                if (!traceLogger.isLogging()) throw throwable;
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
                throw throwable;
            }
            try {}
            catch (SQLException sQLException) {
                if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)sQLException);
                throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
            }
            dBConnection.close();
        }
        if (!traceLogger.isLogging()) return stringArray;
        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getComponentLocation(int n, String[] stringArray) throws ServerException, InvalidParameterException, MissingParameterException {
        String[] stringArray2;
        String string;
        block36: {
            string = "getComponentLocation";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
            }
            if (n == 5 || n == 6 || n == 7 || n == 9) {
                if (!traceLogger.isLogging()) throw new InvalidParameterException(1, new SRMMessage("HWNTM0003E", new String[]{"Invalid component type: " + new Integer(n)}));
                traceLogger.text(IRecordType.TYPE_ERR, (Object)className, string, "Invalid component type: " + n);
                throw new InvalidParameterException(1, new SRMMessage("HWNTM0003E", new String[]{"Invalid component type: " + new Integer(n)}));
            }
            if ((stringArray == null || stringArray.length == 0) && n != 8) {
                stringArray = this.getComponents(n, null, null);
            }
            DBConnection dBConnection = ServiceUtils.getConnection();
            LinkedList linkedList = new LinkedList();
            Class clazz = this.getClassForCompType(n);
            try {
                try {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    if (n == 8) {
                        Class<?> clazz2;
                        hashMap.put("LOCATION_TYPE", "2");
                        try {
                            clazz2 = Class.forName("org.eclipse.aperi.infrastructure.database.objects.TapeMediaLocation");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        Hashtable hashtable = this.createWhereClauseMap(clazz2, hashMap);
                        linkedList.addAll(this.getLocationsKeysAttrs(dBConnection, hashtable, 0, null));
                    } else {
                        int n2 = 0;
                        while (n2 < stringArray.length) {
                            Class<?> clazz3;
                            Hashtable hashtable;
                            Object object;
                            hashMap.clear();
                            if (n == 1 || n == 2 || n == 3) {
                                object = stringArray[n2].split("-multikey-");
                                hashMap.put((String)clazz.getField("TAPE_LIBRARY_ID").get(null), object[0]);
                                hashMap.put((String)clazz.getField("DEVICE_ID").get(null), object[1]);
                                hashtable = this.createWhereClauseMap(this.getClassForCompType(n), hashMap);
                            } else {
                                if (n != 5 && n != 4 && n != 6) {
                                    throw new InvalidParameterException(1, new SRMMessage("HWNTM0003E", new String[]{"Invalid component type: " + new Integer(n)}));
                                }
                                hashMap.put((String)clazz.getField("TAG").get(null), stringArray[n2]);
                                hashtable = this.createWhereClauseMap(this.getClassForCompType(n), hashMap);
                            }
                            object = null;
                            switch (n) {
                                case 1: {
                                    HashMap hashMap2 = (HashMap)this.getDrivesKeysAttrs(dBConnection, hashtable, 1, new String[]{"LOCATION_ID"}).get(0);
                                    object = ((Integer)hashMap2.get("LOCATION_ID")).toString();
                                    break;
                                }
                                case 2: {
                                    HashMap hashMap2 = (HashMap)this.getChangersKeysAttrs(dBConnection, hashtable, 1, new String[]{"LOCATION_ID"}).get(0);
                                    object = ((Integer)hashMap2.get("LOCATION_ID")).toString();
                                    break;
                                }
                                case 4: {
                                    HashMap hashMap2 = (HashMap)this.getCartridgesKeysAttrs(dBConnection, hashtable, 1, new String[]{"LOCATION_ID"}).get(0);
                                    object = ((Integer)hashMap2.get("LOCATION_ID")).toString();
                                    break;
                                }
                                case 3: {
                                    HashMap hashMap2 = (HashMap)this.getIoPortsKeysAttrs(dBConnection, hashtable, 1, new String[]{"LOCATION_ID"}).get(0);
                                    object = ((Integer)hashMap2.get("LOCATION_ID")).toString();
                                    break;
                                }
                            }
                            hashMap.clear();
                            hashMap.put("LOCATION_ID", object);
                            try {
                                clazz3 = Class.forName("org.eclipse.aperi.infrastructure.database.objects.TapeMediaLocation");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            hashtable = this.createWhereClauseMap(clazz3, hashMap);
                            linkedList.addAll(this.getLocationsKeysAttrs(dBConnection, hashtable, 0, null));
                            ++n2;
                        }
                    }
                    stringArray2 = linkedList.toArray(new String[0]);
                    Object var12_17 = null;
                    if (dBConnection == null) break block36;
                }
                catch (SQLException sQLException) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sQLException);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{illegalAccessException.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)illegalAccessException);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{illegalAccessException.getMessage()}));
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{noSuchFieldException.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)noSuchFieldException);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{noSuchFieldException.getMessage()}));
                }
            }
            catch (Throwable throwable) {
                Object var12_18 = null;
                if (dBConnection != null) {
                    try {
                        dBConnection.close();
                    }
                    catch (SQLException sQLException) {
                        if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sQLException);
                        throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                    }
                }
                if (!traceLogger.isLogging()) throw throwable;
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
                throw throwable;
            }
            try {}
            catch (SQLException sQLException) {
                if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sQLException);
                throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
            }
            dBConnection.close();
        }
        if (!traceLogger.isLogging()) return stringArray2;
        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        return stringArray2;
    }

    private Hashtable createWhereClauseMap(Class clazz, HashMap hashMap) {
        Hashtable hashtable = new Hashtable();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            hashtable.put(this.getColumnInfo(clazz, string), hashMap.get(string));
        }
        return hashtable;
    }

    private ColumnInfo getColumnInfo(Class clazz, String string) {
        String string2 = "getColumnInfo";
        try {
            Class<?> clazz2;
            Class[] classArray = new Class[1];
            try {
                clazz2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            classArray[0] = clazz2;
            Method method = clazz.getMethod("getColumnInfo", classArray);
            return (ColumnInfo)method.invoke(null, string);
        }
        catch (Exception exception) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)exception);
            }
            throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{exception.getMessage()}));
        }
    }

    private HashMap getAttributes(Object object, String[] stringArray) {
        String string = "getAttributes";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            Method[] methodArray = object.getClass().getMethods();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    Method method = this.findGetter(methodArray, stringArray[n]);
                    if (method == null) {
                        throw new InvalidParameterException(2, new SRMMessage("HWNTM1520E", new String[]{stringArray[n]}));
                    }
                    method.invoke(object, new Object[0]);
                    hashMap.put(stringArray[n], method.invoke(object, new Object[0]));
                    this.postProcessColumnValue(hashMap, stringArray[n]);
                    ++n;
                }
            } else {
                Method method = object.getClass().getMethod("getColumns", new Class[0]);
                Iterator iterator = ((Hashtable)method.invoke(object, new Object[0])).keySet().iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    Method method2 = this.findGetter(methodArray, string2);
                    if (method2 != null) {
                        method2.invoke(object, new Object[0]);
                        hashMap.put(string2, method2.invoke(object, new Object[0]));
                        this.postProcessColumnValue(hashMap, string2);
                        continue;
                    }
                    throw new InvalidParameterException(2, new SRMMessage("HWNTM1520E", new String[]{string2}));
                }
            }
            return hashMap;
        }
        catch (Exception exception) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
            throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{exception.getMessage()}));
        }
    }

    private void postProcessColumnValue(HashMap hashMap, String string) {
        if (string.equalsIgnoreCase("SECURITY_BREACH")) {
            short s = (Short)hashMap.get(string);
            String string2 = s < this.SECBREACH2STRING.length ? this.SECBREACH2STRING[s] : "Unknown";
            hashMap.put(string, string2);
        } else if (string.equalsIgnoreCase("MEDIA_TYPE")) {
            short s = (Short)hashMap.get(string);
            String string3 = s < this.MEDIATYPE2STRING.length ? this.MEDIATYPE2STRING[s] : "Unknown";
            hashMap.put(string, string3);
        } else if (hashMap.get(string) == null) {
            hashMap.put(string, "");
        }
    }

    private Method findGetter(Method[] methodArray, String string) {
        String string2 = string.replaceAll("_", "");
        int n = 0;
        while (n < methodArray.length) {
            if (string2.matches(".*[Ii][Dd]$")) {
                String string3 = string2.replaceAll("[Ii][Dd]$", "");
                if (methodArray[n].getName().equalsIgnoreCase("get" + string3)) {
                    return methodArray[n];
                }
            }
            if (methodArray[n].getName().equalsIgnoreCase("get" + string2)) {
                return methodArray[n];
            }
            ++n;
        }
        return null;
    }

    private Class getClassForCompType(int n) {
        switch (n) {
            case 1: {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.TapeDrive");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                return clazz;
            }
            case 2: {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.TapeMediaChanger");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                return clazz;
            }
            case 3: {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.TapeIoport");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                return clazz;
            }
            case 4: {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.TapeCartridge");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                return clazz;
            }
            case 5: {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.TapeFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                return clazz;
            }
            case 6: {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.TapeMediaLocation");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                return clazz;
            }
            case 9: {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.Node");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                return clazz;
            }
            case 7: {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.Port");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                return clazz;
            }
        }
        return null;
    }

    private List getLocationsKeysAttrs(DBConnection dBConnection, Hashtable hashtable, int n, String[] stringArray) throws SQLException {
        TapeMediaLocation.TapeMediaLocationCursor tapeMediaLocationCursor = TapeMediaLocation.getCursor((DBConnection)dBConnection, (Hashtable)hashtable, null);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (tapeMediaLocationCursor.next()) {
            TapeMediaLocation tapeMediaLocation = tapeMediaLocationCursor.getAttributes();
            if (n == 0) {
                linkedList.add(tapeMediaLocation.getTag());
                continue;
            }
            if (n != 1) continue;
            linkedList.add(this.getAttributes(tapeMediaLocation, stringArray));
        }
        tapeMediaLocationCursor.close();
        dBConnection.commit();
        if (linkedList.size() == 0 && n == 1) {
            linkedList.add(null);
        }
        return linkedList;
    }

    private List getFramesKeysAttrs(DBConnection dBConnection, Hashtable hashtable, int n, String[] stringArray) throws SQLException {
        TapeFrame.TapeFrameCursor tapeFrameCursor = TapeFrame.getCursor((DBConnection)dBConnection, (Hashtable)hashtable, null);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (tapeFrameCursor.next()) {
            TapeFrame tapeFrame = tapeFrameCursor.getAttributes();
            if (n == 0) {
                linkedList.add(tapeFrame.getTag());
                continue;
            }
            if (n != 1) continue;
            linkedList.add(this.getAttributes(tapeFrame, stringArray));
        }
        tapeFrameCursor.close();
        dBConnection.commit();
        if (linkedList.size() == 0 && n == 1) {
            linkedList.add(null);
        }
        return linkedList;
    }

    private List getCartridgesKeysAttrs(DBConnection dBConnection, Hashtable hashtable, int n, String[] stringArray) throws SQLException {
        TapeCartridge.TapeCartridgeCursor tapeCartridgeCursor = TapeCartridge.getCursor((DBConnection)dBConnection, (Hashtable)hashtable, null);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (tapeCartridgeCursor.next()) {
            TapeCartridge tapeCartridge = tapeCartridgeCursor.getAttributes();
            if (n == 0) {
                linkedList.add(tapeCartridge.getTag());
                continue;
            }
            if (n != 1) continue;
            linkedList.add(this.getAttributes(tapeCartridge, stringArray));
        }
        tapeCartridgeCursor.close();
        dBConnection.commit();
        if (linkedList.size() == 0 && n == 1) {
            linkedList.add(null);
        }
        return linkedList;
    }

    private List getIoPortsKeysAttrs(DBConnection dBConnection, Hashtable hashtable, int n, String[] stringArray) throws SQLException {
        TapeIoport.TapeIoportCursor tapeIoportCursor = TapeIoport.getCursor((DBConnection)dBConnection, (Hashtable)hashtable, null);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (tapeIoportCursor.next()) {
            TapeIoport tapeIoport = tapeIoportCursor.getAttributes();
            if (n == 0) {
                linkedList.add(String.valueOf(tapeIoport.getTapeLibraryId()) + "-multikey-" + tapeIoport.getDeviceId());
                continue;
            }
            if (n != 1) continue;
            linkedList.add(this.getAttributes(tapeIoport, stringArray));
        }
        tapeIoportCursor.close();
        dBConnection.commit();
        if (linkedList.size() == 0 && n == 1) {
            linkedList.add(null);
        }
        return linkedList;
    }

    private List getChangersKeysAttrs(DBConnection dBConnection, Hashtable hashtable, int n, String[] stringArray) throws SQLException {
        TapeMediaChanger.TapeMediaChangerCursor tapeMediaChangerCursor = TapeMediaChanger.getCursor((DBConnection)dBConnection, (Hashtable)hashtable, null);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (tapeMediaChangerCursor.next()) {
            TapeMediaChanger tapeMediaChanger = tapeMediaChangerCursor.getAttributes();
            if (n == 0) {
                linkedList.add(String.valueOf(tapeMediaChanger.getTapeLibraryId()) + "-multikey-" + tapeMediaChanger.getDeviceId());
                continue;
            }
            if (n != 1) continue;
            linkedList.add(this.getAttributes(tapeMediaChanger, stringArray));
        }
        tapeMediaChangerCursor.close();
        dBConnection.commit();
        if (linkedList.size() == 0 && n == 1) {
            linkedList.add(null);
        }
        return linkedList;
    }

    private List getDrivesKeysAttrs(DBConnection dBConnection, Hashtable hashtable, int n, String[] stringArray) throws SQLException {
        TapeDrive.TapeDriveCursor tapeDriveCursor = TapeDrive.getCursor((DBConnection)dBConnection, (Hashtable)hashtable, null);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (tapeDriveCursor.next()) {
            TapeDrive tapeDrive = tapeDriveCursor.getAttributes();
            if (n == 0) {
                linkedList.add(String.valueOf(tapeDrive.getTapeLibraryId()) + "-multikey-" + tapeDrive.getDeviceId());
                continue;
            }
            if (n != 1) continue;
            linkedList.add(this.getAttributes(tapeDrive, stringArray));
        }
        tapeDriveCursor.close();
        dBConnection.commit();
        if (linkedList.size() == 0 && n == 1) {
            linkedList.add(null);
        }
        return linkedList;
    }

    private List getNodesKeysAttrs(DBConnection dBConnection, Hashtable hashtable, int n, String[] stringArray) throws SQLException {
        Node.NodeCursor nodeCursor = Node.getCursor((DBConnection)dBConnection, (Hashtable)hashtable, null);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (nodeCursor.next()) {
            Node node = nodeCursor.getAttributes();
            if (n == 0) {
                linkedList.add(String.valueOf(node.getName()) + "-multikey-" + node.getNameFormat());
                continue;
            }
            if (n != 1) continue;
            linkedList.add(this.getAttributes(node, stringArray));
        }
        nodeCursor.close();
        dBConnection.commit();
        if (linkedList.size() == 0 && n == 1) {
            linkedList.add(null);
        }
        return linkedList;
    }

    private List getPortsKeysAttrs(DBConnection dBConnection, Hashtable hashtable, int n, String[] stringArray) throws SQLException {
        Port.PortCursor portCursor = Port.getCursor((DBConnection)dBConnection, (Hashtable)hashtable, null);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (portCursor.next()) {
            Port port = portCursor.getAttributes();
            if (n == 0) {
                linkedList.add(String.valueOf(port.getName()) + "-multikey-" + port.getNameFormat());
                continue;
            }
            if (n != 1) continue;
            linkedList.add(this.getAttributes(port, stringArray));
        }
        portCursor.close();
        dBConnection.commit();
        if (linkedList.size() == 0 && n == 1) {
            linkedList.add(null);
        }
        return linkedList;
    }

    private int getTapeLibID(DBConnection dBConnection, String string) throws SQLException {
        Class<?> clazz;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = string.split("-multikey-");
        hashMap.put("NAME", stringArray[0]);
        if (stringArray.length > 1) {
            hashMap.put("NAME_FORMAT", stringArray[1]);
        }
        try {
            clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.TapeLibrary");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Hashtable hashtable = this.createWhereClauseMap(clazz, hashMap);
        int n = -1;
        TapeLibrary.TapeLibraryCursor tapeLibraryCursor = TapeLibrary.getCursor((DBConnection)dBConnection, (Hashtable)hashtable, null);
        while (tapeLibraryCursor.next()) {
            TapeLibrary tapeLibrary = tapeLibraryCursor.getAttributes();
            n = tapeLibrary.getTapeLibraryId();
        }
        tapeLibraryCursor.close();
        dBConnection.commit();
        return n;
    }

    public static String getNameFromKey(String string) {
        String[] stringArray = string.split("-multikey-");
        return stringArray[0];
    }

    public static short getNameFormatFromKey(String string) {
        String[] stringArray = string.split("-multikey-");
        if (stringArray.length > 1) {
            return Short.parseShort(stringArray[1]);
        }
        TapeReportingService tapeReportingService = new TapeReportingService();
        HashMap hashMap = tapeReportingService.getTapeLibraryAttributes(new String[]{stringArray[0]}, new String[]{"NAME_FORMAT"})[0];
        return (Short)hashMap.get("NAME_FORMAT");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCartrigeAttrByLocationID(String string, String[] stringArray) throws ServerException, InvalidParameterException, MissingParameterException {
        String string2;
        DBConnection dBConnection;
        String string3;
        block19: {
            block17: {
                block18: {
                    string3 = "getCartridgeAttrByLocationID";
                    if (traceLogger.isLogging()) {
                        traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
                    }
                    dBConnection = ServiceUtils.getConnection();
                    Class clazz = this.getClassForCompType(4);
                    try {
                        try {
                            HashMap<String, String> hashMap2 = new HashMap<String, String>();
                            HashMap hashMap = null;
                            hashMap2.clear();
                            hashMap2.put("LOCATION_ID", string);
                            Hashtable hashtable = this.createWhereClauseMap(clazz, hashMap2);
                            String string4 = null;
                            hashMap = (HashMap)this.getCartridgesKeysAttrs(dBConnection, hashtable, 1, new String[]{"PHYSICAL_LABEL"}).get(0);
                            if (hashMap == null) {
                                Object var10_11 = null;
                                if (dBConnection == null) break block17;
                                break block18;
                            }
                            string2 = string4 = hashMap.get("PHYSICAL_LABEL").toString();
                            break block19;
                        }
                        catch (SQLException sQLException) {
                            if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, (Throwable)sQLException);
                            throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        if (dBConnection != null) {
                            try {
                                dBConnection.close();
                            }
                            catch (SQLException sQLException2) {
                                if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException2.getMessage()}));
                                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, (Throwable)sQLException2);
                                throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException2.getMessage()}));
                            }
                        }
                        if (!traceLogger.isLogging()) throw throwable;
                        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
                        throw throwable;
                    }
                }
                try {}
                catch (SQLException sQLException) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, (Throwable)sQLException);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                }
                dBConnection.close();
            }
            if (!traceLogger.isLogging()) return "";
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
            return "";
        }
        Object var10_12 = null;
        if (dBConnection != null) {
            try {}
            catch (SQLException sQLException) {
                if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, (Throwable)sQLException);
                throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
            }
            dBConnection.close();
        }
        if (!traceLogger.isLogging()) return string2;
        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        return string2;
    }
}

