/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.rcp.gui.connection;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JOptionPane;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.rcp.gui.connection.Connection;
import org.eclipse.aperi.rcp.gui.connection.ConnectionStatus;
import org.eclipse.aperi.rcp.gui.connection.IConnectionListener;
import org.eclipse.aperi.rcp.gui.connection.RunRequest;
import org.eclipse.aperi.rcp.gui.connection.Server;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.server.guireq.SignonResp;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.server.req.ServerStatusResp;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ConnectionManager {
    private static Connection currentConnection;
    private HashMap<IConnectionListener, Object> listenerMap = new HashMap();
    private static ConnectionManager connectionManager;

    static {
        connectionManager = null;
    }

    protected ConnectionManager() {
    }

    public static ConnectionManager getConnectionManager() {
        if (connectionManager == null) {
            connectionManager = new ConnectionManager();
        }
        return connectionManager;
    }

    public void setCurrentConnection(Connection connection) {
        currentConnection = connection;
        this.fireConnectionChanged(currentConnection);
    }

    public Connection getCurrentConnection() {
        return currentConnection;
    }

    public void addConnectionListener(IConnectionListener iConnectionListener) {
        this.listenerMap.put(iConnectionListener, null);
    }

    public void removeConnectionListener(IConnectionListener iConnectionListener) {
        this.listenerMap.remove(iConnectionListener);
    }

    protected void fireConnectionChanged(Connection connection) {
        Iterator<IConnectionListener> iterator = this.listenerMap.keySet().iterator();
        while (iterator.hasNext()) {
            iterator.next().connectionChanged(connection);
        }
    }

    public void refreshConnection(Connection connection) {
        this.fireConnectionChanged(connection);
    }

    public void signon(final Connection connection) {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(null);
        progressMonitorDialog.setCancelable(true);
        try {
            progressMonitorDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                    Request request = new Request();
                    Server server = connection.getServer();
                    iProgressMonitor.beginTask("Contacting server " + server.getHost() + "...", -1);
                    ServerRequest.signon((Request)request, (String)server.getUser(), (String)server.getPassword());
                    iProgressMonitor.subTask("Trying to sign on to " + server.getHost() + "...");
                    Response response = RunRequest.doRequest(request, server);
                    if (response == null || response.status >= 4) {
                        connection.registerError(response);
                    } else {
                        SignonResp signonResp = (SignonResp)response.responseData;
                        connection.setSignonResp(signonResp);
                        connection.setStatus(ConnectionStatus.CONNECTED);
                        GuiClient.server = server.getHost();
                        GuiClient.port = server.getPort();
                        if (signonResp.userRoles == RoleChecker.NO_ROLE) {
                            JOptionPane.showMessageDialog(null, Util.getString((String)"GUI8214E", (String)server.getUser()), Util.getString((String)"LOGIN_FAILED"), 0);
                            response.status = (short)12;
                        }
                    }
                    iProgressMonitor.subTask("Signon successful.");
                    iProgressMonitor.done();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {}
    }

    public void getServerServices() {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(null);
        progressMonitorDialog.setCancelable(true);
        try {
            progressMonitorDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                    Request request = new Request();
                    ServerRequest.serverStatus((Request)request);
                    Server server = currentConnection.getServer();
                    request.userName = server.getUser();
                    iProgressMonitor.beginTask("Getting services for server " + server.getHost() + "...", -1);
                    Response response = RunRequest.doRequest(request, server);
                    currentConnection.setDataServerStatus(response);
                    GuiClient.serverStatusResp = (ServerStatusResp)response.responseData;
                    if (currentConnection.getSignonResp().deviceServerInstalled) {
                        DeviceRequest deviceRequest = new DeviceRequest("org.eclipse.aperi.server.svp.GuiSvp", "org.eclipse.aperi.server.handler.gui.DeviceServerStatusHndlr");
                        deviceRequest.requestData = null;
                        response = RunRequest.doRequest((Request)deviceRequest, server);
                        currentConnection.setDeviceServerStatus(response);
                    }
                    iProgressMonitor.done();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {}
    }

    public void disconnect() {
        currentConnection = null;
    }
}

