/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.rcp.gui.connection;

import java.net.Socket;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.rcp.gui.connection.Server;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.SocketTransceiver;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.IProgressConstants;

public class RunRequestJob
extends Job {
    Request request;
    GuiRequestor requestor;
    Server server;
    Response response;
    private static final int TIME_OUT = 300;

    public static Response doRequest(Request request, Server server) {
        Socket socket;
        try {
            socket = new Socket(server.getHost(), server.getPort());
        }
        catch (Exception exception) {
            return null;
        }
        SocketTransceiver socketTransceiver = new SocketTransceiver(socket, server.getHost(), 300);
        Response response = socketTransceiver.transmitRequest(request, null);
        socketTransceiver.close();
        return response;
    }

    public RunRequestJob(Request request, GuiRequestor guiRequestor, Server server) {
        super("Sending request to server...");
        this.request = request;
        this.requestor = guiRequestor;
        this.server = server;
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        iProgressMonitor.beginTask("Long running action", -1);
        this.response = RunRequestJob.doRequest(this.request, this.server);
        this.requestor.handleResponse(this.response.status, this.response);
        if (iProgressMonitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
        this.setProperty(IProgressConstants.ACTION_PROPERTY, this.getCompletedAction());
        iProgressMonitor.done();
        return Status.OK_STATUS;
    }

    public Response getResponse() {
        return this.response;
    }

    private Action getCompletedAction() {
        return new Action("View job status"){

            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                MessageDialog.openInformation((Shell)shell, (String)"Run Request Status", (String)"Request has been sent.");
            }
        };
    }
}

