/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.snmp.SessionInfoCommString;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.SnmpSocketException;
import org.eclipse.aperi.snmp.SnmpUnknownHostException;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.data.OctetString;

public class SnmpSessionFactory {
    public static final String versionLabel = "snmpVersion";
    public static final String readCommLabel = "readComm";
    public static final String writeCommLabel = "writeComm";
    public static final String retriesLabel = "retries";
    public static final String timeoutLabel = "timeout";
    public static final String portLabel = "port";
    public static final String pollingLabel = "polling";
    public static final String backupAddressesLabel = "backupAddresses";
    public static final String engineIdLabel = "engineId";
    public static final String userNameLabel = "userName";
    public static final String passwordLabel = "password";
    public static final String authKeyLabel = "authKey";
    public static final String privKeyLabel = "privKey";
    public static final String authProtoLabel = "authProto";
    public static final String privProtoLabel = "privProto";
    public static final String maxMsgSizeLabel = "maxMsgSize";
    public static final String PARAMETERS_FILE_NAME = "snmpParameters";
    private static Hashtable sessions = new Hashtable();

    protected static Hashtable getSessions() {
        return sessions;
    }

    public static void main(String[] stringArray) {
        Map map = null;
        if (stringArray.length != 1) {
            System.err.println("Usage: java SnmpSessionFactory <hostname>");
            return;
        }
        map = SnmpSessionFactory.getConfigInfo(stringArray[0]);
        System.out.println(map.toString());
    }

    public static Map getConfigInfo(String string) {
        return SnmpV1API.getConfig().getConfigInfo(string);
    }

    public static SnmpSession makeSession(String string) throws SnmpSocketException, SnmpUnknownHostException, Exception {
        return (SnmpSession)SnmpSessionFactory.makeSession(string, -1, null, null, null, false);
    }

    public static SnmpSession makeSession(String string, int n, String string2, String string3) throws SnmpSocketException, SnmpUnknownHostException, Exception {
        return (SnmpSession)SnmpSessionFactory.makeSession(string, n, string2, string3, null, false);
    }

    public static SnmpSession makeSession(String string, int n, String string2, String string3, Object object) throws SnmpSocketException, SnmpUnknownHostException, Exception {
        return (SnmpSession)SnmpSessionFactory.makeSession(string, n, string2, string3, null, false);
    }

    public static Object makeSession(String string, int n, String string2, String string3, Object object, boolean bl) throws SnmpSocketException, SnmpUnknownHostException, Exception {
        String string4;
        HashMap hashMap;
        SnmpSession snmpSession = null;
        try {
            hashMap = SnmpSessionFactory.getConfigInfo(string);
        }
        catch (Throwable throwable) {
            hashMap = new HashMap();
        }
        String string5 = null;
        String string6 = (String)hashMap.get(versionLabel);
        String string7 = (String)hashMap.get("readCommName");
        if (string7 == null) {
            string7 = "public";
        }
        if ((string4 = (String)hashMap.get("writeCommName")) == null) {
            string4 = "public";
        }
        int n2 = (string5 = (String)hashMap.get(retriesLabel)) == null ? 3 : Integer.parseInt(string5);
        string5 = (String)hashMap.get(timeoutLabel);
        int n3 = string5 == null ? 1000 : Integer.parseInt(string5);
        string5 = (String)hashMap.get(portLabel);
        int n4 = string5 == null ? 161 : Integer.parseInt(string5);
        String string8 = (String)hashMap.get("backupAddrs");
        String string9 = string2;
        String string10 = string3;
        if (string2 == null) {
            string9 = string2 = string7;
        }
        if (string3 == null) {
            string10 = string3 = string4;
        }
        if (n == -1) {
            n = n4;
        }
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("SnmpSessionFactory: starting a session");
        }
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("SnmpSessionFactory: starting a session -- V1");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(n2);
        stringBuffer.append(n3);
        stringBuffer.append(n);
        stringBuffer.append(string9.toString());
        stringBuffer.append(string10.toString());
        String string11 = stringBuffer.toString();
        snmpSession = (SnmpSession)sessions.get(string11);
        if (snmpSession != null) {
            ++snmpSession.useCount;
        } else {
            if (string9 instanceof String && string10 instanceof String) {
                snmpSession = SnmpSession.open(string, string9, string10, n2, n3, n);
            } else if (string9 instanceof OctetString && string10 instanceof OctetString) {
                snmpSession = SnmpSession.open(string, (OctetString)((Object)string9), (OctetString)((Object)string10), n2, n3, n);
            } else if (string9 instanceof String && string10 instanceof OctetString) {
                snmpSession = SnmpSession.open(string, new OctetString(string9, true), (OctetString)((Object)string10), n2, n3, n);
            } else if (string9 instanceof OctetString && string10 instanceof String) {
                snmpSession = SnmpSession.open(string, (OctetString)((Object)string9), new OctetString(string10, true), n2, n3, n);
            }
            ++snmpSession.useCount;
            sessions.put(string11, snmpSession);
        }
        if (string6 != null && "V2".equalsIgnoreCase(string6)) {
            snmpSession.setVersion(2);
        }
        if (string8 != null) {
            snmpSession.addBackupAddresses(string8);
        }
        if (bl) {
            return string11;
        }
        return snmpSession;
    }

    public static SnmpSession getSession(String string) {
        return (SnmpSession)sessions.get(string);
    }

    public static void closeSession(String string) {
        SnmpSession snmpSession = (SnmpSession)sessions.get(string);
        if (snmpSession != null) {
            --snmpSession.useCount;
            if (snmpSession.useCount <= 0) {
                snmpSession = (SnmpSession)sessions.remove(string);
                snmpSession.close();
            }
        }
    }

    public static void closeSession(SnmpSession snmpSession) {
        String string = null;
        SnmpSession snmpSession2 = null;
        StringBuffer stringBuffer = new StringBuffer(snmpSession.primaryAddress);
        stringBuffer.append(snmpSession.retries);
        stringBuffer.append(snmpSession.timeout);
        stringBuffer.append(snmpSession.remotePort);
        stringBuffer.append(((SessionInfoCommString)snmpSession.securityInfo).get_getCommunityName());
        stringBuffer.append(((SessionInfoCommString)snmpSession.securityInfo).get_setCommunityName());
        string = stringBuffer.toString();
        snmpSession2 = (SnmpSession)sessions.get(string);
        if (snmpSession2 != null) {
            --snmpSession2.useCount;
            if (snmpSession2.useCount <= 0) {
                snmpSession2 = (SnmpSession)sessions.remove(string);
            }
        }
        if (snmpSession2 != null && snmpSession2.useCount <= 0) {
            snmpSession2.close();
        }
    }
}

