/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.rmi.ConnectException;
import java.util.Hashtable;

public class PHashtable
extends Hashtable {
    public static final String configDirectory = "config";
    private static final int MAX_INVALIDS = 15;
    private static final int MIN_FILE_SIZE = 100000;
    private int numInvalids = 0;
    private RandomAccessFile theRAF;
    private String filename;
    private Hashtable offsetTable = new Hashtable();
    private FileOutputStream ostream;
    private ObjectOutputStream theOOS;
    private static final String PARSECHAR = ":`:";
    private static Hashtable locks = new Hashtable();

    public static void main(String[] stringArray) {
        new PHashtable("\\work\\foo\\bar\\whee", false);
    }

    public PHashtable(String string, boolean bl) {
        if (bl) {
            File file = new File(configDirectory);
            if (!file.isDirectory()) {
                file.mkdirs();
            }
            String string2 = System.getProperty("file.separator");
            this.filename = configDirectory + string2 + string;
        } else {
            if (string != null && (string.indexOf(47) >= 0 || string.indexOf(92) >= 0)) {
                File file;
                String string3 = null;
                if (string.indexOf(47) >= 0) {
                    string3 = string.substring(0, string.lastIndexOf(47));
                }
                String string4 = null;
                if (string.indexOf(92) >= 0) {
                    string4 = string.substring(0, string.lastIndexOf(92));
                }
                String string5 = null;
                string5 = string3 != null && string4 != null ? (string3.length() > string4.length() ? string3 : string4) : (string3 != null ? string3 : string4);
                if (string5 != null && !(file = new File(string5)).isDirectory()) {
                    file.mkdirs();
                }
            }
            this.filename = string;
        }
        this.restore();
    }

    public PHashtable(String string, String string2) {
        if (string != null) {
            if (string.length() > 0) {
                File file;
                char c = string.charAt(string.length() - 1);
                if (c == '/' || c == '\\') {
                    string = string.substring(0, string.length() - 1);
                }
                if (!(file = new File(string)).isDirectory()) {
                    file.mkdirs();
                }
            } else {
                string = ".";
            }
        }
        String string3 = System.getProperty("file.separator");
        this.filename = String.valueOf(string) + string3 + string2;
        this.restore();
    }

    public static String createKey(String string, String string2) {
        return String.valueOf(string) + PARSECHAR + string2;
    }

    public static String createKey(String string, String string2, String string3) {
        return String.valueOf(string) + PARSECHAR + string2 + PARSECHAR + string3;
    }

    public static String[] parseKey(String string) {
        String[] stringArray = new String[2];
        int n = string.indexOf(PARSECHAR);
        stringArray[0] = string.substring(0, n - 1);
        stringArray[1] = string.substring(n + PARSECHAR.length());
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean backup() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            boolean bl = true;
            if (this.theRAF != null) {
                this.theRAF.close();
            }
            if (this.theOOS != null) {
                this.theOOS.close();
            }
            File file = new File(String.valueOf(this.filename) + ".db");
            File file2 = new File(String.valueOf(this.filename) + ".db" + ".bak");
            File file3 = new File(String.valueOf(this.filename) + ".tb");
            File file4 = new File(String.valueOf(this.filename) + ".tb" + ".bak");
            if (!file3.exists() || !file.exists()) {
                bl = false;
            } else {
                file2.delete();
                file4.delete();
                file3.renameTo(file4);
                file.renameTo(file2);
            }
            this.theRAF = new RandomAccessFile(String.valueOf(this.filename) + ".tb", "rw");
            this.ostream = new FileOutputStream(String.valueOf(this.filename) + ".db");
            this.theOOS = new ObjectOutputStream(this.ostream);
            return bl;
        }
    }

    protected void finalize() {
        this.close();
    }

    public void close() {
        try {
            if (this.theRAF != null) {
                this.theRAF.close();
            }
            if (this.theOOS != null) {
                this.theOOS.close();
            }
            if (this.ostream != null) {
                this.ostream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore() {
        Object object = this.getLock();
        synchronized (object) {
            ObjectInputStream objectInputStream = null;
            RandomAccessFile randomAccessFile = null;
            this.offsetTable = new Hashtable();
            try {
                if (this.backup()) {
                    System.currentTimeMillis();
                    super.clear();
                    FileInputStream fileInputStream = new FileInputStream(String.valueOf(this.filename) + ".db" + ".bak");
                    objectInputStream = new ObjectInputStream(fileInputStream);
                    randomAccessFile = new RandomAccessFile(String.valueOf(this.filename) + ".tb" + ".bak", "r");
                    long l = randomAccessFile.length();
                    while (randomAccessFile.getFilePointer() != l) {
                        boolean bl = randomAccessFile.readBoolean();
                        Object object2 = objectInputStream.readObject();
                        Object object3 = objectInputStream.readObject();
                        if (!bl) continue;
                        this.put(object2, object3);
                    }
                    randomAccessFile.close();
                    objectInputStream.close();
                }
            }
            catch (ConnectException connectException) {
                System.out.println("Tried to restore a remote reference, but did not succeed...");
            }
            catch (Exception exception) {
                System.out.println("PHashtable: an exception occurred restoring data:" + exception.toString());
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                }
                catch (Exception exception2) {}
            }
        }
    }

    public String dumpStats() {
        StringBuffer stringBuffer = new StringBuffer("PHhashtable Stats");
        stringBuffer.append("\nFilename: ");
        stringBuffer.append(this.filename);
        stringBuffer.append("\nsize: ");
        stringBuffer.append(this.size());
        stringBuffer.append("\ninvalids: ");
        stringBuffer.append(this.numInvalids);
        stringBuffer.append("\nfile size: ");
        File file = new File(String.valueOf(this.filename) + ".db");
        stringBuffer.append(file.length());
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        super.clear();
        try {
            if (this.theRAF != null) {
                this.theRAF.close();
            }
            if (this.theOOS != null) {
                this.theOOS.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Object object = this.getLock();
        synchronized (object) {
            File file = new File(String.valueOf(this.filename) + ".tb");
            if (file.exists()) {
                file.delete();
            }
            if ((file = new File(String.valueOf(this.filename) + ".db")).exists()) {
                file.delete();
            }
            try {
                this.theRAF = new RandomAccessFile(String.valueOf(this.filename) + ".tb", "rw");
                this.ostream = new FileOutputStream(String.valueOf(this.filename) + ".db");
                this.theOOS = new ObjectOutputStream(this.ostream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object) {
        Object var2_2 = null;
        Object object2 = this.getLock();
        synchronized (object2) {
            File file = new File(String.valueOf(this.filename) + ".db");
            if (object != null) {
                var2_2 = super.remove(object);
                try {
                    long l = this.theRAF.getFilePointer();
                    this.theRAF.seek((Long)this.offsetTable.get(object));
                    this.theRAF.writeBoolean(false);
                    this.theRAF.seek(l);
                    if (++this.numInvalids > 15 && file.length() > 100000L) {
                        System.out.println("PHashtable : remove : compacting (size/invalids " + this.size() + "/" + this.numInvalids + ")");
                        this.numInvalids = 0;
                        this.clear();
                        this.restore();
                    }
                }
                catch (Exception exception) {
                    var2_2 = null;
                    System.out.println("PHashtable:remove: an exception occurred:");
                    exception.printStackTrace();
                }
            }
        }
        return var2_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        Object object3 = null;
        Object object4 = this.getLock();
        synchronized (object4) {
            if (object != null && object2 != null) {
                try {
                    if (super.get(object) != null) {
                        this.remove(object);
                        this.theOOS.reset();
                    }
                    this.offsetTable.put(object, new Long(this.theRAF.getFilePointer()));
                    this.theRAF.writeBoolean(true);
                    this.theOOS.writeObject(object);
                    this.theOOS.writeObject(object2);
                    this.theOOS.flush();
                    object3 = super.put(object, object2);
                }
                catch (Exception exception) {
                    System.out.println("an exception occurred:");
                    exception.printStackTrace();
                }
            }
        }
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getLock() {
        Object object;
        Hashtable hashtable = locks;
        synchronized (hashtable) {
            object = locks.get(this.filename);
            if (object == null) {
                object = new Object();
                locks.put(this.filename, object);
            }
        }
        return object;
    }
}

