/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.discovery;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.ParameterHelper;
import org.eclipse.aperi.disk.discovery.RetryDeleteParameters;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TAlertLogTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResDataPathTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPhysicalVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPhysicalvolume2extentTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPort2portTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResVolume2extentTable;

public class SubSystemDeletion {
    static final String SELECT_CIMKEY_SUBSYSTEM = "Select CAPABILITY_DATA_ID from T_RES_CIMKEY_SUBSYSTEM where SUBSYSTEM_ID = ?";
    private RetryDeleteParameters cRetryParms = new RetryDeleteParameters();
    static final String SELECT_SS_DISKS = "(select PHYSICAL_VOLUME_ID from T_RES_PHYSICAL_VOLUME  where SUBSYSTEM_ID = ?)";
    static final String SELECT_SVC_DISKS = "(select STORAGE_EXTENT_ID from T_RES_STORAGE_EXTENT  where SUBSYSTEM_ID = ?)";
    static final String DELETE_T_STAT_DISK_SS = "delete from T_STAT_DISK where DISK_ID in (select PHYSICAL_VOLUME_ID from T_RES_PHYSICAL_VOLUME  where SUBSYSTEM_ID = ?)";
    static final String DELETE_T_STAT_DISK_HIST_SS = "delete from T_STAT_DISK_HIST where DISK_ID in (select PHYSICAL_VOLUME_ID from T_RES_PHYSICAL_VOLUME  where SUBSYSTEM_ID = ?)";
    static final String DELETE_T_STAT_DISK_SVC = "delete from T_STAT_DISK where DISK_ID in (select STORAGE_EXTENT_ID from T_RES_STORAGE_EXTENT  where SUBSYSTEM_ID = ?)";
    static final String DELETE_T_STAT_DISK_HIST_SVC = "delete from T_STAT_DISK_HIST where DISK_ID in (select STORAGE_EXTENT_ID from T_RES_STORAGE_EXTENT  where SUBSYSTEM_ID = ?)";
    static final String SELECT_SS_AND_SVC_LUNS = "(select SVID from T_RES_STORAGE_VOLUME  where SUBSYSTEM_ID = ?)";
    static final String DELETE_T_RES_CHUNK_SS = "delete from T_RES_CHUNK where LOGICAL_DISK_ID in (select SVID from T_RES_STORAGE_VOLUME  where SUBSYSTEM_ID = ?)";
    static final String DELETE_T_RES_CHUNK_COLLECTION_SS = "delete from T_RES_CHUNK_CLLCTN where LOGICAL_DISK_ID in (select SVID from T_RES_STORAGE_VOLUME  where SUBSYSTEM_ID = ?)";
    static final String RES_STORAGE_SUBSYSTEM = "117";
    static final String RES_DISK_ARRAY = "78";
    private DBPreparedStatement cStmt = null;
    private DBResultSet cRS = null;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SubSystemDeletion() {
        Class<?> clazz;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"SubSystemDeletion", (Object[])new Object[0]);
        try {
            clazz = Class.forName("org.eclipse.aperi.disk.discovery.SubSystemDeletion");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        logTraceHelper.objectCreation(clazz.getName());
        try {
            this.cRetryParms.init(logTraceHelper);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        logTraceHelper.exit(null);
    }

    private int deleteSSChunkInfo(DBConnection dBConnection, String string, String string2) throws SQLException {
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        hashtable.put(TResStorageVolumeTable.getColumnInfo((String)"SUBSYSTEM_ID"), string2);
        return ComplexQuery.sqlUpdate((DBConnection)dBConnection, (String)string, hashtable);
    }

    private int deleteSSDiskStats(DBConnection dBConnection, String string, String string2) throws SQLException {
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        hashtable.put(TResPhysicalVolumeTable.getColumnInfo((String)"SUBSYSTEM_ID"), string2);
        return ComplexQuery.sqlUpdate((DBConnection)dBConnection, (String)string, hashtable);
    }

    private int deleteSVCDiskStats(DBConnection dBConnection, String string, String string2) throws SQLException {
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        hashtable.put(TResStorageExtentTable.getColumnInfo((String)"SUBSYSTEM_ID"), string2);
        return ComplexQuery.sqlUpdate((DBConnection)dBConnection, (String)string, hashtable);
    }

    public Result cleanupMigratedStorageSubsystem(String string) {
        return this.deleteStorageSubsystem(string, true);
    }

    public Result deleteStorageSubsystem(String string) {
        return this.deleteStorageSubsystem(string, false);
    }

    /*
     * Exception decompiling
     */
    protected Result deleteStorageSubsystem(String var1_1, boolean var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [8 : 2238->2241)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int deleteAlertLogs(DBConnection dBConnection, Hashtable hashtable, String string, String string2) throws SQLException {
        int n = 0;
        Vector<String> vector = new Vector<String>();
        vector.add(string2);
        DBResultSet dBResultSet = DBQueryAssistant.performRetrieve((String)string, (DBConnection)dBConnection, (Hashtable)hashtable, vector);
        while (dBResultSet.next()) {
            int n2 = dBResultSet.getInt(string2);
            Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
            hashtable2.put(TAlertLogTable.getColumnInfo((String)"RESOURCE_ID"), Integer.toString(n2));
            n += DBQueryAssistant.performDelete((String)TAlertLogTable.getTablename(), (DBConnection)dBConnection, hashtable2);
        }
        dBResultSet.closeAll();
        return n;
    }

    private DBResultSet runStatement(DBConnection dBConnection, String string, String[] stringArray, LogTraceHelper logTraceHelper, int n) throws SQLException {
        logTraceHelper.traceInfo(String.valueOf(string) + " with :" + ParameterHelper.stringArrayToString((String[])stringArray));
        this.cStmt = dBConnection.prepareStatement(string);
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.cStmt.setString(n2 + 1, stringArray[n2]);
            ++n2;
        }
        if (n == 1) {
            return this.cStmt.executeQuery();
        }
        this.cStmt.executeUpdate();
        return null;
    }

    private Vector getCimkeySubsystem(String string, DBConnection dBConnection, LogTraceHelper logTraceHelper) throws SQLException {
        Vector<Integer> vector = null;
        this.cRS = this.runStatement(dBConnection, SELECT_CIMKEY_SUBSYSTEM, new String[]{string}, logTraceHelper, 1);
        if (this.cRS != null) {
            vector = new Vector<Integer>();
            while (this.cRS.next()) {
                vector.add(new Integer(this.cRS.getInt(1)));
            }
        }
        if (vector == null) {
            logTraceHelper.traceInfo("No CIMKEY_SUBSYSTEM found for deletion ... Capabilities will not be deleted!");
        }
        return vector;
    }

    private int[] getVolumes(DBConnection dBConnection, String string) throws SQLException {
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        hashtable.put(TResStorageVolumeTable.getColumnInfo((String)"SUBSYSTEM_ID"), string);
        String string2 = "SELECT SVID FROM " + TResStorageVolumeTable.getTablename() + " WHERE " + "SUBSYSTEM_ID" + " = (?)";
        DBResultSet dBResultSet = ComplexQuery.sqlQuery((DBConnection)dBConnection, (String)string2, hashtable);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (dBResultSet.next()) {
            arrayList.add(new Integer(dBResultSet.getInt(1)));
        }
        dBResultSet.close();
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = (Integer)arrayList.get(n);
            ++n;
        }
        return nArray;
    }

    private int[] getPorts(DBConnection dBConnection, String string) throws SQLException {
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        hashtable.put(TResPortTable.getColumnInfo((String)"SUBSYSTEM_ID"), string);
        String string2 = "SELECT PORT_ID FROM " + TResPortTable.getTablename() + " WHERE " + "SUBSYSTEM_ID" + " = (?)";
        DBResultSet dBResultSet = ComplexQuery.sqlQuery((DBConnection)dBConnection, (String)string2, hashtable);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (dBResultSet.next()) {
            arrayList.add(new Integer(dBResultSet.getInt(1)));
        }
        dBResultSet.close();
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = (Integer)arrayList.get(n);
            ++n;
        }
        return nArray;
    }

    private int[] getFabricDetectablePorts(DBConnection dBConnection, String string) throws SQLException {
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        hashtable.put(TResPortTable.getColumnInfo((String)"SUBSYSTEM_ID"), string);
        String string2 = "SELECT PORT_ID FROM " + TResPortTable.getTablename() + ", " + TResPort2portTable.getTablename() + " WHERE " + TResPortTable.getTablename() + "." + "SUBSYSTEM_ID" + " = (?) AND " + "( " + TResPortTable.getTablename() + "." + "PORT_ID" + " = " + TResPort2portTable.getTablename() + "." + "PORT_ID1" + " OR " + TResPortTable.getTablename() + "." + "PORT_ID" + " = " + TResPort2portTable.getTablename() + "." + "PORT_ID2" + ") " + " AND " + TResPort2portTable.getTablename() + "." + "DETECTABLE" + " = 1 ";
        DBResultSet dBResultSet = ComplexQuery.sqlQuery((DBConnection)dBConnection, (String)string2, hashtable);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (dBResultSet.next()) {
            arrayList.add(new Integer(dBResultSet.getInt(1)));
        }
        dBResultSet.close();
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = (Integer)arrayList.get(n);
            ++n;
        }
        return nArray;
    }

    private int cleanFabricDetectablePorts(DBConnection dBConnection, String string) throws SQLException {
        int n = 0;
        int[] nArray = this.getFabricDetectablePorts(dBConnection, string);
        if (nArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < nArray.length) {
                int n3 = nArray[n2];
                stringBuffer.append(n3);
                if (n2 < nArray.length - 1) {
                    stringBuffer.append(", ");
                }
                ++n2;
            }
            String string2 = stringBuffer.toString();
            String string3 = "UPDATE " + TResPortTable.getTablename() + " SET " + "SUBSYSTEM_ID" + " = null " + "WHERE " + "PORT_ID" + " IN (" + string2 + ")";
            n = ComplexQuery.sqlUpdate((DBConnection)dBConnection, (String)string3, null);
        }
        return n;
    }

    private int[] getExtents(DBConnection dBConnection, String string) throws SQLException {
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        hashtable.put(TResStorageExtentTable.getColumnInfo((String)"SUBSYSTEM_ID"), string);
        String string2 = "SELECT STORAGE_EXTENT_ID FROM " + TResStorageExtentTable.getTablename() + " WHERE " + "SUBSYSTEM_ID" + " = (?)";
        DBResultSet dBResultSet = ComplexQuery.sqlQuery((DBConnection)dBConnection, (String)string2, hashtable);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (dBResultSet.next()) {
            arrayList.add(new Integer(dBResultSet.getInt(1)));
        }
        dBResultSet.close();
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = (Integer)arrayList.get(n);
            ++n;
        }
        return nArray;
    }

    private int deleteCIMKeyVolumes(DBConnection dBConnection, String string) throws SQLException {
        int[] nArray = this.getVolumes(dBConnection, string);
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            hashtable.put(TResCimkeyVolumeTable.getColumnInfo((String)"VOLUME_ID"), Integer.toString(nArray[n2]));
            n += DBQueryAssistant.performDelete((String)TResCimkeyVolumeTable.getTablename(), (DBConnection)dBConnection, hashtable);
            ++n2;
        }
        return n;
    }

    private int deleteCimKeyPorts(DBConnection dBConnection, String string) throws SQLException {
        int[] nArray = this.getPorts(dBConnection, string);
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            hashtable.put(TResCimkeyPortTable.getColumnInfo((String)"PORT_ID"), Integer.toString(nArray[n2]));
            n += DBQueryAssistant.performDelete((String)TResCimkeyPortTable.getTablename(), (DBConnection)dBConnection, hashtable);
            ++n2;
        }
        return n;
    }

    private int deleteVolume2Extents(DBConnection dBConnection, String string) throws SQLException {
        int[] nArray = this.getExtents(dBConnection, string);
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            String string2 = Integer.toString(nArray[n2]);
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            hashtable.put(TResStorageExtentTable.getColumnInfo((String)"STORAGE_EXTENT_ID"), string2);
            n += DBQueryAssistant.performDelete((String)TResStorageExtentTable.getTablename(), (DBConnection)dBConnection, hashtable);
            hashtable.clear();
            hashtable.put(TResVolume2extentTable.getColumnInfo((String)"STORAGE_EXTENT_ID"), string2);
            n += DBQueryAssistant.performDelete((String)TResVolume2extentTable.getTablename(), (DBConnection)dBConnection, hashtable);
            hashtable.clear();
            hashtable.put(TResPhysicalvolume2extentTable.getColumnInfo((String)"STORAGE_EXTENT_ID"), string2);
            n += DBQueryAssistant.performDelete((String)TResPhysicalvolume2extentTable.getTablename(), (DBConnection)dBConnection, hashtable);
            ++n2;
        }
        return n;
    }

    private int deleteDataPath(DBConnection dBConnection, String string) throws SQLException {
        int n = 0;
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        hashtable.put(TResStorageSubsystemTable.getColumnInfo((String)"SUBSYSTEM_ID"), string);
        n = DBQueryAssistant.performDelete((String)TResDataPathTable.getTablename(), (DBConnection)dBConnection, hashtable);
        return n;
    }

    private int deleteDataPathAlerts(DBConnection dBConnection, String string) throws SQLException {
        int[] nArray = this.getPorts(dBConnection, string);
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            hashtable.put(TResDataPathTable.getColumnInfo((String)"TARGET_PORT_ID"), Integer.toString(nArray[n2]));
            n += this.deleteAlertLogs(dBConnection, hashtable, TResDataPathTable.getTablename(), new String("DATA_PATH_ID"));
            ++n2;
        }
        return n;
    }
}

