/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.monitor.DiskEventQueue;
import org.eclipse.aperi.disk.monitor.DiskIndicationHandlerFactory;
import org.eclipse.aperi.disk.monitor.ICIMIndicationHandler;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class DiskWorkerThread
extends Thread {
    private volatile boolean cShutdown = false;
    private Thread cThread = null;
    private DiskEventQueue cWorkerQueue = null;

    public DiskWorkerThread(DiskEventQueue diskEventQueue) {
        this.cWorkerQueue = diskEventQueue;
        this.start();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"run", null);
        try {
            this.cThread = Thread.currentThread();
            while (!this.cShutdown) {
                try {
                    CIMIndicationEvent cIMIndicationEvent = this.cWorkerQueue.remove();
                    logTraceHelper.traceInfo("DiskWorkerThread is processing new indication");
                    this.processIndication(cIMIndicationEvent);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    try {
                        logTraceHelper.traceError("Exception in DiskWorkerThread", (Throwable)exception);
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var3_7 = null;
        }
        logTraceHelper.exit(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processIndication(CIMIndicationEvent cIMIndicationEvent) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"processIndication", (Object[])new Object[]{cIMIndicationEvent});
        try {
            block6: {
                try {
                    CIMInstance cIMInstance = cIMIndicationEvent.getCIMInstance();
                    String string = cIMInstance.getClassName();
                    String string2 = cIMInstance.getProperty("IndicationTime").getValue().toString();
                    CIMObjectPath cIMObjectPath = cIMIndicationEvent.getSourceCop();
                    if (cIMObjectPath != null) {
                        String string3 = cIMObjectPath.getObjectName();
                        logTraceHelper.traceAlways("disk worker thread identified indication as " + string + " for " + cIMObjectPath.toString() + " issued on" + string2);
                        ICIMIndicationHandler iCIMIndicationHandler = DiskIndicationHandlerFactory.getInstance().getHandler(string, string3, cIMIndicationEvent);
                        iCIMIndicationHandler.handleCIMIndication();
                        break block6;
                    }
                    logTraceHelper.traceWarning("disk worker thread identified indication as " + string + " issued on" + string2 + "; no action taken");
                }
                catch (Exception exception) {
                    logTraceHelper.traceError("Exception caught in processIndication()", (Throwable)exception);
                }
            }
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        logTraceHelper.exit(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"shutdown", null);
        try {
            this.cShutdown = true;
            if (this.cThread != null) {
                try {
                    this.cThread.interrupt();
                    this.cThread.join(30000L);
                    this.cThread = null;
                }
                catch (Exception exception) {
                    logTraceHelper.traceError("DiskWorkerThread got a " + exception.getMessage() + " while shutting down", (Throwable)exception);
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        logTraceHelper.exit(null);
    }
}

