/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.util.ULocale;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.api.impl.ParameterAttribute;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentConstants;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.internal.document.IPageHintReader;
import org.eclipse.birt.report.engine.internal.document.v1.PageHintReaderV1;
import org.eclipse.birt.report.engine.internal.document.v2.PageHintReaderV2;
import org.eclipse.birt.report.engine.ir.EngineIRReader;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.toc.TOCBuilder;
import org.eclipse.birt.report.engine.toc.TOCTree;

public class ReportDocumentReader
implements IReportDocument,
ReportDocumentConstants {
    private static Logger logger = Logger.getLogger(ReportDocumentReader.class.getName());
    private IReportEngine engine;
    private IDocArchiveReader archive;
    private ReportRunnable reportRunnable;
    private Map moduleOptions;
    private String version;
    private HashMap parameters;
    private HashMap globalVariables;
    private HashMap bookmarks;
    private IPageHintReader pageHintReader;
    private TOCTree tocTree;
    private HashMap reportletsIndexById;
    private HashMap reportletsIndexByBookmark;
    private String systemId;
    private int checkpoint = 0;
    private long pageCount;

    public ReportDocumentReader(IReportEngine engine, IDocArchiveReader archive) throws EngineException {
        this(null, engine, archive);
    }

    public ReportDocumentReader(String systemId, IReportEngine engine, IDocArchiveReader archive) throws EngineException {
        this.engine = engine;
        this.archive = archive;
        this.systemId = systemId;
        this.moduleOptions = new HashMap();
        this.moduleOptions.put("semanticCheck", Boolean.FALSE);
        try {
            archive.open();
        }
        catch (Exception e) {
            throw new EngineException("Failed to open the report document", e);
        }
        try {
            this.doRefresh();
        }
        catch (EngineException ee) {
            try {
                archive.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw ee;
        }
    }

    void setModuleOptions(Map options) {
        this.moduleOptions = new HashMap();
        this.moduleOptions.putAll(options);
        Object semanticCheck = this.moduleOptions.get("semanticCheck");
        if (semanticCheck == null) {
            this.moduleOptions.put("semanticCheck", Boolean.FALSE);
        }
    }

    public IDocArchiveReader getArchive() {
        return this.archive;
    }

    public String getVersion() {
        return this.version;
    }

    public void refresh() {
        if (this.checkpoint == -1) {
            return;
        }
        try {
            this.doRefresh();
        }
        catch (EngineException ee) {
            logger.log(Level.SEVERE, "Failed to refresh", (Throwable)((Object)ee));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRefresh() throws EngineException {
        try {
            Object lock = this.archive.lock("/core");
            try {
                DataInputStream di;
                ReportDocumentCoreInfo documentInfo = new ReportDocumentCoreInfo();
                documentInfo.checkpoint = 0;
                documentInfo.pageCount = 0L;
                RAInputStream in = this.archive.getStream("/checkpoint");
                if (in == null) {
                    documentInfo.checkpoint = -1;
                    this.initializePageHintReader();
                    if (this.pageHintReader != null) {
                        documentInfo.pageCount = this.pageHintReader.getTotalPage();
                    }
                } else {
                    try {
                        di = new DataInputStream((InputStream)in);
                        documentInfo.checkpoint = IOUtil.readInt((InputStream)di);
                        documentInfo.pageCount = IOUtil.readLong((DataInputStream)di);
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                    if (documentInfo.checkpoint == this.checkpoint) {
                        return;
                    }
                }
                in = this.archive.getStream("/core");
                try {
                    di = new DataInputStream((InputStream)in);
                    documentInfo.version = this.checkVersion(di);
                    String orgSystemId = IOUtil.readString((DataInputStream)di);
                    documentInfo.systemId = this.systemId == null ? orgSystemId : this.systemId;
                    Map originalParameters = IOUtil.readMap((DataInputStream)di);
                    documentInfo.parameters = this.convertToCompatibleParameter(originalParameters);
                    documentInfo.globalVariables = (HashMap)IOUtil.readMap((DataInputStream)di);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
                this.checkpoint = documentInfo.checkpoint;
                this.pageCount = documentInfo.pageCount;
                this.version = documentInfo.version;
                this.systemId = documentInfo.systemId;
                this.globalVariables = documentInfo.globalVariables;
                this.parameters = documentInfo.parameters;
            }
            finally {
                this.archive.unlock(lock);
            }
        }
        catch (EngineException ee) {
            throw ee;
        }
        catch (Exception ex) {
            throw new EngineException("document refresh failed", ex);
        }
    }

    private HashMap convertToCompatibleParameter(Map parameters) {
        if (parameters == null) {
            return null;
        }
        HashMap result = new HashMap();
        Iterator iterator = parameters.entrySet().iterator();
        while (iterator.hasNext()) {
            Object[] values;
            Map.Entry entry = iterator.next();
            Object key = entry.getKey();
            Object valueObj = entry.getValue();
            ParameterAttribute paramAttr = null;
            if (valueObj instanceof ParameterAttribute) {
                paramAttr = (ParameterAttribute)valueObj;
            } else if (valueObj instanceof Object[] && (values = (Object[])valueObj).length == 2) {
                Object value = values[0];
                String displayText = (String)values[1];
                paramAttr = new ParameterAttribute(value, displayText);
            }
            if (paramAttr == null) {
                paramAttr = new ParameterAttribute(valueObj, null);
            }
            result.put(key, paramAttr);
        }
        return result;
    }

    protected String checkVersion(DataInputStream di) throws IOException, EngineException {
        String tag = IOUtil.readString((DataInputStream)di);
        String version = IOUtil.readString((DataInputStream)di);
        if (!"reportdocument".equals(tag) || !"1.2.1".equals(version) && !"2.1.0".equals(version)) {
            throw new EngineException("unsupport report document tag" + tag + " version " + version);
        }
        return version;
    }

    public void close() {
        try {
            if (this.pageHintReader != null) {
                this.pageHintReader.close();
            }
            this.pageHintReader = null;
            this.archive.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to close the archive", e);
        }
    }

    public InputStream getDesignStream() {
        try {
            return this.archive.getStream("/design");
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed to open the design!", ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public IReportRunnable getReportRunnable() {
        if (this.reportRunnable != null) {
            return this.reportRunnable;
        }
        ReportDocumentReader reportDocumentReader = this;
        synchronized (reportDocumentReader) {
            block20: {
                if (this.reportRunnable != null) {
                    return this.reportRunnable;
                }
                String name = null;
                name = this.systemId == null ? this.archive.getName() : this.systemId;
                InputStream stream = this.getDesignStream();
                if (stream != null) {
                    this.reportRunnable = (ReportRunnable)this.engine.openReportDesign(name, stream, this.moduleOptions);
                    stream.close();
                    try {
                        stream = this.archive.getStream("/design.ir");
                        if (stream != null) {
                            EngineIRReader reader = new EngineIRReader();
                            Report reportIR = reader.read(stream);
                            reader.link(reportIR, this.reportRunnable.getReport());
                            this.reportRunnable.setReportIR(reportIR);
                        }
                    }
                    catch (IOException ioex) {
                        logger.log(Level.FINE, "Failed to load the engine IR", ioex);
                    }
                    Object var7_8 = null;
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        break block20;
                    }
                    catch (IOException ex2) {}
                    break block20;
                    {
                        catch (Exception ex) {
                            logger.log(Level.SEVERE, "Failed to get the report runnable", ex);
                            Object var7_9 = null;
                            try {
                                if (stream != null) {
                                    stream.close();
                                }
                                break block20;
                            }
                            catch (IOException ex2) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_10 = null;
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                        catch (IOException ex2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
        }
        return this.reportRunnable;
    }

    public Map getParameterValues() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.parameters != null) {
            Iterator iterator = this.parameters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String name = (String)entry.getKey();
                ParameterAttribute value = (ParameterAttribute)entry.getValue();
                result.put(name, value.getValue());
            }
        }
        return result;
    }

    public Map getParameterDisplayTexts() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.parameters != null) {
            Iterator iterator = this.parameters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String name = (String)entry.getKey();
                ParameterAttribute value = (ParameterAttribute)entry.getValue();
                result.put(name, value.getDisplayText());
            }
        }
        return result;
    }

    public long getPageCount() {
        return this.pageCount;
    }

    public IPageHint getPageHint(long pageNumber) {
        this.initializePageHintReader();
        if (this.pageHintReader != null) {
            try {
                return this.pageHintReader.getPageHint(pageNumber);
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "Failed to load page hint " + pageNumber, ex);
            }
        }
        return null;
    }

    public long getPageNumber(String bookmark) {
        if (!this.isComplete()) {
            return -1L;
        }
        this.intializeBookmarks();
        Object number = this.bookmarks.get(bookmark);
        if (number instanceof Number) {
            return ((Number)number).intValue();
        }
        return -1L;
    }

    public List getBookmarks() {
        if (!this.isComplete()) {
            return null;
        }
        this.intializeBookmarks();
        ArrayList<String> list = new ArrayList<String>();
        Set bookmarkSet = this.bookmarks.keySet();
        Iterator iterator = bookmarkSet.iterator();
        while (iterator.hasNext()) {
            String bookmark = (String)iterator.next();
            if (bookmark == null || bookmark.startsWith("__TOC")) continue;
            list.add(bookmark);
        }
        return list;
    }

    public long getBookmark(String bookmark) {
        if (!this.isComplete()) {
            return -1L;
        }
        this.intializeBookmarks();
        Long pageNumber = (Long)this.bookmarks.get(bookmark);
        if (pageNumber == null) {
            return 0L;
        }
        return pageNumber;
    }

    public ITOCTree getTOCTree(String format, ULocale locale) {
        if (!this.isComplete()) {
            return null;
        }
        this.intializeTOC();
        TOCTree result = new TOCTree(this.tocTree.getTOCRoot(), format, locale);
        return result;
    }

    public TOCNode findTOC(String tocNodeId) {
        if (!this.isComplete()) {
            return null;
        }
        this.intializeTOC();
        ITOCTree tree = this.getTOCTree("all", ULocale.getDefault());
        return tree.findTOC(tocNodeId);
    }

    public List findTOCByName(String tocName) {
        if (!this.isComplete()) {
            return null;
        }
        this.intializeTOC();
        ITOCTree tree = this.getTOCTree("all", ULocale.getDefault());
        return tree.findTOCByValue(tocName);
    }

    public List getChildren(String tocNodeId) {
        if (!this.isComplete()) {
            return null;
        }
        TOCNode node = this.findTOC(tocNodeId);
        if (node != null) {
            return node.getChildren();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void intializeTOC() {
        if (this.tocTree != null) {
            return;
        }
        ReportDocumentReader reportDocumentReader = this;
        synchronized (reportDocumentReader) {
            block15: {
                if (this.tocTree != null) {
                    return;
                }
                this.tocTree = new TOCTree();
                if (!this.archive.exists("/toc")) return;
                RAInputStream in = null;
                in = this.archive.getStream("/toc");
                DataInputStream input = new DataInputStream((InputStream)in);
                TOCBuilder.read(this.tocTree, input);
                Object var5_5 = null;
                if (in == null) return;
                try {
                    in.close();
                }
                catch (IOException ex2) {}
                {
                    break block15;
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, "Failed to load the TOC", ex);
                        Object var5_6 = null;
                        if (in == null) return;
                        try {
                            in.close();
                        }
                        catch (IOException ex2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void intializeBookmarks() {
        if (this.bookmarks != null) {
            return;
        }
        var1_1 = this;
        synchronized (var1_1) {
            block15: {
                if (this.bookmarks != null) {
                    return;
                }
                this.bookmarks = new HashMap<K, V>();
                if (!this.archive.exists("/bookmark")) {
                    return;
                }
                in = null;
                try {
                    try {
                        in = this.archive.getStream("/bookmark");
                        di = new DataInputStream((InputStream)in);
                        count = IOUtil.readLong((DataInputStream)di);
                        for (i = 0L; i < count; ++i) {
                            bookmark = IOUtil.readString((DataInputStream)di);
                            pageNumber = IOUtil.readLong((DataInputStream)di);
                            this.bookmarks.put(bookmark, new Long(pageNumber));
                        }
                        var12_9 = null;
                        if (in == null) return;
                    }
                    catch (Exception ex) {
                        ReportDocumentReader.logger.log(Level.SEVERE, "failed to load the bookmarks", ex);
                        var12_10 = null;
                        if (in == null) return;
                        try {
                            in.close();
                        }
                        catch (Exception ex) {}
                        break block15;
                    }
                }
                catch (Throwable var11_15) {
                    var12_11 = null;
                    if (in == null) throw var11_15;
                    ** try [egrp 3[TRYBLOCK] [4 : 169->176)] { 
lbl40:
                    // 1 sources

                    in.close();
                    throw var11_15;
lbl42:
                    // 1 sources

                    catch (Exception ex) {
                        // empty catch block
                    }
                    throw var11_15;
                }
                try {}
                catch (Exception ex) {}
                in.close();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePageHintReader() {
        if (this.pageHintReader != null) {
            return;
        }
        ReportDocumentReader reportDocumentReader = this;
        synchronized (reportDocumentReader) {
            if (this.pageHintReader != null) {
                return;
            }
            this.pageHintReader = "1.0.0".equals(this.getVersion()) ? new PageHintReaderV1(this) : new PageHintReaderV2(this);
            try {
                this.pageHintReader.open();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "can't open the page hint stream", ex);
                if (this.pageHintReader != null) {
                    this.pageHintReader.close();
                }
                this.pageHintReader = null;
            }
        }
    }

    public String getName() {
        return this.archive.getName();
    }

    public Map getGlobalVariables(String option) {
        return this.globalVariables;
    }

    public long getPageNumber(InstanceID iid) {
        if (!this.isComplete()) {
            return -1L;
        }
        if ("1.0.0".equals(this.getVersion())) {
            return -1L;
        }
        long offset = this.getInstanceOffset(iid);
        if (offset != -1L) {
            this.initializePageHintReader();
            if (this.pageHintReader != null) {
                try {
                    return this.pageHintReader.findPage(offset);
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, "Failed to find page which contains " + iid, ex);
                }
            }
        }
        return -1L;
    }

    public long getInstanceOffset(InstanceID iid) {
        if (!this.isComplete()) {
            return -1L;
        }
        if (iid == null) {
            return -1L;
        }
        this.initializeReportlet();
        return this.getOffset(this.reportletsIndexById, iid.toString());
    }

    public long getBookmarkOffset(String bookmark) {
        if (!this.isComplete()) {
            return -1L;
        }
        if (bookmark == null) {
            return -1L;
        }
        this.initializeReportlet();
        return this.getOffset(this.reportletsIndexByBookmark, bookmark);
    }

    private long getOffset(Map index, String key) {
        if ("1.0.0".equals(this.getVersion())) {
            return -1L;
        }
        Long offset = (Long)index.get(key);
        if (offset != null) {
            return offset;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeReportlet() {
        if (this.reportletsIndexById != null) {
            return;
        }
        ReportDocumentReader reportDocumentReader = this;
        synchronized (reportDocumentReader) {
            if (this.reportletsIndexById != null) {
                return;
            }
            this.reportletsIndexById = new HashMap();
            this.reportletsIndexByBookmark = new HashMap();
            this.loadReportletStream(this.reportletsIndexById, "/reportlet");
            this.loadReportletStream(this.reportletsIndexByBookmark, "/reportletBookmarks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadReportletStream(Map index, String streamName) {
        RAInputStream in = null;
        in = this.archive.getStream(streamName);
        DataInputStream di = new DataInputStream((InputStream)in);
        long count = IOUtil.readLong((DataInputStream)di);
        for (long i = 0L; i < count; ++i) {
            String key = IOUtil.readString((DataInputStream)di);
            long offset = IOUtil.readLong((DataInputStream)di);
            index.put(key, new Long(offset));
        }
        in.close();
        Object var13_10 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (Exception ex2) {}
        return;
        {
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed to load the reportlet stream", ex);
                Object var13_11 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (Exception ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public boolean isComplete() {
        return this.checkpoint == -1;
    }

    protected class ReportDocumentCoreInfo {
        String version;
        HashMap globalVariables;
        HashMap parameters;
        String systemId;
        int checkpoint;
        long pageCount;

        protected ReportDocumentCoreInfo() {
        }
    }
}

