/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.extension.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.IExtensionPoint;
import org.eclipse.birt.core.framework.IExtensionRegistry;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.extension.IReportItemGeneration;
import org.eclipse.birt.report.engine.extension.IReportItemPresentation;
import org.eclipse.birt.report.engine.extension.IReportItemQuery;

public class ExtensionManager {
    protected static Logger logger = Logger.getLogger(ExtensionManager.class.getName());
    public static final String EXTENSION_POINT_EMITTERS = "org.eclipse.birt.report.engine.emitters";
    public static final String EXTENSION_POINT_GENERATION = "org.eclipse.birt.report.engine.reportitemGeneration";
    public static final String EXTENSION_POINT_PRESENTATION = "org.eclipse.birt.report.engine.reportitemPresentation";
    public static final String EXTENSION_POINT_QUERY = "org.eclipse.birt.report.engine.reportitemQuery";
    protected static ExtensionManager sm_instance;
    protected HashMap generationExtensions = new HashMap();
    protected HashMap presentationExtensions = new HashMap();
    protected HashMap queryExtensions = new HashMap();
    protected ArrayList emitterExtensions = new ArrayList();
    protected HashMap mimeTypes = new HashMap();

    ExtensionManager() {
        this.loadGenerationExtensionDefns();
        this.loadPresentationExtensionDefns();
        this.loadQueryExtensionDefns();
        this.loadEmitterExtensionDefns();
    }

    private static synchronized void createInstance() {
        if (sm_instance == null) {
            sm_instance = new ExtensionManager();
        }
    }

    public static ExtensionManager getInstance() {
        if (sm_instance == null) {
            ExtensionManager.createInstance();
        }
        return sm_instance;
    }

    public IReportItemGeneration createGenerationItem(String itemType) {
        Object object;
        IConfigurationElement config = (IConfigurationElement)this.generationExtensions.get(itemType);
        if (config != null && (object = this.createObject(config, "class")) instanceof IReportItemGeneration) {
            return (IReportItemGeneration)object;
        }
        return null;
    }

    public IReportItemPresentation createPresentationItem(String itemType) {
        Object object;
        IConfigurationElement config = (IConfigurationElement)this.presentationExtensions.get(itemType);
        if (config != null && (object = this.createObject(config, "class")) instanceof IReportItemPresentation) {
            return (IReportItemPresentation)object;
        }
        return null;
    }

    public IReportItemQuery createQueryItem(String itemType) {
        Object object;
        IConfigurationElement config = (IConfigurationElement)this.queryExtensions.get(itemType);
        if (config != null && (object = this.createObject(config, "class")) instanceof IReportItemQuery) {
            return (IReportItemQuery)object;
        }
        return null;
    }

    public IContentEmitter createEmitter(String format, String id) {
        Object object;
        if (format == null) {
            return null;
        }
        IConfigurationElement config = null;
        for (int i = 0; i < this.emitterExtensions.size(); ++i) {
            EmitterInfo emitterInfo = (EmitterInfo)this.emitterExtensions.get(i);
            if (!format.equalsIgnoreCase(emitterInfo.format) || (id == null || !id.equalsIgnoreCase(emitterInfo.id)) && id != null) continue;
            config = emitterInfo.emitter;
            break;
        }
        if (config != null && (object = this.createObject(config, "class")) instanceof IContentEmitter) {
            return (IContentEmitter)object;
        }
        return null;
    }

    public IContentEmitter createEmitter(String format) {
        Object object;
        if (format == null) {
            return null;
        }
        IConfigurationElement config = null;
        for (int i = 0; i < this.emitterExtensions.size(); ++i) {
            EmitterInfo emitterInfo = (EmitterInfo)this.emitterExtensions.get(i);
            if (!format.equalsIgnoreCase(emitterInfo.format)) continue;
            config = emitterInfo.emitter;
            break;
        }
        if (config != null && (object = this.createObject(config, "class")) instanceof IContentEmitter) {
            return (IContentEmitter)object;
        }
        return null;
    }

    public Collection getSupportedFormat() {
        return this.mimeTypes.keySet();
    }

    protected Object createObject(IConfigurationElement config, String property) {
        try {
            Object object = config.createExecutableExtension(property);
            if (object != null) {
                return object;
            }
        }
        catch (FrameworkException ex) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Can not instantiate class {0} with property {1}.", new String[]{config.getAttribute("class"), property});
            }
            ex.printStackTrace();
        }
        return null;
    }

    protected void loadGenerationExtensionDefns() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint(EXTENSION_POINT_GENERATION);
        if (extPoint == null) {
            return;
        }
        IExtension[] exts = extPoint.getExtensions();
        logger.log(Level.FINE, "Start load extension point: {0}", EXTENSION_POINT_GENERATION);
        for (int i = 0; i < exts.length; ++i) {
            IConfigurationElement[] configs = exts[i].getConfigurationElements();
            for (int j = 0; j < configs.length; ++j) {
                String itemName = configs[j].getAttribute("name");
                this.generationExtensions.put(itemName, configs[j]);
                logger.log(Level.FINE, "Load generation extension: {0}", itemName);
            }
        }
    }

    protected void loadPresentationExtensionDefns() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint(EXTENSION_POINT_PRESENTATION);
        if (extPoint == null) {
            return;
        }
        IExtension[] exts = extPoint.getExtensions();
        logger.log(Level.FINE, "Start load extension point: {0}", EXTENSION_POINT_PRESENTATION);
        for (int i = 0; i < exts.length; ++i) {
            IConfigurationElement[] configs = exts[i].getConfigurationElements();
            for (int j = 0; j < configs.length; ++j) {
                String itemName = configs[j].getAttribute("name");
                this.presentationExtensions.put(itemName, configs[j]);
                logger.log(Level.FINE, "Load prsentation extension: {0}", itemName);
            }
        }
    }

    protected void loadQueryExtensionDefns() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint(EXTENSION_POINT_QUERY);
        if (extPoint == null) {
            return;
        }
        IExtension[] exts = extPoint.getExtensions();
        logger.log(Level.FINE, "Start load extension point: {0}", EXTENSION_POINT_QUERY);
        for (int i = 0; i < exts.length; ++i) {
            IConfigurationElement[] configs = exts[i].getConfigurationElements();
            for (int j = 0; j < configs.length; ++j) {
                String itemName = configs[j].getAttribute("name");
                this.queryExtensions.put(itemName, configs[j]);
                logger.log(Level.FINE, "Load query extension: {0}", itemName);
            }
        }
    }

    protected void loadEmitterExtensionDefns() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint(EXTENSION_POINT_EMITTERS);
        if (extPoint == null) {
            return;
        }
        IExtension[] exts = extPoint.getExtensions();
        logger.log(Level.FINE, "Start load extension point: {0}", EXTENSION_POINT_EMITTERS);
        for (int i = 0; i < exts.length; ++i) {
            IConfigurationElement[] configs = exts[i].getConfigurationElements();
            for (int j = 0; j < configs.length; ++j) {
                String format = configs[j].getAttribute("format");
                String mimeType = configs[j].getAttribute("mimeType");
                String id = configs[j].getAttribute("id");
                this.emitterExtensions.add(new EmitterInfo(format, id, configs[j]));
                this.mimeTypes.put(format, mimeType);
                logger.log(Level.FINE, "Load {0} emitter {1}", new String[]{format, id});
            }
        }
    }

    public String getMIMEType(String format) {
        if (this.mimeTypes.containsKey(format)) {
            return (String)this.mimeTypes.get(format);
        }
        return null;
    }

    protected class EmitterInfo {
        String format;
        String id;
        IConfigurationElement emitter;

        public EmitterInfo(String format, String id, IConfigurationElement emitter) {
            this.format = format;
            this.id = id;
            this.emitter = emitter;
        }
    }
}

