/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.presentation.IPageHint;

class PageHintV1
implements IPageHint {
    protected long pageNumber;
    protected long pageOffset;
    protected long pageStart;
    protected long pageEnd;

    public PageHintV1() {
        this.pageNumber = 0L;
        this.pageOffset = -1L;
        this.pageStart = -1L;
        this.pageEnd = -1L;
    }

    public PageHintV1(long pageNumber, long pageOffset, long pageStart, long pageEnd) {
        this.pageNumber = pageNumber;
        this.pageOffset = pageOffset;
        this.pageStart = pageStart;
        this.pageEnd = pageEnd;
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public void writeObject(DataOutputStream out) throws IOException {
        IOUtil.writeLong((DataOutputStream)out, (long)this.pageNumber);
        IOUtil.writeLong((DataOutputStream)out, (long)this.pageOffset);
        IOUtil.writeLong((DataOutputStream)out, (long)this.pageStart);
        IOUtil.writeLong((DataOutputStream)out, (long)this.pageEnd);
    }

    public void readObject(DataInputStream in) throws IOException {
        this.pageNumber = IOUtil.readLong((DataInputStream)in);
        this.pageOffset = IOUtil.readLong((DataInputStream)in);
        this.pageStart = IOUtil.readLong((DataInputStream)in);
        this.pageEnd = IOUtil.readLong((DataInputStream)in);
    }

    public long getOffset() {
        return this.pageOffset;
    }

    public int getSectionCount() {
        return 1;
    }

    public long getSectionStart(int section) {
        return this.pageStart;
    }

    public long getSectionEnd(int section) {
        return this.pageEnd;
    }
}

