/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.IInlineStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.ILayoutManager;
import org.eclipse.birt.report.engine.layout.IPDFTableLayoutManager;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.CellArea;
import org.eclipse.birt.report.engine.layout.area.impl.RowArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFAbstractLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFInlineStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;

public class PDFRowLM
extends PDFInlineStackingLM
implements IInlineStackingLayoutManager {
    protected IPDFTableLayoutManager tbl = this.getTableLayoutManager();
    protected int rowID;
    protected boolean clear = false;

    public PDFRowLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
        this.rowID = ((IRowContent)content).getRowID();
        this.calculateSpecifiedHeight();
        this.tbl.startRow((IRowContent)content);
    }

    public boolean layout() {
        boolean childBreak = super.layout();
        if (childBreak && this.tbl != null) {
            if (!this.isFinished() && this.needPageBreakBefore()) {
                this.tbl.setTableCloseStateAsForced();
            } else if (this.isFinished() && this.needPageBreakAfter()) {
                this.tbl.setTableCloseStateAsForced();
            }
        }
        return childBreak;
    }

    protected boolean checkAvailableSpace() {
        boolean availableSpace = super.checkAvailableSpace();
        if (availableSpace && this.tbl != null) {
            this.tbl.setTableCloseStateAsForced();
        }
        return availableSpace;
    }

    protected void calculateSpecifiedHeight() {
        super.calculateSpecifiedHeight();
        if (this.specifiedHeight == 0) {
            int fontSize;
            IStyle style = this.content.getComputedStyle();
            this.specifiedHeight = fontSize = this.getDimensionValue(style.getProperty(38));
        }
    }

    protected void createRoot() {
        this.root = AreaFactory.createRowArea((IRowContent)this.content);
    }

    protected void newContext() {
        this.createRoot();
        this.setMaxAvaWidth(this.parent.getMaxAvaWidth());
        this.setMaxAvaHeight(this.parent.getMaxAvaHeight() - this.parent.getCurrentBP());
        this.root.setWidth(this.getMaxAvaWidth());
    }

    protected boolean traverseChildren() {
        boolean childBreak = false;
        if (this.children.size() == 0) {
            while (this.executor.hasNextChild()) {
                IReportItemExecutor childExecutor = this.executor.getNextChild();
                IContent childContent = childExecutor.execute();
                PDFAbstractLM childLM = this.getFactory().createLayoutManager(this, childContent, childExecutor);
                this.addChild(childLM);
                if (!childLM.layout() || childBreak) continue;
                childBreak = true;
            }
        } else if (!this.isRowFinished()) {
            for (int i = 0; i < this.children.size(); ++i) {
                ILayoutManager childLM = (ILayoutManager)this.children.get(i);
                if (!childLM.layout() || childBreak) continue;
                childBreak = true;
            }
        }
        if (childBreak) {
            return true;
        }
        this.status = 3;
        return this.isPageBreakAfter();
    }

    protected void closeLayout() {
        this.tbl.updateRow((RowArea)this.root, this.specifiedHeight);
    }

    public boolean addArea(IArea area) {
        CellArea cArea = (CellArea)area;
        this.root.addChild(area);
        cArea.setPosition(this.tbl.getXPos(cArea.getColumnID()), 0);
        return true;
    }

    protected boolean isRowFinished() {
        for (int i = 0; i < this.children.size(); ++i) {
            PDFAbstractLM lm = (PDFAbstractLM)this.children.get(i);
            if (lm == null || lm.isFinished()) continue;
            return false;
        }
        return true;
    }
}

