/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.text;

import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.layout.pdf.ISplitter;
import org.eclipse.birt.report.engine.layout.pdf.font.FontSplitter;
import org.eclipse.birt.report.engine.layout.pdf.text.BidiSplitter;
import org.eclipse.birt.report.engine.layout.pdf.text.Chunk;

public class ChunkGenerator {
    private ITextContent textContent;
    private ISplitter bidiSplitter = null;
    private ISplitter fontSplitter = null;

    public ChunkGenerator(ITextContent textContent) {
        this.textContent = textContent;
        this.bidiSplitter = new BidiSplitter(new Chunk(textContent.getText()));
        if (this.bidiSplitter.hasMore()) {
            this.fontSplitter = new FontSplitter(this.bidiSplitter.getNext(), textContent);
        }
    }

    public boolean hasMore() {
        if (null == this.bidiSplitter) {
            return false;
        }
        if (this.bidiSplitter.hasMore()) {
            return true;
        }
        if (null == this.fontSplitter) {
            return false;
        }
        return this.fontSplitter.hasMore();
    }

    public Chunk getNext() {
        while (null != this.fontSplitter) {
            if (this.fontSplitter.hasMore()) {
                return this.fontSplitter.getNext();
            }
            this.fontSplitter = null;
            if (this.bidiSplitter.hasMore()) {
                this.fontSplitter = new FontSplitter(this.bidiSplitter.getNext(), this.textContent);
                continue;
            }
            return null;
        }
        return null;
    }
}

