/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.script.eventhandler.ITableGroupEventHandler;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.TableGroup;
import org.eclipse.birt.report.engine.script.internal.instance.ReportElementInstance;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;

public class TableGroupScriptExecutor
extends ScriptExecutor {
    public static void handleOnPrepare(TableGroupHandle groupHandle, ExecutionContext context) {
        try {
            TableGroup group = new TableGroup(groupHandle);
            if (TableGroupScriptExecutor.handleJS((Object)group, groupHandle.getOnPrepare(), context).didRun()) {
                return;
            }
            ITableGroupEventHandler eh = TableGroupScriptExecutor.getEventHandler(groupHandle, context);
            if (eh != null) {
                eh.onPrepare(group, context.getReportContext());
            }
        }
        catch (Exception e) {
            TableGroupScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnPageBreak(ITableGroupContent content, ExecutionContext context) {
        try {
            ReportItemDesign tableGroupDesign = (ReportItemDesign)content.getGenerateBy();
            ReportElementInstance table = new ReportElementInstance(content, context);
            if (TableGroupScriptExecutor.handleJS((Object)table, tableGroupDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            ITableGroupEventHandler eh = TableGroupScriptExecutor.getEventHandler(tableGroupDesign, context);
            if (eh != null) {
                eh.onPageBreak(table, context.getReportContext());
            }
        }
        catch (Exception e) {
            TableGroupScriptExecutor.addException(context, e);
        }
    }

    private static ITableGroupEventHandler getEventHandler(TableGroupHandle handle, ExecutionContext context) {
        ITableGroupEventHandler eh = null;
        try {
            eh = (ITableGroupEventHandler)TableGroupScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            TableGroupScriptExecutor.addClassCastException(context, e, handle.getEventHandlerClass(), ITableGroupEventHandler.class);
        }
        return eh;
    }

    private static ITableGroupEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        TableGroupHandle handle = (TableGroupHandle)design.getHandle();
        if (handle == null) {
            return null;
        }
        return TableGroupScriptExecutor.getEventHandler(handle, context);
    }
}

