/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DefaultResourceLocator;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.IAbsoluteFontSizeValueProvider;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.command.LibraryChangeEvent;
import org.eclipse.birt.report.model.api.command.ResourceChangeEvent;
import org.eclipse.birt.report.model.api.core.IResourceChangeListener;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.i18n.ModelResourceHandle;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.DefaultAbsoluteFontSizeValueProvider;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.parser.DesignReader;
import org.eclipse.birt.report.model.parser.GenericModuleReader;
import org.eclipse.birt.report.model.parser.LibraryReader;
import org.eclipse.birt.report.model.util.ModelUtil;

public class DesignSession {
    protected String resourceFolder = null;
    protected IResourceLocator resourceLocator = new DefaultResourceLocator();
    protected static String resourcePath;
    protected IAbsoluteFontSizeValueProvider fontSizeProvider = DefaultAbsoluteFontSizeValueProvider.getInstance();
    protected List designs = new ArrayList();
    protected List libraries = new ArrayList();
    protected ULocale locale;
    protected ModelResourceHandle resources;
    private String units = "in";
    private int colorFormat = 3;
    private HashMap defaultValues = new HashMap();
    private List resourceChangeListeners = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DesignSession(ULocale theLocale) {
        this.locale = theLocale;
        if (this.locale == null) {
            this.locale = ULocale.getDefault();
        }
        this.activate();
    }

    public void activate() {
        ThreadResources.setLocale(this.locale);
    }

    public void suspend() {
        ThreadResources.setLocale(null);
    }

    public ReportDesign openDesign(String fileName) throws DesignFileException {
        ModuleOption options = null;
        return this.openDesign(fileName, options);
    }

    public ReportDesign openDesign(String fileName, ModuleOption options) throws DesignFileException {
        if (fileName == null) {
            throw new IllegalArgumentException("The file name must not be null");
        }
        ReportDesign design = DesignReader.getInstance().read(this, fileName, options);
        this.designs.add(design);
        return design;
    }

    public ReportDesign openDesign(String fileName, InputStream is) throws DesignFileException {
        ModuleOption options = null;
        return this.openDesign(fileName, is, options);
    }

    public ReportDesign openDesign(String fileName, InputStream is, ModuleOption options) throws DesignFileException {
        if (is == null) {
            throw new IllegalArgumentException("The input stream must not be null");
        }
        ReportDesign design = DesignReader.getInstance().read(this, fileName, is, options);
        this.designs.add(design);
        return design;
    }

    public ReportDesign openDesign(URL systemId, InputStream is) throws DesignFileException {
        ModuleOption options = null;
        return this.openDesign(systemId, is, options);
    }

    public ReportDesign openDesign(URL systemId, InputStream is, ModuleOption options) throws DesignFileException {
        if (is == null) {
            throw new IllegalArgumentException("The input stream must not be null");
        }
        ReportDesign design = DesignReader.getInstance().read(this, systemId, is, options);
        this.designs.add(design);
        return design;
    }

    public Module openModule(String fileName, InputStream is) throws DesignFileException {
        ModuleOption options = null;
        return this.openModule(fileName, is, options);
    }

    public Module openModule(String fileName, InputStream is, ModuleOption options) throws DesignFileException {
        if (is == null) {
            throw new IllegalArgumentException("The input stream must not be null");
        }
        Module module = GenericModuleReader.getInstance().read(this, fileName, is, options);
        if (!($assertionsDisabled || module instanceof Library || module instanceof ReportDesign)) {
            throw new AssertionError();
        }
        if (module instanceof ReportDesign) {
            this.designs.add(module);
        } else {
            this.libraries.add(module);
        }
        return module;
    }

    public Module openModule(String fileName) throws DesignFileException {
        ModuleOption options = null;
        return this.openModule(fileName, options);
    }

    public Module openModule(String fileName, ModuleOption options) throws DesignFileException {
        if (fileName == null) {
            throw new IllegalArgumentException("The file name must not be null");
        }
        Module module = GenericModuleReader.getInstance().read(this, fileName, options);
        if (!($assertionsDisabled || module instanceof Library || module instanceof ReportDesign)) {
            throw new AssertionError();
        }
        if (module instanceof ReportDesign) {
            this.designs.add(module);
        } else {
            this.libraries.add(module);
        }
        return module;
    }

    public Library openLibrary(String fileName) throws DesignFileException {
        ModuleOption options = null;
        return this.openLibrary(fileName, options);
    }

    public Library openLibrary(String fileName, ModuleOption options) throws DesignFileException {
        if (fileName == null) {
            throw new IllegalArgumentException("The file name must not be null");
        }
        Library library = LibraryReader.getInstance().read(this, fileName, options);
        this.libraries.add(library);
        return library;
    }

    public Library openLibrary(String fileName, InputStream is) throws DesignFileException {
        ModuleOption options = null;
        return this.openLibrary(fileName, is, options);
    }

    public Library openLibrary(String fileName, InputStream is, ModuleOption options) throws DesignFileException {
        if (is == null) {
            throw new IllegalArgumentException("The input stream must not be null");
        }
        Library design = LibraryReader.getInstance().read(this, fileName, is, options);
        this.designs.add(design);
        return design;
    }

    public Library openLibrary(URL systemId, InputStream is) throws DesignFileException {
        ModuleOption options = null;
        return this.openLibrary(systemId, is, options);
    }

    public Library openLibrary(URL systemId, InputStream is, ModuleOption options) throws DesignFileException {
        if (is == null) {
            throw new IllegalArgumentException("The input stream must not be null");
        }
        Library library = LibraryReader.getInstance().read(this, systemId, is, options);
        this.libraries.add(library);
        return library;
    }

    public ReportDesign createDesign(String templateName) {
        ReportDesign design = new ReportDesign(this);
        design.setValid(true);
        this.designs.add(design);
        return design;
    }

    public ReportDesign createDesign() {
        return this.createDesign(null);
    }

    public Library createLibrary() {
        Library library = new Library(this);
        Theme theme = new Theme(ModelMessages.getMessage("Theme.defaultThemeName"));
        library.setProperty("theme", (Object)new ElementRefValue(null, theme));
        ModelUtil.insertCompatibleThemeToLibrary(library, theme);
        theme.setID(library.getNextID());
        library.addElementID(theme);
        library.setValid(true);
        this.libraries.add(library);
        return library;
    }

    public Iterator getDesignIterator() {
        return this.designs.iterator();
    }

    public Iterator getLibraryIterator() {
        return this.libraries.iterator();
    }

    public Iterator getModuleIterator() {
        ArrayList roots = new ArrayList();
        roots.addAll(this.designs);
        roots.addAll(this.libraries);
        return roots.iterator();
    }

    public void drop(Module module) {
        if (module instanceof ReportDesign) {
            if (!$assertionsDisabled && !this.designs.contains(module)) {
                throw new AssertionError();
            }
            this.designs.remove(module);
        } else if (module instanceof Library) {
            if (!$assertionsDisabled && !this.libraries.contains(module)) {
                throw new AssertionError();
            }
            this.libraries.remove(module);
        }
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String newUnits) throws PropertyValueException {
        if (!("cm".equalsIgnoreCase(newUnits) || "in".equalsIgnoreCase(newUnits) || "mm".equalsIgnoreCase(newUnits) || "pc".equalsIgnoreCase(newUnits) || "pt".equalsIgnoreCase(newUnits))) {
            throw new PropertyValueException((Object)newUnits, "Error.PropertyValueException.INVALID_VALUE", 5);
        }
        this.units = newUnits;
    }

    public void setColorFormat(int format) throws PropertyValueException {
        if (format != 3 && format != 4 && format != 1 && format != 0 && format != 2) {
            throw new PropertyValueException(new Integer(format), "Error.PropertyValueException.INVALID_VALUE", 5);
        }
        this.colorFormat = format;
    }

    public int getColorFormat() {
        return this.colorFormat;
    }

    public void setDefaultValue(String propName, Object value) throws PropertyValueException {
        if (!$assertionsDisabled && StringUtil.isBlank(propName)) {
            throw new AssertionError();
        }
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        IElementPropertyDefn propDefn = dd.getStyle().getProperty(propName);
        if (!$assertionsDisabled && propDefn == null) {
            throw new AssertionError();
        }
        if (value == null) {
            this.defaultValues.remove(propName);
        } else {
            Object actualValue = ((ElementPropertyDefn)propDefn).validateValue(null, value);
            this.defaultValues.put(propName, actualValue);
        }
    }

    public Object getDefaultValue(String propName) {
        if (!$assertionsDisabled && StringUtil.isBlank(propName)) {
            throw new AssertionError();
        }
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        IElementPropertyDefn propDefn = dd.getStyle().getProperty(propName);
        if (!$assertionsDisabled && propDefn == null) {
            throw new AssertionError();
        }
        return this.defaultValues.get(propName);
    }

    public void setResourceLocator(IResourceLocator algorithm) {
        if (!$assertionsDisabled && algorithm == null) {
            throw new AssertionError();
        }
        this.resourceLocator = algorithm;
    }

    public IResourceLocator getResourceLocator() {
        if (!$assertionsDisabled && this.resourceLocator == null) {
            throw new AssertionError();
        }
        return this.resourceLocator;
    }

    public IAbsoluteFontSizeValueProvider getPredefinedFontSizeProvider() {
        return this.fontSizeProvider;
    }

    public void setPredefinedFontSizeProvider(IAbsoluteFontSizeValueProvider fontSizeProvider) {
        this.fontSizeProvider = fontSizeProvider;
    }

    public ULocale getLocale() {
        return this.locale;
    }

    public void fireLibChange(LibraryChangeEvent ev) {
        String path = ev.getChangedResourcePath();
        try {
            path = new File(path).toURL().toString();
        }
        catch (MalformedURLException e) {
            return;
        }
        Iterator iter = this.getModuleIterator();
        while (iter.hasNext()) {
            Module module = (Module)iter.next();
            if (!module.getLocation().equalsIgnoreCase(path) && module.getLibraryByLocation(path, Integer.MAX_VALUE) == null) continue;
            LibraryChangeEvent event = new LibraryChangeEvent(ev.getChangedResourcePath());
            event.setTarget(module);
            event.setDeliveryPath(ev.getDeliveryPath());
            module.broadcastResourceChangeEvent(event);
        }
        this.broadcastResourceChangeEvent(ev);
    }

    public void addResourceChangeListener(IResourceChangeListener listener) {
        if (this.resourceChangeListeners == null) {
            this.resourceChangeListeners = new ArrayList();
        }
        if (!this.resourceChangeListeners.contains(listener)) {
            this.resourceChangeListeners.add(listener);
        }
    }

    public boolean removeResourceChangeListener(IResourceChangeListener listener) {
        if (this.resourceChangeListeners == null) {
            return false;
        }
        return this.resourceChangeListeners.remove(listener);
    }

    public void broadcastResourceChangeEvent(ResourceChangeEvent event) {
        if (this.resourceChangeListeners == null || this.resourceChangeListeners.isEmpty()) {
            return;
        }
        ArrayList temp = new ArrayList(this.resourceChangeListeners);
        Iterator iter = temp.iterator();
        while (iter.hasNext()) {
            IResourceChangeListener listener = (IResourceChangeListener)iter.next();
            listener.resourceChanged(null, event);
        }
    }

    public void setResourceFolder(String resourceFolder) {
        this.resourceFolder = resourceFolder;
    }

    public String getResourceFolder() {
        if (this.resourceFolder == null) {
            return resourcePath;
        }
        return this.resourceFolder;
    }

    public static String getResourcePath() {
        return resourcePath;
    }

    public static void setResourcePath(String resourcePath) {
        DesignSession.resourcePath = resourcePath;
    }

    static {
        $assertionsDisabled = !DesignSession.class.desiredAssertionStatus();
        resourcePath = null;
    }
}

