/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.NameEvent;
import org.eclipse.birt.report.model.api.command.StyleEvent;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferenceableElement;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

public abstract class StyleElement
extends ReferenceableElement {
    private static final String REPORT_SELECTOR = "report";
    static final /* synthetic */ boolean $assertionsDisabled;

    public StyleElement() {
    }

    public StyleElement(String theName) {
        super(theName);
    }

    protected void adjustDeliveryPath(NotificationEvent ev) {
        ev.setDeliveryPath(2);
    }

    public boolean isStyle() {
        return true;
    }

    public Object getFactoryProperty(Module module, ElementPropertyDefn prop) {
        return this.getLocalProperty(module, prop);
    }

    public DesignElement getExtendsElement() {
        return null;
    }

    public String getExtendsName() {
        return null;
    }

    public void setExtendsElement(DesignElement base) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void setExtendsName(String name) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    protected void broadcastToClients(NotificationEvent ev, Module module) {
        super.broadcastToClients(ev, module);
        ArrayList<String> selectors = new ArrayList<String>();
        if (ev instanceof NameEvent) {
            String oldName = ((NameEvent)ev).getOldName();
            String newName = ((NameEvent)ev).getNewName();
            if (MetaDataDictionary.getInstance().getPredefinedStyle(oldName) != null) {
                selectors.add(oldName);
            }
            if (MetaDataDictionary.getInstance().getPredefinedStyle(newName) != null) {
                selectors.add(newName);
            }
        } else if (MetaDataDictionary.getInstance().getPredefinedStyle(this.getName()) != null) {
            selectors.add(this.getName());
        }
        if (!selectors.isEmpty()) {
            DesignElement tmpContainer = this.getContainer();
            ArrayList<DesignElement> modules = new ArrayList<DesignElement>();
            if (this.getContainer() instanceof Theme) {
                Theme containerTheme = (Theme)tmpContainer;
                if (containerTheme.hasReferences()) {
                    List refs = ((Theme)tmpContainer).getClientList();
                    for (int i = 0; i < refs.size(); ++i) {
                        modules.add(((BackRef)refs.get(i)).getElement());
                    }
                }
            } else {
                modules.add(module);
            }
            for (int i = 0; i < modules.size(); ++i) {
                this.broadcastToModule((Module)modules.get(i), selectors);
            }
        }
    }

    private void broadcastToModule(Module module, List selectorList) {
        if (!$assertionsDisabled && selectorList.isEmpty()) {
            throw new AssertionError();
        }
        Iterator iter = selectorList.iterator();
        while (iter.hasNext()) {
            String selectorName = (String)iter.next();
            if (REPORT_SELECTOR.equals(selectorName)) {
                StyleEvent event = null;
                event = new StyleEvent(module);
                event.setDeliveryPath(2);
                module.broadcast(event);
                continue;
            }
            this.broadcastToSelectedElementsInSlot(module, module.getSlot(5), selectorName);
            this.broadcastToSelectedElementsInSlot(module, module.getSlot(4), selectorName);
            if (!(module instanceof ReportDesign)) continue;
            this.broadcastToSelectedElementsInSlot(module, module.getSlot(6), selectorName);
            this.broadcastToSelectedElementsInSlot(module, module.getSlot(7), selectorName);
        }
    }

    private void broadcastToSelectedElementsInSlot(Module module, ContainerSlot slot, String selectorName) {
        Iterator iter = slot.iterator();
        StyleEvent event = null;
        while (iter.hasNext()) {
            DesignElement element = (DesignElement)iter.next();
            if (!$assertionsDisabled && element == null) {
                throw new AssertionError();
            }
            event = new StyleEvent(element);
            event.setDeliveryPath(2);
            String selector = this.getMatchedElementSelector(element, selectorName);
            if (selector != null) {
                element.broadcast(event, module);
                continue;
            }
            if (this.checkSlotSelector(element, selectorName, event, module)) continue;
            int count = element.getDefn().getSlotCount();
            for (int i = 0; i < count; ++i) {
                this.broadcastToSelectedElementsInSlot(module, element.getSlot(i), selectorName);
            }
        }
    }

    private String getMatchedElementSelector(DesignElement element, String selectorName) {
        String selector = null;
        if (element instanceof ExtendedItem) {
            String tmpSelector = null;
            ExtensionElementDefn elementDefn = ((ExtendedItem)element).getExtDefn();
            if (elementDefn != null) {
                tmpSelector = elementDefn.getSelector();
            }
            if (tmpSelector != null && tmpSelector.equalsIgnoreCase(selectorName)) {
                selector = tmpSelector;
            }
        }
        if (selector == null) {
            selector = ((ElementDefn)element.getDefn()).getSelector();
        }
        if (selector != null && selector.equalsIgnoreCase(selectorName)) {
            return selector;
        }
        return null;
    }

    private boolean checkSlotSelector(DesignElement element, String selectorName, NotificationEvent event, Module module) {
        String selector = element.getContainer().getSelector(element.getContainerSlot());
        if (selector != null && selector.equalsIgnoreCase(selectorName)) {
            element.broadcast(event, module);
            return true;
        }
        return false;
    }

    static {
        $assertionsDisabled = !StyleElement.class.desiredAssertionStatus();
    }
}

