/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.script;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.SystemPropertyDefn;

public class PropertyDefinition {
    private PropertyDefn propDefn;

    public PropertyDefinition(PropertyDefn propDefn) {
        this.propDefn = propDefn;
    }

    boolean isUserProperty() {
        return this.propDefn.isUserProperty();
    }

    String getName() {
        return this.propDefn.getName();
    }

    String getGroup() {
        String groupName;
        if (this.propDefn instanceof SystemPropertyDefn && (groupName = ((SystemPropertyDefn)this.propDefn).getGroupName()) != null) {
            return groupName;
        }
        return "";
    }

    boolean canInherit() {
        if (this.propDefn instanceof SystemPropertyDefn) {
            return ((SystemPropertyDefn)this.propDefn).canInherit();
        }
        return false;
    }

    public boolean isStyle() {
        if (this.propDefn instanceof SystemPropertyDefn) {
            return ((SystemPropertyDefn)this.propDefn).isStyleProperty();
        }
        return false;
    }

    public String getType() {
        return this.propDefn.getType().getName();
    }

    public List getChoices() {
        ArrayList<String> choiceNames = new ArrayList<String>();
        if (this.propDefn.getChoices() != null) {
            IChoice[] choices = this.propDefn.getChoices().getChoices();
            if (choices != null) {
                for (int i = 0; i < choices.length; ++i) {
                    choiceNames.add(choices[i].getName());
                }
            }
            return choiceNames;
        }
        return null;
    }

    public Object getDefaultValue() {
        return this.propDefn.getDefault();
    }
}

