/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.Nas.gui.admin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.eclipse.aperi.Nas.gui.admin.NasAgentDDI;
import org.eclipse.aperi.TStorm.common.NasFilesystem;
import org.eclipse.aperi.TStorm.gui.PrimitiveConditionEditor;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BlackLabel;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.xmsg.MessageLog;

public class NasAgentPanel
extends JPanel
implements ActionListener {
    private MegaTable table = new MegaTable();
    private NasFilesystem[] dataArray;
    private NasFilesystem[] selectedFsArray;
    private NasAgentDDI.ListNode treeList;
    private NameList[] dummyArray;
    private NameList[] windowsAgents;
    private String actionCommand;
    private JButton editButton1;
    private JButton editButton2;
    private JButton okButton;
    private JButton cancelButton;
    private JDialog editDialog;
    private JLabel serverLabel;
    private JLabel domainLabel;
    private JLabel treeLabel;
    private JLabel nameLabel;
    private JLabel agentLabel;
    private JLabel serverField;
    private JLabel domainField;
    private JLabel treeField;
    private JLabel nameField;
    private TComboBox agentBox;
    private JLabel waitLabel1;
    private boolean dblClick;
    private boolean setAll;
    static final byte FOUND = 0;
    static final byte NOT_FOUND = 1;
    private DataDisplayInfo ddi;
    private TableMouseListener mouseListener;
    static final String EDIT1 = MessageLog.getMessageNoID("NAG0013L");
    static final String EDIT2 = MessageLog.getMessageNoID("NAG0014L");
    static final String SAVE = MessageLog.getMessageNoID("GUI0113L");
    static final String CANCEL = MessageLog.getMessageNoID("GUI0114L");
    static final String SERVER = MessageLog.getMessageNoID("NAG0015L");
    static final String DOMAIN = MessageLog.getMessageNoID("NAG0016L");
    static final String TREE = MessageLog.getMessageNoID("NAG0002L");
    static final String NAME = MessageLog.getMessageNoID("STG5003L");
    static final String AGENT = MessageLog.getMessageNoID("NAG0045L");
    static final String NONE = MessageLog.getMessageNoID("NAG0032L");
    static final String[] colNames = new String[]{SERVER, DOMAIN, TREE, NAME, AGENT};
    static final int SERVER_COL = 0;
    static final int DOMAIN_COL = 1;
    static final int TREE_COL = 2;
    static final int NAME_COL = 3;
    static final int AGENT_COL = 4;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public NasAgentPanel(DataDisplayInfo dataDisplayInfo, NasFilesystem[] nasFilesystemArray, NasAgentDDI.ListNode listNode, NameList[] nameListArray) {
        this.ddi = dataDisplayInfo;
        this.dataArray = nasFilesystemArray;
        this.windowsAgents = nameListArray;
        this.treeList = listNode;
        this.setLayout(new BorderLayout());
        this.dummyArray = new NameList[1];
        this.dummyArray[0] = new NameList();
        this.dummyArray[0].nlName = NONE;
        this.dummyArray[0].nlID = -1;
        this.mouseListener = new TableMouseListener();
        this.editButton1 = new JButton(EDIT1);
        this.editButton1.setEnabled(false);
        this.editButton1.setActionCommand(EDIT1);
        this.editButton1.addActionListener(this);
        GuiUtil.setAccessible(this.editButton1, this.editButton1.getText(), this.editButton1.getText());
        this.editButton1.setToolTipText(Util.getString("TOOLTIP_BUTTON_AGENTROW"));
        this.editButton2 = new JButton(EDIT2);
        this.editButton2.setEnabled(false);
        this.editButton2.setActionCommand(EDIT2);
        this.editButton2.addActionListener(this);
        GuiUtil.setAccessible(this.editButton2, this.editButton2.getText(), this.editButton2.getText());
        this.editButton2.setToolTipText(Util.getString("TOOLTIP_BUTTON_AGENTALL"));
        JPanel jPanel = new JPanel();
        jPanel.add(this.editButton1);
        jPanel.add(this.editButton2);
        this.add((Component)jPanel, "North");
        if (nasFilesystemArray == null || nasFilesystemArray.length == 0) {
            JPanel jPanel2 = new JPanel();
            jPanel2.add(new JLabel(MessageLog.getMessageNoID("STG0020M")));
            this.add((Component)jPanel2, "Center");
        } else {
            this.table.setBaseTableModel(new TableModel());
            this.table.setMouseListener(this.mouseListener);
            this.add((Component)this.table, "Center");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.updateDataArray();
            this.editDialog.dispose();
        } else if (object == this.cancelButton) {
            this.editDialog.dispose();
        } else {
            this.setAll = object != this.editButton1;
            this.editSelected();
        }
    }

    private void editSelected() {
        int[] nArray = this.table.getSelectedRows();
        int n = nArray.length;
        if (this.setAll) {
            this.selectedFsArray = new NasFilesystem[n];
            int n2 = 0;
            while (n2 < n) {
                this.selectedFsArray[n2] = this.dataArray[nArray[n2]];
                ++n2;
            }
            this.editInstance();
        } else {
            this.selectedFsArray = new NasFilesystem[1];
            int n3 = 0;
            while (n3 < n) {
                this.selectedFsArray[0] = this.dataArray[nArray[n3]];
                this.editInstance();
                ++n3;
            }
        }
        this.editButton1.setEnabled(false);
        this.editButton2.setEnabled(false);
    }

    private void editInstance() {
        Object object;
        NameList[] nameListArray;
        NasFilesystem nasFilesystem = this.selectedFsArray[0];
        this.editDialog = new JDialog(this.guiMain.getFrame(), true);
        this.editDialog.setTitle(MessageLog.getMessageNoID("NAG0020L"));
        if (this.okButton == null) {
            this.okButton = new JButton(SAVE);
            this.okButton.setActionCommand(SAVE);
            this.cancelButton = new JButton(CANCEL);
            this.cancelButton.setActionCommand(CANCEL);
            this.serverLabel = new BlackLabel(SERVER);
            this.domainLabel = new BlackLabel(DOMAIN);
            this.treeLabel = new BlackLabel(TREE);
            this.nameLabel = new BlackLabel(NAME);
            this.agentLabel = new BlackLabel(AGENT);
            this.waitLabel1 = new BlackLabel(" ");
            this.waitLabel1.setFont(BaseTree.plainFont);
            this.okButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
        }
        this.okButton.setEnabled(true);
        this.serverField = new JLabel(nasFilesystem.nflServerName);
        this.domainField = new JLabel(nasFilesystem.nflDomainName);
        this.treeField = new JLabel(nasFilesystem.nflTreeName);
        this.nameField = new JLabel(nasFilesystem.nflFsName);
        NameList[] nameListArray2 = this.getTreeAgents();
        NameList[] nameListArray3 = this.getNasAgents();
        if (nameListArray2 != null && nameListArray3 != null) {
            nameListArray2 = this.mergeLists(nameListArray2, nameListArray3);
        }
        if ((nameListArray = nameListArray2 != null ? nameListArray2 : nameListArray3) == null) {
            this.waitLabel1.setText(MessageLog.getMessageNoID("NAG0007L"));
            this.agentBox = new TComboBox(this.dummyArray);
        } else {
            this.waitLabel1.setText(" ");
            object = new NameList[1 + nameListArray.length];
            object[0] = this.dummyArray[0];
            System.arraycopy(nameListArray, 0, object, 1, nameListArray.length);
            this.agentBox = new TComboBox((Object[])object);
            int n = 0;
            int n2 = 0;
            while (n2 < ((Object)object).length) {
                if (((NameList)object[n2]).nlID2 == nasFilesystem.nflAgentID) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            this.agentBox.setSelectedIndex(n);
        }
        GuiUtil.setAccessibleLabel(this.agentLabel, this.agentBox, "MNEMONIC_LABEL_AGENT", this.agentLabel.getText(), this.agentLabel.getText());
        object = new JPanel();
        ((Container)object).setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.left = 8;
        gridBagConstraints.insets.top = 4;
        gridBagConstraints.insets.bottom = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        Color color = jPanel.getBackground();
        JTextArea jTextArea = new JTextArea();
        jTextArea.setBackground(color);
        jTextArea.setEditable(false);
        jTextArea.setRows(3);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(GuiUtil.wrapAtWords());
        jTextArea.setText(MessageLog.getMessageNoID("ADG0303L"));
        jTextArea.setFont(jTextArea.getFont().deriveFont(1));
        jPanel.add((Component)jTextArea, gridBagConstraints);
        this.addSeparator((JPanel)object, gridBagConstraints);
        this.addLabeledComponent(this.serverLabel, this.serverField, (JPanel)object, gridBagConstraints);
        this.addLabeledComponent(this.domainLabel, this.domainField, (JPanel)object, gridBagConstraints);
        this.addLabeledComponent(this.treeLabel, this.treeField, (JPanel)object, gridBagConstraints);
        this.addLabeledComponent(this.nameLabel, this.nameField, (JPanel)object, gridBagConstraints);
        this.addLabeledComponent(this.agentLabel, this.agentBox, (JPanel)object, gridBagConstraints);
        this.addSeparator((JPanel)object, gridBagConstraints);
        gridBagConstraints.insets.bottom = 0;
        ((Container)object).add((Component)this.waitLabel1, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.okButton);
        jPanel2.add(this.cancelButton);
        Container container = this.editDialog.getContentPane();
        container.add((Component)jPanel, "North");
        container.add((Component)object, "Center");
        container.add((Component)jPanel2, "South");
        Help.setHelpID(this.editDialog.getRootPane(), "asco65");
        this.editDialog.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
        this.editDialog.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
        this.editDialog.getRootPane().setDefaultButton(this.okButton);
        GuiUtil.centerDialog(this.editDialog);
        this.editDialog.pack();
        this.editDialog.show();
    }

    private void addLabeledComponent(JLabel jLabel, JComponent jComponent, JPanel jPanel, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        jPanel.add((Component)jComponent, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel.add(Box.createVerticalStrut(8), gridBagConstraints);
    }

    private void addSeparator(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        Color color = this.getBackground();
        PrimitiveConditionEditor.HorizontalSeparator horizontalSeparator = new PrimitiveConditionEditor.HorizontalSeparator(color);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.right = 8;
        jPanel.add((Component)horizontalSeparator, gridBagConstraints);
        gridBagConstraints.insets.right = 0;
    }

    private NameList[] getTreeAgents() {
        NasFilesystem nasFilesystem = null;
        NameList[] nameListArray = null;
        int n = 0;
        while (n < this.selectedFsArray.length) {
            if (this.selectedFsArray[n].nflAgentArray == null) {
                nasFilesystem = this.selectedFsArray[n];
                break;
            }
            ++n;
        }
        if (nasFilesystem != null) {
            NasAgentDDI.ListNode listNode = this.treeList;
            while (listNode != null) {
                if (listNode.name.equals(nasFilesystem.nflTreeName)) {
                    nameListArray = listNode.agentArray;
                    break;
                }
                listNode = listNode.next;
            }
            if (nameListArray != null && this.selectedFsArray.length > 1) {
                NameList nameList;
                NameList nameList2 = null;
                int n2 = 0;
                while (n2 < nameListArray.length) {
                    nameListArray[n2].nlState = 0;
                    nameListArray[n2].nlNext = nameList2;
                    nameList2 = nameListArray[n2];
                    ++n2;
                }
                int n3 = n + 1;
                while (n3 < this.selectedFsArray.length) {
                    NasFilesystem nasFilesystem2 = this.selectedFsArray[n3];
                    if (nasFilesystem2.nflAgentArray == null) {
                        listNode = this.treeList;
                        while (listNode != null) {
                            if (listNode.name.equals(nasFilesystem2.nflTreeName)) {
                                NameList[] nameListArray2 = listNode.agentArray;
                                nameList = nameList2;
                                while (nameList != null) {
                                    int n4 = 0;
                                    while (n4 < nameListArray2.length) {
                                        if (nameListArray2[n4].nlID2 == nameList.nlID2) break;
                                        ++n4;
                                    }
                                    if (n4 >= nameListArray2.length) {
                                        nameList.nlState = 1;
                                    }
                                    nameList = nameList.nlNext;
                                }
                                break;
                            }
                            listNode = listNode.next;
                        }
                        if (listNode == null) {
                            nameListArray = null;
                            break;
                        }
                    }
                    ++n3;
                }
                if (nameListArray != null) {
                    n3 = 0;
                    int n5 = 0;
                    nameList = nameList2;
                    while (nameList != null) {
                        if (nameList.nlState == 0) {
                            ++n3;
                        }
                        ++n5;
                        nameList = nameList.nlNext;
                    }
                    if (n3 == 0) {
                        nameListArray = null;
                    } else if (n3 != n5) {
                        nameListArray = new NameList[n3];
                        int n6 = 0;
                        nameList = nameList2;
                        while (nameList != null) {
                            if (nameList.nlState == 0) {
                                nameListArray[n6] = nameList;
                                ++n6;
                            }
                            nameList = nameList.nlNext;
                        }
                    }
                }
            }
        }
        return nameListArray;
    }

    private NameList[] getNasAgents() {
        NameList[] nameListArray = null;
        int n = 0;
        while (n < this.selectedFsArray.length) {
            if (this.selectedFsArray[n].nflAgentArray != null) {
                nameListArray = this.selectedFsArray[n].nflAgentArray;
                break;
            }
            ++n;
        }
        if (nameListArray != null && this.selectedFsArray.length > 1) {
            NameList nameList;
            NameList nameList2 = null;
            int n2 = 0;
            while (n2 < nameListArray.length) {
                nameListArray[n2].nlState = 0;
                nameListArray[n2].nlNext = nameList2;
                nameList2 = nameListArray[n2];
                ++n2;
            }
            int n3 = n + 1;
            while (n3 < this.selectedFsArray.length) {
                NasFilesystem nasFilesystem = this.selectedFsArray[n3];
                if (nasFilesystem.nflAgentArray != null) {
                    NameList[] nameListArray2 = nasFilesystem.nflAgentArray;
                    nameList = nameList2;
                    while (nameList != null) {
                        int n4 = 0;
                        while (n4 < nameListArray2.length) {
                            if (nameListArray2[n4].nlID2 == nameList.nlID2) break;
                            ++n4;
                        }
                        if (n4 >= nameListArray2.length) {
                            nameList.nlState = 1;
                        }
                        nameList = nameList.nlNext;
                    }
                }
                ++n3;
            }
            if (nameListArray != null) {
                n3 = 0;
                int n5 = 0;
                nameList = nameList2;
                while (nameList != null) {
                    if (nameList.nlState == 0) {
                        ++n3;
                    }
                    ++n5;
                    nameList = nameList.nlNext;
                }
                if (n3 == 0) {
                    nameListArray = null;
                } else if (n3 != n5) {
                    nameListArray = new NameList[n3];
                    int n6 = 0;
                    nameList = nameList2;
                    while (nameList != null) {
                        if (nameList.nlState == 0) {
                            nameListArray[n6] = nameList;
                            ++n6;
                        }
                        nameList = nameList.nlNext;
                    }
                }
            }
        }
        return nameListArray;
    }

    private NameList[] mergeLists(NameList[] nameListArray, NameList[] nameListArray2) {
        int n;
        NameList[] nameListArray3 = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nameListArray.length) {
            nameListArray[n3].nlState = 1;
            n = 0;
            while (n < nameListArray2.length) {
                if (nameListArray2[n].nlID2 == nameListArray[n3].nlID2) {
                    nameListArray[n3].nlState = 0;
                    ++n2;
                    break;
                }
                ++n;
            }
            ++n3;
        }
        if (n2 > 0) {
            nameListArray3 = new NameList[n2];
            n3 = 0;
            n = 0;
            while (n < nameListArray.length) {
                if (nameListArray[n].nlState == 0) {
                    nameListArray3[n3] = nameListArray[n];
                    ++n3;
                }
                ++n;
            }
        }
        return nameListArray3;
    }

    private void updateDataArray() {
        NameList nameList = (NameList)this.agentBox.getSelectedItem();
        int n = 0;
        while (n < this.selectedFsArray.length) {
            this.selectedFsArray[n].nflAgentID = nameList.nlID2;
            this.selectedFsArray[n].nflAgentName = nameList.nlID2 > 0 ? nameList.nlName : "";
            ++n;
        }
    }

    private class TableModel
    extends BaseTableModel {
        public TableModel() {
            this.columnNames = colNames;
            this.rowCount = NasAgentPanel.this.dataArray.length;
        }

        public Object getTableDataItem(int n, int n2) {
            String string = null;
            if (n2 == 0) {
                string = ((NasAgentPanel)NasAgentPanel.this).dataArray[n].nflServerName;
            } else if (n2 == 1) {
                string = ((NasAgentPanel)NasAgentPanel.this).dataArray[n].nflDomainName;
            } else if (n2 == 2) {
                string = ((NasAgentPanel)NasAgentPanel.this).dataArray[n].nflTreeName;
            } else if (n2 == 3) {
                string = ((NasAgentPanel)NasAgentPanel.this).dataArray[n].nflFsName;
            } else if (n2 == 4) {
                string = ((NasAgentPanel)NasAgentPanel.this).dataArray[n].nflAgentName;
            }
            return string;
        }
    }

    private class TableMouseListener
    extends TJCTableMouseAdapter {
        private TableMouseListener() {
        }

        public boolean select(int n, int n2) {
            boolean bl = ((NasAgentPanel)NasAgentPanel.this).guiMain.getUserPrefs().administrator;
            if (NasAgentPanel.this.dblClick) {
                NasAgentPanel.this.dblClick = false;
                bl = false;
            }
            return bl;
        }

        public void selectionChanged(boolean bl) {
            NasAgentPanel.this.editButton1.setEnabled(bl);
            NasAgentPanel.this.editButton2.setEnabled(bl);
        }

        public void doubleClick(int n, int n2) {
            if (((NasAgentPanel)NasAgentPanel.this).guiMain.getUserPrefs().administrator) {
                NasAgentPanel.this.selectedFsArray = new NasFilesystem[1];
                ((NasAgentPanel)NasAgentPanel.this).selectedFsArray[0] = NasAgentPanel.this.dataArray[n];
                NasAgentPanel.this.editInstance();
                NasAgentPanel.this.dblClick = true;
            }
        }
    }
}

