/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.ComputerList;
import org.eclipse.aperi.TStorm.common.ComputersAdjuster;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.DiskAdjuster;
import org.eclipse.aperi.TStorm.common.HistChartProcessor;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.RespFSspace;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskCapacityAdjuster
extends CustomReportDataAdjuster {
    private static final String PATH = MessageLog.getMessageNoID("STG1219L");
    private static final String DOMAIN = MessageLog.getMessageNoID("STG1104L");
    private static final String CREATOR = MessageLog.getMessageNoID("STG0021L");
    private static final String GROUP = MessageLog.getMessageNoID("STG1103L");
    private static final String COMPUTER = MessageLog.getMessageNoID("STG1102L");
    private static final String CLUSTER = MessageLog.getMessageNoID("STG1136L");
    private static final String OSTYPE = MessageLog.getMessageNoID("STG1108L");
    private static final String NETWORKADDR = MessageLog.getMessageNoID("STG1281L");
    private static final String IPADDRESS = MessageLog.getMessageNoID("STG1280L");
    private static final String TIMEZONE = MessageLog.getMessageNoID("STG1282L");
    private static final String NAME = MessageLog.getMessageNoID("STG0023T");
    private static final String NUM_DISKS = MessageLog.getMessageNoID("STG6057L");
    private static final String DISK_CAP = MessageLog.getMessageNoID("STG1115L");
    private static final String DISK_FREESP = MessageLog.getMessageNoID("SAG0047I");
    private static final String LUNS = MessageLog.getMessageNoID("STG6058L");
    private static final String LUN_CAP = MessageLog.getMessageNoID("STG6059L");
    public static final String OVERHEAD = MessageLog.getMessageNoID("STG6054L");
    private static final String CACHE = MessageLog.getMessageNoID("STG6056L");
    private static final String FIRMWARE = MessageLog.getMessageNoID("STG1146L");
    private static final String CAPACITY = MessageLog.getMessageNoID("STG1162L");
    public static final String UNALLOCATED = MessageLog.getMessageNoID("STG4131L");
    private static final String MANUF = MessageLog.getMessageNoID("STG1105L");
    private static final String MODEL = MessageLog.getMessageNoID("STG1106L");
    private static final String PRIDEF = MessageLog.getMessageNoID("STG1174L");
    private static final String GROWNDEF = MessageLog.getMessageNoID("STG1175L");
    private static final String SERIAL = MessageLog.getMessageNoID("STG1107L");
    private static final String UNKNOWN = MessageLog.getMessageNoID("STG1020L");
    private static final String NETWORK = MessageLog.getMessageNoID("STG5048L");
    public static final String USED_SPACE = MessageLog.getMessageNoID("STG2005L");
    public static final String FREE_SPACE = MessageLog.getMessageNoID("STG2006L");
    public static final String RAW_CAPACITY = MessageLog.getMessageNoID("STG5521L");
    public static final String UNKNOWN_LCAP = MessageLog.getMessageNoID("STG5522L");
    public static final String NOT_APPLICABLE = MessageLog.getMessageNoID("STG0019T");
    private static final String IN_DISK_ARRAY = MessageLog.getMessageNoID("SAG0200L");
    private static final String USEABLE = MessageLog.getMessageNoID("STG6080L");
    private static final String ASSIGNED = MessageLog.getMessageNoID("STG6081L");
    private static final String UNASSIGNED = MessageLog.getMessageNoID("STG6082L");
    private static final String VS_CAP = MessageLog.getMessageNoID("SAG0048I");
    private static final String VS_FREESP = MessageLog.getMessageNoID("SAG0049I");
    private static final String VS_OVERHEAD = MessageLog.getMessageNoID("SAG0050I");
    private static final String DG_UFCAP = MessageLog.getMessageNoID("SAG0051I");
    private static final String STORSUBASSIGNEDCAPACITY = MessageLog.getMessageNoID("STG7559L");
    private static final String STORSUBUNASSIGNEDCAPACITY = MessageLog.getMessageNoID("STG7560L");
    private static final String STORSUBFORMATTEDDFRESPACE = MessageLog.getMessageNoID("STG7561L");
    private static final String ZOSLUNCAPACITY = MessageLog.getMessageNoID("STG7562L");
    private static final String OPENSYSLUNCAPACITY = MessageLog.getMessageNoID("STG7563L");
    private static final String TOTAL_SCSI_CAPACITY = MessageLog.getMessageNoID("STG7038L");
    private static final String TOTAL_FC_CAPACITY = MessageLog.getMessageNoID("STG7039L");
    private static final String TOTAL_SCSI_UNALLOCATED_SPACE = MessageLog.getMessageNoID("STG7040L");
    private static final String TOTAL_FC_UNALLOCATED_SPACE = MessageLog.getMessageNoID("STG7041L");
    private static String TOTAL_TC;
    private static String TOTAL_TF;
    private static String OWNED_OC;
    private static String OWNED_OF;
    private static String CAPACITY_TC;
    private static String CAPACITY_OC;
    private static String UNALLOCATED_TF;
    private static String UNALLOCATED_OF;
    private static String SPACE_TF;
    private static String SPACE_OF;
    private static String CPU;
    private static String ARCHITECTURE;
    private static String TOTAL_SCSI;
    private static String TOTAL_SCSI_U;
    private static String SCSI_CAPACITY;
    private static String SCSI_UNALLOCATED;
    private static String SCSI_SPACE;
    private static String TOTAL_FC;
    private static String TOTAL_FC_U;
    private static String FC_CAPACITY;
    private static String FC_UNALLOCATED;
    private static String FC_SPACE;
    public String[] colNames;
    private String[] colNames1 = new String[]{" ", " ", CAPACITY, UNALLOCATED};
    private String[] compColNames1 = new String[]{" ", " ", CAPACITY_TC, UNALLOCATED_TF};
    private String[] dskColNames = new String[]{" ", " ", CAPACITY, UNALLOCATED, IN_DISK_ARRAY, MANUF, MODEL, SERIAL, PRIDEF, GROWNDEF};
    private String[] dskColNamesForDrillDown = new String[]{" ", " ", CAPACITY, UNALLOCATED, MANUF, MODEL, SERIAL, PRIDEF, GROWNDEF};
    private String[] compColNames2 = new String[]{" ", " ", String.valueOf(TOTAL_TC) + " " + CAPACITY_TC, String.valueOf(TOTAL_TF) + " " + UNALLOCATED_TF + " " + SPACE_TF, String.valueOf(OWNED_OC) + " " + CAPACITY_OC, String.valueOf(OWNED_OF) + " " + UNALLOCATED_OF + " " + SPACE_OF, String.valueOf(TOTAL_SCSI) + " " + SCSI_CAPACITY, String.valueOf(TOTAL_SCSI_U) + " " + SCSI_UNALLOCATED + " " + SCSI_SPACE, String.valueOf(TOTAL_FC) + " " + FC_CAPACITY, String.valueOf(TOTAL_FC_U) + " " + FC_UNALLOCATED + " " + FC_SPACE};
    private static String[] compColNames;
    private String[] netColNames = new String[]{" ", " ", CAPACITY, USED_SPACE, FREE_SPACE, RAW_CAPACITY, OVERHEAD, UNALLOCATED, UNKNOWN_LCAP};
    private String[] subColNames = new String[]{" ", NAME, DISK_CAP, DISK_FREESP, NUM_DISKS, LUNS, LUN_CAP, USEABLE, ASSIGNED, UNASSIGNED, OVERHEAD, VS_CAP, VS_FREESP, VS_OVERHEAD, DG_UFCAP, CACHE, MANUF, MODEL, SERIAL, FIRMWARE, STORSUBASSIGNEDCAPACITY, STORSUBUNASSIGNEDCAPACITY, STORSUBFORMATTEDDFRESPACE, ZOSLUNCAPACITY, OPENSYSLUNCAPACITY};
    public static final int QUAL_COL = 0;
    private static final int NAME_COL = 1;
    private static final int CAPACITY_COL = 2;
    private static final int UNALLOCATED_COL = 3;
    private static final int OWNEDCAP_COL = 4;
    private static final int OWNEDFREESP_COL = 5;
    private static final int SCSI_DISK_CAP_COL = 6;
    private static final int SCSI_DISK_FREE_COL = 7;
    private static final int FC_DISK_CAP_COL = 8;
    private static final int FC_DISK_FREE_COL = 9;
    private static final int OSTYPE_COL = 10;
    private static final int NETWORKADDR_COL = 11;
    private static final int IPADDRESS_COL = 12;
    private static final int TIMEZONE_COL = 13;
    private static final int CPU_ARCH_COL = 14;
    private static final int COMPUTER_COL = 0;
    private static final int IN_ARRAY_COL = 4;
    private static final int MFR_COL = 5;
    private static final int MODEL_COL = 6;
    private static final int SERIAL_NUM_COL = 7;
    private static final int PRI_DEF_COL = 8;
    private static final int GROWN_DEF_COL = 9;
    private static final int MFR_COL_FOR_DRILL_DOWN = 4;
    private static final int MODEL_COL_FOR_DRILL_DOWN = 5;
    private static final int SERIAL_NUM_COL_FOR_DRILL_DOWN = 6;
    private static final int PRI_DEF_COL_FOR_DRILL_DOWN = 7;
    private static final int GROWN_DEF_COL_FOR_DRILL_DOWN = 8;
    private static final int USED_SPACE_COL = 3;
    private static final int FREE_SPACE_COL = 4;
    private static final int RAW_CAPACITY_COL = 5;
    private static final int OVERHEAD_COL = 6;
    private static final int NET_UNALLOCATED_COL = 7;
    private static final int UNKNOWN_COL = 8;
    public static final int SQUAL_COL = 0;
    private static final int SNAME_COL = 1;
    private static final int SCAPACITY_COL = 2;
    private static final int SFREESP_COL = 3;
    private static final int SDISKS_COL = 4;
    private static final int SLUNS_COL = 5;
    private static final int SLUNCAP_COL = 6;
    private static final int SUSEABLE_COL = 7;
    private static final int SASSIGNED_COL = 8;
    private static final int SUNASSIGNED_COL = 9;
    private static final int SOVERHEAD_COL = 10;
    private static final int SVSCAPACITY_COL = 11;
    private static final int SVSFREESPACE_COL = 12;
    private static final int SVOVERHEAD_COL = 13;
    private static final int SUFDGCAP_COL = 14;
    private static final int SCACHE_COL = 15;
    private static final int SMANUF_COL = 16;
    private static final int SMODEL_COL = 17;
    private static final int SSERIAL_COL = 18;
    private static final int SFIRM_COL = 19;
    private static final int STORSUBASSIGNEDCAPACITY_COL = 20;
    private static final int STORSUBUNASSIGNEDCAPACITY_COL = 21;
    private static final int STORSUBFORMATTEDDFRESPACE_COL = 22;
    private static final int ZOSLUNCAPACITY_COL = 23;
    private static final int OPENSYSLUNCAPACITY_COL = 24;
    private GuiReportReq grr;
    private RespFSspace[] data;
    private MutableLong[] mLong;
    private MutableInteger[] mInt;
    private GComputer[] gcomputer;
    private ComputerList computerList;
    private int[] rendererArray;
    private int rows;
    public int frozenRows;
    public int frozenLabels;
    public int totalRow;
    public static final int FROZEN_LABEL_ROWS = 0;
    public static final int FROZEN_ROWS = 2;
    public static final int FROZEN_COLUMNS = 2;
    private boolean batch;
    private ColumnPopulator populator;

    static {
        String[] stringArray = new String[2];
        String[] stringArray2 = new String[3];
        Util.breakIntoTwo(MessageLog.getMessageNoID("STG7012L"), stringArray);
        TOTAL_TC = stringArray[0];
        CAPACITY_TC = stringArray[1];
        Util.breakIntoTwo(TOTAL_SCSI_CAPACITY, stringArray);
        TOTAL_SCSI = stringArray[0];
        SCSI_CAPACITY = stringArray[1];
        Util.breakIntoTwo(TOTAL_FC_CAPACITY, stringArray);
        TOTAL_FC = stringArray[0];
        FC_CAPACITY = stringArray[1];
        Util.breakIntoThree(TOTAL_SCSI_UNALLOCATED_SPACE, stringArray2);
        TOTAL_SCSI_U = stringArray2[0];
        SCSI_UNALLOCATED = stringArray2[1];
        SCSI_SPACE = stringArray2[2];
        Util.breakIntoThree(TOTAL_FC_UNALLOCATED_SPACE, stringArray2);
        TOTAL_FC_U = stringArray2[0];
        FC_UNALLOCATED = stringArray2[1];
        FC_SPACE = stringArray2[2];
        Util.breakIntoThree(MessageLog.getMessageNoID("STG7013L"), stringArray2);
        TOTAL_TF = stringArray2[0];
        UNALLOCATED_TF = stringArray2[1];
        SPACE_TF = stringArray2[2];
        Util.breakIntoTwo(MessageLog.getMessageNoID("STG7014L"), stringArray);
        OWNED_OC = stringArray[0];
        CAPACITY_OC = stringArray[1];
        Util.breakIntoThree(MessageLog.getMessageNoID("STG7015L"), stringArray2);
        OWNED_OF = stringArray2[0];
        UNALLOCATED_OF = stringArray2[1];
        SPACE_OF = stringArray2[2];
        Util.breakIntoTwo(MessageLog.getMessageNoID("STG1038L"), stringArray);
        CPU = stringArray[0];
        ARCHITECTURE = stringArray[1];
        compColNames = new String[]{" ", COMPUTER, String.valueOf(TOTAL_TC) + " " + CAPACITY_TC, String.valueOf(TOTAL_TF) + " " + UNALLOCATED_TF + " " + SPACE_TF, String.valueOf(OWNED_OC) + " " + CAPACITY_OC, String.valueOf(OWNED_OF) + " " + UNALLOCATED_OF + " " + SPACE_OF, String.valueOf(TOTAL_SCSI) + " " + SCSI_CAPACITY, String.valueOf(TOTAL_SCSI_U) + " " + SCSI_UNALLOCATED + " " + SCSI_SPACE, String.valueOf(TOTAL_FC) + " " + FC_CAPACITY, String.valueOf(TOTAL_FC_U) + " " + FC_UNALLOCATED + " " + FC_SPACE, OSTYPE, NETWORKADDR, IPADDRESS, TIMEZONE, String.valueOf(CPU) + " " + ARCHITECTURE};
    }

    public DiskCapacityAdjuster(GuiReportReq guiReportReq) {
        super(guiReportReq);
        this.grr = guiReportReq;
        this.populator = null;
        this.frozenColumns = 2;
        if (guiReportReq.reportSubtype == 77 || guiReportReq.reportType == 72) {
            this.populator = new BySubsystemPopulator();
            this.colNames = this.subColNames;
            this.frozenRows = 0;
            this.frozenLabels = 0;
            if (guiReportReq.reportSubtype == 78) {
                this.frozenColumns = 3;
            }
            this.rendererArray = new int[this.colNames.length];
            this.rendererArray[2] = 7;
            this.rendererArray[3] = 7;
            this.rendererArray[6] = 7;
            this.rendererArray[7] = 7;
            this.rendererArray[8] = 7;
            this.rendererArray[9] = 7;
            this.rendererArray[10] = 7;
            this.rendererArray[15] = 7;
            this.rendererArray[11] = 7;
            this.rendererArray[12] = 7;
            this.rendererArray[13] = 7;
            this.rendererArray[14] = 7;
            this.rendererArray[4] = 5;
            this.rendererArray[5] = 5;
            this.rendererArray[20] = 7;
            this.rendererArray[21] = 7;
            this.rendererArray[22] = 7;
            this.rendererArray[23] = 7;
            this.rendererArray[24] = 7;
        } else {
            this.colNames = this.colNames1;
            if (guiReportReq.reportSubtype == 12 || guiReportReq.reportSubtype == 82 || guiReportReq.reportSubtype == 13) {
                this.frozenRows = 0;
                this.frozenLabels = 0;
                this.colNames = this.compColNames1;
            } else {
                this.frozenRows = 0;
                this.frozenLabels = 0;
                this.frozenColumns = 0;
            }
            switch (guiReportReq.reportSubtype) {
                case 27: {
                    if (guiReportReq.reportSubtypeOrig == 77 || guiReportReq.reportSubtypeOrig == 12) {
                        this.populator = new ByDiskForDrillDownPopulator();
                        this.colNames = this.dskColNamesForDrillDown;
                    } else {
                        this.populator = new ByDiskPopulator();
                        this.colNames = this.dskColNames;
                    }
                    this.colNames[0] = COMPUTER;
                    this.colNames[1] = PATH;
                    break;
                }
                case 12: {
                    this.colNames = compColNames;
                    break;
                }
                case 13: {
                    this.colNames = this.compColNames2;
                    this.colNames[0] = CREATOR;
                    this.colNames[1] = GROUP;
                    break;
                }
                case 82: {
                    this.colNames = this.compColNames2;
                    this.colNames[0] = CREATOR;
                    this.colNames[1] = CLUSTER;
                    break;
                }
                case 14: {
                    this.colNames[1] = DOMAIN;
                    break;
                }
                case 15: {
                    this.populator = new NetworkWidePopulator();
                    this.colNames = this.netColNames;
                }
            }
            if (this.populator == null) {
                this.populator = new ByComputerPopulator();
            }
            this.rendererArray = new int[this.colNames.length];
            this.rendererArray[2] = 7;
            if (guiReportReq.reportSubtype != 15) {
                this.rendererArray[3] = 7;
            }
            if (guiReportReq.reportSubtype == 12 || guiReportReq.reportSubtype == 82 || guiReportReq.reportSubtype == 13) {
                this.rendererArray[4] = 7;
                this.rendererArray[5] = 7;
                this.rendererArray[6] = 7;
                this.rendererArray[7] = 7;
                this.rendererArray[8] = 7;
                this.rendererArray[9] = 7;
            } else if (guiReportReq.reportSubtype == 27) {
                this.rendererArray[8] = 5;
                if (guiReportReq.reportSubtypeOrig == 77 || guiReportReq.reportSubtypeOrig == 12) {
                    this.rendererArray[8] = 5;
                } else {
                    this.rendererArray[9] = 5;
                }
            } else if (guiReportReq.reportSubtype == 15) {
                this.rendererArray[3] = 7;
                this.rendererArray[4] = 7;
                this.rendererArray[5] = 7;
                this.rendererArray[6] = 7;
                this.rendererArray[7] = 7;
                this.rendererArray[8] = 7;
            }
        }
        if (guiReportReq.reportSubtype != 27 && guiReportReq.reportSubtype != 13) {
            if (guiReportReq.reportSubtype == 15) {
                this.hiddenColumns = new int[2];
                this.hiddenColumns[1] = 1;
            } else {
                this.hiddenColumns = new int[1];
            }
            this.hiddenColumns[0] = 0;
        }
        this.colNames = this.getCustomizedColNames(this.colNames);
    }

    public void adjust(Object[] objectArray, boolean bl) {
        if (this.grr.reportSubtype == 77) {
            Arrays.sort(objectArray, new SubSysSorter());
        } else {
            Arrays.sort(objectArray, new Sorter());
        }
        this.adjustInit(objectArray, bl);
        this.adjustData();
    }

    public void adjustInit(Object[] objectArray, boolean bl) {
        this.batch = bl;
        this.data = (RespFSspace[])objectArray;
        this.rows = this.data.length;
        if (this.grr.reportSubtype == 77 || this.grr.reportType == 72) {
            if (this.rows > 1) {
                this.addTotal();
            }
            int n = this.data.length;
            this.mLong = new MutableLong[n];
            this.mInt = new MutableInteger[n];
            int n2 = 0;
            while (n2 < n) {
                this.mLong[n2] = new MutableLong();
                this.mInt[n2] = new MutableInteger();
                ++n2;
            }
        } else {
            if (this.grr.reportSubtype == 27 && this.rows > 1) {
                this.addTotal();
            }
            int n = this.data.length;
            this.mLong = new MutableLong[n];
            this.mInt = new MutableInteger[n];
            this.gcomputer = new GComputer[n];
            if (bl) {
                this.computerList = new ComputerList();
            }
            int n3 = 0;
            while (n3 < n) {
                this.mLong[n3] = new MutableLong();
                this.mInt[n3] = new MutableInteger();
                ++n3;
            }
        }
    }

    public void adjustData() {
        if (this.grr.reportSubtype == 77 || this.grr.reportType == 72) {
            int n = this.data.length;
            int n2 = 0;
            while (n2 < n) {
                RespFSspace respFSspace = this.data[n2];
                respFSspace.creator = " ";
                respFSspace.capacity *= 512L;
                respFSspace.freeSpace *= 512L;
                respFSspace.lun_capacity *= 512L;
                respFSspace.fsFreeSpace *= 512L;
                respFSspace.fs_capacity *= 512L;
                respFSspace.vs_capacity *= 512L;
                respFSspace.vs_freespace *= 512L;
                respFSspace.dg_freecap *= 512L;
                respFSspace.overhead *= 512L;
                respFSspace.total_overhead *= 512L;
                respFSspace.disk_assigned_capacity *= 512L;
                respFSspace.disk_unassigned_capacity *= 512L;
                respFSspace.disk_total_formatted_free_space *= 512L;
                respFSspace.zos_lun_capacity *= 512L;
                respFSspace.open_sys_lun_capacity *= 512L;
                ++n2;
            }
        } else {
            int n = this.data.length;
            int n3 = 0;
            while (n3 < n) {
                RespFSspace respFSspace = this.data[n3];
                respFSspace.capacity *= 512L;
                respFSspace.freeSpace *= 512L;
                respFSspace.owned_capacity *= 512L;
                respFSspace.owned_freeSp *= 512L;
                respFSspace.FC_capacity *= 512L;
                respFSspace.FC_freespace *= 512L;
                respFSspace.SCSI_capacity *= 512L;
                respFSspace.SCSI_freespace *= 512L;
                if (n3 >= this.totalRow) {
                    if (this.grr.reportSubtype == 15) {
                        respFSspace.usedSpace *= 512L;
                        respFSspace.fsFreeSpace *= 512L;
                        respFSspace.fs_capacity *= 512L;
                        respFSspace.overhead *= 512L;
                        respFSspace.unallocated *= 512L;
                        respFSspace.unknown *= 512L;
                    }
                    if (this.batch) {
                        this.gcomputer[n3] = this.computerList.getComputer(respFSspace.id);
                    } else {
                        switch (this.grr.reportSubtype) {
                            case 27: {
                                respFSspace.creator = GuiUtil.getComputer((int)respFSspace.id).gcTSName;
                                break;
                            }
                            case 12: {
                                this.gcomputer[n3] = GuiUtil.getComputer(respFSspace.id);
                                respFSspace.setName(this.gcomputer[n3].gcTSName);
                                break;
                            }
                            case 14: {
                                respFSspace.creator = " ";
                            }
                        }
                    }
                } else {
                    if (this.grr.reportSubtype == 27 || this.grr.reportSubtype == 13 || this.grr.reportSubtype == 82) {
                        respFSspace.creator = MessageLog.getMessageNoID("STG4136L");
                        respFSspace.setName("");
                    }
                    this.gcomputer[n3] = new GComputer();
                }
                ++n3;
            }
        }
    }

    protected void addValidValues(ColumnDescriptor[] columnDescriptorArray) {
        if (this.grr.reportSubtype == 27) {
            ColumnDescriptor columnDescriptor = columnDescriptorArray[4];
            int[] nArray = new int[2];
            nArray[1] = 1;
            columnDescriptor.cdValidValue = nArray;
        } else if (this.grr.reportSubtype == 12) {
            ColumnDescriptor columnDescriptor = columnDescriptorArray[10];
            columnDescriptor.cdValidValue = ColumnDescriptor.OS_TYPES;
            columnDescriptor = columnDescriptorArray[14];
            columnDescriptor.cdValidValue = ColumnDescriptor.CPU_ARCHITECTURES;
        }
    }

    public Object getArray() {
        return this.data;
    }

    public int getNumberRows() {
        return this.data.length;
    }

    public int getNumberColumns() {
        return this.colNames.length;
    }

    public int getNumberFrozenRows() {
        if (this.grr.reportSubtype == 12 || this.grr.reportSubtype == 82 || this.grr.reportSubtype == 13) {
            return 0;
        }
        return 0;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public int[] getHiddenColumns() {
        return this.hiddenColumns;
    }

    public int[] initHistoryLegend() {
        HistChartProcessor.initLegend(this.grr);
        int n = 0;
        while (n < this.data.length) {
            RespFSspace respFSspace = this.data[n];
            int n2 = respFSspace.id;
            if (this.grr.reportSubtype == 27) {
                n2 = respFSspace.fs_id;
            }
            HistChartProcessor.addLegend(this.grr, respFSspace.creator, respFSspace.getName(), n2);
            ++n;
        }
        return null;
    }

    public int[] getSelectedIDs() {
        int[] nArray = new int[this.data.length];
        int n = 0;
        while (n < this.data.length) {
            RespFSspace respFSspace = this.data[n];
            int n2 = respFSspace.id;
            if (this.grr.reportSubtype == 27) {
                n2 = respFSspace.fs_id;
            }
            nArray[n] = n2;
            ++n;
        }
        return nArray;
    }

    public Object getCellData(int n, int n2) {
        return this.populator.getCellData(n, n2);
    }

    private void addTotal() {
        this.bHasTotalRow = true;
        RespFSspace[] respFSspaceArray = new RespFSspace[this.rows + 1];
        respFSspaceArray[0] = new RespFSspace();
        respFSspaceArray[0].setName(MessageLog.getMessageNoID("STG4136L"));
        respFSspaceArray[0].creator = " ";
        int n = 0;
        while (n < this.rows) {
            if (this.data[n].capacity > 0L) {
                respFSspaceArray[0].capacity += this.data[n].capacity;
            }
            if (this.data[n].freeSpace > 0L) {
                respFSspaceArray[0].freeSpace += this.data[n].freeSpace;
            }
            if (this.data[n].owned_capacity > 0L) {
                respFSspaceArray[0].owned_capacity += this.data[n].owned_capacity;
            }
            if (this.data[n].owned_freeSp > 0L) {
                respFSspaceArray[0].owned_freeSp += this.data[n].owned_freeSp;
            }
            if (this.data[n].primaryDefects > 0) {
                respFSspaceArray[0].primaryDefects += this.data[n].primaryDefects;
            }
            if (this.data[n].grownDefects > 0) {
                respFSspaceArray[0].grownDefects += this.data[n].grownDefects;
            }
            if (this.data[n].lun_capacity > 0L) {
                respFSspaceArray[0].lun_capacity += this.data[n].lun_capacity;
            }
            if (this.data[n].overhead > 0L && this.data[n].osType != 21) {
                respFSspaceArray[0].overhead += this.data[n].overhead;
            }
            if (this.data[n].capacity > 0L && this.data[n].osType != 21 && this.data[n].osType != 26) {
                respFSspaceArray[0].total_overhead = this.data[n].osType == 15 && this.data[n].vs_capacity > 0L ? (respFSspaceArray[0].total_overhead += this.data[n].vs_capacity - this.data[n].vs_freespace - this.data[n].lun_capacity) : (respFSspaceArray[0].total_overhead += this.data[n].capacity - this.data[n].dg_freecap - this.data[n].vs_capacity);
            }
            if (this.data[n].cache > 0L) {
                respFSspaceArray[0].cache += this.data[n].cache;
            }
            if (this.data[n].disks > 0) {
                respFSspaceArray[0].disks += this.data[n].disks;
            }
            if (this.data[n].luns > 0) {
                respFSspaceArray[0].luns += this.data[n].luns;
            }
            if (this.data[n].vs_capacity > 0L && this.data[n].osType != 21) {
                respFSspaceArray[0].vs_capacity += this.data[n].vs_capacity;
            }
            if (this.data[n].vs_freespace > 0L && this.data[n].osType != 21) {
                respFSspaceArray[0].vs_freespace += this.data[n].vs_freespace;
            }
            if (this.data[n].dg_freecap > 0L && this.data[n].osType != 21) {
                respFSspaceArray[0].dg_freecap += this.data[n].dg_freecap;
            }
            if (this.data[n].fs_capacity > 0L) {
                respFSspaceArray[0].fs_capacity += this.data[n].fs_capacity;
            }
            if (this.data[n].fsFreeSpace > 0L) {
                respFSspaceArray[0].fsFreeSpace += this.data[n].fsFreeSpace;
            }
            if (this.data[n].disk_assigned_capacity > 0L && this.data[n].osType != 21) {
                respFSspaceArray[0].disk_assigned_capacity += this.data[n].disk_assigned_capacity;
            }
            if (this.data[n].disk_unassigned_capacity > 0L && this.data[n].osType != 21) {
                respFSspaceArray[0].disk_unassigned_capacity += this.data[n].disk_unassigned_capacity;
            }
            if (this.data[n].disk_total_formatted_free_space > 0L && this.data[n].osType != 21) {
                respFSspaceArray[0].disk_total_formatted_free_space += this.data[n].disk_total_formatted_free_space;
            }
            if (this.data[n].zos_lun_capacity > 0L && this.data[n].osType != 21) {
                respFSspaceArray[0].zos_lun_capacity += this.data[n].zos_lun_capacity;
            }
            if (this.data[n].open_sys_lun_capacity > 0L) {
                respFSspaceArray[0].open_sys_lun_capacity += this.data[n].open_sys_lun_capacity;
            }
            respFSspaceArray[n + 1] = this.data[n];
            ++n;
        }
        this.data = respFSspaceArray;
        ++this.frozenRows;
        this.totalRow = 1;
        ++this.rows;
    }

    private class ByComputerPopulator
    implements ColumnPopulator {
        private ByComputerPopulator() {
        }

        public Object getCellData(int n, int n2) {
            switch (n2) {
                case 0: {
                    return ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].creator;
                }
                case 1: {
                    return DiskCapacityAdjuster.this.data[n].getName();
                }
                case 2: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].capacity;
                    return DiskCapacityAdjuster.this.mLong[n];
                }
                case 3: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].freeSpace;
                    return DiskCapacityAdjuster.this.mLong[n];
                }
                case 4: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].owned_capacity;
                    return DiskCapacityAdjuster.this.mLong[n];
                }
                case 5: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].owned_freeSp;
                    return DiskCapacityAdjuster.this.mLong[n];
                }
                case 6: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].SCSI_capacity;
                    return DiskCapacityAdjuster.this.mLong[n];
                }
                case 7: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].SCSI_freespace;
                    return DiskCapacityAdjuster.this.mLong[n];
                }
                case 8: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].FC_capacity;
                    return DiskCapacityAdjuster.this.mLong[n];
                }
                case 9: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].FC_freespace;
                    return DiskCapacityAdjuster.this.mLong[n];
                }
                case 10: {
                    if (n == 0 && DiskCapacityAdjuster.this.totalRow >= 1) {
                        return "";
                    }
                    if (((DiskCapacityAdjuster)DiskCapacityAdjuster.this).gcomputer[n].gcOsType == 0) {
                        return UNKNOWN;
                    }
                    return MessageLog.getMessageNoID(Constants.OSTYPES[((DiskCapacityAdjuster)DiskCapacityAdjuster.this).gcomputer[n].gcOsType]);
                }
                case 11: {
                    return Util.getDotName(((DiskCapacityAdjuster)DiskCapacityAdjuster.this).gcomputer[n].gcNetworkName, ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).gcomputer[n].gcDomainName);
                }
                case 12: {
                    return ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).gcomputer[n].gcIpAddress;
                }
                case 13: {
                    return Util.formatTimeZone(((DiskCapacityAdjuster)DiskCapacityAdjuster.this).gcomputer[n].gcTimezoneID);
                }
                case 14: {
                    if (n == 0 && DiskCapacityAdjuster.this.totalRow >= 1) {
                        return "";
                    }
                    return ComputersAdjuster.getCPUArchString(((DiskCapacityAdjuster)DiskCapacityAdjuster.this).gcomputer[n].gcCPUArchitecture);
                }
            }
            return null;
        }
    }

    private class ByDiskForDrillDownPopulator
    implements ColumnPopulator {
        private ByDiskForDrillDownPopulator() {
        }

        public Object getCellData(int n, int n2) {
            RespFSspace respFSspace = DiskCapacityAdjuster.this.data[n];
            Object object = null;
            switch (n2) {
                case 0: {
                    object = respFSspace.creator;
                    break;
                }
                case 1: {
                    object = respFSspace.getName();
                    break;
                }
                case 2: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = respFSspace.capacity;
                    object = DiskCapacityAdjuster.this.mLong[n];
                    break;
                }
                case 3: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = respFSspace.freeSpace;
                    object = DiskCapacityAdjuster.this.mLong[n];
                    break;
                }
                case 4: {
                    object = respFSspace.manufacturer;
                    break;
                }
                case 5: {
                    if (n == 0 && DiskCapacityAdjuster.this.totalRow >= 1) {
                        object = "";
                        break;
                    }
                    if (Util.isEmpty(respFSspace.model)) {
                        object = UNKNOWN;
                        break;
                    }
                    object = respFSspace.model;
                    break;
                }
                case 6: {
                    object = respFSspace.serialNumber;
                    break;
                }
                case 7: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mInt[n].value = respFSspace.primaryDefects;
                    object = DiskCapacityAdjuster.this.mInt[n];
                    break;
                }
                case 8: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mInt[n].value = respFSspace.grownDefects;
                    object = DiskCapacityAdjuster.this.mInt[n];
                }
            }
            return object;
        }
    }

    private class ByDiskPopulator
    implements ColumnPopulator {
        private ByDiskPopulator() {
        }

        public Object getCellData(int n, int n2) {
            RespFSspace respFSspace = DiskCapacityAdjuster.this.data[n];
            Object object = null;
            switch (n2) {
                case 0: {
                    object = respFSspace.creator;
                    break;
                }
                case 1: {
                    object = respFSspace.getName();
                    break;
                }
                case 2: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = respFSspace.capacity;
                    object = DiskCapacityAdjuster.this.mLong[n];
                    break;
                }
                case 3: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = respFSspace.freeSpace;
                    object = DiskCapacityAdjuster.this.mLong[n];
                    break;
                }
                case 5: {
                    object = respFSspace.manufacturer;
                    break;
                }
                case 6: {
                    if (n == 0 && DiskCapacityAdjuster.this.totalRow >= 1) {
                        object = "";
                        break;
                    }
                    if (Util.isEmpty(respFSspace.model)) {
                        object = UNKNOWN;
                        break;
                    }
                    object = respFSspace.model;
                    break;
                }
                case 4: {
                    if (n == 0 && DiskCapacityAdjuster.this.totalRow >= 1) {
                        object = "";
                        break;
                    }
                    if (respFSspace.directoryCount > 0L) {
                        object = DiskAdjuster.YES;
                        break;
                    }
                    object = DiskAdjuster.NO;
                    break;
                }
                case 7: {
                    object = respFSspace.serialNumber;
                    break;
                }
                case 8: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mInt[n].value = respFSspace.primaryDefects;
                    object = DiskCapacityAdjuster.this.mInt[n];
                    break;
                }
                case 9: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mInt[n].value = respFSspace.grownDefects;
                    object = DiskCapacityAdjuster.this.mInt[n];
                }
            }
            return object;
        }
    }

    private class BySubsystemPopulator
    implements ColumnPopulator {
        private BySubsystemPopulator() {
        }

        public Object getCellData(int n, int n2) {
            switch (n2) {
                case 1: {
                    return DiskCapacityAdjuster.this.data[n].getName();
                }
                case 4: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mInt[n].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].disks;
                    return DiskCapacityAdjuster.this.mInt[n];
                }
                case 2: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].capacity;
                    return DiskCapacityAdjuster.this.mLong[n];
                }
                case 3: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].freeSpace;
                    return DiskCapacityAdjuster.this.mLong[n];
                }
                case 5: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mInt[n].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].luns;
                    return DiskCapacityAdjuster.this.mInt[n];
                }
                case 6: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].lun_capacity;
                    return DiskCapacityAdjuster.this.mLong[n];
                }
                case 7: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].fs_capacity;
                    return DiskCapacityAdjuster.this.mLong[n];
                }
                case 8: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].fsFreeSpace;
                    return DiskCapacityAdjuster.this.mLong[n];
                }
                case 9: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].fs_capacity - ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].fsFreeSpace;
                    return DiskCapacityAdjuster.this.mLong[n];
                }
                case 10: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].osType == 21 ? -1L : ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].overhead;
                    return DiskCapacityAdjuster.this.mLong[n];
                }
                case 11: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].osType == 21 ? -1L : ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].vs_capacity;
                    return DiskCapacityAdjuster.this.mLong[n];
                }
                case 12: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].osType == 21 ? -1L : ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].vs_freespace;
                    return DiskCapacityAdjuster.this.mLong[n];
                }
                case 13: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = DiskCapacityAdjuster.this.bHasTotalRow && n == 0 ? ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].total_overhead : (((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].osType == 21 || ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].osType == 16 || ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].osType == 26 ? -1L : (((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].osType == 15 ? ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].vs_capacity - ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].vs_freespace - ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].lun_capacity : ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].capacity - ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].dg_freecap - ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].vs_capacity));
                    return DiskCapacityAdjuster.this.mLong[n];
                }
                case 14: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = DiskCapacityAdjuster.this.bHasTotalRow && n == 0 ? ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].dg_freecap : (((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].osType == 12 || ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].osType == 25 || ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].osType == 27 || ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].osType == 15 ? ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].dg_freecap : -1L);
                    return DiskCapacityAdjuster.this.mLong[n];
                }
                case 15: {
                    long l = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].cache;
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = l <<= 20;
                    return DiskCapacityAdjuster.this.mLong[n];
                }
                case 16: {
                    if (((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].manufacturer == null) {
                        return " ";
                    }
                    if (((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].manufacturer.toLowerCase().equals("unknown")) {
                        return UNKNOWN;
                    }
                    return ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].manufacturer;
                }
                case 17: {
                    if (((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].model == null) {
                        return " ";
                    }
                    if (((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].model.toLowerCase().equals("unknown")) {
                        return UNKNOWN;
                    }
                    return ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].model;
                }
                case 18: {
                    if (((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].serialNumber == null) {
                        return " ";
                    }
                    if (((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].serialNumber.toLowerCase().equals("unknown")) {
                        return UNKNOWN;
                    }
                    return ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].serialNumber;
                }
                case 19: {
                    if (((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].firmware == null) {
                        return " ";
                    }
                    if (((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].firmware.toLowerCase().equals("unknown")) {
                        return UNKNOWN;
                    }
                    return ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].firmware;
                }
                case 20: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].osType == 21 ? -1L : ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].disk_assigned_capacity;
                    return DiskCapacityAdjuster.this.mLong[n];
                }
                case 21: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].osType == 21 ? -1L : ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].disk_unassigned_capacity;
                    return DiskCapacityAdjuster.this.mLong[n];
                }
                case 22: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].osType == 21 ? -1L : ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].disk_total_formatted_free_space;
                    return DiskCapacityAdjuster.this.mLong[n];
                }
                case 23: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].osType == 21 ? -1L : ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].zos_lun_capacity;
                    return DiskCapacityAdjuster.this.mLong[n];
                }
                case 24: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[n].open_sys_lun_capacity;
                    return DiskCapacityAdjuster.this.mLong[n];
                }
            }
            return null;
        }
    }

    private static interface ColumnPopulator {
        public Object getCellData(int var1, int var2);
    }

    private class NetworkWidePopulator
    implements ColumnPopulator {
        private NetworkWidePopulator() {
        }

        public Object getCellData(int n, int n2) {
            RespFSspace respFSspace = DiskCapacityAdjuster.this.data[n];
            Object object = null;
            switch (n2) {
                case 1: {
                    object = NETWORK;
                    break;
                }
                case 2: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = respFSspace.capacity;
                    object = DiskCapacityAdjuster.this.mLong[n];
                    break;
                }
                case 3: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = respFSspace.usedSpace;
                    object = DiskCapacityAdjuster.this.mLong[n];
                    break;
                }
                case 4: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = respFSspace.fsFreeSpace;
                    object = DiskCapacityAdjuster.this.mLong[n];
                    break;
                }
                case 5: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = respFSspace.fs_capacity;
                    object = DiskCapacityAdjuster.this.mLong[n];
                    break;
                }
                case 6: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = respFSspace.overhead;
                    object = DiskCapacityAdjuster.this.mLong[n];
                    break;
                }
                case 7: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = respFSspace.unallocated;
                    object = DiskCapacityAdjuster.this.mLong[n];
                    break;
                }
                case 8: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[n].value = respFSspace.unknown;
                    object = DiskCapacityAdjuster.this.mLong[n];
                }
            }
            return object;
        }
    }

    private class Sorter
    implements Comparator {
        private Sorter() {
        }

        public int compare(Object object, Object object2) {
            RespFSspace respFSspace = (RespFSspace)object;
            RespFSspace respFSspace2 = (RespFSspace)object2;
            if (respFSspace.capacity == respFSspace2.capacity) {
                return 0;
            }
            if (respFSspace.capacity > respFSspace2.capacity) {
                return -1;
            }
            return 1;
        }
    }

    private class SubSysSorter
    implements Comparator {
        private SubSysSorter() {
        }

        public int compare(Object object, Object object2) {
            RespFSspace respFSspace = (RespFSspace)object;
            RespFSspace respFSspace2 = (RespFSspace)object2;
            return -respFSspace.getName().compareTo(respFSspace2.getName());
        }
    }
}

