/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import org.eclipse.aperi.TStorm.common.DiskHistory;
import org.eclipse.aperi.TStorm.gui.HistoryChart;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskHistChart
extends HistoryChart {
    private String[] computerPath;

    public DiskHistChart(String[] stringArray) {
        this.computerPath = stringArray;
    }

    protected boolean processResponse(Object object, GuiReportReq guiReportReq) {
        this.sourceName = MessageLog.getMessageNoID("STG1288T");
        DiskHistory[] diskHistoryArray = (DiskHistory[])object;
        int n = diskHistoryArray != null ? diskHistoryArray.length : 0;
        if (n == 0) {
            return false;
        }
        this.seriesL = new String[n];
        this.xvalues = new double[n];
        this.yvalues = new double[n];
        int n2 = -1;
        String string = " ";
        int n3 = 0;
        while (n3 < n) {
            DiskHistory diskHistory = diskHistoryArray[n3];
            if (n2 != diskHistory.dkhDiskID) {
                n2 = diskHistory.dkhDiskID;
                int n4 = 0;
                while (guiReportReq.selectedResources[n4] != n2) {
                    ++n4;
                }
                string = this.computerPath[n4];
            }
            this.seriesL[n3] = string;
            this.xvalues[n3] = diskHistory.dkhTimestamp;
            switch (guiReportReq.reportSubtype) {
                case -24: {
                    this.yvalues[n3] = diskHistory.dkhGrownDefects;
                    break;
                }
                case -25: {
                    this.yvalues[n3] = diskHistory.dkhRecoveredReadErrors + diskHistory.dkhRecoveredWriteErrors + diskHistory.dkhRecoveredVerifyErrors;
                    break;
                }
                case -26: {
                    this.yvalues[n3] = diskHistory.dkhUnrecoveredReadErrors + diskHistory.dkhUnrecoveredWriteErrors + diskHistory.dkhUnrecoveredVerifyErrors;
                    break;
                }
                case -39: {
                    this.yvalues[n3] = diskHistory.dkhFreeSpace *= 512L;
                    break;
                }
                case -23: {
                    this.yvalues[n3] = diskHistory.dkhPrimaryDefects;
                    break;
                }
            }
            ++n3;
        }
        return true;
    }
}

