/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.aperi.TStorm.common.BatchReport;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.SizeLimitedDocument;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.xmsg.MessageLog;

public class FileMaskEditor
implements ListSelectionListener {
    GridBagConstraints gbcRegular = new GridBagConstraints();
    GridBagConstraints gbcDown = new GridBagConstraints();
    GridBagConstraints gbcIndent = new GridBagConstraints();
    Insets insetA = new Insets(0, 5, 0, 0);
    Insets insetB = new Insets(4, 5, 0, 0);
    Insets insetC = new Insets(0, 25, 0, 0);
    JTextField fileMaskField;
    SizeLimitedDocument document;
    JList keywordList;
    String[] keywords;
    int maskSize;
    static final String FILE_MASK_TITLE = MessageLog.getMessageNoID("STG5148L");
    static final String FILE_MASK_LABEL = MessageLog.getMessageNoID("STG5153L");
    static final String KEY_WORD_LABEL = MessageLog.getMessageNoID("GUI0163L");

    public FileMaskEditor(int n) {
        this.maskSize = n;
        this.keywords = BatchReport.messageText;
    }

    public JPanel build() {
        JPanel jPanel = GuiUtil.getTitledBorderedPanel(FILE_MASK_TITLE);
        this.gbcRegular.anchor = 17;
        this.gbcRegular.gridwidth = 0;
        this.gbcRegular.insets = this.insetA;
        this.gbcDown.anchor = 17;
        this.gbcDown.gridwidth = 0;
        this.gbcDown.insets = this.insetB;
        this.gbcIndent.anchor = 17;
        this.gbcIndent.gridwidth = 0;
        this.gbcIndent.insets = this.insetC;
        JLabel jLabel = new JLabel(FILE_MASK_LABEL);
        this.fileMaskField = TTextField.newTTextField(40, false);
        GuiUtil.setAccessibleLabel(jLabel, this.fileMaskField, "MNEMONIC_FILEMASK", FILE_MASK_LABEL, "DESCRIPTION__FILEMASK");
        this.document = new SizeLimitedDocument(this.maskSize, false);
        this.fileMaskField.setDocument(this.document);
        jPanel.add((Component)jLabel, this.gbcRegular);
        jPanel.add((Component)this.fileMaskField, this.gbcDown);
        JLabel jLabel2 = new JLabel(KEY_WORD_LABEL);
        this.keywordList = new JList<String>(this.keywords);
        jPanel.add((Component)jLabel2, this.gbcDown);
        jPanel.add((Component)this.keywordList, this.gbcDown);
        GuiUtil.completePanel(jPanel);
        this.keywordList.addListSelectionListener(this);
        return jPanel;
    }

    public void setData(String string) {
        if (string == null) {
            String string2 = String.valueOf(this.keywords[0]) + "." + this.keywords[1] + "." + this.keywords[3];
            this.fileMaskField.setText(string2);
        } else {
            this.fileMaskField.setText(string);
        }
    }

    public String getData() {
        return this.fileMaskField.getText();
    }

    public void validateData(String string) throws GeneralException {
        if (string == null || string.length() == 0) {
            throw new GeneralException(MessageLog.getMessageNoTS("STG5159E"));
        }
        int n = string.indexOf("{");
        while (n >= 0) {
            int n2 = string.indexOf("}", n);
            if (n2 < 1) {
                throw new GeneralException(MessageLog.getMessageNoTS("STG5168L"));
            }
            String string2 = string.substring(n, ++n2);
            int n3 = 0;
            while (n3 < this.keywords.length) {
                if (string2.equals(this.keywords[n3])) break;
                ++n3;
            }
            if (n3 >= this.keywords.length) {
                Object[] objectArray = new Object[]{string2};
                String string3 = MessageLog.getMessageNoTS("STG5169L", objectArray);
                throw new GeneralException(string3);
            }
            n = string.indexOf("{", n2);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.keywordList.getSelectedIndex();
        if (!listSelectionEvent.getValueIsAdjusting() && n > -1) {
            int n2 = this.fileMaskField.getCaretPosition();
            String string = this.fileMaskField.getText();
            if (string.length() < 1) {
                this.fileMaskField.setText(this.keywords[n]);
            } else {
                String string2 = String.valueOf(string.substring(0, n2)) + this.keywords[n] + string.substring(n2);
                if (string2.length() <= this.maskSize) {
                    this.fileMaskField.setText(string2);
                }
            }
            this.keywordList.removeSelectionInterval(0, this.keywords.length - 1);
            this.fileMaskField.requestFocus();
        }
    }
}

