/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.xmsg.MessageLog;

public class PingOptionsEditor
extends JPanel {
    private static final int VALUE_OPTION = 0;
    private static final int UNITS_OPTION = 1;
    private JPanel optionsPanel;
    private int value;
    private int units;
    private JComboBox intervalValue;
    private JComboBox intervalUnits;
    private static final String[] valueChoices = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99"};
    private String[] unitChoices = new String[]{MessageLog.getMessageNoID("STG4070L"), MessageLog.getMessageNoID("GUI5034L"), MessageLog.getMessageNoID("GUI5035L"), MessageLog.getMessageNoID("GUI5036L")};

    public PingOptionsEditor(String string) {
        String[] stringArray = this.parseOptions(string);
        this.value = Util.isEmpty(stringArray[0]) ? 0 : Integer.parseInt(stringArray[0]);
        this.units = Util.isEmpty(stringArray[1]) ? 2 : Integer.parseInt(stringArray[1]);
    }

    private String[] parseOptions(String string) {
        String[] stringArray = new String[8];
        if (!Util.isEmpty(string)) {
            int n = 0;
            int n2 = -1;
            while (n2 < string.length()) {
                int n3;
                if ((n3 = string.indexOf(32, ++n2)) == -1) {
                    n3 = string.length();
                }
                stringArray[n++] = string.substring(n2, n3);
                n2 = n3;
            }
        }
        return stringArray;
    }

    public Component getComponent() {
        if (this.optionsPanel != null) {
            return this.optionsPanel;
        }
        this.intervalValue = new TComboBox(valueChoices);
        this.intervalValue.setSelectedIndex(this.value);
        this.intervalUnits = new TComboBox(this.unitChoices);
        this.intervalUnits.setSelectedIndex(this.units);
        String string = MessageLog.getMessageNoID("STG4068L");
        JLabel jLabel = new JLabel(string);
        GuiUtil.setAccessibleLabel(jLabel, this.intervalUnits, "MNEMONIC_INTERVALUNITS", string, "DESCRIPTION_INTERVALUNITS");
        GuiUtil.setAccessibleDescription(this.intervalValue, "DESCRIPTION_INTERVALVALUEUNITS");
        JPanel jPanel = GuiUtil.getBorderedPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 0, 4, 16);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.intervalValue, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.intervalUnits, gridBagConstraints);
        GuiUtil.completePanel(jPanel);
        this.setPanelSize(jPanel);
        this.setLayout(new BoxLayout(this, 1));
        this.add(jPanel);
        this.optionsPanel = this;
        return this;
    }

    private void setPanelSize(JPanel jPanel) {
        int n = (int)jPanel.getMaximumSize().getWidth();
        int n2 = (int)jPanel.getMinimumSize().getHeight();
        jPanel.setMaximumSize(new Dimension(n, n2));
    }

    public String getData() {
        StringBuffer stringBuffer = new StringBuffer(16);
        this.value = this.intervalValue.getSelectedIndex();
        stringBuffer.append(this.value);
        stringBuffer.append(' ');
        this.units = this.intervalUnits.getSelectedIndex();
        stringBuffer.append(this.units);
        return stringBuffer.toString();
    }
}

