/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.gui.DiskReportingTreeLabel;
import org.eclipse.aperi.TStorm.gui.ReportingTreeLabel;
import org.eclipse.aperi.TStorm.gui.ReportingTreeNode;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.AlertNameList;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReportSelector {
    private GuiReportReq grr;
    private JTree sourceTree;
    private JTree selectedTree;
    private NameList rootName;
    private TreeSelector selector;
    private TreeSelectorNode selectedNode;
    private short reportType;
    static final String systemWideTitle = MessageLog.getMessageNoID("STG1002L");

    public ReportSelector(GuiReportReq guiReportReq, short s) {
        this.grr = guiReportReq;
        this.reportType = s;
    }

    public JPanel build() {
        if (this.selector == null) {
            this.buildSourceTree();
            this.buildSelectedTree();
            this.selector = new ReportTreeSelector(this.sourceTree, this.selectedTree);
            this.selector.disableMultipleSelection();
        }
        return this.selector;
    }

    public boolean getData() {
        boolean bl = false;
        NameList nameList = this.selector.getNameList();
        if (nameList == null) {
            this.grr.reportType = 0;
            this.grr.reportSubtype = 0;
        } else {
            this.grr.reportType = nameList.nlID;
            this.grr.reportSubtype = nameList.nlID2;
            if (nameList instanceof AlertNameList) {
                AlertNameList alertNameList = (AlertNameList)nameList;
                this.grr.dbmsType = alertNameList.nlSubProductID;
            } else {
                this.grr.dbmsType = (byte)-1;
            }
            if (nameList.nlID3 != -1 && nameList.nlID3 != -2) {
                bl = true;
            }
        }
        return bl;
    }

    private void buildSourceTree() {
        TreeSelectorNode treeSelectorNode = this.newRoot();
        ReportingTreeLabel reportingTreeLabel = new ReportingTreeLabel(false);
        TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this, new TreePath(reportingTreeLabel));
        reportingTreeLabel.expand(treeExpansionEvent);
        this.copyChildren(treeSelectorNode, reportingTreeLabel);
        DiskReportingTreeLabel diskReportingTreeLabel = new DiskReportingTreeLabel(false);
        treeExpansionEvent = new TreeExpansionEvent(this, new TreePath(diskReportingTreeLabel));
        diskReportingTreeLabel.expand(treeExpansionEvent);
        this.copyChildren(treeSelectorNode, diskReportingTreeLabel);
        this.sourceTree = new JTree(treeSelectorNode, true);
        this.sourceTree.getSelectionModel().setSelectionMode(1);
    }

    private void copyChildren(TreeSelectorNode treeSelectorNode, BaseTreeNode baseTreeNode) {
        Enumeration<TreeNode> enumeration = baseTreeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeSelectorNode treeSelectorNode2;
            BaseTreeNode baseTreeNode2 = (BaseTreeNode)enumeration.nextElement();
            AlertNameList alertNameList = new AlertNameList();
            alertNameList.nlName = baseTreeNode2.toString();
            if (alertNameList.nlName.equals(systemWideTitle)) {
                alertNameList.nlName = MessageLog.getMessageNoID("STG1029L");
            }
            if (baseTreeNode2.getAllowsChildren()) {
                treeSelectorNode2 = new TreeSelectorNode((NameList)alertNameList, false, false, true);
                treeSelectorNode2.setButtonFlag(false);
            } else {
                treeSelectorNode2 = new TreeSelectorNode((NameList)alertNameList, true, false, false);
            }
            if (baseTreeNode2 instanceof ReportingTreeNode && !baseTreeNode2.getAllowsChildren()) {
                ReportingTreeNode reportingTreeNode = (ReportingTreeNode)baseTreeNode2;
                alertNameList.nlID = reportingTreeNode.reportType;
                alertNameList.nlID2 = reportingTreeNode.reportSubtype;
                alertNameList.nlID3 = reportingTreeNode.selectionServices;
                alertNameList.nlSubProductID = reportingTreeNode.dbmsType;
            }
            treeSelectorNode2.setSortKey(baseTreeNode2.batchSortNumber);
            treeSelectorNode.add(treeSelectorNode2);
            if (this.grr.reportType == alertNameList.nlID && this.grr.reportSubtype == alertNameList.nlID2 && this.grr.dbmsType == alertNameList.nlSubProductID) {
                this.selectedNode = treeSelectorNode2;
            }
            this.copyChildren(treeSelectorNode2, baseTreeNode2);
        }
    }

    private void buildSelectedTree() {
        NameList nameList = new NameList();
        nameList.nlName = "";
        TreeSelectorNode treeSelectorNode = new TreeSelectorNode(nameList, false, true, "STG4041L");
        if (this.grr.reportType > 0) {
            TreeNode[] treeNodeArray = this.selectedNode.getPath();
            TreeSelectorNode treeSelectorNode2 = treeSelectorNode;
            int n = 1;
            while (n < treeNodeArray.length - 1) {
                TreeSelectorNode treeSelectorNode3 = (TreeSelectorNode)treeNodeArray[n];
                nameList = new NameList();
                nameList.nlName = ((NameList)treeSelectorNode3.getUserObject()).nlName;
                TreeSelectorNode treeSelectorNode4 = new TreeSelectorNode(nameList, false, false, true);
                treeSelectorNode4.setSortKey(treeSelectorNode3.hiOrderSortKey);
                treeSelectorNode2.add(treeSelectorNode4);
                treeSelectorNode2 = treeSelectorNode4;
                ++n;
            }
            treeSelectorNode2.add(this.selectedNode);
        }
        this.selectedTree = new JTree(treeSelectorNode, true);
        this.selectedTree.getSelectionModel().setSelectionMode(1);
    }

    public void replace() {
    }

    private TreeSelectorNode newRoot() {
        if (this.rootName == null) {
            this.rootName = new NameList();
            this.rootName.nlName = "";
        }
        return new TreeSelectorNode(this.rootName, false, false, true);
    }

    public void removeSelection() {
        this.selector.removeSelection();
    }

    static class ReportTreeSelector
    extends TreeSelector
    implements GuiRequestor {
        short devType;

        public ReportTreeSelector(JTree jTree, JTree jTree2) {
            super(jTree, jTree2);
        }

        public void handleResponse(short s, Response response) {
            if (s > 4) {
                super.removeSelection();
            }
        }

        public int getSelectedReportType() {
            NameList nameList = this.getNameList();
            int n = 0;
            if (nameList != null) {
                n = nameList.nlID;
            }
            return n;
        }
    }
}

