/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.TStorm.gui.ReportingTreeNode;
import org.eclipse.aperi.TStorm.gui.SavedReportDDI;
import org.eclipse.aperi.TStorm.gui.SavedReportNode;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiSavedReportReq;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.ChangeManager;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.ExportTableData;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.ObjectChangeListener;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReportingTableDDI
extends SavedReportDDI
implements ActionListener,
GuiRequestor,
ObjectChangeListener {
    private JComponent centerPanel;
    private byte productCode;
    private boolean productAvailable = true;
    private boolean saveEnabled;
    private boolean changeListening;
    private boolean saveAs;
    private boolean showing;

    public ReportingTableDDI(GuiSavedReportReq guiSavedReportReq, BaseTreeNode baseTreeNode) {
        this(guiSavedReportReq.grr, baseTreeNode, String.valueOf(guiSavedReportReq.creator) + "." + guiSavedReportReq.getName());
        this.gsrr = guiSavedReportReq;
    }

    public ReportingTableDDI(GuiReportReq guiReportReq, BaseTreeNode baseTreeNode) {
        this(guiReportReq, baseTreeNode, String.valueOf(GuiReportReq.guiClasses[guiReportReq.reportType][2] == GuiReportReq.subtypeTreeLabels[guiReportReq.reportSubtype][0] ? "" : String.valueOf(MessageLog.getMessageNoID(GuiReportReq.guiClasses[guiReportReq.reportType][2])) + Util.getString("COLON")) + MessageLog.getMessageNoID(GuiReportReq.subtypeTreeLabels[guiReportReq.reportSubtype][0]));
    }

    public ReportingTableDDI(GuiReportReq guiReportReq, BaseTreeNode baseTreeNode, String string) {
        super(string);
        this.treeNode = baseTreeNode;
        this.grr = guiReportReq;
        this.productAvailable = true;
        this.productCode = ((ReportingTreeNode)this.treeNode).productCode;
        this.displayInScrollPane = false;
        this.helpID = GuiReportReq.guiClasses[this.grr.reportType][4];
        this.reDisplay();
    }

    public void reDisplay() {
        if (this.panel == null) {
            try {
                Object object;
                Object[] objectArray;
                Constructor<?> constructor;
                Class<?> clazz = Class.forName(GuiReportReq.guiClasses[this.grr.reportType][0]);
                Class[] classArray = new Class[]{GuiReportReq.class, DataDisplayInfo.class};
                try {
                    constructor = clazz.getConstructor(classArray);
                    objectArray = new Object[2];
                    objectArray[1] = this;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    object = new Class[]{GuiReportReq.class};
                    constructor = clazz.getConstructor((Class<?>)object);
                    objectArray = new Object[]{this.grr};
                }
                this.centerPanel = (JComponent)constructor.newInstance(objectArray);
                this.panel = new JPanel();
                this.panel.setLayout(new BorderLayout());
                object = this.treeNode.getPopupMenuForButtons();
                JPanel jPanel = this.getButtonPanel((JPopupMenu)object);
                if (this.getActionButtonCount() > 0) {
                    this.panel.add((Component)jPanel, "North");
                }
                this.panel.add((Component)this.centerPanel, "Center");
            }
            catch (Exception exception) {
                System.err.println(exception);
                exception.printStackTrace();
            }
        }
        this.showing = true;
        this.show();
        this.showing = false;
        if (!this.saveEnabled) {
            this.saveEnabled = true;
            guiMain.setSaveActionEnabled(true, true);
            guiMain.setSaveAsActionEnabled(true, true);
            guiMain.setPrintActionEnabled(true, true);
            guiMain.setExportActionEnabled(true, true);
            guiMain.setSaveActionToolTip(MessageLog.getMessageNoID("GUI5066T"));
            guiMain.setSaveAsActionToolTip(MessageLog.getMessageNoID("GUI5067T"));
            guiMain.setExportActionToolTip(MessageLog.getMessageNoID("GUI5068T"));
            guiMain.addSaveActionListener(this);
            guiMain.addSaveAsActionListener(this);
            guiMain.addExportActionListener(this);
            guiMain.addPrintActionListener(this);
        }
        if (!this.changeListening) {
            this.changeListening = true;
            ChangeManager.addListener(this, (short)35);
        }
    }

    public void losingFocus() {
        if (!this.showing && this.saveEnabled) {
            this.saveEnabled = false;
            guiMain.setSaveActionEnabled(false, false);
            guiMain.setSaveAsActionEnabled(false, false);
            guiMain.setPrintActionEnabled(false, false);
            guiMain.setExportActionEnabled(false, false);
            guiMain.setSaveActionToolTip(null);
            guiMain.setSaveAsActionToolTip(null);
            guiMain.setExportActionToolTip(null);
            guiMain.removeSaveActionListener(this);
            guiMain.removeSaveAsActionListener(this);
            guiMain.removeExportActionListener(this);
            guiMain.removePrintActionListener(this);
        }
    }

    public void goingAway() {
        if (this.changeListening) {
            ChangeManager.removeListener(this);
        }
    }

    public JComponent getNoDataMessage(GuiReportReq guiReportReq) {
        JLabel jLabel = new JLabel();
        if (guiReportReq != null && (guiReportReq.reportSubtype == 24 || guiReportReq.reportSubtype == 23)) {
            jLabel.setText(Util.getString("LABEL_NO_DISK_DEFECTS_DISCOVERED"));
        } else if (this.gsrr != null && (this.gsrr.grr.reportSubtype == 24 || this.gsrr.grr.reportSubtype == 23)) {
            jLabel.setText(Util.getString("LABEL_NO_DISK_DEFECTS_DISCOVERED"));
        } else {
            jLabel.setText(MessageLog.getMessageNoID("STG0020M"));
        }
        jLabel.setHorizontalAlignment(0);
        return jLabel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Save") {
            this.saveAs = false;
            this.save();
        } else if (string == "SaveAs") {
            this.saveAs = true;
            this.save();
        } else if (string == "Export") {
            ExportTableData.export(this.centerPanel, null, this.getDescription());
        }
    }

    private void save() {
        GuiSavedReportReq guiSavedReportReq = new GuiSavedReportReq();
        if (this.gsrr == null || this.gsrr.ID <= 299) {
            this.saveAs = true;
            guiSavedReportReq.creator = GuiUtil.getUserName();
            guiSavedReportReq.grr = this.grr;
        } else {
            guiSavedReportReq.creator = this.gsrr.creator;
            guiSavedReportReq.setName(this.gsrr.getTrueName());
            guiSavedReportReq.ID = this.gsrr.ID;
            guiSavedReportReq.grr = this.gsrr.grr;
        }
        guiSavedReportReq.productCode = this.productCode;
        if (this.saveAs) {
            guiSavedReportReq.ID = -1;
            String string = MessageLog.getMessageNoID("GUI5007L");
            String string2 = MessageLog.getMessageNoID("GUI5011L", "report");
            boolean bl = true;
            while (bl) {
                guiSavedReportReq.setName(GuiUtil.displayOkCancelPane(string, string2, 32, false, null, guiMain.getFrame()));
                boolean bl2 = bl = guiSavedReportReq.getName() != null && !guiSavedReportReq.getName().equals("") && guiSavedReportReq.getName().indexOf(46) >= 0;
                if (!bl) continue;
                String string3 = MessageLog.getMessageNoTS("GUI0056E", null);
                GuiUtil.displayErrorMessage(string3);
            }
        }
        if (guiSavedReportReq.getName() != null && !guiSavedReportReq.getName().equals("")) {
            SavedReportNode.doRequest(this, guiSavedReportReq);
        }
    }

    public void handleResponse(short s, Response response) {
        if (s <= 4 && response.responseData != null) {
            this.gsrr = (GuiSavedReportReq)response.responseData;
            this.changeDescription();
            NameList nameList = new NameList();
            nameList.nlInfo = (short)35;
            nameList.nlName = this.gsrr.getName();
            nameList.nlID = this.gsrr.ID;
            ChangeManager.signalChange(1, nameList);
        }
    }

    public void changeOccurred(int n, NameList nameList) {
        if (n == 0 && this.gsrr != null && nameList.nlID == this.gsrr.ID) {
            this.gsrr.setName(nameList.nlName);
            this.changeDescription();
        }
    }

    private void changeDescription() {
        this.setDescription(String.valueOf(this.gsrr.creator) + "." + this.gsrr.getName());
        if (ReportingTableDDI.getCurrent() == this) {
            this.showing = true;
            this.show();
            this.showing = false;
        }
    }
}

