/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Toolkit;
import java.text.DecimalFormatSymbols;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DecimalDocument
extends PlainDocument {
    private int maxLength;

    public DecimalDocument(int n) {
        this.maxLength = n;
    }

    public void setMaxSize(int n) {
        this.maxLength = n;
        int n2 = this.getLength();
        if (n2 > n) {
            try {
                this.remove(0, n2);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string != null && string.length() > 0) {
            if (n == 0 && string.charAt(0) == ' ' || string.length() + this.getLength() > this.maxLength) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            int n2 = string.length() - 1;
            while (n2 >= 0) {
                if (!Character.isDigit(string.charAt(n2))) {
                    DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
                    if (string.charAt(n2) == decimalFormatSymbols.getDecimalSeparator()) {
                        String string2 = this.getText(0, this.getLength());
                        int n3 = string2.length() - 1;
                        while (n3 >= 0) {
                            if (string2.charAt(n3) == decimalFormatSymbols.getDecimalSeparator()) {
                                Toolkit.getDefaultToolkit().beep();
                                return;
                            }
                            --n3;
                        }
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                }
                --n2;
            }
        }
        super.insertString(n, string, attributeSet);
    }
}

