/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin.agent;

import java.awt.event.ActionListener;
import java.sql.Time;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.admin.agent.AgentListPanel;
import org.eclipse.aperi.gui.admin.agent.AgentTreeNodesStore;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;

public abstract class AgentListDDI
extends DataDisplayInfo {
    private static Timer refreshAgentsTimer = new Timer(true);
    private static Hashtable refreshRatesStore = new Hashtable();
    private boolean refreshStarted = false;
    private int agentType = -1;
    private int sortColumn = 0;
    private int sortDirection = 1;
    private int[] selectedDataRows = null;
    private String helpID;
    protected BaseTableModel tableModel;
    private long lastRefreshTime = System.currentTimeMillis();
    private TimerTask refreshTask = new TimerTask(){

        public void run() {
            Response response = null;
            Response response2 = null;
            short[] sArray = new short[1];
            short[] sArray2 = new short[1];
            StringBuffer stringBuffer = new StringBuffer();
            if (AgentListDDI.this != DataDisplayInfo.getCurrent() || !AgentListDDI.this.isTimeForAnotherRefresh()) {
                return;
            }
            response = GuiClient.doRefreshRequest(AgentListDDI.this.getAgentRequest(), sArray, stringBuffer);
            if (sArray[0] != 12 && AgentListDDI.this.getAgentInfoRequest() != null) {
                response2 = GuiClient.doRefreshRequest(AgentListDDI.this.getAgentInfoRequest(), sArray2, stringBuffer);
            }
            if (sArray[0] == 12) {
                AgentListDDI.this.setRefreshRate(-1);
                SwingUtilities.invokeLater(new RefreshDataModelError(stringBuffer.toString()));
            } else {
                if (AgentListDDI.this != DataDisplayInfo.getCurrent()) {
                    return;
                }
                SwingUtilities.invokeLater(new RefreshDataModel(sArray[0], response, sArray2[0], response2));
            }
        }
    };

    protected abstract Request getAgentRequest();

    protected abstract AgentListPanel getPanel();

    public abstract BaseTableModel getTableModel();

    abstract Object elementAt(int var1);

    protected abstract void refreshAgents(short var1, Response var2, boolean var3);

    protected void refreshAgentsInfo(short s, Response response, boolean bl) {
    }

    public AgentListDDI(int n, String string, String string2) {
        this.agentType = n;
        this.helpID = string2;
        this.setDescription(string);
        this.displayInScrollPane = true;
        switch (n) {
            case 6: {
                this.sortColumn = 1;
                break;
            }
            case 2: {
                this.sortColumn = 2;
                break;
            }
            case 7: {
                this.sortColumn = 2;
                break;
            }
            case 8: {
                this.sortColumn = 2;
            }
        }
        if (refreshRatesStore.get(new Integer(n)) == null) {
            refreshRatesStore.put(new Integer(n), new Integer(60000));
        }
    }

    void setRefreshRate(int n) {
        refreshRatesStore.put(new Integer(this.agentType), new Integer(n));
    }

    int getRefreshRate() {
        Integer n = (Integer)refreshRatesStore.get(new Integer(this.agentType));
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLastRefreshTime(boolean bl) {
        ActionListener actionListener = this;
        synchronized (actionListener) {
            this.lastRefreshTime = System.currentTimeMillis();
        }
        actionListener = (AgentListPanel)this.panel;
        if (bl && actionListener != null) {
            ((AgentListPanel)actionListener).jLastRefreshTime.setText(new Time(this.lastRefreshTime).toString());
            ((AgentListPanel)actionListener).jLastRefreshTime.revalidate();
        }
    }

    boolean isTimeForAnotherRefresh() {
        long l = System.currentTimeMillis();
        int n = this.getRefreshRate();
        return n >= 0 && l - this.lastRefreshTime >= (long)n;
    }

    protected int getAgentType() {
        return this.agentType;
    }

    public String getHelpID() {
        return this.helpID;
    }

    public void reDisplay() {
        this.getData();
        this.show();
    }

    public void getData() {
        if (this.panel == null) {
            this.panel = this.getPanel();
            ((AgentListPanel)this.panel).setComponents();
        }
        GuiClient.doRequest(this.getRequestor(), this.getAgentRequest());
    }

    public void goingAway() {
        this.stopRefreshJob();
        this.panel = null;
    }

    public void panelToBeNulled() {
        if (this.getPanel() != null && this.getPanel().getTable() != null) {
            this.setSelectedDataRows(this.getPanel().getTable().getSelectedRows());
        } else {
            this.setSelectedDataRows(null);
        }
        this.panel = null;
    }

    private GuiRequestor getRequestor() {
        return new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                AgentListDDI.this.refreshAgents(s, response, true);
                if (AgentListDDI.this.getRequestorInfo() == null) {
                    AgentListDDI.this.startRefreshJob();
                } else {
                    GuiClient.doRequest(AgentListDDI.this.getRequestorInfo(), AgentListDDI.this.getAgentInfoRequest());
                }
            }
        };
    }

    protected GuiRequestor getRequestorInfo() {
        return null;
    }

    protected Request getAgentInfoRequest() {
        return null;
    }

    BaseTreeNode getTreeNode(Object object, boolean bl, boolean bl2) {
        return AgentTreeNodesStore.getTreeNode(object, this.getAgentType(), this.treeNode, bl, bl2);
    }

    protected void startRefreshJob() {
        if (!this.refreshStarted) {
            refreshAgentsTimer.schedule(this.refreshTask, 0L, 5000L);
        }
        this.refreshStarted = true;
    }

    private void stopRefreshJob() {
        this.refreshTask.cancel();
    }

    int[] getSelectedDataRows() {
        if (this.selectedDataRows == null) {
            return null;
        }
        return (int[])this.selectedDataRows.clone();
    }

    void setSelectedDataRows(int[] nArray) {
        this.selectedDataRows = (int[])(nArray != null ? (int[])nArray.clone() : null);
    }

    int getSortColumn() {
        return this.sortColumn;
    }

    void setSortColumn(int n) {
        this.sortColumn = n;
    }

    int getSortDirection() {
        return this.sortDirection;
    }

    void setSortDirection(int n) {
        this.sortDirection = n;
    }

    private class RefreshDataModel
    implements Runnable {
        private short innerStatus;
        private Response innerResponse;
        private short innerStatusInfo;
        private Response innerResponseInfo;

        RefreshDataModel(short s, Response response, short s2, Response response2) {
            this.innerResponse = response;
            this.innerStatus = s;
            this.innerStatusInfo = s2;
            this.innerResponseInfo = response2;
        }

        public void run() {
            boolean bl;
            if (AgentListDDI.this != DataDisplayInfo.getCurrent()) {
                return;
            }
            boolean bl2 = bl = this.innerResponse != null && this.innerResponseInfo == null;
            if (this.innerResponse != null) {
                AgentListDDI.this.refreshAgents(this.innerStatus, this.innerResponse, bl);
                if (this.innerResponseInfo != null) {
                    AgentListDDI.this.refreshAgentsInfo(this.innerStatusInfo, this.innerResponseInfo, true);
                }
            }
        }
    }

    private class RefreshDataModelError
    implements Runnable {
        private String errorMessage;

        RefreshDataModelError(String string) {
            this.errorMessage = string;
        }

        public void run() {
            GuiClient.serverError((short)12, this.errorMessage);
            AgentListDDI.this.setLastRefreshTime(false);
            AgentListPanel agentListPanel = (AgentListPanel)AgentListDDI.this.panel;
            if (agentListPanel != null) {
                agentListPanel.refreshRatesComboBox.setSelectedIndex(0);
                if (AgentListDDI.this == DataDisplayInfo.getCurrent()) {
                    agentListPanel.refreshRatesComboBox.revalidate();
                }
            }
        }
    }
}

