/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.config.fabric;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.gui.FabricMgrTreeLabel;
import org.eclipse.aperi.TStorm.gui.TreeLabel;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.config.common.ConfigNote;
import org.eclipse.aperi.gui.config.common.ConfigSection;
import org.eclipse.aperi.gui.config.common.ConfigUtil;
import org.eclipse.aperi.gui.config.common.LabelRenderer;
import org.eclipse.aperi.gui.config.common.NumberRenderer;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.GuiZoneConstants;
import org.eclipse.aperi.gui.fabric.zone.ZoneControlLabel;
import org.eclipse.aperi.gui.fabric.zone.ZoneUIAccessor;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneCapabilities;
import org.eclipse.aperi.topology.gui.TopologyViewerTreeLabel;
import org.eclipse.aperi.xmsg.MessageLog;

public class FabricsSection
extends ConfigSection
implements ActionListener,
TJCTableMouseInterface {
    private MegaTable table = null;
    private FabricData[] fabricTableData;
    private FabricsTableModel tableModel;
    private JButton link2fabrics = null;
    private JButton link2sysreports = null;
    private JButton link2topo = null;
    private JLabel noData = null;
    private ArrayList fabricsNodePath = null;
    private ArrayList reportsNodePath = null;
    private ArrayList topoNodePath = null;
    private int countTotal = 0;
    private int countUp = 0;
    private int countMissing = 0;
    private int countUnknown = 0;
    private HashMap[] sans = null;

    public FabricsSection(boolean bl) {
        super(bl);
        this.prepareTreeNodes();
    }

    private void prepareTreeNodes() {
        this.fabricsNodePath = new ArrayList();
        this.fabricsNodePath.add(FabricMgrTreeLabel.class);
        this.fabricsNodePath.add(ZoneControlLabel.class);
        this.reportsNodePath = new ArrayList();
        this.reportsNodePath.add(TreeLabel.class);
        this.reportsNodePath.add(MessageLog.getMessageNoID("STG4150L"));
        this.reportsNodePath.add(GuiUtil.getString("SYSTEM_REPORTS"));
        this.reportsNodePath.add(GuiUtil.getString("LABEL_FABRIC"));
        this.reportsNodePath.add(MessageLog.getMessageNoID("STG3913L"));
        this.topoNodePath = new ArrayList();
        this.topoNodePath.add(TreeLabel.class);
        this.topoNodePath.add(TopologyViewerTreeLabel.class);
        this.topoNodePath.add(GuiUtil.getString("TOPO_LABEL_ENTITY_FABRICS"));
    }

    public String getSectionTitle() {
        String string = GuiUtil.getString("CONFIG_FABRICS_SECTION");
        if (!this.isExpanded()) {
            string = GuiUtil.getString("CONFIG_FABRICS_SECTION_COLLAPSED", new String[]{String.valueOf(this.countTotal), String.valueOf(this.countUp), String.valueOf(this.countMissing)});
        }
        return string;
    }

    private void getSANs() {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler";
        request.userName = GuiUtil.getUserName();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(GuiZoneConstants.GET_SANS, GuiZoneConstants.GET_SANS);
        request.requestData = hashMap;
        request.flags = (byte)4;
        GuiClient.doRequest(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                HashMap hashMap;
                FabricsSection.this.sans = null;
                ZoneUIAccessor zoneUIAccessor = ZoneUIAccessor.getInstance();
                if (s <= 4 && (hashMap = (HashMap)response.responseData) != null && hashMap.containsKey(GuiZoneConstants.GET_SANS)) {
                    FabricsSection.this.sans = (HashMap[])hashMap.get(GuiZoneConstants.GET_SANS);
                    FabricsSection.this.resetStateCount();
                    if (FabricsSection.this.sans.length == 0 && FabricsSection.this.table != null) {
                        FabricsSection.this.remove(FabricsSection.this.table);
                    }
                    if (FabricsSection.this.sans.length == 0) {
                        FabricsSection.this.noData = new JLabel(GuiUtil.getString("CONFIG_NO_FABRICS_DATA"));
                        FabricsSection.this.add((Component)FabricsSection.this.noData, "Center");
                    }
                    PingRequestor pingRequestor = new PingRequestor(FabricsSection.this.sans.length);
                    int n = 0;
                    while (n < FabricsSection.this.sans.length) {
                        HashMap hashMap2 = FabricsSection.this.sans[n];
                        FabricsSection.this.setStateCount((Integer)hashMap2.get("State"));
                        hashMap2.put("zEnabled", new Integer(0));
                        zoneUIAccessor.ping(pingRequestor, (String)hashMap2.get("WWN"));
                        ++n;
                    }
                }
            }
        }, request);
    }

    private void resetStateCount() {
        this.countUp = 0;
        this.countMissing = 0;
        this.countUnknown = 0;
        this.countTotal = 0;
    }

    private void setStateCount(int n) {
        if (n == 1) {
            ++this.countUp;
        } else if (n == 0) {
            ++this.countMissing;
        } else {
            ++this.countUnknown;
        }
        ++this.countTotal;
    }

    public void refresh(boolean bl) {
        if (this.link2fabrics == null) {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            this.add((Component)jPanel, "Last");
            JPanel jPanel2 = new JPanel(new FlowLayout(3));
            this.link2fabrics = new JButton(GuiUtil.getString("CONFIG_ZONE_BTN"));
            this.link2fabrics.addActionListener(this);
            GuiUtil.setAccessible(this.link2fabrics, this.link2fabrics.getText(), this.link2fabrics.getText());
            if (!this.capabilities.isFabricOp()) {
                this.link2fabrics.setEnabled(false);
            }
            jPanel2.add(this.link2fabrics);
            this.link2sysreports = new JButton(GuiUtil.getString("CONFIG_SAN_ASSETS_ALL_BTN"));
            this.link2sysreports.addActionListener(this);
            GuiUtil.setAccessible(this.link2sysreports, this.link2sysreports.getText(), this.link2sysreports.getText());
            if (!this.capabilities.isFabricOp()) {
                this.link2sysreports.setEnabled(false);
            }
            jPanel2.add(this.link2sysreports);
            this.link2topo = new JButton(GuiUtil.getString("CONFIG_FTOPO_BTN"));
            this.link2topo.addActionListener(this);
            GuiUtil.setAccessible(this.link2topo, this.link2topo.getText(), this.link2topo.getText());
            if (!this.capabilities.isFabricOp()) {
                this.link2topo.setEnabled(false);
            }
            jPanel2.add(this.link2topo);
            jPanel2.setAlignmentX(0.0f);
            jPanel.add(jPanel2);
            ConfigNote configNote = new ConfigNote(GuiUtil.getString("CONFIG_FMGR_FDESC1"), jPanel);
            configNote.setAlignmentX(0.0f);
            jPanel.add(configNote);
            this.getSANs();
        }
        if (bl) {
            this.getSANs();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.link2fabrics || actionEvent.getSource() == this.link2sysreports || actionEvent.getSource() == this.link2topo) {
            ArrayList arrayList = null;
            if (actionEvent.getSource() == this.link2fabrics) {
                arrayList = new ArrayList(this.fabricsNodePath);
            } else if (actionEvent.getSource() == this.link2sysreports) {
                arrayList = new ArrayList(this.reportsNodePath);
            } else if (actionEvent.getSource() == this.link2topo) {
                arrayList = new ArrayList(this.topoNodePath);
            }
            new ConfigUtil().selectNode(arrayList);
        }
    }

    private void populateFabricData(HashMap[] hashMapArray) {
        if (hashMapArray != null && hashMapArray.length > 0) {
            this.fabricTableData = new FabricData[hashMapArray.length];
            int n = 0;
            while (n < hashMapArray.length) {
                HashMap hashMap = hashMapArray[n];
                this.fabricTableData[n] = new FabricData((String)hashMap.get("WWN"), (String)hashMap.get("Label"), (Integer)hashMap.get("State"), (Integer)hashMap.get("Active"), (Integer)hashMap.get("zEnabled"));
                ++n;
            }
        }
    }

    public void selectionChanged(boolean bl) {
        if (!this.capabilities.isFabricOp()) {
            this.link2topo.setEnabled(false);
            this.link2sysreports.setEnabled(false);
            this.link2fabrics.setEnabled(false);
        } else {
            this.link2fabrics.setEnabled(true);
            this.link2topo.setEnabled(true);
            if (!this.capabilities.isFabricOp()) {
                this.link2sysreports.setEnabled(false);
            } else {
                this.link2sysreports.setEnabled(true);
            }
        }
    }

    public boolean select(int n, int n2) {
        return true;
    }

    public void doubleClick(int n, int n2) {
    }

    public void showPopup(int n, int n2, Component component, int n3, int n4) {
    }

    public void showDefaultChart(int n) {
    }

    private void updatePanel() {
        this.populateFabricData(this.sans);
        this.tableModel = new FabricsTableModel(this.sans);
        if (this.sans.length != 0 && this.tableModel != null) {
            if (this.table != null) {
                this.remove(this.table);
            }
            if (this.noData != null) {
                this.remove(this.noData);
            }
            this.table = new MegaTable();
            this.table.setVisibleRows(10);
            this.table.setMouseListener(this);
            this.table.setBaseTableModel(this.tableModel);
            this.table.setCellRenderer(Number.class, new NumberRenderer());
            this.table.setCellRenderer(JLabel.class, new LabelRenderer());
            this.table.setSelectionPolicy(0);
            this.table.sortByColumn(2, 1);
            this.selectionChanged(true);
            this.table.updateUI();
            this.add((Component)this.table, "First");
        }
        if (this.getContainer() != null) {
            this.getContainer().updateSectionTitle();
        }
        this.selectionChanged(false);
        this.revalidate();
        this.repaint();
    }

    private class FabricData {
        String wwn = "";
        String label = "";
        int state = 0;
        String active = "";
        int zEnabled = 0;

        public FabricData(String string, String string2, Integer n, Integer n2, Integer n3) {
            this.label = string2;
            this.wwn = string;
            this.active = this.getActive(n2);
            this.state = n;
            this.zEnabled = n3;
        }

        private String getActive(Integer n) {
            if (n != null) {
                switch (n) {
                    case 0: {
                        return FabricGuiUtil.getString("FabricZoneSetPage_InactiveZoneSet");
                    }
                }
                return FabricGuiUtil.getString("FabricZoneSetPage_ActiveZoneSet");
            }
            return "";
        }

        private JLabel getState(Integer n) {
            if (n != null) {
                return FabricGuiUtil.getDetectableStateLabel(n);
            }
            return new JLabel();
        }

        private JLabel getEnabled(Integer n) {
            if (n != null) {
                return FabricGuiUtil.getZoningEnabledLabel(n);
            }
            return new JLabel();
        }

        public String getLabel() {
            return this.label;
        }

        public String getWWN() {
            return this.wwn;
        }

        public String getActive() {
            return this.active;
        }

        public int getState() {
            return this.state;
        }

        public int getEnabled() {
            return this.zEnabled;
        }
    }

    public class FabricsTableModel
    extends BaseTableModel {
        public final String[] COL_NAMES = new String[]{FabricGuiUtil.getString("FabricZone_FabricColumn"), FabricGuiUtil.getString("FabricZone_PhysicalFabricColumn2"), FabricGuiUtil.getString("FabricZone_State_Column"), FabricGuiUtil.getString("FabricZone_ActiveColumn"), GuiUtil.getString("CONFIG_ZONE_COL")};
        private static final int F_LABEL = 0;
        private static final int F_PHYS = 1;
        private static final int F_STATE = 2;
        private static final int F_VSAN_STATE = 3;
        private static final int F_ZONE_ENABLED = 4;
        private HashMap[] sans = null;

        FabricsTableModel(HashMap[] hashMapArray) {
            this.columnNames = this.COL_NAMES;
            this.rowCount = hashMapArray != null ? hashMapArray.length : 0;
            this.sans = (HashMap[])hashMapArray.clone();
        }

        public Object getTableDataItem(int n, int n2) {
            HashMap cfr_ignored_0 = this.sans[n];
            try {
                switch (n2) {
                    case 0: {
                        return FabricsSection.this.fabricTableData[n].getLabel();
                    }
                    case 1: {
                        return FabricsSection.this.fabricTableData[n].getWWN();
                    }
                    case 2: {
                        JLabel jLabel = FabricGuiUtil.getDetectableStateLabel(FabricsSection.this.fabricTableData[n].getState());
                        return jLabel;
                    }
                    case 3: {
                        return FabricsSection.this.fabricTableData[n].getActive();
                    }
                    case 4: {
                        JLabel jLabel = FabricGuiUtil.getZoningEnabledLabel(FabricsSection.this.fabricTableData[n].getEnabled());
                        return jLabel;
                    }
                }
                return "";
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return "";
            }
        }
    }

    public class PingRequestor
    implements GuiRequestor {
        int reqCount;

        public PingRequestor(int n) {
            this.reqCount = n;
        }

        public void handleResponse(short s, Response response) {
            --this.reqCount;
            ZoneCapabilities zoneCapabilities = new ZoneCapabilities();
            if (s < 4) {
                HashMap hashMap = (HashMap)response.responseData;
                zoneCapabilities = (ZoneCapabilities)hashMap.get("pingZoneAgent");
                if (zoneCapabilities == null) {
                    if (hashMap.containsKey("pingError")) {
                        int n = (Integer)hashMap.get("pingError");
                        switch (n) {
                            case 5: {
                                GuiUtil.getString("FabricZone_TokenError");
                                GuiUtil.getString("FMSG_PING_INVALID_TOKEN_ERROR");
                                break;
                            }
                            case 4: {
                                GuiUtil.getString("FabricZoneNotebook_pingNoAgentWarning");
                                GuiUtil.getString("FMSG_PING_NOTAVAILABLE_ERROR");
                                break;
                            }
                            case 1: {
                                GuiUtil.getString("FabricZoneNotebook_pingNoAgentWarning");
                                GuiUtil.getString("FMSG_PING_GENERAL_ERROR");
                            }
                        }
                    }
                } else {
                    String string = zoneCapabilities.getAgentName();
                    int n = 0;
                    while (n < FabricsSection.this.sans.length) {
                        if (((String)FabricsSection.this.sans[n].get("WWN")).equals(string)) {
                            FabricsSection.this.sans[n].put("zEnabled", new Integer(1));
                        }
                        ++n;
                    }
                }
            }
            if (this.reqCount == 0) {
                FabricsSection.this.updatePanel();
            }
        }
    }
}

