/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.config.service;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.admin.AdminTreeLabel;
import org.eclipse.aperi.gui.admin.DeviceServicesTreeLabel;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.config.common.ConfigNote;
import org.eclipse.aperi.gui.config.common.ConfigSection;
import org.eclipse.aperi.gui.config.common.ConfigUtil;
import org.eclipse.aperi.gui.config.common.LabelRenderer;
import org.eclipse.aperi.gui.config.common.NumberRenderer;
import org.eclipse.aperi.gui.config.service.ServiceConfigTab;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.req.DeviceServerStatusResp;
import org.eclipse.aperi.xmsg.MessageLog;

public class DeviceServerSection
extends ConfigSection
implements ActionListener {
    private MegaTable table = null;
    private DeviceServerTableModel tableModel = null;
    private DeviceServerStatusResp status = null;
    private JButton link2detail = null;
    private ArrayList devicesvrNodePath = null;
    private ArrayList deviceParentNodePath = null;
    private StringBuffer errorMessage = new StringBuffer();

    public DeviceServerSection(boolean bl) {
        super(bl);
        this.prepareTreeNodes();
    }

    private void prepareTreeNodes() {
        this.devicesvrNodePath = new ArrayList();
        this.devicesvrNodePath.add(AdminTreeLabel.class);
        this.devicesvrNodePath.add(MessageLog.getMessageNoID("ADG0100L", null));
        this.devicesvrNodePath.add(DeviceServicesTreeLabel.class);
        this.devicesvrNodePath.add(new Integer(0));
        this.deviceParentNodePath = new ArrayList();
        this.deviceParentNodePath.add(AdminTreeLabel.class);
        this.deviceParentNodePath.add(MessageLog.getMessageNoID("ADG0100L", null));
        this.deviceParentNodePath.add(DeviceServicesTreeLabel.class);
    }

    public String getSectionTitle() {
        String string = GuiUtil.getString("DEVICE_SERVER");
        if (this.status == null) {
            this.retrieveServerStatus();
        }
        if (this.status != null) {
            String string2 = String.valueOf(this.status.getServerName()) + GuiUtil.getString("COLON") + Integer.toString(this.status.getPort());
            String string3 = "";
            if (!this.isExpanded()) {
                if (this.status.getState() == 3) {
                    string3 = Util.getString("TEXT_STATE_UPGRADING", string2);
                } else if (this.status.getState() == 1) {
                    string3 = Util.getString("TEXT_AGENTSTATE_UP", string2);
                } else if (this.status.getState() == 3) {
                    string3 = Util.getString("TEXT_AGENTSTATE_DOWN", string2);
                }
                string = Util.getString("CONFIG_DEVICESERVER_TITLE_COLLAPSED", string3);
            }
        }
        return string;
    }

    private short retrieveServerStatus() {
        short[] sArray = new short[1];
        DeviceRequest deviceRequest = new DeviceRequest("org.eclipse.aperi.server.svp.GuiSvp", "org.eclipse.aperi.server.handler.gui.DeviceServerStatusHndlr");
        deviceRequest.requestData = null;
        Response response = GuiClient.doRefreshRequest(deviceRequest, sArray, this.errorMessage);
        if (sArray[0] == 12) {
            this.status = (DeviceServerStatusResp)response.responseData;
            this.status.setState((byte)-1);
            this.status.setStartTime(-1L);
            this.status.setJdbcUrl(MessageLog.getMessageNoID("STG0019T"));
        } else {
            this.status = (DeviceServerStatusResp)response.responseData;
        }
        return sArray[0];
    }

    public void refresh(boolean bl) {
        if (this.table == null) {
            this.setLayout(new BorderLayout());
            this.table = new MegaTable();
            this.add((Component)this.table, "Center");
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            this.add((Component)jPanel, "Last");
            JPanel jPanel2 = new JPanel(new FlowLayout(3));
            this.link2detail = new JButton(GuiUtil.getString("CONFIG_DEVICESERVER_BUTTON_DETAILS"));
            GuiUtil.setAccessible(this.link2detail, this.link2detail.getText(), this.link2detail.getText());
            this.link2detail.addActionListener(this);
            this.link2detail.addActionListener(this);
            jPanel2.add(this.link2detail);
            jPanel2.setAlignmentX(0.0f);
            jPanel.add(jPanel2);
            ConfigNote configNote = new ConfigNote(GuiUtil.getString("CONFIG_DEVICESERVER_NOTE"), jPanel);
            configNote.setAlignmentX(0.0f);
            jPanel.add(configNote);
        }
        if (bl || this.tableModel == null) {
            short s = this.retrieveServerStatus();
            if (this.status != null) {
                this.tableModel = new DeviceServerTableModel(this.status);
            }
            if (s == 12) {
                this.link2detail.setEnabled(false);
            } else {
                this.link2detail.setEnabled(true);
            }
            if (this.tableModel != null) {
                this.table.setBaseTableModel(this.tableModel);
                this.table.setCellRenderer(Number.class, new NumberRenderer());
                this.table.setCellRenderer(JLabel.class, new LabelRenderer());
                this.table.setSelectionPolicy(0);
                this.table.updateUI();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.link2detail) {
            BaseTreeNode baseTreeNode = new ConfigUtil().getNode(this.deviceParentNodePath);
            ((DeviceServicesTreeLabel)baseTreeNode).getServices();
            new ConfigUtil().selectNode(this.devicesvrNodePath);
        }
    }

    public class DeviceServerTableModel
    extends BaseTableModel {
        public final String[] COL_NAMES = new String[]{GuiUtil.getString("CONFIG_COMMON_TABLE_COL_SERVER"), GuiUtil.getString("CONFIG_COMMON_TABLE_COL_PORT"), GuiUtil.getString("CONFIG_COMMON_TABLE_COL_STATE"), GuiUtil.getString("CONFIG_COMMON_TABLE_COL_TIME"), GuiUtil.getString("CONFIG_COMMON_TABLE_COL_DB")};
        private static final int DS_NAME = 0;
        private static final int DS_PORT = 1;
        private static final int DS_STATE = 2;
        private static final int DS_START_TIME = 3;
        private static final int DS_DATABASE = 4;
        private DeviceServerStatusResp status;

        public DeviceServerTableModel(DeviceServerStatusResp deviceServerStatusResp) {
            this.status = deviceServerStatusResp;
            this.columnNames = this.COL_NAMES;
            this.rowCount = deviceServerStatusResp != null ? 1 : 0;
        }

        public Object getTableDataItem(int n, int n2) {
            try {
                switch (n2) {
                    case 0: {
                        return GUIEntityUtil.getDisplayText(this.status.getServerName());
                    }
                    case 1: {
                        return Integer.toString(this.status.getPort());
                    }
                    case 2: {
                        if (this.status.getState() == 3) {
                            return new JLabel(GuiUtil.getString("CONFIG_COMMON_SERVER_STATUS_UPGRADE"), ServiceConfigTab.ICON_UPGRADE, 10);
                        }
                        if (this.status.getState() == 1) {
                            return new JLabel(GuiUtil.getString("CONFIG_COMMON_SERVER_STATUS_UP"), ServiceConfigTab.ICON_UP, 10);
                        }
                        if (this.status.getState() == 2) {
                            return new JLabel(GuiUtil.getString("CONFIG_COMMON_SERVER_STATUS_DOWN"), ServiceConfigTab.ICON_DOWN, 10);
                        }
                        if (this.status.getState() == -1) {
                            return GUIEntityUtil.getDisplayText(DeviceServerSection.this.errorMessage.toString());
                        }
                    }
                    case 3: {
                        if (this.status.getStartTime() == -1L) {
                            return GUIEntityUtil.getDisplayText(MessageLog.getMessageNoID("STG0019T"));
                        }
                        return DateFormat.getDateTimeInstance().format(new Date(this.status.getStartTime()));
                    }
                    case 4: {
                        return GUIEntityUtil.getDisplayText(this.status.getJdbcUrl());
                    }
                }
                return "";
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return "";
            }
        }
    }
}

