/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.config.service;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.admin.AdminTreeLabel;
import org.eclipse.aperi.gui.admin.agent.AgentTreeNodesStore;
import org.eclipse.aperi.gui.admin.agent.InbandFabricAgentTableModel;
import org.eclipse.aperi.gui.config.common.ConfigNote;
import org.eclipse.aperi.gui.config.common.ConfigSection;
import org.eclipse.aperi.gui.config.common.LabelRenderer;
import org.eclipse.aperi.gui.config.common.NumberRenderer;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.InbandFabricAgentInfo;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.xmsg.MessageLog;

public class InbandFabricAgentSection
extends ConfigSection
implements ActionListener,
TJCTableMouseInterface {
    private MegaTable table = null;
    private InbandFabricAgentTableModel tableModel = null;
    private JButton link2detail = null;
    private JButton checkBtn = null;
    private JLabel noData = null;
    private ArrayList inbandagtNodePath = null;
    private ArrayList agents = null;
    private ArrayList agentsInfo = null;
    private int countTotal = 0;
    private int countUp = 0;
    private int countDown = 0;
    private int countUnknown = 0;

    public InbandFabricAgentSection(boolean bl) {
        super(bl);
        this.prepareTreeNodes();
    }

    private void prepareTreeNodes() {
        this.inbandagtNodePath = new ArrayList();
        this.inbandagtNodePath.add(AdminTreeLabel.class);
        this.inbandagtNodePath.add(MessageLog.getMessageNoID("ADG0200L", null));
        this.inbandagtNodePath.add(GuiUtil.getString("INBAND_FABRIC"));
    }

    public String getSectionTitle() {
        String string = GuiUtil.getString("CONFIG_IBAGENT_TITLE_EXPANDED");
        if (!this.isExpanded()) {
            string = Util.getString("CONFIG_IBAGENT_TITLE_COLLAPSED", new String[]{String.valueOf(this.countTotal), String.valueOf(this.countUp), String.valueOf(this.countDown)});
        }
        return string;
    }

    private void getAgents() {
        Request request = new Request();
        ServerRequest.guiInfo(request, 8, -2);
        GuiClient.doRequest(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s <= 4) {
                    NameList nameList = (NameList)response.responseData;
                    InbandFabricAgentSection.this.agents = new ArrayList();
                    InbandFabricAgentSection.this.agentsInfo = new ArrayList();
                    InbandFabricAgentSection.this.resetStateCount();
                    while (nameList != null) {
                        InbandFabricAgentSection.this.agents.add(nameList);
                        InbandFabricAgentSection.this.agentsInfo.add(new InbandFabricAgentInfo());
                        InbandFabricAgentSection.this.setStateCount(nameList.nlState);
                        nameList = nameList.nlNext;
                    }
                    if (InbandFabricAgentSection.this.agents.size() == 0 && InbandFabricAgentSection.this.table != null) {
                        InbandFabricAgentSection.this.remove(InbandFabricAgentSection.this.table);
                    }
                    if (InbandFabricAgentSection.this.agents.size() == 0) {
                        InbandFabricAgentSection.this.noData = new JLabel(GuiUtil.getString("CONFIG_NO_IBF_AGENTS"));
                        InbandFabricAgentSection.this.add((Component)InbandFabricAgentSection.this.noData, "Center");
                    }
                    InbandFabricAgentSection.this.sendAgentRequest(new AgentRequestor());
                }
            }
        }, request);
    }

    private void updatePanel() {
        this.tableModel = new InbandFabricAgentTableModel(this.agents, this.agentsInfo);
        if (this.tableModel != null) {
            if (this.agents.size() != 0 && this.table != null) {
                this.remove(this.table);
            }
            if (this.noData != null) {
                this.remove(this.noData);
            }
            this.table = new MegaTable();
            this.table.setVisibleRows(10);
            this.table.setMouseListener(this);
            this.table.setBaseTableModel(this.tableModel);
            this.table.setCellRenderer(Number.class, new NumberRenderer());
            this.table.setCellRenderer(JLabel.class, new LabelRenderer());
            this.table.setSelectionPolicy(0);
            this.table.sortByColumn(2, 1);
            this.selectionChanged(true);
            this.table.updateUI();
            this.add((Component)this.table, "Center");
        }
        if (this.getContainer() != null) {
            this.getContainer().updateSectionTitle();
        }
        this.selectionChanged(false);
        this.revalidate();
        this.repaint();
    }

    private void resetStateCount() {
        this.countUp = 0;
        this.countDown = 0;
        this.countUnknown = 0;
        this.countTotal = 0;
    }

    private void setStateCount(int n) {
        if (n == 1) {
            ++this.countUp;
        } else if (n == 0) {
            ++this.countDown;
        } else {
            ++this.countUnknown;
        }
        ++this.countTotal;
    }

    public void refresh(boolean bl) {
        if (this.checkBtn == null) {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            this.add((Component)jPanel, "Last");
            JPanel jPanel2 = new JPanel(new FlowLayout(3));
            this.link2detail = new JButton(GuiUtil.getString("CONFIG_IBAGENT_BUTTON_DETAILS"));
            GuiUtil.setAccessible(this.link2detail, this.link2detail.getText(), this.link2detail.getText());
            this.link2detail.addActionListener(this);
            this.link2detail.addActionListener(this);
            jPanel2.add(this.link2detail);
            this.checkBtn = new JButton(FabricGuiUtil.getString("FabricInBand_Check"));
            GuiUtil.setAccessible(this.checkBtn, this.checkBtn.getText(), this.checkBtn.getText());
            this.link2detail.addActionListener(this);
            this.checkBtn.addActionListener(this);
            jPanel2.add(this.checkBtn);
            jPanel2.setAlignmentX(0.0f);
            jPanel.add(jPanel2);
            ConfigNote configNote = new ConfigNote(GuiUtil.getString("CONFIG_IBAGENT_NOTE"), jPanel);
            configNote.setAlignmentX(0.0f);
            jPanel.add(configNote);
        }
        if (bl || this.tableModel == null) {
            this.getAgents();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        NameList nameList;
        if (actionEvent.getSource() == this.link2detail) {
            NameList nameList2 = this.getSelectedAgent();
            if (nameList2 != null) {
                AgentTreeNodesStore.getTreeNode(nameList2, 8, null, true, false);
            }
        } else if (actionEvent.getSource() == this.checkBtn && (nameList = this.getSelectedAgent()) != null) {
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
            request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
            request.subType = "org.eclipse.aperi.server.handler.gui.fabric.InBandFabricAgentHandler";
            request.userName = GuiUtil.getUserName();
            InbandFabricAgentInfo inbandFabricAgentInfo = new InbandFabricAgentInfo();
            request.requestData = inbandFabricAgentInfo;
            request.flags = (byte)4;
            inbandFabricAgentInfo.request_type = 3;
            inbandFabricAgentInfo.hostname = nameList.nlName;
            inbandFabricAgentInfo.hostId = nameList.nlID;
            GuiClient.doRequest(new AgentCheckRequestor(nameList), request);
        }
    }

    public NameList getSelectedAgent() {
        int[] nArray;
        if (this.tableModel != null && this.tableModel.getNumRows() != 0 && (nArray = this.table.getSelectedRows()) != null && nArray.length > 0) {
            int n = nArray[0];
            return (NameList)this.agents.get(n);
        }
        return null;
    }

    private void updateAgentInfo(InbandFabricAgentInfo[] inbandFabricAgentInfoArray) {
        if (inbandFabricAgentInfoArray != null) {
            int n = 0;
            while (n < inbandFabricAgentInfoArray.length) {
                InbandFabricAgentInfo inbandFabricAgentInfo = inbandFabricAgentInfoArray[n];
                int n2 = 0;
                while (n2 < this.agents.size()) {
                    NameList nameList = (NameList)this.agents.get(n2);
                    if (nameList.nlID == inbandFabricAgentInfo.hostId) {
                        this.agentsInfo.set(n2, inbandFabricAgentInfo);
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    public void sendAgentRequest(GuiRequestor guiRequestor) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.fabric.InBandFabricAgentHandler";
        request.userName = GuiUtil.getUserName();
        InbandFabricAgentInfo inbandFabricAgentInfo = new InbandFabricAgentInfo();
        request.requestData = inbandFabricAgentInfo;
        request.flags = (byte)4;
        inbandFabricAgentInfo.request_type = 6;
        GuiClient.doRequest(guiRequestor, request);
    }

    public void selectionChanged(boolean bl) {
        NameList nameList = this.getSelectedAgent();
        if (nameList != null) {
            this.link2detail.setEnabled(true);
            this.checkBtn.setEnabled(true);
        } else {
            this.link2detail.setEnabled(false);
            this.checkBtn.setEnabled(false);
        }
    }

    public boolean select(int n, int n2) {
        return true;
    }

    public void doubleClick(int n, int n2) {
    }

    public void showPopup(int n, int n2, Component component, int n3, int n4) {
    }

    public void showDefaultChart(int n) {
    }

    static /* synthetic */ IGuiMain access$0() {
        return ConfigSection.guiMain;
    }

    public class AgentCheckRequestor
    implements GuiRequestor {
        NameList agent = null;

        public AgentCheckRequestor(NameList nameList) {
            this.agent = nameList;
        }

        public void handleResponse(short s, Response response) {
            if (s == 0) {
                InbandFabricAgentSection.this.refresh(true);
                InbandFabricAgentInfo inbandFabricAgentInfo = (InbandFabricAgentInfo)response.responseData;
                this.agent.nlState = (byte)inbandFabricAgentInfo.status;
                if (inbandFabricAgentInfo.status == 1) {
                    String string = MessageLog.getMessageNoID("ADG0294M", this.agent.nlName);
                    JOptionPane.showMessageDialog(InbandFabricAgentSection.access$0().getFrame(), string, MessageLog.getMessageNoID("ADG0295T"), 1);
                } else {
                    String string = String.valueOf(this.agent.nlName) + " " + FabricGuiUtil.getInbandFabricAgentStatusString(inbandFabricAgentInfo.status);
                    JOptionPane.showMessageDialog(InbandFabricAgentSection.access$0().getFrame(), string, MessageLog.getMessageNoID("ADG0295T"), 1);
                }
            }
        }
    }

    public class AgentRequestor
    implements GuiRequestor {
        public void handleResponse(short s, Response response) {
            if (s <= 4) {
                InbandFabricAgentInfo[] inbandFabricAgentInfoArray = (InbandFabricAgentInfo[])response.responseData;
                InbandFabricAgentSection.this.updateAgentInfo(inbandFabricAgentInfoArray);
                InbandFabricAgentSection.this.updatePanel();
            }
        }
    }
}

