/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.common.model;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.common.CIMOMSelectorDbHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskReportingHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.disk.common.util.exceptions.IDParseException;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.IoGroup;
import org.eclipse.aperi.infrastructure.database.objects.Runs;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.tables.TResIoGroupTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TRunsTable;
import org.eclipse.aperi.logging.TraceLogger;

public abstract class DiskDbAccessor {
    public static HashMap[] getStorageSubsystemCapabilities(String[] stringArray, String[] stringArray2, LogTraceHelper logTraceHelper) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getStorageSubsystemCapabilities", stringArray[0]);
        }
        HashMap[] hashMapArray = new HashMap[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            int n2 = Integer.parseInt(stringArray[n]);
            Object[] objectArray = CIMOMSelectorDbHelper.Subsystem.getCimomInformation(n2);
            if (objectArray != null && objectArray.length > 0) {
                Arrays.sort(objectArray);
                int n3 = CIMOMSelectorDbHelper.Subsystem.getCorrespondingCapabilityDataId(((CIMOMSelectorDbHelper.CIMOMInformation)objectArray[0]).getNamespaceId(), n2);
                CapabilityData capabilityData = CIMOMSelectorDbHelper.getCapabilityData(n3);
                hashMapArray[n] = DiskReportingHelper.getAttributes(capabilityData, stringArray2, logTraceHelper);
            }
            ++n;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "getStorageSubsystemCapabilities", hashMapArray);
        }
        return hashMapArray;
    }

    public static HashMap[] getMDisksByMDiskGroup(String string, String[] stringArray, DBConnection dBConnection) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getMDisksByMDiskGroup", string);
        }
        String string2 = "select * FROM T_RES_STORAGE_EXTENT where  POOL_ID = " + string + " AND MODE <> 0 ";
        return DiskDbAccessor.executeQuery(string2, stringArray, dBConnection);
    }

    private static Hashtable getMDisksWhereClause(String string, LogTraceHelper logTraceHelper) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getMDisksWhereClause", string);
        }
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(TResStorageExtentTable.class, "POOL_ID", logTraceHelper);
        hashtable.put(columnInfo, string);
        int n = 2;
        ColumnInfo columnInfo2 = DiskReportingHelper.getColumnInfo(TResStorageExtentTable.class, "MODE", logTraceHelper);
        hashtable.put(columnInfo2, String.valueOf(n));
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "getMDisksWhereClause", hashtable);
        }
        return hashtable;
    }

    public static HashMap[] getMDisksBySVC(String string, int n, String[] stringArray, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getMDisksBySVC", String.valueOf(string) + ", " + n);
        }
        Hashtable hashtable = DiskDbAccessor.getMDisksBySVCWhereClause(string, n, logTraceHelper);
        StorageExtent.StorageExtentCursor storageExtentCursor = null;
        Vector<HashMap> vector = new Vector<HashMap>();
        try {
            storageExtentCursor = StorageExtent.getCursor(dBConnection, hashtable, null);
            while (storageExtentCursor.next()) {
                StorageExtent storageExtent = storageExtentCursor.getAttributes();
                HashMap hashMap = DiskReportingHelper.getAttributes(storageExtent, stringArray, logTraceHelper);
                vector.add(hashMap);
            }
        }
        catch (Throwable throwable) {
            try {
                if (storageExtentCursor != null) {
                    storageExtentCursor.close();
                }
            }
            catch (Exception exception) {}
            dBConnection.commit();
            throw throwable;
        }
        try {
            if (storageExtentCursor != null) {
                storageExtentCursor.close();
            }
        }
        catch (Exception exception) {}
        dBConnection.commit();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "getMDisksBySVC", vector);
        }
        return vector.toArray(new HashMap[0]);
    }

    private static Hashtable getMDisksBySVCWhereClause(String string, int n, LogTraceHelper logTraceHelper) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getMDisksBySVCWhereClause", String.valueOf(string) + "," + n);
        }
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(TResStorageExtentTable.class, "SUBSYSTEM_ID", logTraceHelper);
        hashtable.put(columnInfo, string);
        if (n != -1) {
            ColumnInfo columnInfo2 = DiskReportingHelper.getColumnInfo(TResStorageExtentTable.class, "MODE", logTraceHelper);
            hashtable.put(columnInfo2, String.valueOf(n));
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "getMDisksBySVCWhereClause", hashtable);
        }
        return hashtable;
    }

    public static HashMap[] getIOGroupsBySVC(String string, String[] stringArray, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getIOGroupsBySVC", string);
        }
        Hashtable hashtable = DiskDbAccessor.getIOGroupsWhereClause(string, logTraceHelper);
        IoGroup.IoGroupCursor ioGroupCursor = null;
        Vector<HashMap> vector = new Vector<HashMap>();
        try {
            ioGroupCursor = IoGroup.getCursor(dBConnection, hashtable, null);
            while (ioGroupCursor.next()) {
                IoGroup ioGroup = ioGroupCursor.getAttributes();
                HashMap hashMap = DiskReportingHelper.getAttributes(ioGroup, stringArray, logTraceHelper);
                vector.add(hashMap);
            }
        }
        catch (Throwable throwable) {
            try {
                if (ioGroupCursor != null) {
                    ioGroupCursor.close();
                }
            }
            catch (Exception exception) {}
            dBConnection.commit();
            throw throwable;
        }
        try {
            if (ioGroupCursor != null) {
                ioGroupCursor.close();
            }
        }
        catch (Exception exception) {}
        dBConnection.commit();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "getIOGroupsBySVC", vector);
        }
        return vector.toArray(new HashMap[0]);
    }

    private static Hashtable getIOGroupsWhereClause(String string, LogTraceHelper logTraceHelper) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getIOGroupsWhereClause", string);
        }
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(TResIoGroupTable.class, "SUBSYSTEM_ID", logTraceHelper);
        hashtable.put(columnInfo, string);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "getIOGroupsWhereClause", hashtable);
        }
        return hashtable;
    }

    public static String[] getVDiskIdsForByIOGroup(String string, String string2, HashMap hashMap, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException, InvalidParameterException, MissingParameterException, IDParseException {
        String[] stringArray;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getVDiskIdsForByIOGroup", String.valueOf(string) + ", " + string2);
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Hashtable hashtable = DiskDbAccessor.getVDiskByIOGroupWhereClause(string2, logTraceHelper);
        StorageVolume.StorageVolumeCursor storageVolumeCursor = null;
        try {
            storageVolumeCursor = StorageVolume.getCursor(dBConnection, hashtable, null);
            while (storageVolumeCursor.next()) {
                stringArray = storageVolumeCursor.getAttributes();
                linkedList.add(ExternalKeyConverter.getStorageVolumeKey((StorageVolume)stringArray, string, logTraceHelper));
            }
        }
        catch (Throwable throwable) {
            try {
                if (storageVolumeCursor != null) {
                    storageVolumeCursor.close();
                }
            }
            catch (Exception exception) {}
            dBConnection.commit();
            throw throwable;
        }
        try {
            if (storageVolumeCursor != null) {
                storageVolumeCursor.close();
            }
        }
        catch (Exception exception) {}
        dBConnection.commit();
        stringArray = new String[]{};
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "getVDiskIdsForByIOGroup", linkedList);
        }
        return linkedList.toArray(stringArray);
    }

    private static Hashtable getVDiskByIOGroupWhereClause(String string, LogTraceHelper logTraceHelper) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getVDiskByIOGroupWhereClause", string);
        }
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(TResStorageVolumeTable.class, "IO_GROUP_ID", logTraceHelper);
        hashtable.put(columnInfo, string);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "getVDiskByIOGroupWhereClause", hashtable);
        }
        return hashtable;
    }

    public static int updateSubsystemAttributes(String string, Hashtable hashtable, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException {
        int n;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "updateSubsystemAttributes", string);
        }
        Hashtable hashtable2 = ExternalKeyConverter.getStorageSubsystemWhereClause(string, logTraceHelper);
        Hashtable hashtable3 = new Hashtable();
        for (String string2 : hashtable.keySet()) {
            hashtable3.put(TResStorageSubsystemTable.getColumnInfo(string2), hashtable.get(string2));
        }
        try {
            n = StorageSubsystem.update(dBConnection, hashtable3, hashtable2);
        }
        finally {
            dBConnection.commit();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "updateSubsystemAttributes", n);
        }
        return n;
    }

    public static int updateVolumeAttributes(String string, Hashtable hashtable, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException {
        int n;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "updateVolumeAttributes", string);
        }
        Hashtable hashtable2 = ExternalKeyConverter.getVolumeWhereclause(logTraceHelper, string, dBConnection);
        Hashtable hashtable3 = new Hashtable();
        for (String string2 : hashtable.keySet()) {
            hashtable3.put(TResStorageVolumeTable.getColumnInfo(string2), hashtable.get(string2));
        }
        try {
            n = StorageVolume.update(dBConnection, hashtable3, hashtable2);
        }
        finally {
            dBConnection.commit();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "updateVolumeAttributes", n);
        }
        return n;
    }

    public static int getNumberOfJobs(int n, int n2, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getNumberOfJobs", n + ", " + n2);
        }
        int n3 = 0;
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(TRunsTable.class, "SCHEDULE_ID", logTraceHelper);
        hashtable.put(columnInfo, String.valueOf(n));
        ColumnInfo columnInfo2 = DiskReportingHelper.getColumnInfo(TRunsTable.class, "STATUS", logTraceHelper);
        hashtable.put(columnInfo2, String.valueOf(n2));
        Runs.RunsCursor runsCursor = null;
        try {
            runsCursor = Runs.getCursor(dBConnection, hashtable, null);
            while (runsCursor.next()) {
                Runs runs = runsCursor.getAttributes();
                n3 += runs.getNumberJobs();
            }
        }
        catch (Throwable throwable) {
            try {
                if (runsCursor != null) {
                    runsCursor.close();
                }
            }
            catch (Exception exception) {}
            dBConnection.commit();
            throw throwable;
        }
        try {
            if (runsCursor != null) {
                runsCursor.close();
            }
        }
        catch (Exception exception) {}
        dBConnection.commit();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "getNumberOfJobs", n3);
        }
        return n3;
    }

    public static HashMap[] getVolumeNamesForSubsystem(String string, String[] stringArray, DBConnection dBConnection) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getVolumeNamesForSubsystem", string);
        }
        String string2 = "select DISPLAY_NAME from T_RES_STORAGE_VOLUME  where SUBSYSTEM_ID = " + string;
        return DiskDbAccessor.executeQuery(string2, stringArray, dBConnection);
    }

    public static HashMap[] getPort2HostMapping(String[] stringArray, DBConnection dBConnection) throws ServerException, SQLException {
        String string = "select distinct PORT.NAME AS PORT_WWN, H2P.HOST_URL from   T_VIEW_HOST2PORT H2P, T_RES_PORT PORT where  PORT.PORT_ID = H2P.PORT_ID and HOST_URL is not NULL";
        return DiskDbAccessor.executeQuery(string, stringArray, dBConnection);
    }

    public static HashMap[] getPortsForSubsystem(String string, String[] stringArray, DBConnection dBConnection) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getPortsForSubsystem", string);
        }
        String string2 = "select distinct PORT.PORT_ID, PORT.NAME as PORT_WWN, PORT2FABRIC.FABRIC_WWN,  CAST (null as varchar(255)) HOST_URL, CAST (null as varchar(255)) SUBSYSTEM_DISPLAY_TYPE,  PORT.TYPE  from T_RES_PORT PORT LEFT JOIN T_VIEW_ALL_PORTS PORT2FABRIC on PORT.NAME = PORT2FABRIC.PORT_WWN  where PORT.SUBSYSTEM_ID = " + string;
        return DiskDbAccessor.executeQuery(string2, stringArray, dBConnection);
    }

    public static HashMap[] getHostPortsInFabricForSubsystem(String string, String[] stringArray, DBConnection dBConnection) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getHostPortsForSubsystem", string);
        }
        String string2 = "select distinct TVAP.PORT_WWN, TVAP.FABRIC_WWN, TVAP.HOST_URL, PORT.TYPE, TVAP.SUBSYSTEM_DISPLAY_TYPE  from T_VIEW_ALL_PORTS  TVAP , T_RES_PORT PORT where TVAP.FABRIC_WWN in (select distinct FABRIC_WWN from T_VIEW_ALL_PORTS TVAP2 where TVAP2.SUBSYSTEM_ID = " + string + ") " + " and (TVAP.SUBSYSTEM_ID IS NULL or (TVAP.SUBSYSTEM_TYPE = 'SVC' and TVAP.SUBSYSTEM_ID <> " + string + ")) " + " and TVAP.PORT_WWN = PORT.NAME";
        return DiskDbAccessor.executeQuery(string2, stringArray, dBConnection);
    }

    public static HashMap[] getDefinedHostPortsForSubsystem(String string, String[] stringArray, DBConnection dBConnection) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getHostPortsForSubsystem", string);
        }
        String string2 = "select distinct PORT.NAME as PORT_WWN, CAST (null as char(16)) FABRIC_WWN, HOST2PORT.HOST_URL as HOST_URL,  CAST (null as varchar(255)) SUBSYSTEM_DISPLAY_TYPE,  PORT.TYPE as TYPE  from  T_RES_PORT PORT, T_VIEW_HOST2PORT HOST2PORT left outer join T_VIEW_HOSTPORT2FABRIC HOSTPORT2FABRIC on HOST2PORT.PORT_ID = HOSTPORT2FABRIC.PORT_ID where PORT.PORT_ID = HOST2PORT.PORT_ID and HOSTPORT2FABRIC.PORT_ID is null";
        return DiskDbAccessor.executeQuery(string2, stringArray, dBConnection);
    }

    public static HashMap[] getMDiskInfoForVDisk(String string, String string2, String[] stringArray, DBConnection dBConnection) throws ServerException, SQLException {
        String string3 = "select T_RES_STORAGE_EXTENT.STORAGE_EXTENT_ID, T_RES_STORAGE_EXTENT.DEVICE_ID, T_RES_STORAGE_EXTENT.NAME, T_RES_STORAGE_EXTENT.ELEMENT_NAME, T_RES_STORAGE_EXTENT.TOTAL_CAPACITY, T_RES_STORAGE_EXTENT.FREE_SPACE, T_RES_STORAGE_EXTENT.BLOCK_SIZE, T_RES_STORAGE_EXTENT.NUM_OF_BLOCKS, T_RES_STORAGE_EXTENT.CONSUMABLE_BLOCKS, T_RES_STORAGE_EXTENT.POOL_ID, T_RES_STORAGE_EXTENT.NATIVE_STATUS, T_RES_STORAGE_EXTENT.SUBSYSTEM_ID,  T_RES_STORAGE_EXTENT.MODE from T_RES_STORAGE_EXTENT AS T_RES_STORAGE_EXTENT, T_RES_STORAGE_VOLUME AS T_RES_STORAGE_VOLUME, T_RES_VOLUME2EXTENT AS T_RES_VOLUME2EXTENT where T_RES_STORAGE_VOLUME.NAME = '" + string + "' " + "and T_RES_STORAGE_VOLUME.SUBSYSTEM_ID = " + string2 + " " + "and T_RES_STORAGE_EXTENT.STORAGE_EXTENT_ID = T_RES_VOLUME2EXTENT.STORAGE_EXTENT_ID AND T_RES_VOLUME2EXTENT.VOLUME_ID = T_RES_STORAGE_VOLUME.SVID";
        return DiskDbAccessor.executeQuery(string3, stringArray, dBConnection);
    }

    public static HashMap[] getTypeForPortFromClientSetting(String string, String[] stringArray, DBConnection dBConnection) throws ServerException, SQLException {
        String string2 = "SELECT DISTINCT T_RES_CLIENT_SETTING_DATA.CLIENT_TYPES, T_RES_CLIENT_SETTING_DATA.ELEMENT_NAME, T_RES_CLIENT_SETTING_DATA.CLIENT_TYPE_DESCRIPTIONS from T_RES_PORT AS T_RES_PORT, T_RES_DATA_PATH AS T_RES_DATA_PATH, T_RES_MASKING_INFO AS T_RES_MASKING_INFO, T_RES_CLIENT_SETTING_DATA AS T_RES_CLIENT_SETTING_DATA where T_RES_CLIENT_SETTING_DATA.SETTING_DATA_ID = T_RES_MASKING_INFO.SETTING_DATA_ID and T_RES_MASKING_INFO.MASKING_INFO_ID = T_RES_DATA_PATH.MASKING_INFO_ID and T_RES_DATA_PATH.INITIATOR_PORT_ID = T_RES_PORT.PORT_ID and T_RES_PORT.NAME = '" + string + "'";
        return DiskDbAccessor.executeQuery(string2, stringArray, dBConnection);
    }

    public static HashMap[] getTypeForPortFromHost(String string, String[] stringArray, DBConnection dBConnection) throws ServerException, SQLException {
        String string2 = "SELECT DISTINCT T_RES_HOST.HOST_URL, T_RES_HOST.OS_TYPE from T_RES_HOST AS T_RES_HOST where T_RES_HOST.HOST_URL = '" + string + "'";
        return DiskDbAccessor.executeQuery(string2, stringArray, dBConnection);
    }

    public static HashMap[] executeQuery(String string, String[] stringArray, DBConnection dBConnection) throws ServerException, SQLException {
        HashMap[] hashMapArray;
        Vector<HashMap[]> vector;
        block21: {
            block23: {
                if (TraceLogger.enableTrace) {
                    TraceLogger.entry(DiskDbAccessor.class.getName(), "executeQuery", string);
                }
                vector = new Vector<HashMap[]>();
                DBResultSet dBResultSet = null;
                try {
                    try {
                        dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, null);
                        while (dBResultSet.next()) {
                            hashMapArray = new HashMap();
                            int n = 0;
                            while (n < stringArray.length) {
                                String string2 = stringArray[n];
                                hashMapArray.put(string2, dBResultSet.getObject(string2));
                                ++n;
                            }
                            vector.add(hashMapArray);
                        }
                    }
                    catch (Exception exception) {
                        block20: {
                            dBConnection.rollback();
                            if (TraceLogger.enableTrace) {
                                TraceLogger.exception(DiskDbAccessor.class.getName(), "executeQuery", exception);
                            }
                            try {
                                if (dBResultSet != null) {
                                    dBResultSet.getStatement().close();
                                }
                            }
                            catch (Exception exception2) {
                                if (!TraceLogger.enableTrace) break block20;
                                TraceLogger.exception(DiskDbAccessor.class.getName(), "executeQuery", exception2);
                            }
                        }
                        dBConnection.commit();
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    block22: {
                        try {
                            if (dBResultSet != null) {
                                dBResultSet.getStatement().close();
                            }
                        }
                        catch (Exception exception) {
                            if (!TraceLogger.enableTrace) break block22;
                            TraceLogger.exception(DiskDbAccessor.class.getName(), "executeQuery", exception);
                        }
                    }
                    dBConnection.commit();
                    throw throwable;
                }
                try {
                    if (dBResultSet != null) {
                        dBResultSet.getStatement().close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block23;
                    TraceLogger.exception(DiskDbAccessor.class.getName(), "executeQuery", exception);
                }
            }
            dBConnection.commit();
        }
        hashMapArray = vector.toArray(new HashMap[0]);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "executeQuery", vector);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "executeQuery", hashMapArray);
        }
        return hashMapArray;
    }
}

