/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.system;

import javax.swing.JLabel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.system.SubsystemDDI;

public class SubsystemTableModel
extends BaseTableModel {
    private SubsystemDDI aDDI;
    public static final String[] COL_NAMES = new String[]{Util.getString("DISK_SUBSYSTEM_COLUMN_SYSID_LABEL"), Util.getString("DISK_COMMON_LABEL"), Util.getString("DISK_SUBSYSTEM_COLUMN_TYPE_LABEL"), Util.getString("DISK_SUBSYSTEM_COLUMN_STATUS_LABEL"), Util.getString("DISK_SUBSYSTEM_COLUMN_UNUSEDCAP_LABEL"), Util.getString("DISK_SUBSYSTEM_COLUMN_USEDCAP_LABEL")};
    private static final int SYS_ID = 0;
    private static final int SYS_NAME = 1;
    private static final int SYS_TYPE = 2;
    private static final int SYS_STATUS = 3;
    private static final int SYS_USED = 4;
    private static final int SYS_UNUSED = 5;

    SubsystemTableModel(SubsystemDDI subsystemDDI) {
        this.aDDI = subsystemDDI;
        this.columnNames = COL_NAMES;
        this.rowCount = this.aDDI.getSubsystems().size();
    }

    public Object getTableDataItem(int n, int n2) {
        try {
            GUIStorageSubsystem gUIStorageSubsystem = (GUIStorageSubsystem)this.aDDI.getSubsystems().elementAt(n);
            switch (n2) {
                case 0: {
                    return GUIEntityUtil.getDisplayText(gUIStorageSubsystem.getDeviceId());
                }
                case 1: {
                    return GUIEntityUtil.getDisplayText(gUIStorageSubsystem.getUserProvidedName());
                }
                case 3: {
                    JLabel jLabel = GUIEntityUtil.getEntityStateLabel(gUIStorageSubsystem);
                    return jLabel;
                }
                case 2: {
                    if (gUIStorageSubsystem.getType() == 0) {
                        return Util.getString("DISK_SUBSYSTEMS_TYPE_ESS");
                    }
                    if (gUIStorageSubsystem.getType() == 1) {
                        return Util.getString("DISK_SUBSYSTEMS_TYPE_FASTT");
                    }
                    if (gUIStorageSubsystem.getType() == 2) {
                        return Util.getString("DISK_SUBSYSTEMS_TYPE_DS6000");
                    }
                    if (gUIStorageSubsystem.getType() == 3) {
                        return Util.getString("DISK_SUBSYSTEMS_TYPE_DS8000");
                    }
                    if (gUIStorageSubsystem.getType() == 4) {
                        return Util.getString("DISK_SUBSYSTEMS_TYPE_SVC");
                    }
                    if (gUIStorageSubsystem.getType() == 5) {
                        return Util.getString("DISK_SUBSYSTEMS_TYPE_HDS");
                    }
                    if (gUIStorageSubsystem.getType() == 6) {
                        return Util.getString("DISK_SUBSYSTEMS_TYPE_EMC");
                    }
                    if (gUIStorageSubsystem.getType() == 7) {
                        return Util.getString("DISK_SUBSYSTEMS_TYPE_HP");
                    }
                    if (gUIStorageSubsystem.getType() == 8) {
                        return Util.getString("DISK_SUBSYSTEMS_TYPE_SUN");
                    }
                    if (gUIStorageSubsystem.getType() == 9) {
                        return Util.getString("DISK_SUBSYSTEMS_TYPE_FUJITSU");
                    }
                    if (gUIStorageSubsystem.getType() == 10) {
                        return Util.getString("DISK_SUBSYSTEMS_TYPE_HPXP128");
                    }
                    if (gUIStorageSubsystem.getType() == 99) {
                        return Util.getString("DISK_SUBSYSTEMS_TYPE_OTHER");
                    }
                }
                case 5: {
                    return new Double(GUIEntityUtil.convertStorageCapacity(gUIStorageSubsystem.getUsedCapacity(), 0, 3, 10));
                }
                case 4: {
                    return new Double(GUIEntityUtil.convertStorageCapacity(gUIStorageSubsystem.getUnusedCapacity(), 0, 3, 10));
                }
            }
            return "";
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "";
        }
    }
}

