/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.disk.api.VolumeID;
import org.eclipse.aperi.gui.GuiDeviceJob;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Wizard;
import org.eclipse.aperi.gui.WizardEvent;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.common.model.GUIEntity;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.model.DiskDataController;
import org.eclipse.aperi.gui.disk.common.model.GUIIOGroup;
import org.eclipse.aperi.gui.disk.common.model.GUIMDisk;
import org.eclipse.aperi.gui.disk.common.model.GUIMDiskGroup;
import org.eclipse.aperi.gui.disk.common.model.GUIPort;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.volume.BaseZoneActionStep;
import org.eclipse.aperi.gui.disk.volume.CreateVDiskReviewStep;
import org.eclipse.aperi.gui.disk.volume.CreateVDiskSelectHostPortsStep;
import org.eclipse.aperi.gui.disk.volume.CreateVDiskSetCharacteristicsStep;
import org.eclipse.aperi.gui.disk.volume.CreateVDiskZoneActionStep;
import org.eclipse.aperi.request.Response;

public class CreateVDiskWizard
extends Wizard {
    private CreateVDiskSetCharacteristicsStep charStep = null;
    private CreateVDiskSelectHostPortsStep hostStep = null;
    private CreateVDiskZoneActionStep zoneStep = null;
    private CreateVDiskReviewStep reviewStep = null;
    private String SVC_ID = null;
    private String deviceID = null;
    private HashMap vdiskData = null;
    private Vector volumeVector = new Vector();
    private Vector hostports = new Vector();
    private Vector ssports = new Vector();
    private String[] hostportWWPNs = null;
    private String[] hostNames = null;
    private Integer hostType = new Integer(-1);
    private String hostTypeDesc = null;
    private String[] ssportWWPNs = null;
    private String[] volumeIDs = null;
    private GUIStorageSubsystem subSystem = null;
    private String[] vdiskTypes = new String[]{Util.getString("DISK_VDISK_TYPE_STRIPED"), Util.getString("DISK_VDISK_TYPE_SEQUENTIAL")};
    private int WIZARD_FLAGS = 31;
    private DiskDataController diskController = null;
    private HashMap unitsMap = new HashMap();
    private JDialog wizardDialog = null;

    public CreateVDiskWizard(GUIStorageSubsystem gUIStorageSubsystem) {
        this.subSystem = gUIStorageSubsystem;
        this.SVC_ID = this.subSystem.getId();
        this.deviceID = this.subSystem.getDeviceId();
        this.addWizardListener(this);
        this.vdiskData = new HashMap();
        this.charStep = new CreateVDiskSetCharacteristicsStep(this.WIZARD_FLAGS, this.SVC_ID);
        this.add(this.charStep);
        this.hostStep = new CreateVDiskSelectHostPortsStep(this.WIZARD_FLAGS, this.subSystem);
        this.add(this.hostStep);
        this.zoneStep = new CreateVDiskZoneActionStep(this.WIZARD_FLAGS, this.SVC_ID);
        this.add(this.zoneStep);
        this.reviewStep = new CreateVDiskReviewStep(this.WIZARD_FLAGS, this.SVC_ID);
        this.add(this.reviewStep);
        this.unitsMap.put(Util.getString("DISK_BYTES"), "0");
        this.unitsMap.put(Util.getString("DISK_KB"), "1");
        this.unitsMap.put(Util.getString("DISK_MB"), "2");
        this.unitsMap.put(Util.getString("DISK_GB"), "3");
        this.unitsMap.put(Util.getString("DISK_TB"), "4");
        this.unitsMap.put(Util.getString("DISK_PB"), "5");
    }

    public WizardPage getCurrentStep() {
        return (WizardPage)this.getCurrentPage();
    }

    public void addVDiskData(String string, Object object) {
        this.vdiskData.put(string, object);
    }

    public HashMap getData() {
        return this.vdiskData;
    }

    public CreateVDiskSelectHostPortsStep getHostPortsStep() {
        return this.hostStep;
    }

    public void nextBegin(WizardEvent wizardEvent) {
        wizardEvent.setAllowChange(((WizardPage)wizardEvent.getCurrentPage()).nextBegin());
        if ((WizardPage)wizardEvent.getCurrentPage() == this.hostStep) {
            if (this.hostStep.skipSubsystemStep()) {
                wizardEvent.setNewPage(this.zoneStep);
            }
            if (this.hostStep.skipToReviewStep()) {
                wizardEvent.setNewPage(this.reviewStep);
            }
        }
    }

    public void nextComplete(WizardEvent wizardEvent) {
        wizardEvent.setAllowChange(((WizardPage)wizardEvent.getCurrentPage()).nextComplete());
        if ((WizardPage)wizardEvent.getNewPage() == this.reviewStep) {
            this.reviewStep.fillData();
        }
        if ((WizardPage)wizardEvent.getNewPage() == this.zoneStep) {
            this.zoneStep.fillData();
        }
    }

    public void previousBegin(WizardEvent wizardEvent) {
        wizardEvent.setAllowChange(((WizardPage)wizardEvent.getCurrentPage()).previousBegin());
        if ((WizardPage)wizardEvent.getCurrentPage() == this.reviewStep) {
            if (this.hostStep.skipSubsystemStep()) {
                wizardEvent.setNewPage(this.zoneStep);
            }
            if (this.hostStep.skipToReviewStep()) {
                wizardEvent.setNewPage(this.hostStep);
            }
        }
    }

    public void finished(WizardEvent wizardEvent) {
        super.finished(wizardEvent);
        if (((WizardPage)wizardEvent.getCurrentPage()).equals(this.reviewStep)) {
            String string = Util.getString("DISK_VDISK_WIZARD_FINISHED");
            JOptionPane.showMessageDialog(this, string, Util.getString("DISK_CREATE_VDISK_WIZARD_LABEL", this.deviceID), 1);
            this.closeWizard();
            new VDiskThread(this).start();
        }
    }

    public void canceled(WizardEvent wizardEvent) {
        int n = JOptionPane.showConfirmDialog(this, Util.getString("DISK_VDISK_WIZARD_CANCELED"), Util.getString("DISK_VDISK_WIZARD_TITLE", this.deviceID), 0);
        switch (n) {
            case 0: {
                super.canceled(wizardEvent);
                this.closeWizard();
                break;
            }
        }
    }

    private void closeWizard() {
        this.wizardDialog = (JDialog)this.getParent().getParent().getParent().getParent();
        this.wizardDialog.dispose();
    }

    public class JobResultThread
    extends Thread {
        protected int jobID = 0;
        protected String fabricID = null;

        public JobResultThread(int n) {
            this.jobID = n;
        }

        public JobResultThread(int n, String string) {
            this.jobID = n;
            this.fabricID = string;
        }

        public void run() {
            AsyncResult asyncResult;
            AsyncResult[] asyncResultArray;
            Response response = GuiDeviceJob.getJobStatus(this.jobID, true);
            if (this.fabricID != null) {
                GuiUtil.triggerJobChange((short)108);
                boolean bl = false;
                if (response != null && (asyncResultArray = (AsyncResult[])response.responseData) != null && (asyncResultArray.getReturnException() != null || asyncResultArray.getRc() > 0)) {
                    bl = true;
                }
                if (bl) {
                    CreateVDiskWizard.this.diskController.rollbackFabricTransaction(new GuiRequestor(){

                        public void handleResponse(short s, Response response) {
                        }
                    }, this.fabricID);
                } else {
                    CreateVDiskWizard.this.diskController.releaseFabric(new GuiRequestor(){

                        public void handleResponse(short s, Response response) {
                        }
                    }, this.fabricID);
                }
            } else {
                GuiUtil.triggerJobChange((short)107);
            }
            if (response != null && (asyncResult = (AsyncResult)response.responseData) != null) {
                asyncResultArray = asyncResult.getSubJobResults();
                int n = 0;
                while (asyncResultArray != null && n < asyncResultArray.length) {
                    Exception exception = asyncResultArray[n].getReturnException();
                    if (exception != null) {
                        String string = exception.getMessage();
                        if (exception instanceof SRMRuntimeException) {
                            string = ((SRMRuntimeException)exception).getLocalizedMessage();
                        }
                    }
                    if (asyncResultArray[n] != null && asyncResultArray[n].getResults() != null && asyncResultArray[n].getRc() <= 0) {
                        asyncResultArray[n].getResults();
                    }
                    ++n;
                }
            }
        }
    }

    public class VDiskJobResultThread
    extends JobResultThread {
        public VDiskJobResultThread(int n) {
            super(n);
        }

        public void run() {
            Response response = GuiDeviceJob.getJobStatus(this.jobID, true);
            GuiUtil.triggerJobChange((short)107);
            if (response != null) {
                AsyncResult asyncResult = (AsyncResult)response.responseData;
                if (asyncResult != null) {
                    AsyncResult[] asyncResultArray = asyncResult.getSubJobResults();
                    int n = 0;
                    while (n < asyncResultArray.length) {
                        VolumeID[] volumeIDArray;
                        Exception exception = asyncResultArray[n].getReturnException();
                        if (exception != null) {
                            volumeIDArray = exception.getMessage();
                            if (exception instanceof SRMRuntimeException) {
                                volumeIDArray = ((SRMRuntimeException)exception).getLocalizedMessage();
                            }
                        }
                        if (asyncResultArray[n] != null && asyncResultArray[n].getResults() != null && asyncResultArray[n].getRc() <= 0) {
                            volumeIDArray = (VolumeID[])asyncResultArray[n].getResults();
                            CreateVDiskWizard.this.volumeVector.add(volumeIDArray[0].getStorageVolumeID());
                        }
                        ++n;
                    }
                }
                CreateVDiskWizard.this.hostportWWPNs = new String[CreateVDiskWizard.this.hostports.size()];
                int n = 0;
                while (n < CreateVDiskWizard.this.hostports.size()) {
                    ((CreateVDiskWizard)CreateVDiskWizard.this).hostportWWPNs[n] = ((GUIPort)CreateVDiskWizard.this.hostports.get(n)).getWwpn();
                    ++n;
                }
                if (CreateVDiskWizard.this.subSystem.isTargetPortRestrictionSupported() && 4 != CreateVDiskWizard.this.subSystem.getCapabilityData().getPortsPerView() && CreateVDiskWizard.this.ssports != null) {
                    CreateVDiskWizard.this.ssportWWPNs = new String[CreateVDiskWizard.this.ssports.size()];
                    n = 0;
                    while (n < CreateVDiskWizard.this.ssports.size()) {
                        ((CreateVDiskWizard)CreateVDiskWizard.this).ssportWWPNs[n] = ((GUIPort)CreateVDiskWizard.this.ssports.get(n)).getWwpn();
                        ++n;
                    }
                } else {
                    CreateVDiskWizard.this.ssportWWPNs = null;
                }
                CreateVDiskWizard.this.volumeIDs = CreateVDiskWizard.this.volumeVector.toArray(new String[0]);
                if (CreateVDiskWizard.this.hostportWWPNs.length > 0 && CreateVDiskWizard.this.volumeIDs.length > 0) {
                    CreateVDiskWizard.this.diskController.assignPorts(new GuiRequestor(){

                        public void handleResponse(short s, Response response) {
                            GuiUtil.triggerJobChange((short)107);
                            if (s <= 4) {
                                int n = (Integer)response.responseData;
                                new JobResultThread(n).start();
                            }
                        }
                    }, CreateVDiskWizard.this.volumeIDs, CreateVDiskWizard.this.ssportWWPNs, CreateVDiskWizard.this.hostportWWPNs);
                }
            }
        }
    }

    private class VDiskThread
    extends Thread {
        private CreateVDiskWizard wizard;

        public VDiskThread(CreateVDiskWizard createVDiskWizard2) {
            this.wizard = createVDiskWizard2;
        }

        public void run() {
            this.createVDisks();
        }

        private void createVDisks() {
            int n;
            Object object;
            int n2 = -1;
            long l = -1L;
            String string = new String();
            int n3 = -1;
            Vector vector = new Vector();
            boolean bl = false;
            int n4 = -1;
            String string2 = new String();
            boolean bl2 = false;
            CreateVDiskWizard.this.wizardDialog = (JDialog)this.wizard.getParent().getParent().getParent().getParent();
            CreateVDiskWizard.this.diskController = DiskDataController.getInstance();
            n2 = Integer.valueOf(CreateVDiskWizard.this.vdiskData.get(Util.getString("DISK_VDISK_QUANTITY_LABEL")).toString());
            l = Long.valueOf(CreateVDiskWizard.this.vdiskData.get(Util.getString("DISK_VDISK_SIZE_LABEL")).toString());
            string = CreateVDiskWizard.this.vdiskData.get(Util.getString("DISK_UNITS_LABEL")).toString();
            string = (String)CreateVDiskWizard.this.unitsMap.get(string);
            l = GUIEntityUtil.convertStorageCapacity(l, Integer.valueOf(string), 0);
            String string3 = CreateVDiskWizard.this.vdiskData.get(Util.getString("DISK_TYPE_LABEL")).toString();
            n3 = string3.equals(CreateVDiskWizard.this.vdiskTypes[1]) ? 1 : 0;
            vector = (Vector)CreateVDiskWizard.this.vdiskData.get(Util.getString("DISK_VDISK_CREATE_VDISK_LABEL"));
            String[] stringArray = vector != null ? vector.toArray(new String[0]) : (String[])null;
            bl = Boolean.valueOf(CreateVDiskWizard.this.vdiskData.get(Util.getString("DISK_VDISK_FORMAT_LABEL")).toString());
            GUIIOGroup gUIIOGroup = (GUIIOGroup)CreateVDiskWizard.this.vdiskData.get(Util.getString("DISK_VDISK_IOGROUP_LABEL"));
            if (gUIIOGroup != null) {
                n4 = Integer.valueOf(gUIIOGroup.getId());
            }
            Vector vector2 = (Vector)CreateVDiskWizard.this.vdiskData.get(Util.getString("DISK_VDISK_MDISKS_LABEL"));
            Vector<String> vector3 = new Vector<String>();
            bl2 = Boolean.valueOf(CreateVDiskWizard.this.vdiskData.get(Util.getString("DISK_VDISK_ROUNDROBIN_LABEL")).toString());
            if (n3 == 1 && !bl2) {
                if (!bl2) {
                    object = ((GUIMDisk)vector2.get(0)).getId();
                    n = 0;
                    while (n < n2) {
                        vector3.add((String)object);
                        ++n;
                    }
                }
            } else {
                int n5 = 0;
                while (n5 < vector2.size()) {
                    vector3.add(((GUIMDisk)vector2.get(n5)).getId());
                    ++n5;
                }
            }
            String[] stringArray2 = vector3.toArray(new String[0]);
            object = (GUIMDiskGroup)CreateVDiskWizard.this.vdiskData.get(Util.getString("DISK_VDISK_MDGROUP_LABEL"));
            string2 = object != null ? ((GUIEntity)object).getId() : null;
            CreateVDiskWizard.this.hostports = (Vector)CreateVDiskWizard.this.vdiskData.get(CreateVDiskSelectHostPortsStep.HOSTPORTS_DATA);
            CreateVDiskWizard.this.ssports = (Vector)CreateVDiskWizard.this.vdiskData.get(CreateVDiskSelectHostPortsStep.SUBSYSTEM_DATA);
            CreateVDiskWizard.this.hostType = (Integer)CreateVDiskWizard.this.vdiskData.get(CreateVDiskSelectHostPortsStep.HOSTPORTS_TYPE_DATA);
            CreateVDiskWizard.this.hostTypeDesc = (String)CreateVDiskWizard.this.vdiskData.get(CreateVDiskSelectHostPortsStep.HOSTPORTS_TYPE_DESC_DATA);
            if (CreateVDiskWizard.this.hostTypeDesc != null && CreateVDiskWizard.this.hostTypeDesc.length() == 0) {
                CreateVDiskWizard.this.hostTypeDesc = null;
            }
            CreateVDiskWizard.this.hostportWWPNs = new String[CreateVDiskWizard.this.hostports.size()];
            CreateVDiskWizard.this.hostNames = new String[CreateVDiskWizard.this.hostports.size()];
            n = 0;
            while (n < CreateVDiskWizard.this.hostports.size()) {
                ((CreateVDiskWizard)CreateVDiskWizard.this).hostportWWPNs[n] = ((GUIPort)CreateVDiskWizard.this.hostports.get(n)).getWwpn();
                ((CreateVDiskWizard)CreateVDiskWizard.this).hostNames[n] = ((GUIPort)CreateVDiskWizard.this.hostports.get(n)).getHostName();
                ++n;
            }
            if (CreateVDiskWizard.this.subSystem.isTargetPortRestrictionSupported() && 4 != CreateVDiskWizard.this.subSystem.getCapabilityData().getPortsPerView() && CreateVDiskWizard.this.ssports != null) {
                CreateVDiskWizard.this.ssportWWPNs = new String[CreateVDiskWizard.this.ssports.size()];
                n = 0;
                while (n < CreateVDiskWizard.this.ssports.size()) {
                    ((CreateVDiskWizard)CreateVDiskWizard.this).ssportWWPNs[n] = ((GUIPort)CreateVDiskWizard.this.ssports.get(n)).getWwpn();
                    ++n;
                }
            } else {
                CreateVDiskWizard.this.ssportWWPNs = null;
            }
            HashMap hashMap = (HashMap)CreateVDiskWizard.this.vdiskData.get(CreateVDiskZoneActionStep.ZONE_ACTION_DATA);
            if (hashMap != null) {
                Iterator iterator = hashMap.values().iterator();
                new Vector(hashMap.values());
                while (iterator.hasNext()) {
                    int n6;
                    String[] stringArray3;
                    Vector vector4;
                    BaseZoneActionStep.ZoneAction zoneAction = (BaseZoneActionStep.ZoneAction)iterator.next();
                    if (zoneAction.action == 0) {
                        zoneAction.hostPorts.addAll(zoneAction.ssPorts);
                        vector4 = zoneAction.hostPorts;
                        stringArray3 = new String[vector4.size()];
                        n6 = 0;
                        while (n6 < vector4.size()) {
                            stringArray3[n6] = ((GUIPort)vector4.get(n6)).getWwpn();
                            ++n6;
                        }
                        CreateVDiskWizard.this.diskController.createZone(new ZoneRequestor(zoneAction.fabricID), zoneAction.fabricID, zoneAction.zoneset.getName(), zoneAction.zoneName, stringArray3);
                        continue;
                    }
                    if (zoneAction.action != 1) continue;
                    zoneAction.hostPorts.addAll(zoneAction.ssPorts);
                    vector4 = zoneAction.hostPorts;
                    stringArray3 = new String[vector4.size()];
                    n6 = 0;
                    while (n6 < vector4.size()) {
                        stringArray3[n6] = ((GUIPort)vector4.get(n6)).getWwpn();
                        ++n6;
                    }
                    CreateVDiskWizard.this.diskController.updateZone(new ZoneRequestor(zoneAction.fabricID), zoneAction.fabricID, zoneAction.zoneset.getName(), zoneAction.zoneName, stringArray3);
                }
            }
            if (CreateVDiskWizard.this.hostportWWPNs == null || CreateVDiskWizard.this.hostportWWPNs.length == 0) {
                CreateVDiskWizard.this.diskController.createVDisks(new GuiRequestor(){

                    public void handleResponse(short s, Response response) {
                        GuiUtil.triggerJobChange((short)107);
                    }
                }, l, string2, stringArray, bl, n3, n4, stringArray2, n2, false);
            } else {
                CreateVDiskWizard.this.diskController.createVDisksAndAssignPorts(new GuiRequestor(){

                    public void handleResponse(short s, Response response) {
                        GuiUtil.triggerJobChange((short)107);
                    }
                }, l, string2, stringArray, bl, n3, n4, stringArray2, n2, CreateVDiskWizard.this.ssportWWPNs, CreateVDiskWizard.this.hostportWWPNs, CreateVDiskWizard.this.hostType, CreateVDiskWizard.this.hostTypeDesc, CreateVDiskWizard.this.hostNames);
            }
        }
    }

    public class ZoneRequestor
    implements GuiRequestor {
        String fabricID = null;

        public ZoneRequestor(String string) {
            this.fabricID = string;
        }

        public void handleResponse(short s, Response response) {
            GuiUtil.triggerJobChange((short)108);
            if (s <= 4) {
                int n = (Integer)response.responseData;
                new JobResultThread(n, this.fabricID).start();
            }
        }
    }
}

