/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.reports;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.gui.AskForRowIconInterface;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.fabric.reports.PortConnectionsAdjuster;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.fabric.reports.RespPortConnections;

public class PortConnectionsTable
extends JPanel
implements GuiRequestor {
    private MegaTable table = new MegaTable();
    PortConnectionsModel PortConnectionsModel;
    private GuiReportReq grr;
    private ReportingDDI ddi;
    private RespPortConnections[] data;
    private PortConnectionsAdjuster adjuster;
    private TJCTableMouseAdapter myMouseListener = new SelectListener();

    public PortConnectionsTable(GuiReportReq guiReportReq, ReportingDDI reportingDDI) {
        this.grr = guiReportReq;
        this.ddi = reportingDDI;
        GuiReportRequest guiReportRequest = new GuiReportRequest(guiReportReq);
        GuiClient.doRequest(this, guiReportRequest);
        this.setLayout(new BorderLayout());
        this.adjuster = new PortConnectionsAdjuster(guiReportReq);
    }

    public void handleResponse(short s, Response response) {
        this.data = s <= 4 ? (RespPortConnections[])response.responseData : null;
        int n = this.data != null ? this.data.length : 0;
        if (n == 0) {
            this.add((Component)this.ddi.getNoDataMessage_instance(this.grr), "Center");
            return;
        }
        this.adjuster.adjust(this.data, false);
        this.data = (RespPortConnections[])this.adjuster.getArray();
        this.table.setMouseListener(this.myMouseListener);
        this.PortConnectionsModel = new PortConnectionsModel();
        this.table.setCellRenderer(MutableLong.class, TableCellRenderers.space);
        this.table.setCellRenderer(MutableInteger.class, TableCellRenderers.number);
        this.table.setFrozenColumns(this.adjuster.frozenColumns);
        this.table.setFrozenRows(this.adjuster.frozenRows);
        this.table.setBaseTableModel(this.PortConnectionsModel);
        this.ddi.addRowCount(this.adjuster);
        this.add((Component)this.table, "Center");
    }

    public TJCTableMouseInterface getShowsPopup() {
        return this.myMouseListener;
    }

    private class PortConnectionsModel
    extends BaseTableModel
    implements AskForRowIconInterface {
        PortConnectionsModel() {
            this.columnNames = ((PortConnectionsTable)PortConnectionsTable.this).adjuster.colNames;
            this.rowCount = PortConnectionsTable.this.data.length + ((PortConnectionsTable)PortConnectionsTable.this).adjuster.frozenLabels;
            this.commonAdjuster = PortConnectionsTable.this.adjuster;
        }

        public boolean changeIcon(int n) {
            return n < ((PortConnectionsTable)PortConnectionsTable.this).adjuster.frozenRows;
        }

        public Object getTableDataItem(int n, int n2) {
            return PortConnectionsTable.this.adjuster.getCellData(n, PortConnectionsTable.this.adjuster.translateColumn(n2));
        }
    }

    public class SelectListener
    extends TJCTableMouseAdapter {
        public boolean select(int n, int n2) {
            return n >= ((PortConnectionsTable)PortConnectionsTable.this).adjuster.frozenLabels;
        }

        public void doubleClick(int n, int n2) {
            if ((n -= ((PortConnectionsTable)PortConnectionsTable.this).adjuster.frozenLabels) < 0 || PortConnectionsTable.this.adjuster.hasTotalsRow() && n == 0) {
                return;
            }
        }
    }
}

