/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GridBagPanel
extends JPanel {
    public static final int C_HORZ = 2;
    public static final int C_VERT = 3;
    public static final int C_BOTH = 1;
    public static final int C_NONE = 0;
    public static final int C_CENTER = 10;
    public static final int C_WEST = 17;
    public static final int C_EAST = 13;
    public static final int C_NW = 18;
    public static final int C_NE = 12;
    public static final int C_SW = 16;
    public static final int C_SE = 14;
    public static final int C_NORTH = 11;
    public static final int C_WIDTH = 1;
    public static final int C_HEIGHT = 1;
    public static final Dimension TEXTFIELDSIZE = new Dimension(165, 25);
    public static final Dimension TEXTAREASIZE;
    public static final Dimension TABLESIZE;
    private GridBagConstraints gbc;
    private Insets m_insets;
    private Insets titleInsets = new Insets(8, 5, 0, 8);
    private Insets subtitleInsets = new Insets(8, 10, 0, 8);
    private Insets descriptionInsets = new Insets(4, 12, 2, 8);
    private int m_anchor = 18;
    private int m_column = 0;
    private int m_row = 0;
    private JLabel topLabel;
    private JLabel descriptionLabel;

    static {
        TABLESIZE = TEXTAREASIZE = new Dimension(165, 100);
    }

    public GridBagPanel() {
        this(new Insets(4, 12, 0, 8));
    }

    public GridBagPanel(Insets insets) {
        super(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = this.m_anchor;
        this.gbc.insets = this.m_insets = insets;
        this.gbc.fill = 2;
    }

    public void setDefaultAnchor(int n) {
        this.gbc.anchor = this.m_anchor = n;
    }

    public void setDefaultInsets(Insets insets) {
        this.gbc.insets = this.m_insets = insets;
    }

    public void changeTitle(String string) {
        this.topLabel.setText(string);
    }

    public void changeDescription(String string) {
        this.descriptionLabel.setText(string);
    }

    public void newRow() {
        ++this.m_row;
        this.m_column = 0;
    }

    public void skipColumn() {
        ++this.m_column;
    }

    public void add(JComponent jComponent) {
        this.addComponent(jComponent, this.m_row, this.m_column, 1, 1, this.m_anchor, 2);
    }

    public void add(JComponent jComponent, int n) {
        this.addComponent(jComponent, this.m_row, this.m_column, 1, 1, this.m_anchor, n);
    }

    public void add(JComponent jComponent, Insets insets) {
        this.gbc.insets = insets;
        this.addComponent(jComponent, this.m_row, this.m_column, 1, 1, this.m_anchor, 2);
    }

    public void add(JComponent jComponent, int n, int n2) {
        this.addComponent(jComponent, this.m_row, this.m_column, 1, 1, n, n2);
    }

    public void add(JComponent jComponent, int n, Insets insets) {
        this.gbc.insets = insets;
        this.addComponent(jComponent, this.m_row, this.m_column, 1, 1, this.m_anchor, n);
    }

    public void add(JComponent jComponent, int n, int n2, Insets insets) {
        this.gbc.insets = insets;
        this.addComponent(jComponent, this.m_row, this.m_column, 1, 1, n, n2);
    }

    public void add(JComponent jComponent, int n, int n2, int n3) {
        this.addComponent(jComponent, this.m_row, this.m_column, n, n2, this.m_anchor, n3);
    }

    public void add(JComponent jComponent, int n, int n2, int n3, Insets insets) {
        this.gbc.insets = insets;
        this.addComponent(jComponent, this.m_row, this.m_column, n, n2, this.m_anchor, n3);
    }

    public void add(JComponent jComponent, int n, int n2, int n3, int n4, int n5, int n6, Insets insets) {
        this.gbc.insets = insets;
        this.addComponent(jComponent, n, n2, n3, n4, n5, n6);
    }

    public void createBox() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.getBackground());
        this.addComponent(jPanel, this.m_row, this.m_column, 1, 1, this.m_anchor, 0);
    }

    public void createStretchBox() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.getBackground());
        jPanel.setPreferredSize(new Dimension(0, 0));
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        jPanel.setMinimumSize(new Dimension(0, 0));
        this.addComponent(jPanel, this.m_row, this.m_column, 1, 1, this.m_anchor, 1);
    }

    public void addComponent(JComponent jComponent, int n, int n2, int n3, int n4, int n5, int n6) {
        this.gbc.gridx = n2;
        this.gbc.gridy = n;
        this.gbc.gridwidth = n3;
        this.gbc.gridheight = n4;
        this.gbc.anchor = n5;
        if (n3 > 1) {
            // empty if block
        }
        if (n4 > 1) {
            // empty if block
        }
        switch (n6) {
            case 2: {
                this.gbc.weightx = 1.0;
                this.gbc.weighty = 0.0;
                break;
            }
            case 3: {
                this.gbc.weightx = 0.0;
                this.gbc.weighty = 1.0;
                break;
            }
            case 1: {
                this.gbc.weightx = 1.0;
                this.gbc.weighty = 1.0;
                break;
            }
            case 0: {
                this.gbc.weightx = 0.0;
                this.gbc.weighty = 0.0;
                break;
            }
        }
        this.gbc.fill = n6;
        super.add((Component)jComponent, this.gbc);
        this.gbc.insets = this.m_insets;
        this.gbc.anchor = this.m_anchor;
        this.m_column = n2 + n3;
        this.m_row = n + n4 - 1;
    }
}

