/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.tape.drives;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.tape.common.TapeConstants;
import org.eclipse.aperi.gui.tape.common.model.GUILibrary;
import org.eclipse.aperi.gui.tape.common.model.TapeDataAccessor;
import org.eclipse.aperi.gui.tape.drives.DrivesListPanel;
import org.eclipse.aperi.gui.tape.drives.DrivesPanel;
import org.eclipse.aperi.request.Response;

public class DrivesDDI
extends DataDisplayInfo
implements ActionListener {
    private DrivesPanel mainPanel;
    private boolean closing;
    private boolean initialized;
    private HashMap hmapDrivesofLibrary;
    public GUILibrary library;
    private Vector drives = new Vector();
    protected TapeDataAccessor tapeAccessor = TapeDataAccessor.getInstance();

    public DrivesDDI(GUILibrary gUILibrary) {
        this.setDescription(Util.getString("TAPE_DRIVES_LABEL"));
        this.displayInScrollPane = true;
        this.helpID = "tapesys";
        this.library = gUILibrary;
    }

    public String getHelpID() {
        Component component = this.mainPanel.tabs.getSelectedComponent();
        if (component instanceof DrivesListPanel) {
            return TapeConstants.DRIVES_HELP;
        }
        return "welcome_gettingstarted";
    }

    public void reDisplay() {
        if (this.panel == null || this.drives.isEmpty()) {
            this.getData();
        } else {
            this.show();
            guiMain.setSaveActionEnabled(false, false);
        }
        guiMain.addSaveActionListener(this);
    }

    public Vector getDrives() {
        return this.drives;
    }

    public void getData() {
        this.drives.removeAllElements();
        this.tapeAccessor.getDrivesByLibrary(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s <= 4) {
                    DrivesDDI.this.hmapDrivesofLibrary = (HashMap)response.responseData;
                    DrivesDDI.this.drives = new Vector(DrivesDDI.this.hmapDrivesofLibrary.values());
                    if (DrivesDDI.this.mainPanel == null) {
                        DrivesDDI.this.mainPanel = new DrivesPanel(DrivesDDI.this);
                    }
                    DrivesDDI.this.panel = DrivesDDI.this.mainPanel.getComponent();
                    ((DrivesDDI)DrivesDDI.this).mainPanel.listPanel.buildtable();
                    DrivesDDI.this.show();
                }
            }
        }, this.library.getId());
    }

    public void panelToBeNulled() {
        this.mainPanel = null;
    }

    public void losingFocus() {
        guiMain.setSaveActionEnabled(false, false);
        guiMain.setSaveActionToolTip(null);
        guiMain.removeSaveActionListener(this);
    }

    public boolean isEditable() {
        return false;
    }

    public boolean changesPending() {
        return false;
    }

    public void saveAndClose() {
        this.closing = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }
}

