/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphGroupKey;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphDisk;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphLun;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphPool;
import org.eclipse.aperi.gui.topo.model.bean.GraphPool2Disk;
import org.eclipse.aperi.gui.topo.model.bean.GraphPool2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2Disk;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphZone;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneFabric2Zone;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneFabric2ZoneSet;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneSet;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneSet2Zone;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class GraphGroupingUtilities {
    public static final Integer GROUPBY_ALL = new Integer(0);
    public static final Integer GROUPBY_HEALTH = new Integer(2);
    public static final Integer GROUPBY_UDP1 = new Integer(4);
    public static final Integer GROUPBY_UDP2 = new Integer(8);
    public static final Integer GROUPBY_UDP3 = new Integer(16);
    public static final Integer GROUPBY_COMPUTERBYOS = new Integer(32);
    public static final Integer GROUPBY_SWBYFABRIC = new Integer(64);
    public static final Integer GROUPBY_SUBSYSTEMBYMODEL = new Integer(128);
    public static final Integer GROUPBY_DISKBYPOOL = new Integer(256);
    public static final Integer GROUPBY_DISKBYSUBSYSTEM = new Integer(512);
    public static final Integer GROUPBY_POOLBYRAID = new Integer(1024);
    public static final Integer GROUPBY_VOLUMEBYPOOL = new Integer(2048);
    public static final Integer GROUPBY_VOLUMEBYSUBSYSTEM = new Integer(4096);
    public static final Integer GROUPBY_LUNBYDEVICE = new Integer(8192);
    protected static final Hashtable groupByH = new Hashtable();

    static {
        groupByH.put(GROUPBY_ALL, new GroupingMethod_All());
        groupByH.put(GROUPBY_HEALTH, new GroupingMethod_Health());
        groupByH.put(GROUPBY_UDP1, new GroupingMethod_UDP1());
        groupByH.put(GROUPBY_UDP2, new GroupingMethod_UDP2());
        groupByH.put(GROUPBY_UDP3, new GroupingMethod_UDP3());
        groupByH.put(GROUPBY_COMPUTERBYOS, new GroupingMethod_ComputerByOS());
        groupByH.put(GROUPBY_SWBYFABRIC, new GroupingMethod_SwitchByFabric());
        groupByH.put(GROUPBY_SUBSYSTEMBYMODEL, new GroupingMethod_SubsystemByModel());
        groupByH.put(GROUPBY_DISKBYPOOL, new GroupingMethod_DiskByPool());
        groupByH.put(GROUPBY_DISKBYSUBSYSTEM, new GroupingMethod_DiskBySubsystem());
        groupByH.put(GROUPBY_POOLBYRAID, new GroupingMethod_PoolByRAID());
        groupByH.put(GROUPBY_VOLUMEBYPOOL, new GroupingMethod_VolumeByPool());
        groupByH.put(GROUPBY_VOLUMEBYSUBSYSTEM, new GroupingMethod_VolumeBySubsystem());
        groupByH.put(GROUPBY_LUNBYDEVICE, new GroupingMethod_LunByDevice());
    }

    public static Hashtable applyGrouping(Vector vector, Integer n, GraphModel graphModel) {
        IGroupingMethod iGroupingMethod;
        Hashtable hashtable = new Hashtable();
        GraphGroupKey graphGroupKey = new GraphGroupKey();
        hashtable.put(graphGroupKey, vector);
        int n2 = n;
        if (n2 == 0) {
            IGroupingMethod iGroupingMethod2 = (IGroupingMethod)groupByH.get(GROUPBY_ALL);
            hashtable = iGroupingMethod2.applyGrouping(hashtable, graphModel);
            return hashtable;
        }
        if ((n2 & GROUPBY_HEALTH) != 0) {
            iGroupingMethod = (IGroupingMethod)groupByH.get(GROUPBY_HEALTH);
            hashtable = iGroupingMethod.applyGrouping(hashtable, graphModel);
        }
        if ((n2 & GROUPBY_UDP1) != 0) {
            iGroupingMethod = (IGroupingMethod)groupByH.get(GROUPBY_UDP1);
            hashtable = iGroupingMethod.applyGrouping(hashtable, graphModel);
        }
        if ((n2 & GROUPBY_UDP2) != 0) {
            iGroupingMethod = (IGroupingMethod)groupByH.get(GROUPBY_UDP2);
            hashtable = iGroupingMethod.applyGrouping(hashtable, graphModel);
        }
        if ((n2 & GROUPBY_UDP3) != 0) {
            iGroupingMethod = (IGroupingMethod)groupByH.get(GROUPBY_UDP3);
            hashtable = iGroupingMethod.applyGrouping(hashtable, graphModel);
        }
        if ((n2 & GROUPBY_COMPUTERBYOS) != 0) {
            iGroupingMethod = (IGroupingMethod)groupByH.get(GROUPBY_COMPUTERBYOS);
            hashtable = iGroupingMethod.applyGrouping(hashtable, graphModel);
        }
        if ((n2 & GROUPBY_SWBYFABRIC) != 0) {
            iGroupingMethod = (IGroupingMethod)groupByH.get(GROUPBY_SWBYFABRIC);
            hashtable = iGroupingMethod.applyGrouping(hashtable, graphModel);
        }
        if ((n2 & GROUPBY_SUBSYSTEMBYMODEL) != 0) {
            iGroupingMethod = (IGroupingMethod)groupByH.get(GROUPBY_SUBSYSTEMBYMODEL);
            hashtable = iGroupingMethod.applyGrouping(hashtable, graphModel);
        }
        if ((n2 & GROUPBY_DISKBYPOOL) != 0) {
            iGroupingMethod = (IGroupingMethod)groupByH.get(GROUPBY_DISKBYPOOL);
            hashtable = iGroupingMethod.applyGrouping(hashtable, graphModel);
        }
        if ((n2 & GROUPBY_DISKBYSUBSYSTEM) != 0) {
            iGroupingMethod = (IGroupingMethod)groupByH.get(GROUPBY_DISKBYSUBSYSTEM);
            hashtable = iGroupingMethod.applyGrouping(hashtable, graphModel);
        }
        if ((n2 & GROUPBY_POOLBYRAID) != 0) {
            iGroupingMethod = (IGroupingMethod)groupByH.get(GROUPBY_POOLBYRAID);
            hashtable = iGroupingMethod.applyGrouping(hashtable, graphModel);
        }
        if ((n2 & GROUPBY_VOLUMEBYPOOL) != 0) {
            iGroupingMethod = (IGroupingMethod)groupByH.get(GROUPBY_VOLUMEBYPOOL);
            hashtable = iGroupingMethod.applyGrouping(hashtable, graphModel);
        }
        if ((n2 & GROUPBY_VOLUMEBYSUBSYSTEM) != 0) {
            iGroupingMethod = (IGroupingMethod)groupByH.get(GROUPBY_VOLUMEBYSUBSYSTEM);
            hashtable = iGroupingMethod.applyGrouping(hashtable, graphModel);
        }
        if ((n2 & GROUPBY_LUNBYDEVICE) != 0) {
            iGroupingMethod = (IGroupingMethod)groupByH.get(GROUPBY_LUNBYDEVICE);
            hashtable = iGroupingMethod.applyGrouping(hashtable, graphModel);
        }
        return hashtable;
    }

    protected static void groupOrphanZone(GraphModel graphModel) {
        GraphZoneSet graphZoneSet = null;
        GraphEntity.ID iD = null;
        Enumeration enumeration = graphModel.enumerateID(GraphZone.TYPE);
        while (enumeration.hasMoreElements()) {
            Object object;
            GraphZone.ID iD2 = (GraphZone.ID)enumeration.nextElement();
            Enumeration enumeration2 = graphModel.associatorID(GraphZoneSet2Zone.TYPE, iD2);
            if (enumeration2.hasMoreElements()) continue;
            if (graphZoneSet == null) {
                graphZoneSet = new GraphZoneSet("Orphan");
                iD = (GraphZoneSet.ID)graphZoneSet.getEntityID();
                graphZoneSet.setDisplayName(GuiUtil.getString("TOPO_LABEL_ENTITY_ORPHANZONES"));
                graphZoneSet.setActive(Boolean.FALSE);
                graphZoneSet.addScope("Orphan");
                graphModel.put(graphZoneSet);
                object = graphModel.associatorID(GraphZoneFabric2Zone.TYPE, iD2);
                while (object.hasMoreElements()) {
                    GraphZoneFabric.ID iD3 = (GraphZoneFabric.ID)object.nextElement();
                    GraphZoneFabric2ZoneSet graphZoneFabric2ZoneSet = new GraphZoneFabric2ZoneSet(iD3.getID() + "+" + iD.getID());
                    graphZoneFabric2ZoneSet.setZoneFabricID(iD3);
                    graphZoneFabric2ZoneSet.setZoneSetID((GraphZoneSet.ID)iD);
                    graphModel.put(graphZoneFabric2ZoneSet);
                }
            }
            object = new GraphZoneSet2Zone(iD.getID() + "+" + iD2.getID());
            ((GraphZoneSet2Zone)object).setZoneSetID((GraphZoneSet.ID)iD);
            ((GraphZoneSet2Zone)object).setZoneID(iD2);
            graphModel.put((GraphEntity)object);
        }
    }

    protected static class GroupingMethod_All
    implements IGroupingMethod {
        protected GroupingMethod_All() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYSINGLEGROUP");
        }

        public Hashtable applyGrouping(Hashtable hashtable, GraphModel graphModel) {
            Hashtable<GraphGroupKey, Vector> hashtable2 = new Hashtable<GraphGroupKey, Vector>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration.nextElement();
                Vector vector = (Vector)hashtable.get(graphGroupKey);
                String string = GuiUtil.getString("TOPO_LABEL_GROUPING_ALL");
                GraphGroupKey graphGroupKey2 = new GraphGroupKey(graphGroupKey);
                graphGroupKey2.addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)string)));
                hashtable2.put(graphGroupKey2, vector);
            }
            return hashtable2;
        }
    }

    protected static class GroupingMethod_ComputerByOS
    implements IGroupingMethod {
        protected GroupingMethod_ComputerByOS() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYOS");
        }

        public Hashtable applyGrouping(Hashtable hashtable, GraphModel graphModel) {
            Hashtable<GraphGroupKey, Vector<GraphComputer>> hashtable2 = new Hashtable<GraphGroupKey, Vector<GraphComputer>>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration.nextElement();
                Vector vector = (Vector)hashtable.get(graphGroupKey);
                int n = 0;
                while (n < vector.size()) {
                    GraphComputer graphComputer = (GraphComputer)vector.elementAt(n);
                    String string = graphComputer.getOSType();
                    if (string == null) {
                        string = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
                    }
                    GraphGroupKey graphGroupKey2 = new GraphGroupKey(graphGroupKey);
                    graphGroupKey2.addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)string)));
                    Vector<GraphComputer> vector2 = (Vector<GraphComputer>)hashtable2.get(graphGroupKey2);
                    if (vector2 == null) {
                        vector2 = new Vector<GraphComputer>();
                        hashtable2.put(graphGroupKey2, vector2);
                    }
                    vector2.add(graphComputer);
                    ++n;
                }
            }
            return hashtable2;
        }
    }

    protected static class GroupingMethod_DiskByPool
    implements IGroupingMethod {
        protected GroupingMethod_DiskByPool() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYPOOL");
        }

        public Hashtable applyGrouping(Hashtable hashtable, GraphModel graphModel) {
            Hashtable<Comparable, Serializable> hashtable2 = new Hashtable<Comparable, Serializable>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                GraphEntity graphEntity;
                Object object;
                Serializable serializable;
                Object object2;
                Comparable comparable;
                Object object3;
                GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration.nextElement();
                Vector vector = (Vector)hashtable.get(graphGroupKey);
                Hashtable<GraphDisk.ID, Object> hashtable3 = new Hashtable<GraphDisk.ID, Object>();
                int n = 0;
                while (n < vector.size()) {
                    object3 = (GraphDisk)vector.elementAt(n);
                    comparable = (GraphDisk.ID)((GraphEntity)object3).getEntityID();
                    hashtable3.put((GraphDisk.ID)comparable, object3);
                    ++n;
                }
                Hashtable hashtable4 = new Hashtable();
                object3 = graphModel.enumerate(GraphPool2Disk.TYPE);
                while (object3.hasMoreElements()) {
                    String string;
                    comparable = (GraphPool2Disk)object3.nextElement();
                    object2 = ((GraphPool2Disk)comparable).getDiskID();
                    serializable = (GraphDisk)hashtable3.remove(object2);
                    if (serializable == null) continue;
                    object = ((GraphPool2Disk)comparable).getPoolID();
                    graphEntity = (GraphPool)hashtable4.get(object);
                    if (graphEntity == null) {
                        graphEntity = (GraphPool)graphModel.get((GraphEntity.ID)object);
                    }
                    if ((string = graphEntity.getDisplayName()) == null) {
                        string = ((GraphEntity.ID)object).toString();
                    }
                    GraphGroupKey graphGroupKey2 = new GraphGroupKey(graphGroupKey);
                    graphGroupKey2.addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)string)));
                    Vector<Serializable> vector2 = (Vector<Serializable>)hashtable2.get(graphGroupKey2);
                    if (vector2 == null) {
                        vector2 = new Vector<Serializable>();
                        hashtable2.put(graphGroupKey2, vector2);
                    }
                    vector2.add(serializable);
                }
                comparable = new GraphGroupKey(graphGroupKey);
                object2 = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
                ((GraphGroupKey)comparable).addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)object2));
                serializable = new Vector();
                object = hashtable3.elements();
                while (object.hasMoreElements()) {
                    graphEntity = (GraphDisk)object.nextElement();
                    ((Vector)serializable).add(graphEntity);
                }
                if (((Vector)serializable).size() <= 0) continue;
                hashtable2.put(comparable, serializable);
            }
            return hashtable2;
        }
    }

    protected static class GroupingMethod_DiskBySubsystem
    implements IGroupingMethod {
        protected GroupingMethod_DiskBySubsystem() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYSUBSYSTEM");
        }

        public Hashtable applyGrouping(Hashtable hashtable, GraphModel graphModel) {
            Hashtable<Comparable, Serializable> hashtable2 = new Hashtable<Comparable, Serializable>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                GraphEntity graphEntity;
                Object object;
                Serializable serializable;
                Object object2;
                Comparable comparable;
                Object object3;
                GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration.nextElement();
                Vector vector = (Vector)hashtable.get(graphGroupKey);
                Hashtable<GraphDisk.ID, Object> hashtable3 = new Hashtable<GraphDisk.ID, Object>();
                int n = 0;
                while (n < vector.size()) {
                    object3 = (GraphDisk)vector.elementAt(n);
                    comparable = (GraphDisk.ID)((GraphEntity)object3).getEntityID();
                    hashtable3.put((GraphDisk.ID)comparable, object3);
                    ++n;
                }
                Hashtable hashtable4 = new Hashtable();
                object3 = graphModel.enumerate(GraphSubsystem2Disk.TYPE);
                while (object3.hasMoreElements()) {
                    String string;
                    comparable = (GraphSubsystem2Disk)object3.nextElement();
                    object2 = ((GraphSubsystem2Disk)comparable).getDiskID();
                    serializable = (GraphDisk)hashtable3.remove(object2);
                    if (serializable == null) continue;
                    object = ((GraphSubsystem2Disk)comparable).getSubsystemID();
                    graphEntity = (GraphSubsystem)hashtable4.get(object);
                    if (graphEntity == null) {
                        graphEntity = (GraphSubsystem)graphModel.get((GraphEntity.ID)object);
                    }
                    if ((string = graphEntity.getDisplayName()) == null) {
                        string = ((GraphEntity.ID)object).toString();
                    }
                    GraphGroupKey graphGroupKey2 = new GraphGroupKey(graphGroupKey);
                    GraphGroupKey.Key key = new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)string), string.toString());
                    if (Boolean.TRUE.equals(((GraphSubsystem)graphEntity).getIsSVC())) {
                        key.setJumping(graphEntity, TopoResource.ICON_SVC_16_SELECTED, TopoResource.ICON_SVC_16_UNSELECTED);
                    } else {
                        key.setJumping(graphEntity, TopoResource.ICON_SUBSYSTEM_16_SELECTED, TopoResource.ICON_SUBSYSTEM_16_UNSELECTED);
                    }
                    graphGroupKey2.addKey(key);
                    Vector<Serializable> vector2 = (Vector<Serializable>)hashtable2.get(graphGroupKey2);
                    if (vector2 == null) {
                        vector2 = new Vector<Serializable>();
                        hashtable2.put(graphGroupKey2, vector2);
                    }
                    vector2.add(serializable);
                }
                comparable = new GraphGroupKey(graphGroupKey);
                object2 = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
                ((GraphGroupKey)comparable).addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)object2));
                serializable = new Vector();
                object = hashtable3.elements();
                while (object.hasMoreElements()) {
                    graphEntity = (GraphDisk)object.nextElement();
                    ((Vector)serializable).add(graphEntity);
                }
                if (((Vector)serializable).size() <= 0) continue;
                hashtable2.put(comparable, serializable);
            }
            return hashtable2;
        }
    }

    protected static class GroupingMethod_Health
    implements IGroupingMethod {
        protected GroupingMethod_Health() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYHEALTH");
        }

        public Hashtable applyGrouping(Hashtable hashtable, GraphModel graphModel) {
            Hashtable<GraphGroupKey, Vector<GraphEntity>> hashtable2 = new Hashtable<GraphGroupKey, Vector<GraphEntity>>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration.nextElement();
                Vector vector = (Vector)hashtable.get(graphGroupKey);
                int n = 0;
                while (n < vector.size()) {
                    GraphEntity graphEntity = (GraphEntity)vector.elementAt(n);
                    Integer n2 = graphEntity.getHealthStatus();
                    if (n2 == null) {
                        n2 = GraphModelConstant.STATUS_NA;
                    }
                    String string = GraphModelUtilities.getStatusAlias(n2);
                    GraphGroupKey graphGroupKey2 = new GraphGroupKey(graphGroupKey);
                    graphGroupKey2.addKey(new GraphGroupKey.Key(this.getMethodName(), n2, string));
                    Vector<GraphEntity> vector2 = (Vector<GraphEntity>)hashtable2.get(graphGroupKey2);
                    if (vector2 == null) {
                        vector2 = new Vector<GraphEntity>();
                        hashtable2.put(graphGroupKey2, vector2);
                    }
                    vector2.add(graphEntity);
                    ++n;
                }
            }
            return hashtable2;
        }
    }

    protected static class GroupingMethod_LunByDevice
    implements IGroupingMethod {
        protected GroupingMethod_LunByDevice() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYDEVICE");
        }

        public Hashtable applyGrouping(Hashtable hashtable, GraphModel graphModel) {
            Hashtable<Object, Serializable> hashtable2 = new Hashtable<Object, Serializable>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Serializable serializable;
                Comparable comparable;
                Object object;
                Object object2;
                Object object3;
                Serializable serializable2;
                Object object4;
                Comparable comparable2;
                Object object5;
                Object object6;
                Serializable serializable3;
                GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration.nextElement();
                Vector vector = (Vector)hashtable.get(graphGroupKey);
                Hashtable<GraphLun.ID, Serializable> hashtable3 = new Hashtable<GraphLun.ID, Serializable>();
                int n = 0;
                while (n < vector.size()) {
                    serializable3 = (GraphLun)vector.elementAt(n);
                    object6 = (GraphLun.ID)((GraphEntity)serializable3).getEntityID();
                    hashtable3.put((GraphLun.ID)object6, serializable3);
                    ++n;
                }
                Hashtable hashtable4 = new Hashtable();
                serializable3 = new Hashtable();
                object6 = graphModel.enumerate(GraphComputer2Lun.TYPE);
                while (object6.hasMoreElements()) {
                    object5 = (GraphComputer2Lun)object6.nextElement();
                    comparable2 = ((GraphComputer2Lun)object5).getLunID();
                    object4 = (GraphLun)hashtable3.remove(comparable2);
                    if (object4 == null) continue;
                    serializable2 = ((GraphComputer2Lun)object5).getComputerID();
                    object3 = (GraphComputer)hashtable4.get(serializable2);
                    if (object3 == null) {
                        object3 = (GraphComputer)graphModel.get((GraphEntity.ID)serializable2);
                    }
                    if ((object2 = ((GraphEntity)object3).getDisplayName()) == null) {
                        object2 = ((GraphEntity.ID)serializable2).toString();
                    }
                    object = new GraphGroupKey(graphGroupKey);
                    comparable = new GraphGroupKey.Key(this.getMethodName(), (Comparable)object2, ((String)object2).toString());
                    ((GraphGroupKey.Key)comparable).setJumping((GraphEntity)object3, TopoResource.ICON_COMPUTER_16_SELECTED, TopoResource.ICON_COMPUTER_16_UNSELECTED);
                    ((GraphGroupKey)object).addKey((GraphGroupKey.Key)comparable);
                    serializable = (Vector)hashtable2.get(object);
                    if (serializable == null) {
                        serializable = new Vector();
                        hashtable2.put(object, serializable);
                    }
                    ((Vector)serializable).add(object4);
                }
                object5 = graphModel.enumerate(GraphOther2Lun.TYPE);
                while (object5.hasMoreElements()) {
                    comparable2 = (GraphOther2Lun)object5.nextElement();
                    object4 = ((GraphOther2Lun)comparable2).getLunID();
                    serializable2 = (GraphLun)hashtable3.remove(object4);
                    if (serializable2 == null) continue;
                    object3 = ((GraphOther2Lun)comparable2).getOtherID();
                    object2 = (GraphOther)((Hashtable)serializable3).get(object3);
                    if (object2 == null) {
                        object2 = (GraphOther)graphModel.get((GraphEntity.ID)object3);
                    }
                    if ((object = ((GraphEntity)object2).getDisplayName()) == null) {
                        object = ((GraphEntity.ID)object3).toString();
                    }
                    comparable = new GraphGroupKey(graphGroupKey);
                    serializable = new GraphGroupKey.Key(this.getMethodName(), (Comparable)object, ((String)object).toString());
                    ((GraphGroupKey.Key)serializable).setJumping((GraphEntity)object2, TopoResource.ICON_OTHER_16_SELECTED, TopoResource.ICON_OTHER_16_UNSELECTED);
                    ((GraphGroupKey)comparable).addKey((GraphGroupKey.Key)serializable);
                    Vector<Serializable> vector2 = (Vector<Serializable>)hashtable2.get(comparable);
                    if (vector2 == null) {
                        vector2 = new Vector<Serializable>();
                        hashtable2.put(comparable, vector2);
                    }
                    vector2.add(serializable2);
                }
                comparable2 = new GraphGroupKey(graphGroupKey);
                object4 = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
                ((GraphGroupKey)comparable2).addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)object4));
                serializable2 = new Vector();
                object3 = hashtable3.elements();
                while (object3.hasMoreElements()) {
                    object2 = (GraphLun)object3.nextElement();
                    ((Vector)serializable2).add(object2);
                }
                if (((Vector)serializable2).size() <= 0) continue;
                hashtable2.put(comparable2, serializable2);
            }
            return hashtable2;
        }
    }

    protected static class GroupingMethod_PoolByRAID
    implements IGroupingMethod {
        protected GroupingMethod_PoolByRAID() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYRAID");
        }

        public Hashtable applyGrouping(Hashtable hashtable, GraphModel graphModel) {
            Hashtable<GraphGroupKey, Vector<GraphPool>> hashtable2 = new Hashtable<GraphGroupKey, Vector<GraphPool>>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration.nextElement();
                Vector vector = (Vector)hashtable.get(graphGroupKey);
                int n = 0;
                while (n < vector.size()) {
                    GraphPool graphPool = (GraphPool)vector.elementAt(n);
                    String string = graphPool.getRAIDLevel();
                    if (string == null) {
                        string = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
                    }
                    GraphGroupKey graphGroupKey2 = new GraphGroupKey(graphGroupKey);
                    graphGroupKey2.addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)string)));
                    Vector<GraphPool> vector2 = (Vector<GraphPool>)hashtable2.get(graphGroupKey2);
                    if (vector2 == null) {
                        vector2 = new Vector<GraphPool>();
                        hashtable2.put(graphGroupKey2, vector2);
                    }
                    vector2.add(graphPool);
                    ++n;
                }
            }
            return hashtable2;
        }
    }

    protected static class GroupingMethod_SubsystemByModel
    implements IGroupingMethod {
        protected GroupingMethod_SubsystemByModel() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYMODEL");
        }

        public Hashtable applyGrouping(Hashtable hashtable, GraphModel graphModel) {
            Hashtable<GraphGroupKey, Vector<GraphSubsystem>> hashtable2 = new Hashtable<GraphGroupKey, Vector<GraphSubsystem>>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration.nextElement();
                Vector vector = (Vector)hashtable.get(graphGroupKey);
                int n = 0;
                while (n < vector.size()) {
                    GraphSubsystem graphSubsystem = (GraphSubsystem)vector.elementAt(n);
                    String string = graphSubsystem.getModel();
                    if (string == null) {
                        string = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
                    }
                    GraphGroupKey graphGroupKey2 = new GraphGroupKey(graphGroupKey);
                    graphGroupKey2.addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)string)));
                    Vector<GraphSubsystem> vector2 = (Vector<GraphSubsystem>)hashtable2.get(graphGroupKey2);
                    if (vector2 == null) {
                        vector2 = new Vector<GraphSubsystem>();
                        hashtable2.put(graphGroupKey2, vector2);
                    }
                    vector2.add(graphSubsystem);
                    ++n;
                }
            }
            return hashtable2;
        }
    }

    protected static class GroupingMethod_SwitchByFabric
    implements IGroupingMethod {
        protected GroupingMethod_SwitchByFabric() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYFABRIC");
        }

        public Hashtable applyGrouping(Hashtable hashtable, GraphModel graphModel) {
            Hashtable<Comparable, Serializable> hashtable2 = new Hashtable<Comparable, Serializable>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                GraphEntity graphEntity;
                Object object;
                Serializable serializable;
                Object object2;
                Comparable comparable;
                Object object3;
                GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration.nextElement();
                Vector vector = (Vector)hashtable.get(graphGroupKey);
                Hashtable<GraphSwitch.ID, Object> hashtable3 = new Hashtable<GraphSwitch.ID, Object>();
                int n = 0;
                while (n < vector.size()) {
                    object3 = (GraphSwitch)vector.elementAt(n);
                    comparable = (GraphSwitch.ID)((GraphEntity)object3).getEntityID();
                    hashtable3.put((GraphSwitch.ID)comparable, object3);
                    ++n;
                }
                Hashtable hashtable4 = new Hashtable();
                object3 = graphModel.enumerate(GraphFabric2Switch.TYPE);
                while (object3.hasMoreElements()) {
                    String string;
                    comparable = (GraphFabric2Switch)object3.nextElement();
                    object2 = ((GraphFabric2Switch)comparable).getSwitchID();
                    serializable = (GraphSwitch)hashtable3.remove(object2);
                    if (serializable == null) continue;
                    object = ((GraphFabric2Switch)comparable).getFabricID();
                    graphEntity = (GraphFabric)hashtable4.get(object);
                    if (graphEntity == null) {
                        graphEntity = (GraphFabric)graphModel.get((GraphEntity.ID)object);
                    }
                    if ((string = graphEntity.getDisplayName()) == null) {
                        string = ((GraphEntity.ID)object).toString();
                    }
                    GraphGroupKey graphGroupKey2 = new GraphGroupKey(graphGroupKey);
                    GraphGroupKey.Key key = new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)string), string.toString());
                    key.setJumping(graphEntity, TopoResource.ICON_FABRIC_16_SELECTED, TopoResource.ICON_FABRIC_16_UNSELECTED);
                    graphGroupKey2.addKey(key);
                    Vector<Serializable> vector2 = (Vector<Serializable>)hashtable2.get(graphGroupKey2);
                    if (vector2 == null) {
                        vector2 = new Vector<Serializable>();
                        hashtable2.put(graphGroupKey2, vector2);
                    }
                    vector2.add(serializable);
                }
                comparable = new GraphGroupKey(graphGroupKey);
                object2 = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
                ((GraphGroupKey)comparable).addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)object2));
                serializable = new Vector();
                object = hashtable3.elements();
                while (object.hasMoreElements()) {
                    graphEntity = (GraphSwitch)object.nextElement();
                    ((Vector)serializable).add(graphEntity);
                }
                if (((Vector)serializable).size() <= 0) continue;
                hashtable2.put(comparable, serializable);
            }
            return hashtable2;
        }
    }

    protected static class GroupingMethod_UDP1
    implements IGroupingMethod {
        protected GroupingMethod_UDP1() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYUDP1");
        }

        public Hashtable applyGrouping(Hashtable hashtable, GraphModel graphModel) {
            Hashtable<GraphGroupKey, Vector<GraphEntity>> hashtable2 = new Hashtable<GraphGroupKey, Vector<GraphEntity>>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration.nextElement();
                Vector vector = (Vector)hashtable.get(graphGroupKey);
                int n = 0;
                while (n < vector.size()) {
                    GraphEntity graphEntity = (GraphEntity)vector.elementAt(n);
                    String string = graphEntity.getUDP1();
                    if (string == null) {
                        string = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
                    }
                    GraphGroupKey graphGroupKey2 = new GraphGroupKey(graphGroupKey);
                    graphGroupKey2.addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)string)));
                    Vector<GraphEntity> vector2 = (Vector<GraphEntity>)hashtable2.get(graphGroupKey2);
                    if (vector2 == null) {
                        vector2 = new Vector<GraphEntity>();
                        hashtable2.put(graphGroupKey2, vector2);
                    }
                    vector2.add(graphEntity);
                    ++n;
                }
            }
            return hashtable2;
        }
    }

    protected static class GroupingMethod_UDP2
    implements IGroupingMethod {
        protected GroupingMethod_UDP2() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYUDP2");
        }

        public Hashtable applyGrouping(Hashtable hashtable, GraphModel graphModel) {
            Hashtable<GraphGroupKey, Vector<GraphEntity>> hashtable2 = new Hashtable<GraphGroupKey, Vector<GraphEntity>>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration.nextElement();
                Vector vector = (Vector)hashtable.get(graphGroupKey);
                int n = 0;
                while (n < vector.size()) {
                    GraphEntity graphEntity = (GraphEntity)vector.elementAt(n);
                    String string = graphEntity.getUDP2();
                    if (string == null) {
                        string = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
                    }
                    GraphGroupKey graphGroupKey2 = new GraphGroupKey(graphGroupKey);
                    graphGroupKey2.addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)string)));
                    Vector<GraphEntity> vector2 = (Vector<GraphEntity>)hashtable2.get(graphGroupKey2);
                    if (vector2 == null) {
                        vector2 = new Vector<GraphEntity>();
                        hashtable2.put(graphGroupKey2, vector2);
                    }
                    vector2.add(graphEntity);
                    ++n;
                }
            }
            return hashtable2;
        }
    }

    protected static class GroupingMethod_UDP3
    implements IGroupingMethod {
        protected GroupingMethod_UDP3() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYUDP3");
        }

        public Hashtable applyGrouping(Hashtable hashtable, GraphModel graphModel) {
            Hashtable<GraphGroupKey, Vector<GraphEntity>> hashtable2 = new Hashtable<GraphGroupKey, Vector<GraphEntity>>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration.nextElement();
                Vector vector = (Vector)hashtable.get(graphGroupKey);
                int n = 0;
                while (n < vector.size()) {
                    GraphEntity graphEntity = (GraphEntity)vector.elementAt(n);
                    String string = graphEntity.getUDP3();
                    if (string == null) {
                        string = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
                    }
                    GraphGroupKey graphGroupKey2 = new GraphGroupKey(graphGroupKey);
                    graphGroupKey2.addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)string)));
                    Vector<GraphEntity> vector2 = (Vector<GraphEntity>)hashtable2.get(graphGroupKey2);
                    if (vector2 == null) {
                        vector2 = new Vector<GraphEntity>();
                        hashtable2.put(graphGroupKey2, vector2);
                    }
                    vector2.add(graphEntity);
                    ++n;
                }
            }
            return hashtable2;
        }
    }

    protected static class GroupingMethod_VolumeByPool
    implements IGroupingMethod {
        protected GroupingMethod_VolumeByPool() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYPOOL");
        }

        public Hashtable applyGrouping(Hashtable hashtable, GraphModel graphModel) {
            Hashtable<Comparable, Serializable> hashtable2 = new Hashtable<Comparable, Serializable>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                GraphEntity graphEntity;
                Object object;
                Serializable serializable;
                Object object2;
                Comparable comparable;
                Object object3;
                GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration.nextElement();
                Vector vector = (Vector)hashtable.get(graphGroupKey);
                Hashtable<GraphVolume.ID, Object> hashtable3 = new Hashtable<GraphVolume.ID, Object>();
                int n = 0;
                while (n < vector.size()) {
                    object3 = (GraphVolume)vector.elementAt(n);
                    comparable = (GraphVolume.ID)((GraphEntity)object3).getEntityID();
                    hashtable3.put((GraphVolume.ID)comparable, object3);
                    ++n;
                }
                Hashtable hashtable4 = new Hashtable();
                object3 = graphModel.enumerate(GraphPool2Volume.TYPE);
                while (object3.hasMoreElements()) {
                    String string;
                    comparable = (GraphPool2Volume)object3.nextElement();
                    object2 = ((GraphPool2Volume)comparable).getVolumeID();
                    serializable = (GraphVolume)hashtable3.remove(object2);
                    if (serializable == null) continue;
                    object = ((GraphPool2Volume)comparable).getPoolID();
                    graphEntity = (GraphPool)hashtable4.get(object);
                    if (graphEntity == null) {
                        graphEntity = (GraphPool)graphModel.get((GraphEntity.ID)object);
                    }
                    if ((string = graphEntity.getDisplayName()) == null) {
                        string = ((GraphEntity.ID)object).toString();
                    }
                    GraphGroupKey graphGroupKey2 = new GraphGroupKey(graphGroupKey);
                    graphGroupKey2.addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)string)));
                    Vector<Serializable> vector2 = (Vector<Serializable>)hashtable2.get(graphGroupKey2);
                    if (vector2 == null) {
                        vector2 = new Vector<Serializable>();
                        hashtable2.put(graphGroupKey2, vector2);
                    }
                    vector2.add(serializable);
                }
                comparable = new GraphGroupKey(graphGroupKey);
                object2 = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
                ((GraphGroupKey)comparable).addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)object2));
                serializable = new Vector();
                object = hashtable3.elements();
                while (object.hasMoreElements()) {
                    graphEntity = (GraphVolume)object.nextElement();
                    ((Vector)serializable).add(graphEntity);
                }
                if (((Vector)serializable).size() <= 0) continue;
                hashtable2.put(comparable, serializable);
            }
            return hashtable2;
        }
    }

    protected static class GroupingMethod_VolumeBySubsystem
    implements IGroupingMethod {
        protected GroupingMethod_VolumeBySubsystem() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYSUBSYSTEM");
        }

        public Hashtable applyGrouping(Hashtable hashtable, GraphModel graphModel) {
            Hashtable<Comparable, Serializable> hashtable2 = new Hashtable<Comparable, Serializable>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                GraphEntity graphEntity;
                Object object;
                Serializable serializable;
                Object object2;
                Comparable comparable;
                Object object3;
                GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration.nextElement();
                Vector vector = (Vector)hashtable.get(graphGroupKey);
                Hashtable<GraphVolume.ID, Object> hashtable3 = new Hashtable<GraphVolume.ID, Object>();
                int n = 0;
                while (n < vector.size()) {
                    object3 = (GraphVolume)vector.elementAt(n);
                    comparable = (GraphVolume.ID)((GraphEntity)object3).getEntityID();
                    hashtable3.put((GraphVolume.ID)comparable, object3);
                    ++n;
                }
                Hashtable hashtable4 = new Hashtable();
                object3 = graphModel.enumerate(GraphSubsystem2Volume.TYPE);
                while (object3.hasMoreElements()) {
                    String string;
                    comparable = (GraphSubsystem2Volume)object3.nextElement();
                    object2 = ((GraphSubsystem2Volume)comparable).getVolumeID();
                    serializable = (GraphVolume)hashtable3.remove(object2);
                    if (serializable == null) continue;
                    object = ((GraphSubsystem2Volume)comparable).getSubsystemID();
                    graphEntity = (GraphSubsystem)hashtable4.get(object);
                    if (graphEntity == null) {
                        graphEntity = (GraphSubsystem)graphModel.get((GraphEntity.ID)object);
                    }
                    if ((string = graphEntity.getDisplayName()) == null) {
                        string = ((GraphEntity.ID)object).toString();
                    }
                    GraphGroupKey graphGroupKey2 = new GraphGroupKey(graphGroupKey);
                    GraphGroupKey.Key key = new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)string), string.toString());
                    if (Boolean.TRUE.equals(((GraphSubsystem)graphEntity).getIsSVC())) {
                        key.setJumping(graphEntity, TopoResource.ICON_SVC_16_SELECTED, TopoResource.ICON_SVC_16_UNSELECTED);
                    } else {
                        key.setJumping(graphEntity, TopoResource.ICON_SUBSYSTEM_16_SELECTED, TopoResource.ICON_SUBSYSTEM_16_UNSELECTED);
                    }
                    graphGroupKey2.addKey(key);
                    Vector<Serializable> vector2 = (Vector<Serializable>)hashtable2.get(graphGroupKey2);
                    if (vector2 == null) {
                        vector2 = new Vector<Serializable>();
                        hashtable2.put(graphGroupKey2, vector2);
                    }
                    vector2.add(serializable);
                }
                comparable = new GraphGroupKey(graphGroupKey);
                object2 = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
                ((GraphGroupKey)comparable).addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)object2));
                serializable = new Vector();
                object = hashtable3.elements();
                while (object.hasMoreElements()) {
                    graphEntity = (GraphVolume)object.nextElement();
                    ((Vector)serializable).add(graphEntity);
                }
                if (((Vector)serializable).size() <= 0) continue;
                hashtable2.put(comparable, serializable);
            }
            return hashtable2;
        }
    }

    protected static interface IGroupingMethod {
        public String getMethodName();

        public Hashtable applyGrouping(Hashtable var1, GraphModel var2);
    }
}

