/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.JTopoPrintable;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoPrint {
    protected AbstractJTopoCanvas canvas;
    protected PrinterJob prnJob;
    protected PageFormat pageFormat;
    protected JTopoPrintable page1;

    public JTopoPrint(AbstractJTopoCanvas abstractJTopoCanvas) {
        this.canvas = abstractJTopoCanvas;
        this.prnJob = PrinterJob.getPrinterJob();
        this.pageFormat = this.prnJob.defaultPage();
        Book book = new Book();
        this.prnJob.setPageable(book);
        AbstractJTopoCanvas.CanvasPanel canvasPanel = abstractJTopoCanvas.getCanvasPanel();
        this.page1 = new JTopoPrintable(canvasPanel);
        book.append(this.page1, this.pageFormat);
    }

    public void print() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    if (!JTopoPrint.this.prnJob.printDialog()) {
                        return;
                    }
                    JTopoPrint.this.canvas.setCursor(Cursor.getPredefinedCursor(3));
                    JTopoPrint.this.prnJob.print();
                    JTopoPrint.this.canvas.setCursor(Cursor.getPredefinedCursor(0));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        thread.start();
    }

    public void preview() {
        Frame frame = (Frame)SwingUtilities.windowForComponent(this.canvas);
        PreviewDialog previewDialog = new PreviewDialog(frame);
        previewDialog.show();
    }

    protected class PreviewDialog
    extends JDialog {
        protected JComboBox scaleCB;
        protected JPanel previewPageContainer;
        protected PreviewPage previewPage;

        public PreviewDialog(Frame frame) {
            super(frame, GuiUtil.getString("TOPO_LABEL_DIALOG_PRINTPREVIEW_TITLE"), true);
            this.setSize(TopoResource.DIMENSION_PRINTPREVIEW);
            this.setLocation((frame.getWidth() - this.getWidth()) / 2, (frame.getHeight() - this.getHeight()) / 2);
            JPanel jPanel = (JPanel)this.getContentPane();
            jPanel.setLayout(new BorderLayout());
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(0));
            jPanel.add((Component)jPanel2, "North");
            JButton jButton = new JButton(GuiUtil.getString("TOPO_LABEL_DIALOG_PRINTPREVIEW_PRINT"));
            jButton.addActionListener(new AL_Print());
            jPanel2.add(jButton);
            JButton jButton2 = new JButton(GuiUtil.getString("TOPO_LABEL_DIALOG_PRINTPREVIEW_CLOSE"));
            jButton2.addActionListener(new AL_Close());
            jPanel2.add(jButton2);
            JLabel jLabel = new JLabel("  " + GuiUtil.getString("TOPO_LABEL_DIALOG_PRINTPREVIEW_SCALE") + ":");
            jPanel2.add(jLabel);
            this.scaleCB = new JComboBox();
            this.scaleCB.addActionListener(new AL_Scale());
            jPanel2.add(this.scaleCB);
            JLabel jLabel2 = new JLabel(" %");
            jPanel2.add(jLabel2);
            JScrollPane jScrollPane = new JScrollPane();
            jPanel.add((Component)jScrollPane, "Center");
            this.previewPageContainer = new JPanel();
            jScrollPane.setViewportView(this.previewPageContainer);
            double d = 1.0;
            int n = (int)(JTopoPrint.this.pageFormat.getWidth() * d);
            int n2 = (int)(JTopoPrint.this.pageFormat.getHeight() * d);
            BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.setColor(TopoResource.COLOR_BACKGROUND);
            graphics.fillRect(0, 0, n, n2);
            try {
                JTopoPrint.this.page1.print(graphics, JTopoPrint.this.pageFormat, 0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.previewPage = new PreviewPage(bufferedImage, d);
            this.previewPageContainer.add(this.previewPage);
            this.scaleCB.addItem("25");
            this.scaleCB.addItem("50");
            this.scaleCB.addItem("100");
            this.scaleCB.addItem("150");
            this.scaleCB.addItem("200");
            this.scaleCB.addItem("400");
            this.scaleCB.setSelectedIndex(1);
            this.setDefaultCloseOperation(2);
        }

        protected double getScale() {
            String string = (String)this.scaleCB.getSelectedItem();
            if (string == null) {
                return -1.0;
            }
            return (double)Integer.parseInt(string) / 100.0;
        }

        protected class AL_Close
        implements ActionListener {
            protected AL_Close() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewDialog.this.dispose();
            }
        }

        protected class AL_Print
        implements ActionListener {
            protected AL_Print() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JTopoPrint.this.print();
                PreviewDialog.this.dispose();
            }
        }

        protected class AL_Scale
        implements ActionListener {
            protected AL_Scale() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (PreviewDialog.this.previewPage == null) {
                    return;
                }
                double d = PreviewDialog.this.getScale();
                PreviewDialog.this.previewPage.setScale(d);
                PreviewDialog.this.previewPageContainer.revalidate();
                PreviewDialog.this.previewPageContainer.repaint();
            }
        }

        protected class PreviewPage
        extends JPanel {
            protected Image original;
            protected Image scaled;
            protected double scale;

            public PreviewPage(Image image, double d) {
                this.original = image;
                this.setScale(d);
                this.setBorder(LineBorder.createGrayLineBorder());
            }

            public void setScale(double d) {
                this.scale = d;
                int n = (int)((double)this.original.getWidth(null) * d);
                int n2 = (int)((double)this.original.getHeight(null) * d);
                this.scaled = this.original.getScaledInstance(n, n2, 4);
            }

            public Dimension getPreferredSize() {
                Dimension dimension = new Dimension(0, 0);
                Insets insets = this.getInsets();
                dimension.width += insets.left + insets.right;
                dimension.height += insets.top + insets.bottom;
                dimension.width += this.scaled.getWidth(this);
                dimension.height += this.scaled.getHeight(this);
                return dimension;
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            protected void paintComponent(Graphics graphics) {
                Insets insets = this.getInsets();
                graphics.drawImage(this.scaled, insets.left, insets.top, this);
            }
        }
    }
}

