/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Null;

public class DBQueryAssistant {
    private static boolean debug = false;
    private static final String DELIMITER = "'";

    private DBQueryAssistant() {
    }

    public static void processBoolean(ColumnInfo columnInfo, Hashtable hashtable) {
        String string = (String)hashtable.get(columnInfo);
        if (string != null) {
            if (string.equalsIgnoreCase("true")) {
                hashtable.put(columnInfo, "1");
            } else if (string.equalsIgnoreCase("false")) {
                hashtable.put(columnInfo, "0");
            }
        }
    }

    public static void closeResultSet(DBResultSet dBResultSet) throws SQLException {
        dBResultSet.closeAll();
    }

    private static String buildWhereClause(Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        TreeMap treeMap = new TreeMap(hashtable);
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            ColumnInfo columnInfo = (ColumnInfo)iterator.next();
            stringBuffer.append(DBQueryAssistant.transformReservedNameIfNeeded(columnInfo.getName()));
            if (hashtable.get(columnInfo).getClass() != Null.class) {
                if (columnInfo.getOperator() != null) {
                    stringBuffer.append(columnInfo.getOperator());
                } else {
                    stringBuffer.append("=");
                }
                stringBuffer.append("?");
            } else {
                stringBuffer.append(" IS NULL");
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" AND ");
        }
        return stringBuffer.toString();
    }

    private static boolean insert(DBPreparedStatement dBPreparedStatement, Hashtable hashtable) throws SQLException {
        if (dBPreparedStatement == null) {
            throw new SQLException("Error - prepared statemetn is null");
        }
        if (hashtable == null) {
            throw new SQLException("Error - data input is null");
        }
        TreeMap treeMap = new TreeMap(hashtable);
        Iterator iterator = treeMap.keySet().iterator();
        int n = 1;
        while (iterator.hasNext()) {
            ColumnInfo columnInfo = (ColumnInfo)iterator.next();
            DBQueryAssistant.setPreparedStatementParameter(dBPreparedStatement, columnInfo, n, hashtable);
            ++n;
        }
        int n2 = dBPreparedStatement.executeUpdate();
        return n2 == 1;
    }

    private static int update(DBPreparedStatement dBPreparedStatement, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBPreparedStatement == null) {
            throw new SQLException("Error - statement is null");
        }
        if (hashtable == null) {
            throw new SQLException("Error - column/value hashtable is null");
        }
        if (hashtable2 == null) {
            throw new SQLException("Error - where clause hashtable is null");
        }
        ColumnInfo columnInfo2 = null;
        TreeMap treeMap = new TreeMap(hashtable);
        Iterator iterator = treeMap.keySet().iterator();
        int n = 1;
        while (iterator.hasNext()) {
            columnInfo2 = (ColumnInfo)iterator.next();
            DBQueryAssistant.setPreparedStatementParameter(dBPreparedStatement, columnInfo2, n, hashtable);
            ++n;
        }
        treeMap = null;
        iterator = null;
        treeMap = new TreeMap(hashtable2);
        for (ColumnInfo columnInfo2 : treeMap.keySet()) {
            DBQueryAssistant.setPreparedStatementParameter(dBPreparedStatement, columnInfo2, n, hashtable2);
            ++n;
        }
        treeMap = null;
        iterator = null;
        int n2 = dBPreparedStatement.executeUpdate();
        return n2;
    }

    private static DBResultSet query(DBPreparedStatement dBPreparedStatement, Hashtable hashtable) throws SQLException {
        DBResultSet dBResultSet = null;
        if (dBPreparedStatement == null) {
            throw new SQLException("Error - prepared statement is null");
        }
        if (hashtable != null) {
            TreeMap treeMap = new TreeMap(hashtable);
            Iterator iterator = treeMap.keySet().iterator();
            ColumnInfo columnInfo = null;
            int n = 1;
            while (iterator.hasNext()) {
                columnInfo = (ColumnInfo)iterator.next();
                if (hashtable.get(columnInfo).getClass() == Null.class) continue;
                DBQueryAssistant.setPreparedStatementParameter(dBPreparedStatement, columnInfo, n, hashtable);
                ++n;
            }
        }
        dBResultSet = dBPreparedStatement.executeQuery();
        return dBResultSet;
    }

    private static int delete(DBPreparedStatement dBPreparedStatement, Hashtable hashtable) throws SQLException {
        if (dBPreparedStatement == null) {
            throw new SQLException("Error - prepared statemetn is null");
        }
        if (hashtable != null) {
            TreeMap treeMap = new TreeMap(hashtable);
            Iterator iterator = treeMap.keySet().iterator();
            int n = 1;
            while (iterator.hasNext()) {
                ColumnInfo columnInfo = (ColumnInfo)iterator.next();
                DBQueryAssistant.setPreparedStatementParameter(dBPreparedStatement, columnInfo, n, hashtable);
                ++n;
            }
        }
        int n = dBPreparedStatement.executeUpdate();
        return n;
    }

    private static String buildQueryPreparedStatement(String string, DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        if (string == null) {
            throw new SQLException("Error - table name is null");
        }
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        if (vector == null) {
            stringBuffer.append("* FROM ");
        } else {
            int n = 0;
            while (n < vector.size()) {
                stringBuffer.append(vector.elementAt(n));
                if (n < vector.size() - 1) {
                    stringBuffer.append(",");
                }
                ++n;
            }
            stringBuffer.append(" FROM ");
        }
        stringBuffer.append(string);
        if (hashtable != null) {
            stringBuffer.append(" WHERE ");
            String string2 = DBQueryAssistant.buildWhereClause(hashtable);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private static String buildInsertPreparedStatement(String string, DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (string == null) {
            throw new SQLException("Invalid call - null table name");
        }
        if (hashtable == null) {
            throw new SQLException("Invalid call - null column/value hashtable");
        }
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
        StringBuffer stringBuffer2 = new StringBuffer(" VALUES (");
        stringBuffer.append(string);
        stringBuffer.append(" (");
        TreeMap treeMap = new TreeMap(hashtable);
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            ColumnInfo columnInfo = (ColumnInfo)iterator.next();
            stringBuffer.append(DBQueryAssistant.transformReservedNameIfNeeded(columnInfo.getName()));
            stringBuffer2.append("?");
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
            stringBuffer2.append(",");
        }
        stringBuffer.append(")");
        stringBuffer2.append(")");
        return stringBuffer.append(stringBuffer2).toString();
    }

    private static String buildUpdatePreparedStatement(String string, DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        ColumnInfo columnInfo;
        if (string == null) {
            throw new SQLException("Error - table name is null");
        }
        if (hashtable == null) {
            throw new SQLException("Error - column/value hashtable name is null");
        }
        if (hashtable2 == null) {
            throw new SQLException("Error - where clause hashtable name is null");
        }
        StringBuffer stringBuffer = new StringBuffer("UPDATE ");
        StringBuffer stringBuffer2 = new StringBuffer("WHERE ");
        stringBuffer.append(string);
        stringBuffer.append(" SET ");
        TreeMap treeMap = new TreeMap(hashtable2);
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            columnInfo = (ColumnInfo)iterator.next();
            stringBuffer2.append(DBQueryAssistant.transformReservedNameIfNeeded(columnInfo.getName()));
            if (columnInfo.getOperator() != null) {
                stringBuffer2.append(columnInfo.getOperator());
            } else {
                stringBuffer2.append("=");
            }
            stringBuffer2.append("? ");
            if (!iterator.hasNext()) continue;
            stringBuffer2.append("AND ");
        }
        treeMap = null;
        iterator = null;
        columnInfo = null;
        treeMap = new TreeMap(hashtable);
        iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            columnInfo = (ColumnInfo)iterator.next();
            stringBuffer.append(DBQueryAssistant.transformReservedNameIfNeeded(columnInfo.getName()));
            stringBuffer.append(" = ?");
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(" ");
        return stringBuffer.append(stringBuffer2).toString();
    }

    private static String buildDeletePreparedStatement(String string, DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (string == null) {
            throw new SQLException("Error -table name is null");
        }
        ColumnInfo columnInfo = null;
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM ");
        StringBuffer stringBuffer2 = null;
        stringBuffer.append(string);
        if (hashtable != null) {
            stringBuffer2 = new StringBuffer(" WHERE ");
            TreeMap treeMap = new TreeMap(hashtable);
            Iterator iterator = treeMap.keySet().iterator();
            while (iterator.hasNext()) {
                columnInfo = (ColumnInfo)iterator.next();
                stringBuffer2.append(DBQueryAssistant.transformReservedNameIfNeeded(columnInfo.getName()));
                if (columnInfo.getOperator() != null) {
                    stringBuffer2.append(columnInfo.getOperator());
                } else {
                    stringBuffer2.append("=");
                }
                stringBuffer2.append("?");
                if (!iterator.hasNext()) continue;
                stringBuffer2.append(" AND ");
            }
        }
        String string2 = stringBuffer2 == null ? stringBuffer.toString() : stringBuffer.append(stringBuffer2).toString();
        return string2;
    }

    public static void setPreparedStatementParameter(DBPreparedStatement dBPreparedStatement, ColumnInfo columnInfo, int n, Hashtable hashtable) throws SQLException {
        if (hashtable.get(columnInfo).getClass() != Null.class) {
            try {
                switch (columnInfo.getDataType()) {
                    case -1: 
                    case 1: 
                    case 12: {
                        String string = (String)hashtable.get(columnInfo);
                        dBPreparedStatement.setString(n, string);
                    }
                    case 2005: {
                        Clob clob = (Clob)hashtable.get(columnInfo);
                        dBPreparedStatement.setClob(n, clob);
                    }
                    case 3: {
                        Object v = hashtable.get(columnInfo);
                        BigDecimal bigDecimal = DBConstants.INVALID_BIGDECIMAL_VALUE;
                        if (v instanceof Float) {
                            bigDecimal = (BigDecimal)v;
                        } else if (v instanceof String) {
                            bigDecimal = new BigDecimal((String)v);
                        } else {
                            throw new SQLException("Error - unable to conver " + v.getClass() + " to a Java bigdecimal");
                        }
                        dBPreparedStatement.setBigDecimal(n, bigDecimal);
                    }
                    case 8: {
                        Object v = hashtable.get(columnInfo);
                        double d = Double.MIN_VALUE;
                        if (v instanceof Double) {
                            d = (Double)v;
                        } else if (v instanceof String) {
                            d = Double.parseDouble((String)v);
                        } else {
                            throw new SQLException("Error - unable to conver " + v.getClass() + " to a Java double");
                        }
                        dBPreparedStatement.setDouble(n, d);
                    }
                    case 6: 
                    case 7: {
                        Object v = hashtable.get(columnInfo);
                        float f = Float.MIN_VALUE;
                        if (v instanceof Float) {
                            f = ((Float)v).floatValue();
                        } else if (v instanceof String) {
                            f = Float.parseFloat((String)v);
                        } else {
                            throw new SQLException("Error - unable to conver " + v.getClass() + " to a Java float");
                        }
                        dBPreparedStatement.setFloat(n, f);
                    }
                    case 4: {
                        Object v = hashtable.get(columnInfo);
                        int n2 = Integer.MIN_VALUE;
                        if (v instanceof Integer) {
                            n2 = (Integer)v;
                        } else if (v instanceof String) {
                            n2 = Integer.parseInt((String)v);
                        } else {
                            throw new SQLException("Error - unable to conver " + v.getClass() + " to a Java int");
                        }
                        dBPreparedStatement.setInt(n, n2);
                    }
                    case 2: {
                        throw new SQLException("Error - Unsupported type - NUMERIC");
                    }
                    case 5: {
                        Object v = hashtable.get(columnInfo);
                        int n3 = Short.MIN_VALUE;
                        if (v instanceof Short) {
                            n3 = ((Short)v).shortValue();
                        } else if (v instanceof String) {
                            n3 = Short.parseShort((String)v);
                        } else {
                            throw new SQLException("Error - unable to conver " + v.getClass() + " to a Java short");
                        }
                        dBPreparedStatement.setInt(n, n3);
                    }
                    case 16: {
                        String string = (String)hashtable.get(columnInfo);
                        short s = string.equalsIgnoreCase("true") ? (short)1 : 0;
                        dBPreparedStatement.setShort(n, s);
                    }
                    case -6: {
                        throw new SQLException("Error - Unsupported type - TINYINT");
                    }
                    case 93: {
                        Object v = hashtable.get(columnInfo);
                        Timestamp timestamp = DBConstants.INVALID_TIMESTAMP_VALUE;
                        if (v instanceof Timestamp) {
                            timestamp = (Timestamp)v;
                        } else if (v instanceof String) {
                            timestamp = Timestamp.valueOf((String)v);
                        } else {
                            throw new SQLException("Error - unable to conver " + v.getClass() + " to a Java timestamp");
                        }
                        dBPreparedStatement.setTimestamp(n, timestamp);
                    }
                    case 2003: {
                        throw new SQLException("Error - Unsupported type - ARRAY");
                    }
                    case 2004: {
                        throw new SQLException("Error - Unsupported type - BLOB");
                    }
                    case -7: {
                        throw new SQLException("Error - Unsupported type - BIT");
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        byte[] byArray = ((String)hashtable.get(columnInfo)).getBytes();
                        dBPreparedStatement.setByteArray(n, byArray);
                    }
                    case 70: {
                        throw new SQLException("Error - Unsupported type - DATALINK");
                    }
                    case 91: {
                        Date date = (Date)hashtable.get(columnInfo);
                        dBPreparedStatement.setDate(n, date);
                    }
                    case 92: {
                        Time time = (Time)hashtable.get(columnInfo);
                        dBPreparedStatement.setTime(n, time);
                    }
                    case -5: {
                        Object v = hashtable.get(columnInfo);
                        long l = Long.MIN_VALUE;
                        if (v instanceof BigInteger) {
                            l = ((BigInteger)v).longValue();
                        } else if (v instanceof Long) {
                            l = (Long)v;
                        } else if (v instanceof String) {
                            l = Long.parseLong((String)v);
                        } else {
                            throw new SQLException("Error - unable to conver " + v.getClass() + " to a Java long");
                        }
                        dBPreparedStatement.setLong(n, l);
                    }
                    default: {
                        throw new SQLException("Error - Unknown type encountered - " + columnInfo.getDataType());
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                String string = "Number Format exception on " + hashtable.get(columnInfo) + " and field " + columnInfo.getName();
                System.out.println(string);
                throw new SQLException(string);
            }
        } else {
            dBPreparedStatement.setNull(n, columnInfo.getDataType());
        }
    }

    public static boolean performInsert(String string, DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        boolean bl = false;
        String string2 = DBQueryAssistant.buildInsertPreparedStatement(string, dBConnection, hashtable);
        DBPreparedStatement dBPreparedStatement = null;
        try {
            dBPreparedStatement = dBConnection.prepareStatement(string2);
            bl = DBQueryAssistant.insert(dBPreparedStatement, hashtable);
        }
        catch (Throwable throwable) {
            if (dBPreparedStatement != null) {
                try {
                    dBPreparedStatement.close();
                }
                catch (Exception exception) {}
                dBPreparedStatement = null;
            }
            throw throwable;
        }
        if (dBPreparedStatement != null) {
            try {
                dBPreparedStatement.close();
            }
            catch (Exception exception) {}
            dBPreparedStatement = null;
        }
        return bl;
    }

    public static int performUpdate(String string, DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        String string2 = DBQueryAssistant.buildUpdatePreparedStatement(string, dBConnection, hashtable, hashtable2);
        int n = 0;
        DBPreparedStatement dBPreparedStatement = null;
        try {
            dBPreparedStatement = dBConnection.prepareStatement(string2);
            n = DBQueryAssistant.update(dBPreparedStatement, hashtable, hashtable2);
        }
        catch (Throwable throwable) {
            if (dBPreparedStatement != null) {
                try {
                    dBPreparedStatement.close();
                }
                catch (Exception exception) {}
                dBPreparedStatement = null;
            }
            throw throwable;
        }
        if (dBPreparedStatement != null) {
            try {
                dBPreparedStatement.close();
            }
            catch (Exception exception) {}
            dBPreparedStatement = null;
        }
        return n;
    }

    public static DBResultSet performRetrieve(String string, DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        DBResultSet dBResultSet = null;
        String string2 = DBQueryAssistant.buildQueryPreparedStatement(string, dBConnection, hashtable, vector);
        DBPreparedStatement dBPreparedStatement = dBConnection.prepareStatement(string2);
        dBResultSet = DBQueryAssistant.query(dBPreparedStatement, hashtable);
        return dBResultSet;
    }

    public static int performDelete(String string, DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (string == null) {
            throw new SQLException("ERRROR - table name is null");
        }
        if (dBConnection == null) {
            throw new SQLException("ERRROR - DBConnection is null");
        }
        int n = 0;
        String string2 = null;
        DBPreparedStatement dBPreparedStatement = null;
        string2 = DBQueryAssistant.buildDeletePreparedStatement(string, dBConnection, hashtable);
        try {
            dBPreparedStatement = dBConnection.prepareStatement(string2);
            n = DBQueryAssistant.delete(dBPreparedStatement, hashtable);
        }
        catch (Throwable throwable) {
            if (dBPreparedStatement != null) {
                try {
                    dBPreparedStatement.close();
                }
                catch (Exception exception) {}
                dBPreparedStatement = null;
            }
            throw throwable;
        }
        if (dBPreparedStatement != null) {
            try {
                dBPreparedStatement.close();
            }
            catch (Exception exception) {}
            dBPreparedStatement = null;
        }
        return n;
    }

    private static String transformReservedNameIfNeeded(String string) {
        if (string.equalsIgnoreCase("partition")) {
            return "\"partition\"";
        }
        return string;
    }
}

