/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResAuthRolesTable;

public class AuthRoles
extends TResAuthRolesTable {
    public static AuthRolesCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new AuthRolesCursor(dBConnection, hashtable, vector);
    }

    public AuthRoles() {
        this.clear();
    }

    public AuthRoles(int n, String string, String string2, short s) {
        this.clear();
        this.m_RoleId = n;
        this.m_RoleName = string;
        this.m_GroupName = string2;
        this.m_GroupType = s;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_RoleName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(AuthRoles.getColumnInfo("ROLE_NAME"), this.m_RoleName);
        }
        if (this.m_GroupName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(AuthRoles.getColumnInfo("GROUP_NAME"), this.m_GroupName);
        }
        if (this.m_GroupType != Short.MIN_VALUE) {
            hashtable.put(AuthRoles.getColumnInfo("GROUP_TYPE"), String.valueOf(this.m_GroupType));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_RoleId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key ROLE_ID not found");
        }
        this.htColsAndValues.put(AuthRoles.getColumnInfo("ROLE_ID"), String.valueOf(this.m_RoleId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_AUTH_ROLES", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(AuthRoles.getColumnInfo("ROLE_ID")) == null) {
            throw new SQLException(" ERROR: key ROLE_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_AUTH_ROLES", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_RoleId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key ROLE_ID not found");
        }
        this.htWhereClause.put(AuthRoles.getColumnInfo("ROLE_ID"), String.valueOf(this.m_RoleId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_AUTH_ROLES", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(AuthRoles.getColumnInfo("ROLE_ID")) == null) {
            throw new SQLException(" ERROR: key ROLE_ID not found");
        }
        this.htWhereClause.put(AuthRoles.getColumnInfo("ROLE_ID"), hashtable.get(AuthRoles.getColumnInfo("ROLE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_AUTH_ROLES", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_RoleId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key ROLE_ID not found");
        }
        this.htWhereClause.put(AuthRoles.getColumnInfo("ROLE_ID"), String.valueOf(this.m_RoleId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_AUTH_ROLES", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(AuthRoles.getColumnInfo("ROLE_ID")) == null) {
            throw new SQLException(" ERROR: key ROLE_ID not found");
        }
        this.htWhereClause.put(AuthRoles.getColumnInfo("ROLE_ID"), hashtable.get(AuthRoles.getColumnInfo("ROLE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_AUTH_ROLES", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_RoleId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key ROLE_ID not found");
        }
        this.htWhereClause.put(AuthRoles.getColumnInfo("ROLE_ID"), String.valueOf(this.m_RoleId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_AUTH_ROLES", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static AuthRoles retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        AuthRoles authRoles = null;
        if (hashtable.get(AuthRoles.getColumnInfo("ROLE_ID")) == null) {
            throw new SQLException(" ERROR: key ROLE_ID not found");
        }
        hashtable2.put(AuthRoles.getColumnInfo("ROLE_ID"), hashtable.get(AuthRoles.getColumnInfo("ROLE_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_AUTH_ROLES", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                authRoles = new AuthRoles();
                authRoles.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return authRoles;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_AUTH_ROLES", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_AUTH_ROLES", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setRoleId(dBResultSet.getInt("ROLE_ID"));
        this.setRoleName(dBResultSet.getString("ROLE_NAME"));
        this.setGroupName(dBResultSet.getString("GROUP_NAME"));
        this.setGroupType(dBResultSet.getShort("GROUP_TYPE"));
    }

    public static class AuthRolesCursor
    extends DBCursor {
        private AuthRoles element = new AuthRoles();
        private DBConnection con;

        public AuthRolesCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_AUTH_ROLES", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public AuthRoles getObject() throws SQLException {
            AuthRoles authRoles = null;
            if (this.DBrs != null) {
                authRoles = new AuthRoles();
                authRoles.setFields(this.con, this.DBrs);
            }
            return authRoles;
        }

        public AuthRoles getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

