/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TStatCompHistTable;

public class CompHist
extends TStatCompHistTable {
    public static CompHistCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new CompHistCursor(dBConnection, hashtable, vector);
    }

    public CompHist() {
        this.clear();
    }

    public CompHist(int n, String string, Timestamp timestamp, Timestamp timestamp2, int n2, int n3) {
        this.clear();
        this.m_ComputerId = n;
        this.m_StatisticType = string;
        this.m_MonitorStart = timestamp;
        this.m_MonitorEnd = timestamp2;
        this.m_PowerCycles = n2;
        this.m_DownTime = n3;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_ComputerId != Integer.MIN_VALUE) {
            hashtable.put(CompHist.getColumnInfo("COMPUTER_ID"), String.valueOf(this.m_ComputerId));
        }
        if (this.m_StatisticType != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(CompHist.getColumnInfo("STATISTIC_TYPE"), this.m_StatisticType);
        }
        if (this.m_MonitorStart != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(CompHist.getColumnInfo("MONITOR_START"), this.m_MonitorStart);
        }
        if (this.m_MonitorEnd != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(CompHist.getColumnInfo("MONITOR_END"), this.m_MonitorEnd);
        }
        if (this.m_PowerCycles != Integer.MIN_VALUE) {
            hashtable.put(CompHist.getColumnInfo("POWER_CYCLES"), String.valueOf(this.m_PowerCycles));
        }
        if (this.m_DownTime != Integer.MIN_VALUE) {
            hashtable.put(CompHist.getColumnInfo("DOWN_TIME"), String.valueOf(this.m_DownTime));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_STAT_COMP_HIST", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_STAT_COMP_HIST", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_STAT_COMP_HIST", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_STAT_COMP_HIST", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_STAT_COMP_HIST", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_STAT_COMP_HIST", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_STAT_COMP_HIST", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static CompHist retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        CompHist compHist = null;
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_STAT_COMP_HIST", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                compHist = new CompHist();
                compHist.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return compHist;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_STAT_COMP_HIST", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_STAT_COMP_HIST", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setComputerId(dBResultSet.getInt("COMPUTER_ID"));
        this.setStatisticType(dBResultSet.getString("STATISTIC_TYPE"));
        this.setMonitorStart(dBResultSet.getTimestamp("MONITOR_START"));
        this.setMonitorEnd(dBResultSet.getTimestamp("MONITOR_END"));
        this.setPowerCycles(dBResultSet.getInt("POWER_CYCLES"));
        this.setDownTime(dBResultSet.getInt("DOWN_TIME"));
    }

    public static class CompHistCursor
    extends DBCursor {
        private CompHist element = new CompHist();
        private DBConnection con;

        public CompHistCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_STAT_COMP_HIST", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public CompHist getObject() throws SQLException {
            CompHist compHist = null;
            if (this.DBrs != null) {
                compHist = new CompHist();
                compHist.setFields(this.con, this.DBrs);
            }
            return compHist;
        }

        public CompHist getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

