/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResPe2nodeTable;

public class Pe2node
extends TResPe2nodeTable {
    public static Pe2nodeCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new Pe2nodeCursor(dBConnection, hashtable, vector);
    }

    public Pe2node() {
        this.clear();
    }

    public Pe2node(int n, int n2, int n3, Timestamp timestamp, short s) {
        this.clear();
        this.m_Pe2nodeId = n;
        this.m_PhyPeId = n2;
        this.m_NodeId = n3;
        this.m_UpdateTimestamp = timestamp;
        this.m_Detectable = s;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_Pe2nodeId != Integer.MIN_VALUE) {
            hashtable.put(Pe2node.getColumnInfo("PE2NODE_ID"), String.valueOf(this.m_Pe2nodeId));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(Pe2node.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            hashtable.put(Pe2node.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_PhyPeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key PHY_PE_ID not found");
        }
        this.htColsAndValues.put(Pe2node.getColumnInfo("PHY_PE_ID"), String.valueOf(this.m_PhyPeId));
        if (this.m_NodeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key NODE_ID not found");
        }
        this.htColsAndValues.put(Pe2node.getColumnInfo("NODE_ID"), String.valueOf(this.m_NodeId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_PE2NODE", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(Pe2node.getColumnInfo("PHY_PE_ID")) == null) {
            throw new SQLException(" ERROR: key PHY_PE_ID not found");
        }
        if (hashtable.get(Pe2node.getColumnInfo("NODE_ID")) == null) {
            throw new SQLException(" ERROR: key NODE_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_PE2NODE", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_PhyPeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key PHY_PE_ID not found");
        }
        this.htWhereClause.put(Pe2node.getColumnInfo("PHY_PE_ID"), String.valueOf(this.m_PhyPeId));
        if (this.m_NodeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key NODE_ID not found");
        }
        this.htWhereClause.put(Pe2node.getColumnInfo("NODE_ID"), String.valueOf(this.m_NodeId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_PE2NODE", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Pe2node.getColumnInfo("PHY_PE_ID")) == null) {
            throw new SQLException(" ERROR: key PHY_PE_ID not found");
        }
        this.htWhereClause.put(Pe2node.getColumnInfo("PHY_PE_ID"), hashtable.get(Pe2node.getColumnInfo("PHY_PE_ID")));
        if (hashtable.get(Pe2node.getColumnInfo("NODE_ID")) == null) {
            throw new SQLException(" ERROR: key NODE_ID not found");
        }
        this.htWhereClause.put(Pe2node.getColumnInfo("NODE_ID"), hashtable.get(Pe2node.getColumnInfo("NODE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_PE2NODE", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_PhyPeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key PHY_PE_ID not found");
        }
        this.htWhereClause.put(Pe2node.getColumnInfo("PHY_PE_ID"), String.valueOf(this.m_PhyPeId));
        if (this.m_NodeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key NODE_ID not found");
        }
        this.htWhereClause.put(Pe2node.getColumnInfo("NODE_ID"), String.valueOf(this.m_NodeId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_PE2NODE", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Pe2node.getColumnInfo("PHY_PE_ID")) == null) {
            throw new SQLException(" ERROR: key PHY_PE_ID not found");
        }
        this.htWhereClause.put(Pe2node.getColumnInfo("PHY_PE_ID"), hashtable.get(Pe2node.getColumnInfo("PHY_PE_ID")));
        if (hashtable.get(Pe2node.getColumnInfo("NODE_ID")) == null) {
            throw new SQLException(" ERROR: key NODE_ID not found");
        }
        this.htWhereClause.put(Pe2node.getColumnInfo("NODE_ID"), hashtable.get(Pe2node.getColumnInfo("NODE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_PE2NODE", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_PhyPeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key PHY_PE_ID not found");
        }
        this.htWhereClause.put(Pe2node.getColumnInfo("PHY_PE_ID"), String.valueOf(this.m_PhyPeId));
        if (this.m_NodeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key NODE_ID not found");
        }
        this.htWhereClause.put(Pe2node.getColumnInfo("NODE_ID"), String.valueOf(this.m_NodeId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_PE2NODE", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static Pe2node retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        Pe2node pe2node = null;
        if (hashtable.get(Pe2node.getColumnInfo("PHY_PE_ID")) == null) {
            throw new SQLException(" ERROR: key PHY_PE_ID not found");
        }
        hashtable2.put(Pe2node.getColumnInfo("PHY_PE_ID"), hashtable.get(Pe2node.getColumnInfo("PHY_PE_ID")));
        if (hashtable.get(Pe2node.getColumnInfo("NODE_ID")) == null) {
            throw new SQLException(" ERROR: key NODE_ID not found");
        }
        hashtable2.put(Pe2node.getColumnInfo("NODE_ID"), hashtable.get(Pe2node.getColumnInfo("NODE_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_PE2NODE", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                pe2node = new Pe2node();
                pe2node.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return pe2node;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_PE2NODE", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_PE2NODE", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setPe2nodeId(dBResultSet.getInt("PE2NODE_ID"));
        this.setPhyPeId(dBResultSet.getInt("PHY_PE_ID"));
        this.setNodeId(dBResultSet.getInt("NODE_ID"));
        this.setUpdateTimestamp(dBResultSet.getTimestamp("UPDATE_TIMESTAMP"));
        this.setDetectable(dBResultSet.getShort("DETECTABLE"));
    }

    public static class Pe2nodeCursor
    extends DBCursor {
        private Pe2node element = new Pe2node();
        private DBConnection con;

        public Pe2nodeCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_PE2NODE", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public Pe2node getObject() throws SQLException {
            Pe2node pe2node = null;
            if (this.DBrs != null) {
                pe2node = new Pe2node();
                pe2node.setFields(this.con, this.DBrs);
            }
            return pe2node;
        }

        public Pe2node getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

