/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResSnapshotMetadataTable;

public class SnapshotMetadata
extends TResSnapshotMetadataTable {
    public static SnapshotMetadataCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new SnapshotMetadataCursor(dBConnection, hashtable, vector);
    }

    public SnapshotMetadata() {
        this.clear();
    }

    public SnapshotMetadata(int n, Timestamp timestamp, int n2, short s, short s2, short s3) {
        this.clear();
        this.m_SnapshotId = n;
        this.m_SnapshotTime = timestamp;
        this.m_SystemId = n2;
        this.m_SystemType = s;
        this.m_SnapshotConsistent = s2;
        this.m_SnapshotType = s3;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_SnapshotTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(SnapshotMetadata.getColumnInfo("SNAPSHOT_TIME"), this.m_SnapshotTime);
        }
        if (this.m_SystemId != Integer.MIN_VALUE) {
            hashtable.put(SnapshotMetadata.getColumnInfo("SYSTEM_ID"), String.valueOf(this.m_SystemId));
        }
        if (this.m_SystemType != Short.MIN_VALUE) {
            hashtable.put(SnapshotMetadata.getColumnInfo("SYSTEM_TYPE"), String.valueOf(this.m_SystemType));
        }
        if (this.m_SnapshotConsistent != Short.MIN_VALUE) {
            hashtable.put(SnapshotMetadata.getColumnInfo("SNAPSHOT_CONSISTENT"), String.valueOf(this.m_SnapshotConsistent));
        }
        if (this.m_SnapshotType != Short.MIN_VALUE) {
            hashtable.put(SnapshotMetadata.getColumnInfo("SNAPSHOT_TYPE"), String.valueOf(this.m_SnapshotType));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htColsAndValues.put(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_SNAPSHOT_METADATA", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_SNAPSHOT_METADATA", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SNAPSHOT_METADATA", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID"), hashtable.get(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SNAPSHOT_METADATA", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SNAPSHOT_METADATA", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID"), hashtable.get(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SNAPSHOT_METADATA", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_SNAPSHOT_METADATA", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static SnapshotMetadata retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        SnapshotMetadata snapshotMetadata = null;
        if (hashtable.get(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        hashtable2.put(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID"), hashtable.get(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_SNAPSHOT_METADATA", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                snapshotMetadata = new SnapshotMetadata();
                snapshotMetadata.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return snapshotMetadata;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_SNAPSHOT_METADATA", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_SNAPSHOT_METADATA", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setSnapshotId(dBResultSet.getInt("SNAPSHOT_ID"));
        this.setSnapshotTime(dBResultSet.getTimestamp("SNAPSHOT_TIME"));
        this.setSystemId(dBResultSet.getInt("SYSTEM_ID"));
        this.setSystemType(dBResultSet.getShort("SYSTEM_TYPE"));
        this.setSnapshotConsistent(dBResultSet.getShort("SNAPSHOT_CONSISTENT"));
        this.setSnapshotType(dBResultSet.getShort("SNAPSHOT_TYPE"));
    }

    public static class SnapshotMetadataCursor
    extends DBCursor {
        private SnapshotMetadata element = new SnapshotMetadata();
        private DBConnection con;

        public SnapshotMetadataCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_SNAPSHOT_METADATA", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public SnapshotMetadata getObject() throws SQLException {
            SnapshotMetadata snapshotMetadata = null;
            if (this.DBrs != null) {
                snapshotMetadata = new SnapshotMetadata();
                snapshotMetadata.setFields(this.con, this.DBrs);
            }
            return snapshotMetadata;
        }

        public SnapshotMetadata getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

