/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResSystemNamesSnapshotTable;

public class SystemNamesSnapshot
extends TResSystemNamesSnapshotTable {
    private String m_SystemNamesId_str;

    public void setSystemNames(String string) {
        this.m_SystemNamesId_str = string;
    }

    public String getSystemNames() {
        return this.m_SystemNamesId_str;
    }

    public static SystemNamesSnapshotCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new SystemNamesSnapshotCursor(dBConnection, hashtable, vector);
    }

    public SystemNamesSnapshot() {
        this.clear();
    }

    public SystemNamesSnapshot(int n, short s, String string) {
        this.clear();
        this.m_SnapshotId = n;
        this.m_SystemNamesId = s;
        this.m_SystemName = string;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_SystemNamesId != Short.MIN_VALUE) {
            hashtable.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(this.m_SystemNamesId));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(dBConnection, this.m_SystemNamesId_str);
        }
        if (this.m_SystemName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SYSTEM_NAME not found");
        }
        this.htColsAndValues.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME"), this.m_SystemName);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htColsAndValues.put(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_SYSTEM_NAMES_SNAPSHOT", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME")) == null) {
            throw new SQLException(" ERROR: key SYSTEM_NAME not found");
        }
        if (hashtable.get(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_SYSTEM_NAMES_SNAPSHOT", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(dBConnection, this.m_SystemNamesId_str);
        }
        if (this.m_SystemName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SYSTEM_NAME not found");
        }
        this.htWhereClause.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME"), this.m_SystemName);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SYSTEM_NAMES_SNAPSHOT", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME")) == null) {
            throw new SQLException(" ERROR: key SYSTEM_NAME not found");
        }
        this.htWhereClause.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME"), hashtable.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME")));
        if (hashtable.get(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID"), hashtable.get(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SYSTEM_NAMES_SNAPSHOT", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(dBConnection, this.m_SystemNamesId_str);
        }
        if (this.m_SystemName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SYSTEM_NAME not found");
        }
        this.htWhereClause.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME"), this.m_SystemName);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SYSTEM_NAMES_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME")) == null) {
            throw new SQLException(" ERROR: key SYSTEM_NAME not found");
        }
        this.htWhereClause.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME"), hashtable.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME")));
        if (hashtable.get(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID"), hashtable.get(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SYSTEM_NAMES_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(dBConnection, this.m_SystemNamesId_str);
        }
        if (this.m_SystemName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SYSTEM_NAME not found");
        }
        this.htWhereClause.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME"), this.m_SystemName);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_SYSTEM_NAMES_SNAPSHOT", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static SystemNamesSnapshot retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        SystemNamesSnapshot systemNamesSnapshot = null;
        if (hashtable.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME")) == null) {
            throw new SQLException(" ERROR: key SYSTEM_NAME not found");
        }
        hashtable2.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME"), hashtable.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME")));
        if (hashtable.get(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        hashtable2.put(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID"), hashtable.get(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_SYSTEM_NAMES_SNAPSHOT", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                systemNamesSnapshot = new SystemNamesSnapshot();
                systemNamesSnapshot.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return systemNamesSnapshot;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable2.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable2.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable2.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_SYSTEM_NAMES_SNAPSHOT", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_SYSTEM_NAMES_SNAPSHOT", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setSnapshotId(dBResultSet.getInt("SNAPSHOT_ID"));
        this.setSystemNamesId(dBResultSet.getShort("SYSTEM_NAMES_ID"));
        this.setSystemNames(Normalizer.SystemNamesGetName(dBConnection, this.m_SystemNamesId));
        this.setSystemName(dBResultSet.getString("SYSTEM_NAME"));
    }

    public static class SystemNamesSnapshotCursor
    extends DBCursor {
        private SystemNamesSnapshot element = new SystemNamesSnapshot();
        private DBConnection con;

        private static Hashtable normalize(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            if (hashtable == null) {
                return null;
            }
            if (hashtable.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
                hashtable.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
            }
            return hashtable;
        }

        public SystemNamesSnapshotCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_SYSTEM_NAMES_SNAPSHOT", dBConnection, SystemNamesSnapshotCursor.normalize(dBConnection, hashtable), vector);
            this.con = dBConnection;
        }

        public SystemNamesSnapshot getObject() throws SQLException {
            SystemNamesSnapshot systemNamesSnapshot = null;
            if (this.DBrs != null) {
                systemNamesSnapshot = new SystemNamesSnapshot();
                systemNamesSnapshot.setFields(this.con, this.DBrs);
            }
            return systemNamesSnapshot;
        }

        public SystemNamesSnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

