/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class FcPortXmlToDBMapper
extends DBAttributeMapper {
    private static final String STATE = "State";
    private static final String PORTSTATE = "Port State";
    private static final String CONSTATE = "conState";
    private static final String FCPORTID = "FC Port ID";
    private static final String TYPE = "Type";
    private static final String PHYSICALPORTNUMBER = "Physical Port Number";
    private static final String NAMEFORMAT = "Name Format";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String string = "FcPortXml";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        DBAttributeMapper.RegistrationData registrationData = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        return new DBAttributeMapper.RegistrationData[]{registrationData};
    }

    public FcPortXmlToDBMapper() {
        this.m_dataConverter.addSimpleDataConversion(TYPE.toLowerCase(), "Port_Types");
        this.m_dataConverter.addComplexDataConversion("UniqueIdXml".toLowerCase(), ":", 2);
        this.m_htAttribToMapperInfo.put(PHYSICALPORTNUMBER.toLowerCase(), new MapperInfo(Port.getColumnInfo("PORT_NUMBER")));
        this.m_htAttribToMapperInfo.put(STATE.toLowerCase(), new MapperInfo(Port.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put(PORTSTATE.toLowerCase(), new MapperInfo(Port.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put(CONSTATE.toLowerCase(), new MapperInfo(Port.getColumnInfo("CONSOLIDATED_STATUS")));
        this.m_htAttribToMapperInfo.put(TYPE.toLowerCase(), new MapperInfo(Port.getColumnInfo("TYPE")));
        this.m_htAttribToMapperInfo.put(FCPORTID.toLowerCase(), new MapperInfo(Port.getColumnInfo("FC_PORT_ID")));
        ColumnInfo columnInfo = Port.getColumnInfo("NAME");
        columnInfo.setIsPrimaryKey();
        MapperInfo mapperInfo = new MapperInfo(columnInfo);
        this.m_htAttribToMapperInfo.put("UniqueIdXml".toLowerCase(), mapperInfo);
        ColumnInfo columnInfo2 = Port.getColumnInfo("NAME_FORMAT");
        columnInfo2.setIsPrimaryKey();
        this.m_htAttribToMapperInfo.put(NAMEFORMAT.toLowerCase(), new MapperInfo(columnInfo2));
        ColumnInfo columnInfo3 = Port.getColumnInfo("PORT_ID");
        columnInfo3.setAutoGenerated();
        mapperInfo.setDerivedColumn(columnInfo3);
    }

    public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        Object object;
        Object object2;
        String string2 = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        this.logEntry(this.myClassname, string2, new Object[]{dBConnection, hashtable, string});
        String string3 = (String)hashtable.get("UniqueIdXml");
        if (string3 == null) {
            SQLException sQLException = new SQLException("Required field, UniqueIdXml, was not found.");
            this.logException(this.myClassname, string2, sQLException, "");
            throw sQLException;
        }
        hashtable.put("UniqueIdXml", string3.toUpperCase());
        String string4 = (String)hashtable.remove(STATE);
        boolean bl = true;
        if (string4 == null) {
            string4 = (String)hashtable.remove(PORTSTATE);
            if (string4 == null) {
                string4 = (String)hashtable.remove(PORTSTATE.toLowerCase());
            }
            bl = false;
        }
        if (string4 != null) {
            object2 = this.convertSNIAOPStatToBitArrValue(string4);
            if (bl) {
                hashtable.put(STATE, object2[0]);
            } else {
                hashtable.put(PORTSTATE, object2[0]);
            }
            object = new Vector<String>();
            ((Vector)object).add(object2[1]);
            String string5 = DBConstants.convertOperationalstatusArrayToConsolidatedValue((List)object);
            if (string5 != null) {
                hashtable.put(CONSTATE, string5);
            }
        }
        hashtable.put(NAMEFORMAT.toLowerCase(), DBConstants.getValueFromKey("Name_Format", "FC_WWN"));
        object2 = (String)hashtable.get(FCPORTID);
        if (object2 != null) {
            try {
                int n = Integer.parseInt((String)object2, 16);
                hashtable.put(FCPORTID, Integer.toString(n));
            }
            catch (NumberFormatException numberFormatException) {
                hashtable.remove(FCPORTID);
                this.logWarning(this.myClassname, string2, "An error occurred when trying to parse the FC_PORT_ID value, " + (String)object2 + ", as a hex integer");
            }
        }
        object = super.persist(dBConnection, hashtable, string);
        this.logExit(this.myClassname, string2, object);
        return object;
    }
}

