/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.Node;
import org.eclipse.aperi.infrastructure.database.objects.TapeDrive;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMIS11CIM_TapeDriveToDBMapper
extends DBAttributeMapper {
    public static final String sPERMANENTADDRESS = "permanentaddress";
    public static final String sNAME = "name";
    public static final String sNAMEFORMAT = "nameformat";
    public static final String sDISPLAYICONNAME = "displayiconname";
    public static final String sSCSISUPPORTED = "scsisupported";
    public static final String sPLATFORMTYPE = "platformtype";
    public static final String sRNIDTYPE = "rnidtype";
    public static final String sTAPELIBRARYID = "ref_toplevelsystem_id";
    public static final String sSYSTEMNAME = "systemname";
    public static final String sDEVICEID = "deviceid";
    public static final String sOPERATIONALSTATUS = "operationalstatus";
    public static final String sNEEDSCLEANING = "needscleaning";
    public static final String sMOUNTCOUNT = "mountcount";
    public static final String sAVAILABILITY = "availability";
    public static final String sPOWERONHOURS = "poweronhours";
    public static final String sTOTALPOWERONHOURS = "totalpoweronhours";
    public static final String sELEMENTNAME = "elementname";
    public static final String sFIRMWARE_VERSION = "firmware_version";
    public static final String sCREATIONCLASSNAME = "creationclassname";
    public static final String sSYSTEMCREATIONCLASSNAME = "systemcreationclassname";
    public static final String sDISPLAYNAME = "displayname";
    public static final String sNODE_ID = "ref_node_id";
    public static final String sLIBRARYID = "ref_toplevelsystem_id";
    public static final String sLOCATIONID = "ref_tape_location_id";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String string = "CIM_TapeDrive";
        String string2 = "1.1.0";
        String string3 = "GENERIC_TAPE_LIBRARY";
        String string4 = null;
        DBAttributeMapper.RegistrationData registrationData = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        string = "CIM_MediaAccessDevice";
        DBAttributeMapper.RegistrationData registrationData2 = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        return new DBAttributeMapper.RegistrationData[]{registrationData, registrationData2};
    }

    public SMIS11CIM_TapeDriveToDBMapper() {
        ColumnInfo columnInfo = TapeDrive.getColumnInfo("TAPE_LIBRARY_ID");
        columnInfo.setIsPrimaryKey();
        this.m_htAttribToMapperInfo.put("ref_toplevelsystem_id", new MapperInfo(columnInfo));
        ColumnInfo columnInfo2 = TapeDrive.getColumnInfo("DEVICE_ID");
        columnInfo2.setIsPrimaryKey();
        MapperInfo mapperInfo = new MapperInfo(columnInfo2);
        ColumnInfo columnInfo3 = TapeDrive.getColumnInfo("TAPE_DRIVE_ID");
        columnInfo3.setAutoGenerated();
        mapperInfo.setDerivedColumn(columnInfo3);
        this.m_htAttribToMapperInfo.put(sDEVICEID, mapperInfo);
        this.m_htAttribToMapperInfo.put(sOPERATIONALSTATUS, new MapperInfo(TapeDrive.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put(sMOUNTCOUNT, new MapperInfo(TapeDrive.getColumnInfo("MOUNT_COUNT")));
        this.m_htAttribToMapperInfo.put(sAVAILABILITY, new MapperInfo(TapeDrive.getColumnInfo("AVAILABILITY")));
        this.m_htAttribToMapperInfo.put(sPOWERONHOURS, new MapperInfo(TapeDrive.getColumnInfo("POWER_ON_HOURS")));
        this.m_htAttribToMapperInfo.put(sTOTALPOWERONHOURS, new MapperInfo(TapeDrive.getColumnInfo("TOTAL_POWER_ON_HOURS")));
        this.m_htAttribToMapperInfo.put(sELEMENTNAME, new MapperInfo(TapeDrive.getColumnInfo("ELEMENT_NAME")));
        this.m_dataConverter.addSimpleDataConversion(sNEEDSCLEANING, "Boolean");
        this.m_htAttribToMapperInfo.put(sNEEDSCLEANING, new MapperInfo(TapeDrive.getColumnInfo("NEEDS_CLEANING")));
        this.m_htAttribToMapperInfo.put(sFIRMWARE_VERSION, new MapperInfo(TapeDrive.getColumnInfo("FIRMWARE_VERSION")));
        this.m_htAttribToMapperInfo.put(sNODE_ID, new MapperInfo(TapeDrive.getColumnInfo("NODE_ID")));
        this.m_htAttribToMapperInfo.put(sSYSTEMNAME, new MapperInfo(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")));
        this.m_htAttribToMapperInfo.put(sLOCATIONID, new MapperInfo(TapeDrive.getColumnInfo("LOCATION_ID")));
        this.m_htAttribToMapperInfo.put(sCREATIONCLASSNAME, new MapperInfo(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")));
        this.m_htAttribToMapperInfo.put(sSYSTEMCREATIONCLASSNAME, new MapperInfo(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")));
        this.m_htAttribToMapperInfo.put(sSYSTEMNAME, new MapperInfo(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")));
        this.m_htAttribToMapperInfo.put(sDISPLAYNAME, new MapperInfo(TapeDrive.getColumnInfo("DISPLAY_NAME")));
    }

    public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        Object object;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{dBConnection, hashtable, string});
        String string2 = (String)hashtable.get(sOPERATIONALSTATUS);
        if (string2 != null) {
            object = SMIS11CIM_TapeDriveToDBMapper.processArrayvalues(string2);
            if ((string2 = DBConstants.convertOperationalstatusArrayToBitValue((Vector)object)) != null) {
                hashtable.put(sOPERATIONALSTATUS, string2);
            } else {
                hashtable.remove(sOPERATIONALSTATUS);
            }
            string2 = DBConstants.convertOperationalstatusArrayToConsolidatedValue((List)object);
            if (string2 != null) {
                hashtable.put("CONSOLIDATED_STATUS".toLowerCase(), string2);
            }
        }
        if (hashtable.get(sDISPLAYNAME) == null) {
            object = (String)hashtable.get("ref_toplevelsystem_name");
            hashtable.put(sDISPLAYNAME, object);
        }
        object = new MapperResult();
        if (hashtable.get(sNODE_ID) == null && hashtable.get("SCSI") == null) {
            NodeMapper nodeMapper = new NodeMapper();
            object = nodeMapper.persist(dBConnection, hashtable, string);
            hashtable.putAll(((MapperResult)object).getKeyReferences());
        }
        ((MapperResult)object).addMapperResult(super.persist(dBConnection, hashtable, string));
        ((MapperResult)object).addKeyReference("ref_device_id", TapeDrive.getColumnInfo("DEVICE_ID"));
        ((MapperResult)object).addKeyReference("ref_system_names_id", TapeDrive.getColumnInfo("SYSTEM_NAMES_ID"));
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", object);
        return object;
    }

    private class NodeMapper
    extends DBAttributeMapper {
        public NodeMapper() {
            ColumnInfo columnInfo = Node.getColumnInfo("NAME_FORMAT");
            columnInfo.setIsPrimaryKey();
            this.m_dataConverter.addSimpleDataConversion(SMIS11CIM_TapeDriveToDBMapper.sNAMEFORMAT, "Name_Format");
            this.m_htAttribToMapperInfo.put(SMIS11CIM_TapeDriveToDBMapper.sNAMEFORMAT, new MapperInfo(columnInfo));
            this.m_htAttribToMapperInfo.put(SMIS11CIM_TapeDriveToDBMapper.sDISPLAYNAME, new MapperInfo(Node.getColumnInfo("DISPLAY_NAME")));
            this.m_htAttribToMapperInfo.put(SMIS11CIM_TapeDriveToDBMapper.sDISPLAYICONNAME, new MapperInfo(Node.getColumnInfo("DISPLAY_ICON_TYPE")));
            this.m_htAttribToMapperInfo.put(SMIS11CIM_TapeDriveToDBMapper.sOPERATIONALSTATUS, new MapperInfo(Node.getColumnInfo("OPERATIONAL_STATUS")));
            this.m_htAttribToMapperInfo.put("CONSOLIDATED_STATUS".toLowerCase(), new MapperInfo(Node.getColumnInfo("CONSOLIDATED_STATUS")));
            this.m_htAttribToMapperInfo.put("ref_toplevelsystem_id", new MapperInfo(Node.getColumnInfo("TAPE_LIBRARY_ID")));
            ColumnInfo columnInfo2 = Node.getColumnInfo("NAME");
            columnInfo2.setIsPrimaryKey();
            MapperInfo mapperInfo = new MapperInfo(columnInfo2);
            ColumnInfo columnInfo3 = Node.getColumnInfo("NODE_ID");
            columnInfo3.setAutoGenerated();
            mapperInfo.setDerivedColumn(columnInfo3);
            this.m_htAttribToMapperInfo.put(SMIS11CIM_TapeDriveToDBMapper.sDEVICEID, mapperInfo);
        }

        public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
            String string2;
            String string3;
            String string4;
            this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{dBConnection, hashtable, string});
            String string5 = (String)hashtable.get(SMIS11CIM_TapeDriveToDBMapper.sSCSISUPPORTED);
            if (string5 == null) {
                hashtable.put(SMIS11CIM_TapeDriveToDBMapper.sSCSISUPPORTED, "1");
            }
            if ((string4 = (String)hashtable.get(SMIS11CIM_TapeDriveToDBMapper.sPLATFORMTYPE)) == null) {
                hashtable.put(SMIS11CIM_TapeDriveToDBMapper.sPLATFORMTYPE, "1");
            }
            if ((string3 = (String)hashtable.get(SMIS11CIM_TapeDriveToDBMapper.sRNIDTYPE)) == null) {
                hashtable.put(SMIS11CIM_TapeDriveToDBMapper.sRNIDTYPE, "1");
            }
            if ((string2 = (String)hashtable.get(SMIS11CIM_TapeDriveToDBMapper.sNAMEFORMAT)) == null) {
                hashtable.put(SMIS11CIM_TapeDriveToDBMapper.sNAMEFORMAT, "FC_WWN");
            }
            MapperResult mapperResult = super.persist(dBConnection, hashtable, string);
            mapperResult.addKeyReference(SMIS11CIM_TapeDriveToDBMapper.sNODE_ID, Node.getColumnInfo("NODE_ID"));
            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mapperResult);
            return mapperResult;
        }
    }
}

