/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.tsanm.zone.interfaces;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneAlias;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneCapabilities;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneDefinition;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneMember;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;
import org.eclipse.aperi.sanmgmt.tsanm.zone.interfaces.Command;
import org.eclipse.aperi.sanmgmt.tsanm.zone.interfaces.IZoneControlAgent;
import org.eclipse.aperi.sanmgmt.tsanm.zone.interfaces.ZoneDefSaxParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class ZoneControlAgent
implements IZoneControlAgent {
    protected boolean activateOnCommit = false;
    protected static ILogger msgLogger = null;
    protected static ILogger traceLogger = null;
    protected HashMap SANtoZoneDef = new HashMap();
    protected Hashtable SANtoNewZoneDef = new Hashtable();
    private String defaultZoneSet = "unusedZS";
    protected HashMap SANtoCommands = new HashMap();
    static final String className = ZoneControlAgent.class.getName();
    protected Hashtable SANtoHandle = new Hashtable();

    public ZoneDefinition getOldZoneDefinition(String string) {
        String string2 = "getOldZoneDefinition";
        ZoneDefinition zoneDefinition = (ZoneDefinition)this.SANtoZoneDef.get(string);
        this.SANtoZoneDef.remove(string);
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, this, string2, "zone definition returned by getOldZoneDefinition is " + zoneDefinition);
        }
        return zoneDefinition;
    }

    public ZoneDefinition getNewZoneDefinition(String string) {
        String string2 = "getNewZoneDefinition";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, className, string2);
        }
        ZoneDefinition zoneDefinition = (ZoneDefinition)this.SANtoNewZoneDef.get(string);
        this.SANtoNewZoneDef.remove(string);
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, this, string2, "zone definition returned by getNewZoneDefinition without making native calls is " + zoneDefinition);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return zoneDefinition;
    }

    public int readCurrentZoneDefinition(String string, ZoneDefinition zoneDefinition) throws Exception {
        int n;
        String string2;
        String string3 = "readCurrentZoneDefinition";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, className, string3);
        }
        if ((string2 = this.getCurrentZoningInfoNative(n = ((Integer)this.SANtoHandle.get(string)).intValue())) == null) {
            return 1111;
        }
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, this, string3, "String returned by getCurrentZoningInfoNative is " + string2);
        }
        XMLReader xMLReader = null;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        xMLReader = sAXParser.getXMLReader();
        ZoneDefSaxParser zoneDefSaxParser = new ZoneDefSaxParser(zoneDefinition);
        xMLReader.setContentHandler(zoneDefSaxParser);
        xMLReader.setErrorHandler(zoneDefSaxParser);
        StringReader stringReader = new StringReader(string2);
        InputSource inputSource = new InputSource(stringReader);
        try {
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERR, this, string3, "Parsing of Zoning Configuration XML failed for SAN " + string + ".\tZoneDef XML =\t" + string2);
            }
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string3, sAXException);
            }
            msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string3, "ZoneControl_SAXParseException", string);
            msgLogger.exception(IRecordType.TYPE_ERR, this, string3, sAXException);
            throw sAXException;
        }
        string2 = null;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string3);
        }
        return 0;
    }

    public int sendCommandArray(String string, Command[] commandArray) {
        String string2 = "sendCommandArray";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, string2);
            }
            ArrayList arrayList = (ArrayList)this.SANtoCommands.remove(string);
            Command command = new Command();
            int n = 0;
            while (n < commandArray.length) {
                command = commandArray[n];
                arrayList.add(command);
                ++n;
            }
            this.SANtoCommands.put(string, arrayList);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, string2, exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
            }
            return 271111;
        }
        return 0;
    }

    protected int createDesiredZoneDefinition(ZoneDefinition zoneDefinition, ZoneDefinition zoneDefinition2, ArrayList arrayList) {
        String string = "createDesiredZoneDefinition";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, className, string);
        }
        Command command = new Command();
        int n = 0;
        while (n < arrayList.size()) {
            command = (Command)arrayList.get(n);
            ArrayList arrayList2 = command.getParams();
            switch (command.getType()) {
                case 2: {
                    String string2 = (String)arrayList2.get(0);
                    ZoneSet zoneSet = zoneDefinition2.getZoneSet(string2);
                    if (zoneSet == null) {
                        return 201998;
                    }
                    zoneDefinition2.activateZoneSet(zoneSet);
                    break;
                }
                case 14: {
                    String string3 = (String)arrayList2.get(0);
                    String string4 = (String)arrayList2.get(1);
                    Zone zone = zoneDefinition2.getZone(string3);
                    ZoneAlias zoneAlias = zoneDefinition2.getZoneAlias(string4);
                    if (zone == null || zoneAlias == null) {
                        return 101998;
                    }
                    zoneDefinition2.addAlias(zone, zoneAlias);
                    break;
                }
                case 16: {
                    String string4 = (String)arrayList2.get(0);
                    String string5 = (String)arrayList2.get(1);
                    short s = (Short)arrayList2.get(2);
                    ZoneAlias zoneAlias = zoneDefinition2.getZoneAlias(string4);
                    ZoneMember zoneMember = zoneDefinition2.getZoneMember(string5, s);
                    if (zoneAlias == null || zoneMember == null) {
                        return 111998;
                    }
                    zoneDefinition2.addMember(zoneAlias, zoneMember);
                    break;
                }
                case 12: {
                    String string3 = (String)arrayList2.get(0);
                    String string5 = (String)arrayList2.get(1);
                    short s = (Short)arrayList2.get(2);
                    Zone zone = zoneDefinition2.getZone(string3);
                    ZoneMember zoneMember = zoneDefinition2.getZoneMember(string5, s);
                    if (zone == null || zoneMember == null) {
                        return 91998;
                    }
                    zoneDefinition2.addMember(zone, zoneMember);
                    break;
                }
                case 10: {
                    String string2 = (String)arrayList2.get(0);
                    String string3 = (String)arrayList2.get(1);
                    ZoneSet zoneSet = zoneDefinition2.getZoneSet(string2);
                    Zone zone = zoneDefinition2.getZone(string3);
                    if (zone == null || zoneSet == null) {
                        return 81998;
                    }
                    zoneDefinition2.addZone(zoneSet, zone);
                    break;
                }
                case 8: {
                    String string4 = (String)arrayList2.get(0);
                    ZoneAlias[] zoneAliasArray = zoneDefinition2.getAliases();
                    short s = 0;
                    while (s < zoneAliasArray.length) {
                        ZoneAlias zoneAlias = zoneAliasArray[s];
                        if (zoneAlias.getName().equalsIgnoreCase(string4)) {
                            return 65002;
                        }
                        ++s;
                    }
                    ZoneAlias zoneAlias = new ZoneAlias(string4);
                    zoneDefinition2.addAlias(zoneAlias);
                    break;
                }
                case 4: {
                    String string3 = (String)arrayList2.get(0);
                    if (zoneDefinition2.getZone(string3) != null) {
                        return 55002;
                    }
                    Zone zone = new Zone(string3);
                    zoneDefinition2.addZone(zone);
                    break;
                }
                case 6: {
                    Zone zone;
                    short s = (Short)arrayList2.get(0);
                    String string6 = (String)arrayList2.get(1);
                    short s2 = (Short)arrayList2.get(2);
                    String string7 = (String)arrayList2.get(3);
                    ZoneMember zoneMember = new ZoneMember(s, string6);
                    if (s2 == 0) {
                        zone = zoneDefinition2.getZone(string7);
                        if (zone == null) {
                            return 71998;
                        }
                        zoneDefinition2.addMember(zone, zoneMember);
                        break;
                    }
                    if (s2 != 1) break;
                    ZoneAlias zoneAlias = zoneDefinition2.getZoneAlias(string7);
                    if (zoneAlias == null) {
                        return 71998;
                    }
                    zoneDefinition2.addMember(zoneAlias, zoneMember);
                    break;
                }
                case 0: {
                    String string2 = (String)arrayList2.get(0);
                    if (zoneDefinition2.getZoneSet(string2) != null) {
                        return 45002;
                    }
                    ZoneSet zoneSet = new ZoneSet(string2);
                    zoneDefinition2.addZoneSet(zoneSet);
                    break;
                }
                case 3: {
                    zoneDefinition2.deactivateZoneSet();
                    break;
                }
                case 9: {
                    String string4 = (String)arrayList2.get(0);
                    ZoneAlias zoneAlias = zoneDefinition2.getZoneAlias(string4);
                    if (zoneAlias == null) {
                        if (!traceLogger.isLogging()) break;
                        traceLogger.text(IRecordType.TYPE_WARN, this, string, "Tried to delete an Alias which does not exist: " + string4);
                        break;
                    }
                    zoneDefinition2.deleteAlias(zoneAlias);
                    break;
                }
                case 5: {
                    String string3 = (String)arrayList2.get(0);
                    Zone zone = zoneDefinition2.getZone(string3);
                    if (zone == null) {
                        if (!traceLogger.isLogging()) break;
                        traceLogger.text(IRecordType.TYPE_WARN, this, string, "Tried to delete a Zone which does not exist: " + string3);
                        break;
                    }
                    zoneDefinition2.deleteZone(zone);
                    break;
                }
                case 7: {
                    String string5 = (String)arrayList2.get(0);
                    short s = (Short)arrayList2.get(1);
                    ZoneMember zoneMember = zoneDefinition2.getZoneMember(string5, s);
                    if (zoneMember == null) {
                        if (!traceLogger.isLogging()) break;
                        traceLogger.text(IRecordType.TYPE_WARN, this, string, "Tried to delete a ZoneMember which does not exist: " + string5);
                        break;
                    }
                    zoneDefinition2.deleteMember(zoneMember);
                    break;
                }
                case 1: {
                    String string2 = (String)arrayList2.get(0);
                    ZoneSet zoneSet = zoneDefinition2.getZoneSet(string2);
                    if (zoneSet == null) {
                        if (!traceLogger.isLogging()) break;
                        traceLogger.text(IRecordType.TYPE_WARN, this, string, "Tried to delete a ZoneSet which does not exist: " + string2);
                        break;
                    }
                    zoneDefinition2.deleteZoneSet(zoneSet);
                    break;
                }
                case 15: {
                    String string3 = (String)arrayList2.get(0);
                    String string4 = (String)arrayList2.get(1);
                    Zone zone = zoneDefinition2.getZone(string3);
                    ZoneAlias zoneAlias = zoneDefinition2.getZoneAlias(string4);
                    if (zone == null || zoneAlias == null) {
                        return 131998;
                    }
                    zoneDefinition2.removeAlias(zone, zoneAlias);
                    break;
                }
                case 17: {
                    String string4 = (String)arrayList2.get(0);
                    String string5 = (String)arrayList2.get(1);
                    short s = (Short)arrayList2.get(2);
                    ZoneAlias zoneAlias = zoneDefinition2.getZoneAlias(string4);
                    ZoneMember zoneMember = zoneDefinition2.getZoneMember(string5, s);
                    if (zoneAlias == null || zoneMember == null) {
                        return 151998;
                    }
                    zoneDefinition2.removeMember(zoneAlias, zoneMember);
                    break;
                }
                case 13: {
                    String string3 = (String)arrayList2.get(0);
                    String string5 = (String)arrayList2.get(1);
                    Zone zone = zoneDefinition2.getZone(string3);
                    short s = (Short)arrayList2.get(2);
                    ZoneMember zoneMember = zoneDefinition2.getZoneMember(string5, s);
                    if (zone == null || zoneMember == null) {
                        return 141998;
                    }
                    zoneDefinition2.removeMember(zone, zoneMember);
                    break;
                }
                case 11: {
                    String string2 = (String)arrayList2.get(0);
                    String string3 = (String)arrayList2.get(1);
                    ZoneSet zoneSet = zoneDefinition2.getZoneSet(string2);
                    Zone zone = zoneDefinition2.getZone(string3);
                    if (zone == null || zoneSet == null) {
                        return 121998;
                    }
                    zoneDefinition2.removeZone(zoneSet, zone);
                }
            }
            ++n;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return 0;
    }

    public abstract int lock(String var1, String[] var2);

    public abstract int startTransaction(String var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int commitTransaction(String string) {
        String string2 = "commitTransaction";
        int n = 1111;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, className, string2);
        }
        try {
            ((Integer)this.SANtoHandle.get(string)).intValue();
            ZoneDefinition zoneDefinition = new ZoneDefinition();
            try {
                n = this.readCurrentZoneDefinition(string, zoneDefinition);
                if (n != 0) {
                    return 251999;
                }
            }
            catch (SAXException sAXException) {
                return 231999;
            }
            this.SANtoZoneDef.put(string, zoneDefinition);
            ArrayList arrayList = (ArrayList)this.SANtoCommands.get(string);
            ZoneDefinition zoneDefinition2 = (ZoneDefinition)zoneDefinition.clone();
            n = this.createDesiredZoneDefinition(zoneDefinition, zoneDefinition2, arrayList);
            if (n != 0) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERR, this, string2, "Error occurred while creating logical ZoneDefinition for " + string);
                }
                return n;
            }
            this.setZoneTypesToDefault(zoneDefinition);
            this.setZoneTypesToDefault(zoneDefinition2);
            this.SANtoNewZoneDef.put(string, zoneDefinition2);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, this, string2, "Old Zone Definition:\n " + zoneDefinition.toString());
                traceLogger.text(IRecordType.TYPE_MISC_DATA, this, string2, "New Zone Definition:\n " + zoneDefinition2.toString());
            }
            n = this.activateOnCommit ? this.sendCommandsToSwitch(string, zoneDefinition2, zoneDefinition, 1) : this.sendCommandsToSwitch(string, zoneDefinition2, zoneDefinition, 0);
            this.activateOnCommit = false;
            if (n != 0) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERR, this, string2, "Error occurred while sending zoning commands to SAN " + string);
                }
                return n;
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, string2, exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
            }
            n = 231111;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return n;
    }

    public abstract int rollbackTransaction(String var1);

    public int release(String string) {
        String string2 = "release";
        int n = 1111;
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, string2);
            }
            this.SANtoZoneDef.remove(string);
            this.SANtoNewZoneDef.remove(string);
            n = this.closeSessionNative((Integer)this.SANtoHandle.get(string));
            if (n != 0) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERR, this, string2, "Failed to release resource " + string + ".  Err = " + n);
                }
                this.SANtoHandle.remove(string);
                return n;
            }
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, "Released resource: " + string);
            }
            this.SANtoHandle.remove(string);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, string2, exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
            }
            n = 31111;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setZoneInfo(String string, ZoneDefinition zoneDefinition, int n) {
        String string2 = "setZoneInfo";
        int n2 = 1111;
        if (n != 1 && n != 0) {
            return 251000;
        }
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, string2);
            }
            ZoneDefinition zoneDefinition2 = new ZoneDefinition();
            try {
                n2 = this.readCurrentZoneDefinition(string, zoneDefinition2);
                if (n2 != 0) {
                    return 251999;
                }
            }
            catch (SAXException sAXException) {
                return 251999;
            }
            this.setZoneTypesToDefault(zoneDefinition2);
            this.setZoneTypesToDefault(zoneDefinition);
            this.SANtoZoneDef.put(string, zoneDefinition2);
            this.SANtoNewZoneDef.put(string, zoneDefinition);
            n2 = this.sendCommandsToSwitch(string, zoneDefinition, zoneDefinition2, n);
            if (n2 != 0) {
                return n2;
            }
            if (!traceLogger.isLogging()) return n2;
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
            return n2;
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, string2, exception);
            if (!traceLogger.isLogging()) return 251111;
            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
            return 251111;
        }
    }

    public abstract int ping(String var1, String[] var2);

    public abstract ZoneCapabilities getCapabilities(String var1);

    public int createZoneSet(String string, String string2) {
        String string3 = "createZoneSet";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, string3);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            Command command = new Command(0, arrayList);
            ArrayList arrayList2 = (ArrayList)this.SANtoCommands.remove(string);
            arrayList2.add(command);
            this.SANtoCommands.put(string, arrayList2);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string3);
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, string3, exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string3, exception);
            }
            return 41111;
        }
        return 0;
    }

    public int createZone(String string, String string2, short s, short s2) {
        String string3 = "createZone";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, string3);
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(string2);
            arrayList.add(new Short(s));
            arrayList.add(new Short(s2));
            Command command = new Command(4, arrayList);
            ArrayList arrayList2 = (ArrayList)this.SANtoCommands.remove(string);
            arrayList2.add(command);
            this.SANtoCommands.put(string, arrayList2);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string3);
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, string3, exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string3, exception);
            }
            return 51111;
        }
        return 0;
    }

    public int createZoneAlias(String string, String string2) {
        String string3 = "createZoneAlias";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, string3);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            Command command = new Command(8, arrayList);
            ArrayList arrayList2 = (ArrayList)this.SANtoCommands.remove(string);
            arrayList2.add(command);
            this.SANtoCommands.put(string, arrayList2);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string3);
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, string3, exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string3, exception);
            }
            return 61111;
        }
        return 0;
    }

    public int createZoneMemberSettingData(String string, short s, String string2, short s2, String string3) {
        String string4 = "createZoneMemberSettingData";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, string4);
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(new Short(s));
            arrayList.add(string2);
            arrayList.add(new Short(s2));
            arrayList.add(string3);
            Command command = new Command(6, arrayList);
            ArrayList arrayList2 = (ArrayList)this.SANtoCommands.remove(string);
            arrayList2.add(command);
            this.SANtoCommands.put(string, arrayList2);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string4);
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, string4, exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string4, exception);
            }
            return 71111;
        }
        return 0;
    }

    public int addZoneToZoneSet(String string, String string2, String string3) {
        String string4 = "addZoneToZoneSet";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, string4);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            arrayList.add(string3);
            Command command = new Command(10, arrayList);
            ArrayList arrayList2 = (ArrayList)this.SANtoCommands.remove(string);
            arrayList2.add(command);
            this.SANtoCommands.put(string, arrayList2);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string4);
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, string4, exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string4, exception);
            }
            return 81111;
        }
        return 0;
    }

    public int addZoneMemberToZone(String string, String string2, String string3, short s) {
        String string4 = "addZoneMemberToZone";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, string4);
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(new Short(s));
            Command command = new Command(12, arrayList);
            ArrayList arrayList2 = (ArrayList)this.SANtoCommands.remove(string);
            arrayList2.add(command);
            this.SANtoCommands.put(string, arrayList2);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string4);
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, string4, exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string4, exception);
            }
            return 91111;
        }
        return 0;
    }

    public int addZoneAliasToZone(String string, String string2, String string3) {
        String string4 = "addZoneAliasToZone";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, string4);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            arrayList.add(string3);
            Command command = new Command(14, arrayList);
            ArrayList arrayList2 = (ArrayList)this.SANtoCommands.remove(string);
            arrayList2.add(command);
            this.SANtoCommands.put(string, arrayList2);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string4);
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, string4, exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string4, exception);
            }
            return 101111;
        }
        return 0;
    }

    public int addZoneMemberToZoneAlias(String string, String string2, String string3, short s) {
        String string4 = "addZoneMemberToZoneAlias";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, string4);
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(new Short(s));
            Command command = new Command(16, arrayList);
            ArrayList arrayList2 = (ArrayList)this.SANtoCommands.remove(string);
            arrayList2.add(command);
            this.SANtoCommands.put(string, arrayList2);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string4);
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, string4, exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string4, exception);
            }
            return 111111;
        }
        return 0;
    }

    public int removeZoneFromZoneSet(String string, String string2, String string3) {
        String string4 = "removeZoneFromZoneSet";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, string4);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            arrayList.add(string3);
            Command command = new Command(11, arrayList);
            ArrayList arrayList2 = (ArrayList)this.SANtoCommands.remove(string);
            arrayList2.add(command);
            this.SANtoCommands.put(string, arrayList2);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string4);
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, string4, exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string4, exception);
            }
            return 121111;
        }
        return 0;
    }

    public int removeZoneAliasFromZone(String string, String string2, String string3) {
        String string4 = "removeZoneAliasFromZone";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, string4);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            arrayList.add(string3);
            Command command = new Command(15, arrayList);
            ArrayList arrayList2 = (ArrayList)this.SANtoCommands.remove(string);
            arrayList2.add(command);
            this.SANtoCommands.put(string, arrayList2);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string4);
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, string4, exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string4, exception);
            }
            return 131111;
        }
        return 0;
    }

    public int removeZoneMemberFromZone(String string, String string2, String string3, short s) {
        String string4 = "removeZoneMemberFromZone";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, string4);
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(new Short(s));
            Command command = new Command(13, arrayList);
            ArrayList arrayList2 = (ArrayList)this.SANtoCommands.remove(string);
            arrayList2.add(command);
            this.SANtoCommands.put(string, arrayList2);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string4);
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, string4, exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string4, exception);
            }
            return 141111;
        }
        return 0;
    }

    public int removeZoneMemberFromZoneAlias(String string, String string2, String string3, short s) {
        String string4 = "removeZoneMemberFromZoneAlias";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, string4);
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(new Short(s));
            Command command = new Command(17, arrayList);
            ArrayList arrayList2 = (ArrayList)this.SANtoCommands.remove(string);
            arrayList2.add(command);
            this.SANtoCommands.put(string, arrayList2);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string4);
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, string4, exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string4, exception);
            }
            return 151111;
        }
        return 0;
    }

    public int deleteZoneMember(String string, String string2, short s) {
        String string3 = "deleteZoneMember";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, string3);
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(string2);
            arrayList.add(new Short(s));
            Command command = new Command(7, arrayList);
            ArrayList arrayList2 = (ArrayList)this.SANtoCommands.remove(string);
            arrayList2.add(command);
            this.SANtoCommands.put(string, arrayList2);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string3);
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, string3, exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string3, exception);
            }
            return 161111;
        }
        return 0;
    }

    public int deleteZone(String string, String string2) {
        String string3 = "deleteZone";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, string3);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            Command command = new Command(5, arrayList);
            ArrayList arrayList2 = (ArrayList)this.SANtoCommands.remove(string);
            arrayList2.add(command);
            this.SANtoCommands.put(string, arrayList2);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string3);
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, string3, exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string3, exception);
            }
            return 171111;
        }
        return 0;
    }

    public int deleteZoneSet(String string, String string2) {
        String string3 = "deleteZoneSet";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, string3);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            Command command = new Command(1, arrayList);
            ArrayList arrayList2 = (ArrayList)this.SANtoCommands.remove(string);
            arrayList2.add(command);
            this.SANtoCommands.put(string, arrayList2);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string3);
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, string3, exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string3, exception);
            }
            return 181111;
        }
        return 0;
    }

    public int deleteZoneAlias(String string, String string2) {
        String string3 = "deleteZoneAlias";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, string3);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            Command command = new Command(9, arrayList);
            ArrayList arrayList2 = (ArrayList)this.SANtoCommands.remove(string);
            arrayList2.add(command);
            this.SANtoCommands.put(string, arrayList2);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string3);
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, string3, exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string3, exception);
            }
            return 191111;
        }
        return 0;
    }

    public int activateZoneSet(String string, String string2) {
        String string3 = "activateZoneSet";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, string3);
            }
            this.activateOnCommit = true;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            Command command = new Command(2, arrayList);
            ArrayList arrayList2 = (ArrayList)this.SANtoCommands.remove(string);
            arrayList2.add(command);
            this.SANtoCommands.put(string, arrayList2);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string3);
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, string3, exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string3, exception);
            }
            return 201111;
        }
        return 0;
    }

    public int deactivateZoneSet(String string, String string2) {
        String string3 = "deactivateZoneSet";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, string3);
            }
            this.activateOnCommit = true;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            Command command = new Command(3, arrayList);
            ArrayList arrayList2 = (ArrayList)this.SANtoCommands.remove(string);
            arrayList2.add(command);
            this.SANtoCommands.put(string, arrayList2);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string3);
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, string3, exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string3, exception);
            }
            return 211111;
        }
        return 0;
    }

    protected void findSameZoneEntities(ZoneDefinition zoneDefinition, ZoneDefinition zoneDefinition2, HashMap hashMap, HashMap hashMap2, HashMap hashMap3) {
        String string = "findSameZoneEntities";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        ZoneSet[] zoneSetArray = zoneDefinition.getZoneSets();
        int n = 0;
        while (n < zoneSetArray.length) {
            String string2 = zoneSetArray[n].getName();
            if (zoneDefinition2.getZoneSet(string2) != null) {
                ArrayList arrayList;
                ArrayList arrayList2;
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string, "Evaluating ZoneSet " + string2 + " of both ZoneDefinitions for differences.");
                }
                if (zoneDefinition2.isSameZoneSet(zoneDefinition, string2, arrayList2 = new ArrayList(), arrayList = new ArrayList())) {
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string, "ZoneSet " + string2 + " is same in both ZoneDefinitions.");
                    }
                    hashMap.put(string2, zoneSetArray[n]);
                } else {
                    Zone zone;
                    boolean bl = false;
                    int n2 = 0;
                    while (!bl && n2 < arrayList2.size()) {
                        zone = (Zone)arrayList2.get(n2);
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string, "Evaluating Zone " + zone.getName() + " in uniqueZones.");
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string, String.valueOf(zone.getName()) + " has vendorType " + Short.toString(zone.getVendorType()));
                        }
                        if (zone.getVendorType() == 1) {
                            bl = true;
                        }
                        ++n2;
                    }
                    n2 = 0;
                    while (!bl && n2 < arrayList.size()) {
                        zone = (Zone)arrayList.get(n2);
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string, "Evaluating Zone " + zone.getName() + " in otherUniqueZones.");
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string, String.valueOf(zone.getName()) + " has vendorType " + Short.toString(zone.getVendorType()));
                        }
                        if (zone.getVendorType() == 1) {
                            bl = true;
                        }
                        ++n2;
                    }
                    if (!bl) {
                        hashMap.put(string2, zoneSetArray[n]);
                    }
                }
            }
            ++n;
        }
        if (hashMap2 != null) {
            ZoneAlias[] zoneAliasArray = zoneDefinition.getAliases();
            int n3 = 0;
            while (n3 < zoneAliasArray.length) {
                if (zoneDefinition2.getZoneAlias(zoneAliasArray[n3].getName()) != null && zoneDefinition2.isSameAlias(zoneDefinition, zoneAliasArray[n3].getName())) {
                    hashMap2.put(zoneAliasArray[n3].getName(), zoneAliasArray[n3]);
                }
                ++n3;
            }
        }
        Zone[] zoneArray = zoneDefinition.getZones();
        int n4 = 0;
        while (n4 < zoneArray.length) {
            if (zoneDefinition2.getZone(zoneArray[n4].getName()) != null && zoneDefinition2.isSameZone(zoneDefinition, zoneArray[n4].getName(), zoneArray[n4].getVendorType())) {
                hashMap3.put(zoneArray[n4].getName(), zoneArray[n4]);
            }
            ++n4;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
    }

    private void setZoneTypesToDefault(ZoneDefinition zoneDefinition) {
        Zone[] zoneArray = zoneDefinition.getZones();
        int n = 0;
        while (n < zoneArray.length) {
            zoneArray[n].setSubType(new Integer(0).shortValue());
            zoneArray[n].setType(new Integer(0).shortValue());
            ++n;
        }
    }

    protected abstract int sendCommandsToSwitch(String var1, ZoneDefinition var2, ZoneDefinition var3, int var4);

    protected abstract int activateTransactionNative(int var1);

    protected abstract int closeSessionNative(int var1);

    protected abstract String getCurrentZoningInfoNative(int var1);
}

