/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.request.handler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponseImpl;
import org.eclipse.aperi.server.guireq.topology.request.handler.TopoSettingHandler;
import org.eclipse.aperi.server.guireq.topology.views.ViewerOtherL0;
import org.eclipse.aperi.server.guireq.topology.views.ViewerOtherL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerOtherL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerPinnedList;
import org.eclipse.aperi.server.guireq.topology.views.ViewerProbeMgr;
import org.eclipse.aperi.server.guireq.topology.views.ViewerPropagatedStatus;
import org.eclipse.aperi.server.guireq.topology.views.ViewerRoot;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSanL0;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSanL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL0;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerStorageL0;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSubsystemL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSubsystemL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSwitchL0;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSwitchL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSwitchL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerTapeLibraryL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerTapeLibraryL2;

public class ViewerRequestHandler {
    static boolean debug = false;
    static int tempIds = 0;
    public static final String SELECT_TIMEOUT = "SELECT \tSETTINGS.TV_REFRESH_TIMEOUT TIMEOUT FROM \tT_STORM_SETTINGS SETTINGS ";
    public static final String UPDATE_TIMEOUT = "UPDATE     T_STORM_SETTINGS SET T_STORM_SETTINGS.TV_REFRESH_TIMEOUT = ?";

    public static synchronized int getTmpId() {
        return tempIds++;
    }

    public static ViewerResponse handleRequest(Connection connection, Request request) {
        Object object;
        Object object2;
        ViewerRequest viewerRequest = (ViewerRequest)request.requestData;
        String string = request.userName;
        if (debug) {
            System.out.println("ENTER- handleRequest(): " + viewerRequest);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerRequestHandler.class.getName(), "handleRequest", "");
        }
        ViewerResponse viewerResponse = null;
        if (viewerRequest == null) {
            viewerResponse = new ViewerResponseImpl();
            viewerResponse.addResponse(1, null);
            return viewerResponse;
        }
        viewerResponse = viewerRequest.constructResponse();
        Enumeration enumeration = viewerRequest.elements();
        ViewerRequest viewerRequest2 = (ViewerRequest)enumeration.nextElement();
        try {
            if (viewerRequest.getRequestType() == 0) {
                object2 = viewerRequest2.getModelID();
                ViewerPropagatedStatus.propagateStatus(connection, null, ((GraphModel.ID)object2).getFocusLevel());
                object = ((GraphModel.ID)object2).getFocusLevel();
                if (((String)object).equals("Overview")) {
                    new ViewerRoot().getView(connection, viewerRequest, viewerResponse);
                } else if (((String)object).equals("FabricL0")) {
                    new ViewerSanL0().getView(connection, viewerRequest, viewerResponse);
                } else if (((String)object).equals("FabricL2")) {
                    new ViewerSanL1().getView(connection, viewerRequest, viewerResponse);
                } else if (((String)object).equals("ComputerL0")) {
                    new ViewerServerL0().getView(connection, viewerRequest, viewerResponse);
                } else if (((String)object).equals("ComputerL2")) {
                    new ViewerServerL2().getView(connection, viewerRequest, viewerResponse);
                } else if (((String)object).equals("SwitchL0")) {
                    new ViewerSwitchL0().getView(connection, viewerRequest, viewerResponse);
                } else if (((String)object).equals("SwitchL2")) {
                    new ViewerSwitchL2().getView(connection, viewerRequest, viewerResponse);
                } else if (((String)object).equals("StorageL0")) {
                    new ViewerStorageL0().getView(connection, viewerRequest, viewerResponse);
                } else if (((String)object).equals("SubsystemL2")) {
                    new ViewerSubsystemL2().getView(connection, viewerRequest, viewerResponse);
                } else if (((String)object).equals("TapeLibraryL1")) {
                    new ViewerTapeLibraryL1().getView(connection, viewerRequest, viewerResponse);
                } else if (((String)object).equals("TapeLibraryL2")) {
                    new ViewerTapeLibraryL2().getView(connection, viewerRequest, viewerResponse);
                } else if (((String)object).equals("OtherL0")) {
                    new ViewerOtherL0().getView(connection, viewerRequest, viewerResponse);
                } else if (((String)object).equals("OtherL2")) {
                    new ViewerOtherL2().getView(connection, viewerRequest, viewerResponse);
                } else if (((String)object).equals("PinList")) {
                    ViewerPinnedList.getView(connection, viewerRequest, viewerResponse);
                } else if (((String)object).equals("ComputerL1") || ((String)object).equals("SwitchL1") || ((String)object).equals("SubsystemL1") || ((String)object).equals("OtherL1")) {
                    int n = ViewerRequestHandler.getTmpId();
                    if (((String)object).equals("ComputerL1")) {
                        new ViewerServerL1().getView(connection, viewerRequest, viewerResponse, n);
                    } else if (((String)object).equals("SwitchL1")) {
                        new ViewerSwitchL1().getView(connection, viewerRequest, viewerResponse, n);
                    } else if (((String)object).equals("SubsystemL1")) {
                        new ViewerSubsystemL1().getView(connection, viewerRequest, viewerResponse);
                    } else if (((String)object).equals("OtherL1")) {
                        new ViewerOtherL1().getView(connection, viewerRequest, viewerResponse, n);
                    }
                }
            } else if (viewerRequest.getRequestType() == 2) {
                ViewerRequestHandler.getRefreshInterval(connection, viewerRequest, viewerResponse);
            } else if (viewerRequest.getRequestType() == 1) {
                ViewerRequestHandler.setRefreshInterval(connection, viewerRequest, viewerResponse);
            } else if (viewerRequest.getRequestType() == 3) {
                new ViewerProbeMgr();
                ViewerProbeMgr.probe(connection, string, viewerRequest, viewerResponse);
            } else if (viewerRequest.getRequestType() == 4) {
                ViewerRequestHandler.getTopoSettings(connection, string, viewerRequest, viewerResponse);
            } else if (viewerRequest.getRequestType() == 5) {
                ViewerRequestHandler.setTopoSettings(connection, string, viewerRequest, viewerResponse);
            }
        }
        catch (Throwable throwable) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(ViewerRequestHandler.class.getName(), "handleRequest", throwable);
            }
            if (throwable instanceof Exception) {
                object = new ByteArrayOutputStream();
                PrintWriter printWriter = new PrintWriter((OutputStream)object);
                throwable.printStackTrace(printWriter);
                printWriter.flush();
                object2 = new Throwable(((ByteArrayOutputStream)object).toString());
            }
            viewerResponse.addResponse(1, (Serializable)object2);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerRequestHandler.class.getName(), "handleRequest", "");
        }
        if (debug) {
            System.out.println("EXIT- handleRequest()");
        }
        object2 = new ByteArrayOutputStream();
        object = null;
        try {
            object = new ObjectOutputStream((OutputStream)object2);
            ((ObjectOutputStream)object).writeObject(viewerResponse);
            ((ObjectOutputStream)object).flush();
            ((ObjectOutputStream)object).close();
            byte[] byArray = ((ByteArrayOutputStream)object2).toByteArray();
            int n = byArray.length;
            if (debug) {
                System.out.println("Total Size: " + n);
            }
        }
        catch (IOException iOException) {}
        return viewerResponse;
    }

    public static void getRefreshInterval(Connection connection, ViewerRequest viewerRequest, ViewerResponse viewerResponse) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_TIMEOUT);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n = (Integer)resultSet.getObject("TIMEOUT");
                if (n == null) {
                    n = new Integer(300);
                }
                viewerResponse.setRefreshRate(n);
            }
        }
        finally {
            block17: {
                block16: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block16;
                        TraceLogger.exception(ViewerRequestHandler.class.getName(), "getRefreshInterval", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block17;
                    TraceLogger.exception(ViewerRequestHandler.class.getName(), "getRefreshInterval", sQLException);
                }
            }
        }
    }

    public static void setRefreshInterval(Connection connection, ViewerRequest viewerRequest, ViewerResponse viewerResponse) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(UPDATE_TIMEOUT);
            preparedStatement.setInt(1, viewerRequest.getRefreshRate());
            preparedStatement.executeUpdate();
            connection.commit();
        }
        finally {
            block15: {
                block14: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block14;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "setRefreshInterval", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block15;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "setRefreshInterval", sQLException);
                }
            }
        }
    }

    public static Timestamp getLatestUpdate(Connection connection) {
        return null;
    }

    public static void getTopoSettings(Connection connection, String string, ViewerRequest viewerRequest, ViewerResponse viewerResponse) throws SQLException {
        TopoSetting topoSetting = TopoSettingHandler.readSettings(connection, string);
        viewerResponse.setTopoSettings(topoSetting);
    }

    public static void setTopoSettings(Connection connection, String string, ViewerRequest viewerRequest, ViewerResponse viewerResponse) throws SQLException {
        TopoSetting topoSetting = viewerRequest.getTopoSettings();
        if (topoSetting == null) {
            return;
        }
        TopoSettingHandler.writeSettings(connection, string, topoSetting);
    }
}

