/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelTapeLibraryL1;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2TapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSanL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerTapeLibraryL2;

public class ViewerTapeLibraryL1
extends ViewerSanL1 {
    private static boolean debug = false;
    public static final String SELECT_TAPE_LIBRARY = "SELECT distinct \t\tT_RES_TAPE_LIBRARY.PREFIX_ID, \t\tT_RES_TAPE_LIBRARY.TAPE_LIBRARY_ID TAPE_LIBRARY_ID, \t\tCASE WHEN T_RES_TAPE_LIBRARY.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_TAPE_LIBRARY.USER_PROVIDED_NAME)\t\t!= '' THEN T_RES_TAPE_LIBRARY.USER_PROVIDED_NAME \t\t\t WHEN T_RES_TAPE_LIBRARY.DISPLAY_NAME IS NOT NULL THEN T_RES_TAPE_LIBRARY.DISPLAY_NAME \t\t\t ELSE T_RES_TAPE_LIBRARY.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_TAPE_LIBRARY.FIRMWARE_VERSION FIRMWARE_VERSION, \t\tT_RES_TAPE_LIBRARY.MAX_CARTRIDGES MAX_CARTRIDGES, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_TAPE_LIBRARY.SERIAL_NUMBER SERIAL_NUMBER, \t\tT_RES_TAPE_LIBRARY.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_TAPE_LIBRARY.DETECTABLE DETECTABLE, \t\tT_RES_TAPE_LIBRARY.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_TAPE_LIBRARY.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_TAPE_LIBRARY.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_TAPE_LIBRARY.TOTAL_DRIVES, \t\tT_RES_TAPE_LIBRARY.TOTAL_CARTRIDGES, \t\tT_RES_TAPE_LIBRARY.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_TAPE_LIBRARY.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_TAPE_LIBRARY.USER_ATTRIB3 USER_ATTRIB3 FROM     T_VIEW_VTAPE_LIBRARY T_RES_TAPE_LIBRARY left outer join T_RES_VENDOR VENDOR on  \t T_RES_TAPE_LIBRARY.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on \t T_RES_TAPE_LIBRARY.MODEL_ID = MODEL.MODEL_ID WHERE     T_RES_TAPE_LIBRARY.PREFIX_ID = ? and \t T_RES_TAPE_LIBRARY.TAPE_LIBRARY_ID = ? ";
    public static final String SELECT_PORTS_FROM_TAPE = "SELECT     CASE WHEN T_RES_PORT.DISPLAY_NAME IS NOT NULL and RTRIM(T_RES_PORT.DISPLAY_NAME) != '' THEN T_RES_PORT.DISPLAY_NAME \t\t  ELSE T_RES_PORT.NAME \t END DISPLAY_NAME,     T_RES_PORT.NAME || '+' || CAST(T_RES_PORT.NAME_FORMAT as CHAR) NATURAL_KEY, \t T_RES_PORT.PORT_ID PORT_ID, \t T_RES_PORT.NAME NAME, \t T_RES_PORT.NAME_FORMAT NAME_FORMAT, \t T_RES_PORT.PORT_NUMBER PORT_NUMBER, \t T_RES_PORT.TYPE TYPE, \t T_RES_PORT.PORT_SPEED PORT_SPEED, \t T_RES_PORT.DETECTABLE DETECTABLE, \t T_RES_PORT.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_PORT.CONSOLIDATED_STATUS CONSOLIDATED_STATUS FROM     T_VIEW_VTAPE2PORT TAPE2PORT, T_RES_PORT WHERE     TAPE2PORT.PREFIX_ID = ? and \t TAPE2PORT.TAPE_LIBRARY_ID = ? and     TAPE2PORT.PORT_ID = T_RES_PORT.PORT_ID";
    public static final String SELECT_SWITCH_FROM_TAPE = "SELECT distinct \t T_RES_SWITCH.PREFIX_ID,     CASE WHEN T_RES_SWITCH.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.DISPLAY_NAME) != '' THEN T_RES_SWITCH.DISPLAY_NAME          WHEN T_RES_SWITCH.LOGICAL_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.LOGICAL_NAME) != '' THEN T_RES_SWITCH.LOGICAL_NAME \t\t  ELSE T_RES_SWITCH.SWITCH_WWN \t END DISPLAY_NAME,     T_RES_SWITCH.SWITCH_ID SWITCH_ID,     T_RES_SWITCH.LOGICAL_NAME LOGICAL_NAME,     T_RES_SWITCH.SWITCH_WWN SWITCH_WWN,     T_RES_SWITCH.SERIAL_NUMBER SERIAL_NUMBER,     T_RES_SWITCH.DESCRIPTION DESCRIPTION,     T_RES_SWITCH.IP_ADDRESS IP_ADDRESS,     T_RES_SWITCH.DOMAIN DOMAIN,     T_RES_SWITCH.VERSION VERSION,     MODEL.MODEL_NAME MODEL,     VENDOR.VENDOR_NAME VENDOR, \t T_RES_SWITCH.PARENT_SWITCH_WWN PARENT_SWITCH_WWN, \t T_RES_SWITCH.MGMT_URL_ADDR DEFAULT_MANAGER, \t T_RES_SWITCH.DETECTABLE DETECTABLE, \t T_RES_SWITCH.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_SWITCH.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t T_RES_SWITCH.PROPAGATED_STATUS PROPAGATED_STATUS, \t T_RES_SWITCH.USER_ATTRIB1 USER_ATTRIB1, \t T_RES_SWITCH.USER_ATTRIB2 USER_ATTRIB2, \t T_RES_SWITCH.USER_ATTRIB3 USER_ATTRIB3 ,\t\tSWITCH2TAPE.SWITCH_PORT_ID PORT_ID FROM T_VIEW_VSWITCH2TAPE SWITCH2TAPE, \t T_VIEW_VSWITCH T_RES_SWITCH left outer join T_RES_VENDOR VENDOR on \t T_RES_SWITCH.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on\t T_RES_SWITCH.MODEL_ID = MODEL.MODEL_ID where     T_RES_SWITCH.PREFIX_ID = SWITCH2TAPE.SWITCH_PREFIX_ID and \t T_RES_SWITCH.SWITCH_ID = SWITCH2TAPE.SWITCH_ID AND \t SWITCH2TAPE.TAPE_PREFIX_ID = ? and \t SWITCH2TAPE.TAPE_LIBRARY_ID = ? ";
    public static final String SELECT_SWITCH2TAPE_FROM_TAPE = "SELECT distinct     SWITCH2TAPE.SWITCH_PREFIX_ID PREFIX_ID, \t SWITCH2TAPE.SWITCH_ID SWITCH_ID, \t SWITCH2TAPE.PORT2PORT_ID PORT2PORT_ID,\t SWITCH2TAPE.DETECTABLE DETECTABLE FROM T_VIEW_VSWITCH2TAPE SWITCH2TAPE WHERE \t SWITCH2TAPE.TAPE_PREFIX_ID = ? and \t SWITCH2TAPE.TAPE_LIBRARY_ID = ?";
    public static final String SELECT_ZONE2MEMBER_FROM_TAPE = "SELECT DISTINCT     PORT2ZONE.ZONE_ID ZONE_ID,     'tapelibrary:' || CAST(TAPE2PORT.TAPE_LIBRARY_ID as CHAR) ENTITY_KEY FROM T_VIEW_VTAPE2PORT TAPE2PORT, T_VIEW_PORT2ZONE PORT2ZONE WHERE \t TAPE2PORT.TAPE_LIBRARY_ID = ? and     TAPE2PORT.PORT_ID = PORT2ZONE.PORT_ID ";
    public static final String SELECT_SANS_FROM_SWITCH_FROM_TAPE = "SELECT \t SWITCH2FABRIC.PREFIX_ID PREFIX_ID, \t SWITCH2FABRIC.SWITCH_ID SWITCH_ID, \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3  FROM     T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN, T_VIEW_VSWITCH2TAPE SWITCH2TAPE, T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC WHERE     T_RES_FABRIC.FABRIC_ID = SWITCH2FABRIC.FABRIC_ID and \t SWITCH2FABRIC.PREFIX_ID = SWITCH2TAPE.SWITCH_PREFIX_ID and \t SWITCH2FABRIC.SWITCH_ID = SWITCH2TAPE.SWITCH_ID and     SWITCH2TAPE.TAPE_PREFIX_ID = ? and \t SWITCH2TAPE.TAPE_LIBRARY_ID = ?";
    public static String SELECT_SANS_FROM_TAPE = "SELECT     TAPE2FABRIC.PREFIX_ID PREFIX_ID,     TAPE2FABRIC.FABRIC_ID FABRIC_ID,     TAPE2FABRIC.TAPE_LIBRARY_ID TAPE_LIBRARY_ID FROM T_VIEW_VTAPE2FABRIC TAPE2FABRIC WHERE \t TAPE2FABRIC.PREFIX_ID = ? and \t TAPE2FABRIC.TAPE_LIBRARY_ID = ? ";

    public void getSwitchFromTape(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerTapeLibraryL1.class.getName(), "getSwitchFromTape", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("switch ...");
        }
        GraphTapeLibrary cfr_ignored_0 = (GraphTapeLibrary)hashMap.get(String.valueOf(string) + n);
        try {
            preparedStatement = connection.prepareStatement(SELECT_SWITCH_FROM_TAPE);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = (String)resultSet.getObject("PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("SWITCH_ID");
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerTapeLibraryL1.class.getName(), "getSwitchFromTape", "NULL column field SWITCH_WWN from switch");
                    continue;
                }
                String string3 = String.valueOf(string2) + n2;
                GraphSwitch graphSwitch = null;
                graphSwitch = (GraphSwitch)hashMap.get(string3);
                if (graphSwitch == null) {
                    graphSwitch = new GraphSwitch(string3);
                    this.populator.populateSwitch(resultSet, graphSwitch, true);
                    hashMap.put(string3, graphSwitch);
                    graphModel.put(graphSwitch);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerTapeLibraryL1.class.getName(), "getSwitchFromTape", "Duplicated host entry:" + string3);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerTapeLibraryL1.class.getName(), "getSwitch2TapeFromSan", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerTapeLibraryL1.class.getName(), "getSwitch2TapeFromSan", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("switch totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerTapeLibraryL1.class.getName(), "getSwitchFromTape", "");
        }
    }

    public void getSwitch2TapeFromSan(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        GraphTapeLibrary graphTapeLibrary;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerTapeLibraryL1.class.getName(), "getSwitch2TapeFromSan", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        l = System.currentTimeMillis();
        if (debug) {
            System.out.println("Switch2Tape...");
        }
        if ((graphTapeLibrary = (GraphTapeLibrary)hashMap.get(String.valueOf(string) + n)) == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage(1, ViewerTapeLibraryL1.class.getName(), "getSwitch2TapeFromSan", "Tape not fould: tape:" + n);
                TraceLogger.exit(ViewerTapeLibraryL1.class.getName(), "getSwitch2TapeFromSan", "");
            }
            return;
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_SWITCH2TAPE_FROM_TAPE);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = (String)resultSet.getObject("PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("SWITCH_ID");
                Integer n3 = (Integer)resultSet.getObject("PORT2PORT_ID");
                GraphSwitch graphSwitch = (GraphSwitch)hashMap.get(String.valueOf(string2) + n2);
                if (graphTapeLibrary != null && graphSwitch != null) {
                    String string3 = "port2port:" + string2 + n2 + ',' + string + n + ',' + n3;
                    if (hashMap.get(string3) == null) {
                        GraphSwitch2TapeLibrary graphSwitch2TapeLibrary = new GraphSwitch2TapeLibrary(string3);
                        graphSwitch2TapeLibrary.setTapeLibraryID((GraphTapeLibrary.ID)graphTapeLibrary.getEntityID());
                        graphSwitch2TapeLibrary.setSwitchID((GraphSwitch.ID)graphSwitch.getEntityID());
                        this.populator.populatePort2Port(resultSet, graphSwitch2TapeLibrary);
                        graphModel.put(graphSwitch2TapeLibrary);
                        hashMap.put(string3, graphSwitch2TapeLibrary);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerTapeLibraryL1.class.getName(), "getSwitch2TapeFromSan", "Switch2tape already exists!");
                    continue;
                }
                if (graphSwitch != null) continue;
                if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(1, ViewerTapeLibraryL1.class.getName(), "getSwitch2TapeFromSan", "Switch not fould: switch:" + n2);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerTapeLibraryL1.class.getName(), "getSwitch2TapeFromSan", "Tape not fould: tape:" + n);
            }
        }
        finally {
            block25: {
                block24: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block24;
                        TraceLogger.exception(ViewerTapeLibraryL1.class.getName(), "getSwitch2TapeFromSan", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block25;
                    TraceLogger.exception(ViewerTapeLibraryL1.class.getName(), "getSwitch2TapeFromSan", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("Switch2Tape totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerTapeLibraryL1.class.getName(), "getSwitch2TapeFromSan", "");
        }
    }

    public void getZonesFromTape(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
    }

    public void getZonesFromEntitiesConnectedToTape(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
    }

    public void getSansFromTape(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        this.getSansFromTape(connection, graphModel, hashMap, string, new Integer(n), SELECT_SANS_FROM_TAPE);
    }

    public void getSansFromSwitch(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        this.getSansFromSwitch(connection, graphModel, hashMap, string, new Integer(n), SELECT_SANS_FROM_SWITCH_FROM_TAPE);
    }

    public void commit(Connection connection) {
        block2: {
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception(ViewerServerL2.class.getName(), "commit", sQLException);
            }
        }
    }

    public GraphTapeLibrary getTapeLibrary(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerTapeLibraryL2.class.getName(), "getTapeLibrary", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("tape...");
        }
        GraphTapeLibrary graphTapeLibrary = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_TAPE_LIBRARY);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                try {
                    String string2 = (String)resultSet.getObject("PREFIX_ID");
                    Integer n2 = (Integer)resultSet.getObject("TAPE_LIBRARY_ID");
                    if (n2 == null) {
                        if (!TraceLogger.enableTrace) continue;
                        TraceLogger.traceMessage(1, ViewerTapeLibraryL2.class.getName(), "getTapeLibrary", "Tape ID is NULL");
                        continue;
                    }
                    String string3 = String.valueOf(string2) + n2;
                    if (hashMap == null || hashMap.get(string3) == null) {
                        graphTapeLibrary = new GraphTapeLibrary(string3);
                        this.populator.populateTapeLibrary(resultSet, graphTapeLibrary);
                        if (graphModel != null) {
                            graphModel.put(graphTapeLibrary);
                        }
                        if (hashMap == null) continue;
                        hashMap.put(string3, graphTapeLibrary);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerTapeLibraryL2.class.getName(), "getTapeLibrary", "Duplicated Array entry:" + string3);
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getTapeLibrary", exception);
                }
            }
        }
        finally {
            block25: {
                block24: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block24;
                        TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getTapeLibrary", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block25;
                    TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getTapeLibrary", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("tape totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerTapeLibraryL2.class.getName(), "getTapeLibrary", "");
        }
        return graphTapeLibrary;
    }

    public void getView(Connection connection, ViewerRequest viewerRequest, ViewerResponse viewerResponse) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerTapeLibraryL1.class.getName(), "getView", "");
        }
        GraphModelTapeLibraryL1 graphModelTapeLibraryL1 = null;
        GraphModel.MultiEntityID multiEntityID = (GraphModel.MultiEntityID)viewerRequest.getModelID();
        Vector vector = multiEntityID.getChildFocusEntityIDs();
        String string = null;
        HashMap hashMap = new HashMap();
        Timestamp timestamp = viewerRequest.getTimestamp();
        Timestamp timestamp2 = null;
        if (timestamp2 == null || timestamp == null || timestamp2.after(timestamp)) {
            graphModelTapeLibraryL1 = new GraphModelTapeLibraryL1((GraphModelTapeLibraryL1.ID)viewerRequest.getModelID());
            for (GraphTapeLibrary.ID iD : vector) {
                int n;
                string = (String)iD.getID();
                int n2 = string.indexOf(58);
                String string2 = string.substring(0, n2 + 1);
                GraphTapeLibrary graphTapeLibrary = this.getTapeLibrary(connection, graphModelTapeLibraryL1, hashMap, string2, n = Integer.parseInt(string = string.substring(n2 + 1)));
                if (graphTapeLibrary == null) continue;
                this.getSwitchFromTape(connection, graphModelTapeLibraryL1, hashMap, string2, n);
                this.getSwitch2TapeFromSan(connection, graphModelTapeLibraryL1, hashMap, string2, n);
                this.getSansFromSwitch(connection, (GraphModel)graphModelTapeLibraryL1, hashMap, string2, n);
                if (viewerRequest.getModelID().isNeedZoneData()) {
                    this.getZonesFromTape(connection, graphModelTapeLibraryL1, hashMap, n);
                }
                this.commit(connection);
            }
            graphModelTapeLibraryL1.setWithZoneData(viewerRequest.getModelID().isNeedZoneData());
            viewerResponse.addResponse(0, graphModelTapeLibraryL1);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerTapeLibraryL1.class.getName(), "getView", "");
        }
    }

    public void main(String[] stringArray) {
    }
}

