/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelTapeLibraryL2;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphMediaChanger;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeDrive;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeDrive2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary2MediaChanger;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary2TapeDrive;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerTapeLibraryL1;

public class ViewerTapeLibraryL2
extends ViewerTapeLibraryL1 {
    private static boolean debug = false;
    public static String SELECT_SANS_FROM_TAPE = "SELECT distinct     TAPE2FABRIC.PREFIX_ID, \t TAPE2FABRIC.FABRIC_ID,     TAPE2FABRIC.TAPE_LIBRARY_ID FROM T_VIEW_VTAPE2FABRIC TAPE2FABRIC WHERE     TAPE2FABRIC.PREFIX_ID = ? and \t TAPE2FABRIC.TAPE_LIBRARY_ID = ? ";
    public static final String SELECT_PORT2PORT_FROM_TAPE = "select     PORT2PORT.PORT_ID1 PORT_ID,     PORT2PORT.PORT_ID2 PORT2_ID, \t CASE \t\tWHEN PORT1.DISPLAY_NAME IS NOT NULL AND RTRIM(PORT1.DISPLAY_NAME) != '' THEN PORT1.DISPLAY_NAME \t\tELSE PORT1.NAME \t END PORT1_NAME, \t PORT1.PORT_NUMBER PORT_NUMBER1, \t CASE \t\tWHEN PORT2.DISPLAY_NAME IS NOT NULL AND RTRIM(PORT2.DISPLAY_NAME)!= '' THEN PORT2.DISPLAY_NAME \t\tELSE PORT2.NAME \t END PORT2_NAME, \t PORT2.PORT_NUMBER PORT_NUMBER2,     PORT2PORT.PORT2PORT_ID PORT2PORT_ID, \t PORT2PORT.DETECTABLE DETECTABLE,\t ENTITY2PORT.PREFIX_ID,\t ENTITY2PORT.ENTITY_ID  from     T_RES_PORT PORT1, T_RES_PORT PORT2, T_VIEW_VTAPE2PORT TAPE2PORT, T_VIEW_PORT2PORT PORT2PORT, T_VIEW_ENTITY2PORT ENTITY2PORT where     ENTITY2PORT.PORT_ID = PORT1.PORT_ID and \t PORT1.PORT_ID = PORT2PORT.PORT_ID1 and \t PORT2.PORT_ID = PORT2PORT.PORT_ID2 and     TAPE2PORT.PORT_ID = PORT2PORT.PORT_ID1 and     TAPE2PORT.PREFIX_ID = ? and \t TAPE2PORT.TAPE_LIBRARY_ID = ? ";
    public static final String SELECT_PORTS_FROM_TAPE = "SELECT     CASE WHEN T_RES_PORT.DISPLAY_NAME IS NOT NULL and RTRIM(T_RES_PORT.DISPLAY_NAME) != '' THEN T_RES_PORT.DISPLAY_NAME \t\t  ELSE T_RES_PORT.NAME \t END DISPLAY_NAME,     T_RES_PORT.NAME || '+' || CAST(T_RES_PORT.NAME_FORMAT as CHAR) NATURAL_KEY, \t T_RES_PORT.PORT_ID PORT_ID, \t T_RES_PORT.NAME NAME, \t T_RES_PORT.NAME_FORMAT NAME_FORMAT, \t T_RES_PORT.PORT_NUMBER PORT_NUMBER, \t T_RES_PORT.TYPE TYPE, \t T_RES_PORT.PORT_SPEED PORT_SPEED, \t T_RES_PORT.DETECTABLE DETECTABLE, \t T_RES_PORT.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_PORT.CONSOLIDATED_STATUS CONSOLIDATED_STATUS FROM T_VIEW_VTAPE2PORT TAPE2PORT,    T_RES_PORT WHERE     TAPE2PORT.PREFIX_ID = ? and \t TAPE2PORT.TAPE_LIBRARY_ID = ? and     TAPE2PORT.PORT_ID = T_RES_PORT.PORT_ID ";
    public static final String SELECT_SWITCH_FROM_TAPE = "SELECT distinct \t T_RES_SWITCH.PREFIX_ID,     CASE WHEN T_RES_SWITCH.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.DISPLAY_NAME) != '' THEN T_RES_SWITCH.DISPLAY_NAME          WHEN T_RES_SWITCH.LOGICAL_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.LOGICAL_NAME) != '' THEN T_RES_SWITCH.LOGICAL_NAME \t\t  ELSE T_RES_SWITCH.SWITCH_WWN \t END DISPLAY_NAME,     T_RES_SWITCH.SWITCH_ID SWITCH_ID,     T_RES_SWITCH.LOGICAL_NAME LOGICAL_NAME,     T_RES_SWITCH.SWITCH_WWN SWITCH_WWN,     T_RES_SWITCH.SERIAL_NUMBER SERIAL_NUMBER,     T_RES_SWITCH.DESCRIPTION DESCRIPTION,     T_RES_SWITCH.IP_ADDRESS IP_ADDRESS,     T_RES_SWITCH.DOMAIN DOMAIN,     T_RES_SWITCH.VERSION VERSION,     MODEL.MODEL_NAME MODEL,     VENDOR.VENDOR_NAME VENDOR, \t T_RES_SWITCH.PARENT_SWITCH_WWN PARENT_SWITCH_WWN, \t T_RES_SWITCH.MGMT_URL_ADDR DEFAULT_MANAGER, \t T_RES_SWITCH.DETECTABLE DETECTABLE, \t T_RES_SWITCH.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_SWITCH.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t T_RES_SWITCH.PROPAGATED_STATUS PROPAGATED_STATUS, \t T_RES_SWITCH.USER_ATTRIB1 USER_ATTRIB1, \t T_RES_SWITCH.USER_ATTRIB2 USER_ATTRIB2, \t T_RES_SWITCH.USER_ATTRIB3 USER_ATTRIB3 ,\tSWITCH2TAPE.SWITCH_PORT_ID PORT_ID FROM T_VIEW_VSWITCH2TAPE SWITCH2TAPE, T_VIEW_VSWITCH T_RES_SWITCH left outer join T_RES_MODEL MODEL on \tT_RES_SWITCH.MODEL_ID = MODEL.MODEL_ID left outer join T_RES_VENDOR VENDOR on \tT_RES_SWITCH.VENDOR_ID = VENDOR.VENDOR_ID WHERE     T_RES_SWITCH.SWITCH_ID = SWITCH2TAPE.SWITCH_ID and \t SWITCH2TAPE.TAPE_PREFIX_ID = ? and \t SWITCH2TAPE.TAPE_LIBRARY_ID = ? ";
    public static String SELECT_SANS_FROM_SWITCH_FROM_TAPE = "SELECT distinct     TAPE2FABRIC.PREFIX_ID, \t TAPE2FABRIC.FABRIC_ID,     TAPE2FABRIC.TAPE_LIBRARY_ID FROM T_VIEW_VSWITCH2TAPE SWITCH2TAPE, T_VIEW_VTAPE2FABRIC TAPE2FABRIC WHERE     TAPE2FABRIC.PREFIX_ID = SWITCH2TAPE.TAPE_PREFIX_ID and \t TAPE2FABRIC.TAPE_LIBRARY_ID = SWITCH2TAPE.TAPE_LIBRARY_ID and     SWITCH2TAPE.SWITCH_PREFIX_ID = ? and \t SWITCH2TAPE.SWITCH_ID = ?";
    public static final String SELECT_TAPE_DRIVES = "SELECT distinct    CASE WHEN T_RES_TAPE_DRIVE.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_TAPE_DRIVE.DISPLAY_NAME) != '' THEN T_RES_TAPE_DRIVE.DISPLAY_NAME    \t  ELSE CAST (T_RES_TAPE_DRIVE.TAPE_DRIVE_ID as CHAR)    END DISPLAY_NAME,    LOCATION.LOCATION_COORDINATES LOCATION, \tT_RES_TAPE_DRIVE.TAPE_DRIVE_ID TAPE_DRIVE_ID, \tT_RES_TAPE_DRIVE.OPERATIONAL_STATUS OPERATIONAL_STATUS, \tT_RES_TAPE_DRIVE.DETECTABLE DETECTABLE, \tT_RES_TAPE_DRIVE.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \tT_RES_TAPE_DRIVE.PROPAGATED_STATUS PROPAGATED_STATUS, \tT_RES_TAPE_DRIVE.MOUNT_COUNT MOUNT_COUNT, \tT_RES_TAPE_DRIVE.NEEDS_CLEANING NEEDS_CLEANING, \tT_RES_TAPE_DRIVE.FIRMWARE_VERSION FIRMWARE_VERSION, \tT_RES_TAPE_DRIVE.USER_ATTRIB1 USER_ATTRIB1, \tT_RES_TAPE_DRIVE.USER_ATTRIB2 USER_ATTRIB2, \tT_RES_TAPE_DRIVE.USER_ATTRIB3 USER_ATTRIB3 FROM     T_RES_TAPE_DRIVE left outer join T_RES_TAPE_MEDIA_LOCATION LOCATION on \t T_RES_TAPE_DRIVE.LOCATION_ID = LOCATION.LOCATION_ID WHERE   \t T_RES_TAPE_DRIVE.TAPE_LIBRARY_ID = ?  ";
    public static final String SELECT_MEDIA_CHANGER = "SELECT distinct    CASE WHEN T_RES_TAPE_MEDIA_CHANGER.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_TAPE_MEDIA_CHANGER.DISPLAY_NAME) != '' THEN T_RES_TAPE_MEDIA_CHANGER.DISPLAY_NAME    \t  ELSE CAST (T_RES_TAPE_MEDIA_CHANGER.TAPE_MEDIA_CHANGER_ID as CHAR)    END DISPLAY_NAME,    T_RES_TAPE_MEDIA_CHANGER.TAPE_MEDIA_CHANGER_ID TAPE_MEDIA_CHANGER_ID, \tT_RES_TAPE_MEDIA_CHANGER.OPERATIONAL_STATUS OPERATIONAL_STATUS, \tT_RES_TAPE_MEDIA_CHANGER.DETECTABLE DETECTABLE, \tT_RES_TAPE_MEDIA_CHANGER.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \tT_RES_TAPE_MEDIA_CHANGER.PROPAGATED_STATUS PROPAGATED_STATUS, \tT_RES_TAPE_MEDIA_CHANGER.FIRMWARE_VERSION FIRMWARE_VERSION, \tT_RES_TAPE_MEDIA_CHANGER.USER_ATTRIB1 USER_ATTRIB1, \tT_RES_TAPE_MEDIA_CHANGER.USER_ATTRIB2 USER_ATTRIB2, \tT_RES_TAPE_MEDIA_CHANGER.USER_ATTRIB3 USER_ATTRIB3 FROM     T_RES_TAPE_MEDIA_CHANGER WHERE   \t T_RES_TAPE_MEDIA_CHANGER.TAPE_LIBRARY_ID = ?  ";
    public static final String SELECT_TAPE_DRIVES2PORT_FROM_TAPE = "SELECT distinct \t T_RES_TAPE_DRIVE.TAPE_DRIVE_ID TAPE_DRIVE_ID,     PORT.PORT_ID PORT_ID FROM     T_RES_NODE NODE,     T_RES_PORT PORT, T_RES_TAPE_DRIVE WHERE   \t T_RES_TAPE_DRIVE.TAPE_LIBRARY_ID = ? and     T_RES_TAPE_DRIVE.NODE_ID = NODE.NODE_ID and     NODE.NODE_ID = PORT.NODE_ID  ";
    public static final String SELECT_FABRIC_FROM_ZONES_FROM_TAPE = "SELECT DISTINCT \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3 FROM T_VIEW_VTAPE2PORT TAPE2PORT,     T_VIEW_PORT2ZONE PORT2ZONE,  \t T_RES_ZONE, T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN WHERE    TAPE2PORT.PREFIX_ID = ? and    TAPE2PORT.TAPE_LIBRARY_ID = ? and \tTAPE2PORT.PORT_ID = PORT2ZONE.PORT_ID and \tPORT2ZONE.ZONE_ID = T_RES_ZONE.ZONE_ID and \tT_RES_ZONE.FABRIC_WWN = T_RES_FABRIC.FABRIC_WWN";
    public static final String SELECT_ZONES_FROM_TAPE = "SELECT DISTINCT    T_RES_ZONE.ZONE_ID ZONE_ID, \tT_RES_ZONE.ZONE_TYPE ZONE_TYPE, \tT_RES_ZONE.ACTIVE ACTIVE,\tT_RES_ZONE.ZONE_NAME ZONE_NAME, \tT_RES_ZONE.FABRIC_WWN FABRIC_WWN, \tT_RES_ZONE.DESCRIPTION DESCRIPTION,  \tT_RES_ZONE.ZONE_NAME DISPLAY_NAME , \tFABRIC.FABRIC_ID FROM T_VIEW_VTAPE2PORT TAPE2PORT, T_VIEW_PORT2ZONE PORT2ZONE, T_RES_ZONE, T_RES_FABRIC FABRIC WHERE \t TAPE2PORT.PREFIX_ID = ? and \t TAPE2PORT.TAPE_LIBRARY_ID = ? and     TAPE2PORT.PORT_ID = PORT2ZONE.PORT_ID and     PORT2ZONE.ZONE_ID = T_RES_ZONE.ZONE_ID and \t T_RES_ZONE.FABRIC_WWN = FABRIC.FABRIC_WWN ";
    public static final String SELECT_ZONE2MEMBER_FROM_TAPE = "SELECT DISTINCT     PORT2ZONE2.ZONE_ID ZONE_ID,     PORT2ZONE2.PORT_ID PORT_ID,\t ENTITY_TO_PORT.TYPE, \t ENTITY_TO_PORT.PREFIX_ID, \t ENTITY_TO_PORT.ENTITY_ID, \t ENTITY_TO_PORT.DISPLAY_NAME, \t ENTITY_TO_PORT.PORT_DISPLAY_NAME, \t PORT2ZONE2.MEMBER_NAME, \t PORT2ZONE2.ZONE_MEMBER_ID,     ENTITY_TO_PORT.PORT_NUMBER FROM T_VIEW_VTAPE2PORT TAPE2PORT,T_VIEW_PORT2ZONE PORT2ZONE1,T_VIEW_PORT2ZONE PORT2ZONE2 left outer join \t T_VIEW_ENTITY_TO_PORT ENTITY_TO_PORT on \t PORT2ZONE2.PORT_ID = ENTITY_TO_PORT.PORT_ID  WHERE     TAPE2PORT.PREFIX_ID = ? and \t TAPE2PORT.TAPE_LIBRARY_ID = ? and     TAPE2PORT.PORT_ID = PORT2ZONE1.PORT_ID and \t PORT2ZONE1.ZONE_ID = PORT2ZONE2.ZONE_ID  ";
    public static final String SELECT_ZSET2ZONE_FROM_TAPE = "SELECT DISTINCT     ZSET2ZONE.ZONE_ID,     ZSET2ZONE.ZSET_ID FROM T_VIEW_VTAPE2PORT TAPE2PORT, T_VIEW_PORT2ZONE PORT2ZONE,  \tT_RES_ZSET2ZONE ZSET2ZONE WHERE \t TAPE2PORT.PREFIX_ID = ? and     TAPE2PORT.TAPE_LIBRARY_ID = ? and     TAPE2PORT.PORT_ID = PORT2ZONE.PORT_ID and     PORT2ZONE.ZONE_ID = ZSET2ZONE.ZONE_ID ";
    public static final String SELECT_ZSET_FROM_TAPE = "SELECT DISTINCT    T_RES_ZSET.ZSET_ID, \tT_RES_ZSET.ACTIVE ACTIVE,\tT_RES_ZSET.ZSET_NAME ZSET_NAME, \tT_RES_ZSET.FABRIC_WWN FABRIC_WWN, \tT_RES_ZSET.DESCRIPTION DESCRIPTION,    T_RES_ZSET.ZSET_NAME DISPLAY_NAME , \tFABRIC.FABRIC_ID FROM T_VIEW_VTAPE2PORT TAPE2PORT, T_VIEW_PORT2ZSET PORT2ZSET, \tT_RES_ZSET, T_RES_FABRIC FABRIC WHERE \t TAPE2PORT.PREFIX_ID = ? and \t TAPE2PORT.TAPE_LIBRARY_ID = ? and     TAPE2PORT.PORT_ID = PORT2ZSET.PORT_ID and     PORT2ZSET.ZSET_ID = T_RES_ZSET.ZSET_ID and \t T_RES_ZSET.FABRIC_WWN = FABRIC.FABRIC_WWN ";

    public void getTapeDrivesFromTape(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Integer n2;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerTapeLibraryL2.class.getName(), "getTapeDrivesFromTape", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        GraphTapeLibrary graphTapeLibrary = (GraphTapeLibrary)hashMap.get("tapelibrary:" + n);
        if (graphTapeLibrary == null) {
            return;
        }
        if (debug) {
            System.out.println("tapedrives ...");
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_TAPE_DRIVES);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n2 = (Integer)resultSet.getObject("TAPE_DRIVE_ID");
                object4 = "tapedrive:" + n2;
                if (hashMap.get(object4) == null) {
                    object3 = new GraphTapeDrive((String)object4);
                    this.populator.populateTapeDrive(resultSet, (GraphTapeDrive)object3);
                    hashMap.put(object4, object3);
                    graphModel.put((GraphEntity)object3);
                    object2 = "tape2tapedrive:" + n + ',' + n2;
                    object = new GraphTapeLibrary2TapeDrive((String)object2);
                    ((GraphTapeLibrary2TapeDrive)object).setTapeLibraryID((GraphTapeLibrary.ID)graphTapeLibrary.getEntityID());
                    ((GraphTapeLibrary2TapeDrive)object).setTapeDriveID((GraphTapeDrive.ID)((GraphEntity)object3).getEntityID());
                    hashMap.put(object2, object);
                    graphModel.put((GraphEntity)object);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerTapeLibraryL2.class.getName(), "getTapeDrivesFromTape", "Duplicated tape drive:" + (String)object4);
            }
        }
        finally {
            block40: {
                block39: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block39;
                        TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block40;
                    TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", exception);
                }
            }
        }
        if (debug) {
            System.out.println("tapedrives totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        l = System.currentTimeMillis();
        if (debug) {
            System.out.println("tapedrive2port ...");
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_TAPE_DRIVES2PORT_FROM_TAPE);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n2 = (Integer)resultSet.getObject("TAPE_DRIVE_ID");
                object4 = (Integer)resultSet.getObject("PORT_ID");
                object3 = "tapedrive:" + n2;
                object2 = (GraphTapeDrive)hashMap.get(object3);
                if (object2 != null) {
                    object = "Port:" + object4;
                    GraphFCPort graphFCPort = (GraphFCPort)hashMap.get(object);
                    if (graphFCPort != null) {
                        String string = "tapedrive2port:" + n2 + ',' + object4;
                        GraphTapeDrive2FCPort graphTapeDrive2FCPort = new GraphTapeDrive2FCPort(string);
                        graphTapeDrive2FCPort.setFCPortID((GraphFCPort.ID)graphFCPort.getEntityID());
                        graphTapeDrive2FCPort.setTapeDriveID((GraphTapeDrive.ID)((GraphEntity)object2).getEntityID());
                        hashMap.put(string, graphTapeDrive2FCPort);
                        graphModel.put(graphTapeDrive2FCPort);
                        String string2 = "tape2port:" + n + ',' + object4;
                        GraphTapeLibrary2FCPort graphTapeLibrary2FCPort = new GraphTapeLibrary2FCPort(string2);
                        graphTapeLibrary2FCPort.setTapeLibraryID((GraphTapeLibrary.ID)graphTapeLibrary.getEntityID());
                        graphTapeLibrary2FCPort.setFCPortID((GraphFCPort.ID)graphFCPort.getEntityID());
                        graphModel.put(graphTapeLibrary2FCPort);
                        hashMap.put(string2, graphTapeLibrary2FCPort);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", "Missing FCPort entry for:" + (String)object);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", "Missing tape drive:" + (String)object3);
            }
        }
        finally {
            block43: {
                block42: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block42;
                        TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block43;
                    TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", exception);
                }
            }
        }
        if (debug) {
            System.out.println("tapedrive2port totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", "");
        }
    }

    public void getTapeMediaChanger(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerTapeLibraryL2.class.getName(), "getTapeMediaChanger", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        GraphTapeLibrary graphTapeLibrary = (GraphTapeLibrary)hashMap.get("tapelibrary:" + n);
        if (graphTapeLibrary == null) {
            return;
        }
        if (debug) {
            System.out.println("mediachanger ...");
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_MEDIA_CHANGER);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n2 = (Integer)resultSet.getObject("TAPE_MEDIA_CHANGER_ID");
                String string = "mediachanger:" + n2;
                if (hashMap.get(string) == null) {
                    GraphMediaChanger graphMediaChanger = new GraphMediaChanger(string);
                    this.populator.populateTapeMediaChanger(resultSet, graphMediaChanger);
                    hashMap.put(string, graphMediaChanger);
                    graphModel.put(graphMediaChanger);
                    String string2 = "tape2mediachanger:" + n + ',' + n2;
                    GraphTapeLibrary2MediaChanger graphTapeLibrary2MediaChanger = new GraphTapeLibrary2MediaChanger(string2);
                    graphTapeLibrary2MediaChanger.setTapeLibraryID((GraphTapeLibrary.ID)graphTapeLibrary.getEntityID());
                    graphTapeLibrary2MediaChanger.setMediaChangerID((GraphMediaChanger.ID)graphMediaChanger.getEntityID());
                    hashMap.put(string2, graphTapeLibrary2MediaChanger);
                    graphModel.put(graphTapeLibrary2MediaChanger);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerTapeLibraryL2.class.getName(), "getTapeMediaChanger", "Duplicated tape drive:" + string);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getTapeMediaChanger", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getTapeMediaChanger", exception);
                }
            }
        }
        if (debug) {
            System.out.println("mediachanger totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerTapeLibraryL2.class.getName(), "getTapeMediaChanger", "");
        }
    }

    public void getPortsFromTape(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        Object object;
        Object object2;
        String string2;
        Integer n2;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string3 = String.valueOf(string) + n;
        GraphTapeLibrary graphTapeLibrary = (GraphTapeLibrary)hashMap.get(string3);
        if (graphTapeLibrary == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage(1, ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", "tape was not found:" + string3);
            }
            return;
        }
        if (debug) {
            System.out.println("ports ...");
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_PORTS_FROM_TAPE);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n2 = (Integer)resultSet.getObject("PORT_ID");
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", "NULL column field SWITCH_WWN from switch");
                    continue;
                }
                string2 = "Port:" + n2;
                if (hashMap.get(string2) == null) {
                    object2 = new GraphFCPort(string2);
                    this.populator.populatePort(resultSet, (GraphFCPort)object2);
                    hashMap.put(string2, object2);
                    graphModel.put((GraphEntity)object2);
                    object = new GraphTapeLibrary2FCPort("tape2port:" + string3 + ',' + n2);
                    ((GraphTapeLibrary2FCPort)object).setFCPortID((GraphFCPort.ID)((GraphEntity)object2).getEntityID());
                    ((GraphTapeLibrary2FCPort)object).setTapeLibraryID((GraphTapeLibrary.ID)graphTapeLibrary.getEntityID());
                    graphModel.put((GraphEntity)object);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", "Duplicated host entry:" + string2);
            }
        }
        finally {
            block44: {
                block43: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block43;
                        TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block44;
                    TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", exception);
                }
            }
        }
        if (debug) {
            System.out.println("ports totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        l = System.currentTimeMillis();
        if (debug) {
            System.out.println("port2port totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        l = System.currentTimeMillis();
        if (debug) {
            System.out.println("port2port ...");
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_PORT2PORT_FROM_TAPE);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n2 = (Integer)resultSet.getObject("PORT_ID");
                string2 = (String)resultSet.getObject("PORT1_NAME");
                object2 = (String)resultSet.getObject("PORT_NUMBER1");
                object = (String)resultSet.getObject("PORT_NUMBER2");
                Integer n3 = (Integer)resultSet.getObject("PORT2_ID");
                String string4 = (String)resultSet.getObject("PORT2_NAME");
                Integer n4 = (Integer)resultSet.getObject("PORT2PORT_ID");
                String string5 = (String)resultSet.getObject("PREFIX_ID");
                Integer n5 = (Integer)resultSet.getObject("ENTITY_ID");
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", "NULL column field SWITCH_WWN from switch");
                    continue;
                }
                String string6 = "Port:" + n2;
                String string7 = "Port:" + n3;
                GraphFCPort graphFCPort = (GraphFCPort)hashMap.get(string7);
                GraphFCPort graphFCPort2 = (GraphFCPort)hashMap.get(string6);
                if (graphFCPort == null) {
                    graphFCPort = new GraphFCPort(string7);
                    graphFCPort.setDisplayName(string4);
                    graphFCPort.setPortNumber((String)object);
                    hashMap.put(string7, graphFCPort);
                    graphModel.put(graphFCPort);
                }
                if (graphFCPort2 == null) {
                    graphFCPort2 = new GraphFCPort(string6);
                    graphFCPort2.setDisplayName(string2);
                    graphFCPort2.setPortNumber((String)object2);
                    hashMap.put(string6, graphFCPort2);
                    graphModel.put(graphFCPort2);
                }
                String string8 = "port2port:" + string + n + ',' + string5 + n5 + ',' + n4;
                GraphFCPort2FCPort graphFCPort2FCPort = new GraphFCPort2FCPort(string8);
                graphFCPort2FCPort.setFCPort1ID((GraphFCPort.ID)graphFCPort2.getEntityID());
                graphFCPort2FCPort.setFCPort2ID((GraphFCPort.ID)graphFCPort.getEntityID());
                this.populator.populatePort2Port(resultSet, graphFCPort2FCPort);
                hashMap.put(string8, graphFCPort2FCPort);
                graphModel.put(graphFCPort2FCPort);
            }
        }
        finally {
            block47: {
                block46: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block46;
                        TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block47;
                    TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", exception);
                }
            }
        }
        if (debug) {
            System.out.println("port2port totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", "");
        }
    }

    public void getSwitchFromTape(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerTapeLibraryL2.class.getName(), "getSwitchFromSubsystem", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("switch ...");
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_SWITCH_FROM_TAPE);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = (String)resultSet.getObject("PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("SWITCH_ID");
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerTapeLibraryL2.class.getName(), "getSwitchFromSubsystem", "NULL column field SWITCH_WWN from switch");
                    continue;
                }
                String string3 = String.valueOf(string2) + n2;
                GraphSwitch graphSwitch = null;
                graphSwitch = (GraphSwitch)hashMap.get(string3);
                if (graphSwitch == null) {
                    graphSwitch = new GraphSwitch(string3);
                    this.populator.populateSwitch(resultSet, graphSwitch, true);
                    hashMap.put(string3, graphSwitch);
                    graphModel.put(graphSwitch);
                } else if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(1, ViewerTapeLibraryL2.class.getName(), "getSwitchFromSubsystem", "Duplicated host entry:" + string3);
                }
                Integer n3 = (Integer)resultSet.getObject("PORT_ID");
                String string4 = "Port:" + n3;
                GraphFCPort graphFCPort = (GraphFCPort)hashMap.get(string4);
                if (graphFCPort != null) {
                    String string5 = "switch2fcport:" + string3 + ',' + n3;
                    GraphSwitch2FCPort graphSwitch2FCPort = new GraphSwitch2FCPort(string5);
                    graphSwitch2FCPort.setFCPortID((GraphFCPort.ID)graphFCPort.getEntityID());
                    graphSwitch2FCPort.setSwitchID((GraphSwitch.ID)graphSwitch.getEntityID());
                    graphModel.put(graphSwitch2FCPort);
                    hashMap.put(string5, graphSwitch2FCPort);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerTapeLibraryL2.class.getName(), "getSwitchFromSubsystem", "Missing port entity:" + string4);
            }
        }
        finally {
            block25: {
                block24: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block24;
                        TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getSwitchFromSubsystem", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block25;
                    TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getSwitchFromSubsystem", exception);
                }
            }
        }
        if (debug) {
            System.out.println("switch totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerTapeLibraryL2.class.getName(), "getSwitchFromSubsystem", "");
        }
    }

    public void getZonesFromTape(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        this.getZonesFromEntitiesConnectedToEntity(connection, graphModel, hashMap, new Object[]{string, new Integer(n)}, new String[]{SELECT_FABRIC_FROM_ZONES_FROM_TAPE, SELECT_ZONES_FROM_TAPE, SELECT_ZSET_FROM_TAPE, SELECT_ZSET2ZONE_FROM_TAPE, SELECT_ZONE2MEMBER_FROM_TAPE});
    }

    public void getZonesFromEntitiesConnectedToTape(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
    }

    public void commit(Connection connection) {
        block2: {
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception(ViewerServerL2.class.getName(), "commit", sQLException);
            }
        }
    }

    public void getView(Connection connection, ViewerRequest viewerRequest, ViewerResponse viewerResponse) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerTapeLibraryL2.class.getName(), "getView", "");
        }
        GraphModelTapeLibraryL2 graphModelTapeLibraryL2 = null;
        String string = null;
        GraphTapeLibrary.ID iD = (GraphTapeLibrary.ID)viewerRequest.getModelID().getFocusEntityID();
        string = (String)iD.getID();
        int n = string.indexOf(58);
        String string2 = string.substring(0, n + 1);
        string = string.substring(n + 1);
        int n2 = Integer.parseInt(string);
        HashMap<String, GraphTapeLibrary> hashMap = new HashMap<String, GraphTapeLibrary>();
        Timestamp timestamp = viewerRequest.getTimestamp();
        Timestamp timestamp2 = null;
        if (timestamp2 == null || timestamp == null || timestamp2.after(timestamp)) {
            GraphTapeLibrary graphTapeLibrary = this.getTapeLibrary(connection, null, null, string2, n2);
            graphModelTapeLibraryL2 = new GraphModelTapeLibraryL2((GraphModelTapeLibraryL2.ID)viewerRequest.getModelID());
            if (graphTapeLibrary != null) {
                hashMap.put(String.valueOf(string2) + string, graphTapeLibrary);
                graphModelTapeLibraryL2.put(graphTapeLibrary);
                this.getPortsFromTape(connection, graphModelTapeLibraryL2, hashMap, string2, n2);
                this.getSwitchFromTape(connection, graphModelTapeLibraryL2, hashMap, string2, n2);
                if ("tapelibrary:".equals(string2)) {
                    this.getTapeDrivesFromTape(connection, graphModelTapeLibraryL2, hashMap, n2);
                    this.getTapeMediaChanger(connection, graphModelTapeLibraryL2, hashMap, n2);
                }
                this.commit(connection);
                this.getSansFromSwitch(connection, (GraphModel)graphModelTapeLibraryL2, hashMap, string2, n2);
                if (viewerRequest.getModelID().isNeedZoneData()) {
                    this.getZonesFromTape(connection, graphModelTapeLibraryL2, hashMap, string2, n2);
                }
                this.commit(connection);
                graphModelTapeLibraryL2.setWithZoneData(viewerRequest.getModelID().isNeedZoneData());
                viewerResponse.addResponse(0, graphModelTapeLibraryL2);
            } else {
                viewerResponse.addResponse(0, graphModelTapeLibraryL2);
            }
        } else {
            viewerResponse.addResponse(0, null);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerTapeLibraryL2.class.getName(), "getView", "");
        }
    }

    public void main(String[] stringArray) {
    }
}

