/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.util.ULocale;
import java.util.Comparator;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.ReportParameterConverter;

public class SelectionChoiceComparator
implements Comparator {
    protected boolean sortDisplayValue;
    protected String format = null;
    protected ULocale locale = null;

    public SelectionChoiceComparator(boolean sortDisplayValue, String format, ULocale locale) {
        this.sortDisplayValue = sortDisplayValue;
        this.format = format;
        this.locale = locale;
        if (null == this.locale) {
            this.locale = ULocale.getDefault();
        }
    }

    public int compare(Object o1, Object o2) {
        if (o1 instanceof IParameterSelectionChoice && o2 instanceof IParameterSelectionChoice) {
            Object value2;
            Object value1;
            if (this.sortDisplayValue) {
                value1 = ((IParameterSelectionChoice)o1).getLabel();
                value2 = ((IParameterSelectionChoice)o2).getLabel();
                if (null == value1) {
                    value1 = this.getDisplayValue(((IParameterSelectionChoice)o1).getValue());
                }
                if (null == value2) {
                    value2 = this.getDisplayValue(((IParameterSelectionChoice)o2).getValue());
                }
            } else {
                value1 = ((IParameterSelectionChoice)o1).getValue();
                value2 = ((IParameterSelectionChoice)o2).getValue();
            }
            if (value1 == value2) {
                return 0;
            }
            if (value1 == null) {
                return -1;
            }
            if (value2 == null) {
                return 1;
            }
            if (value1 instanceof Boolean && value2 instanceof Boolean) {
                if ((Boolean)value1 ^ (Boolean)value1) {
                    return 0;
                }
                return (Boolean)value1 != false ? 1 : -1;
            }
            if (value1 instanceof Comparable) {
                return ((Comparable)value1).compareTo(value2);
            }
            if (value2 instanceof Comparable) {
                return -((Comparable)value2).compareTo(value1);
            }
        }
        return -1;
    }

    private String getDisplayValue(Object value) {
        if (null == value) {
            return null;
        }
        ReportParameterConverter converter = new ReportParameterConverter(this.format, this.locale);
        return converter.format(value);
    }
}

